/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.s2c;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.server.config.enums.ClimbeyBlockmode;

public record ClimbingPayloadS2C(boolean allowed, ClimbeyBlockmode blockmode, @Nullable List<String> blocks) implements VivecraftPayloadS2C
{
    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.CLIMBING;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        buffer.writeBoolean(this.allowed);
        buffer.writeByte(this.blockmode.ordinal());
        if (this.blocks != null) {
            for (String block : this.blocks) {
                try {
                    Holder.Reference b = BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)block)).orElseGet(() -> null);
                    if (b == null || b.value() == Blocks.AIR) continue;
                    buffer.writeUtf(block);
                }
                catch (ResourceLocationException resourceLocationException) {}
            }
        }
    }

    public static ClimbingPayloadS2C read(FriendlyByteBuf buffer) {
        boolean allowed = buffer.readBoolean();
        if (buffer.readableBytes() > 0) {
            ClimbeyBlockmode blockmode = ClimbeyBlockmode.values()[buffer.readByte()];
            ArrayList<String> blocks = new ArrayList<String>();
            if (buffer.readableBytes() > 0) {
                while (buffer.readableBytes() > 0) {
                    blocks.add(buffer.readUtf());
                }
            }
            return new ClimbingPayloadS2C(allowed, blockmode, blocks);
        }
        return new ClimbingPayloadS2C(allowed, ClimbeyBlockmode.DISABLED, null);
    }
}

