/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.world;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.settings.VRSettings;

@Mixin(value={AbstractBoat.class})
public abstract class AbstractBoatMixin
extends Entity {
    @Shadow
    private float deltaRotation;
    @Shadow
    private boolean inputLeft;
    @Shadow
    private boolean inputRight;
    @Shadow
    private boolean inputUp;

    public AbstractBoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyExpressionValue(method={"controlBoat()V"}, at={@At(value="CONSTANT", args={"floatValue=1F"}, ordinal=0)})
    private float vivecraft$inputLeft(float leftInput) {
        return VRState.VR_RUNNING ? Minecraft.getInstance().player.input.leftImpulse : leftInput;
    }

    @ModifyExpressionValue(method={"controlBoat()V"}, at={@At(value="CONSTANT", args={"floatValue=1F"}, ordinal=1)})
    private float vivecraft$inputRight(float rightInput) {
        return VRState.VR_RUNNING ? -Minecraft.getInstance().player.input.leftImpulse : rightInput;
    }

    @ModifyVariable(method={"controlBoat()V"}, at=@At(value="LOAD", ordinal=3))
    private float vivecraft$modifyAcceleration(float acceleration) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (VRState.VR_RUNNING && !dataHolder.vrSettings.seated) {
            if (this.inputUp) {
                float yaw;
                float f = yaw = dataHolder.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.HMD ? dataHolder.vrPlayer.vrdata_world_pre.hmd.getYaw() : dataHolder.vrPlayer.vrdata_world_pre.getController(1).getYaw();
                if (dataHolder.vrSettings.vehicleRotation) {
                    float start;
                    float end = this.getYRot() % 360.0f;
                    float difference = Math.abs(end - (start = yaw));
                    if (difference > 180.0f) {
                        if (end > start) {
                            start += 360.0f;
                        } else {
                            end += 360.0f;
                        }
                    }
                    difference = end - start;
                    acceleration = 0.0f;
                    if (Math.abs(difference) < 30.0f) {
                        acceleration = 0.04f;
                    } else if (Math.abs(difference) > 150.0f) {
                        acceleration = -0.005f;
                    } else if (difference != 0.0f) {
                        acceleration = 0.005f;
                    }
                    if (Math.abs(difference) > 10.0f && Math.abs(difference) < 150.0f) {
                        this.deltaRotation -= Math.signum(difference) * Math.min(1.0f, Math.max(0.0f, Math.abs(difference) - 25.0f) / 40.0f);
                    }
                } else {
                    this.setYRot(yaw);
                }
            } else if (dataHolder.rowTracker.isRowing()) {
                this.deltaRotation += dataHolder.rowTracker.LOar / 1.5f;
                this.deltaRotation -= dataHolder.rowTracker.ROar / 1.5f;
                if (this.deltaRotation < 0.0f) {
                    this.inputLeft = true;
                }
                if (this.deltaRotation > 0.0f) {
                    this.inputRight = true;
                }
                if ((acceleration = Math.min(0.04f, 0.06f * dataHolder.rowTracker.FOar)) > 0.0f) {
                    this.inputUp = true;
                }
            }
        }
        return acceleration;
    }
}

