/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;

public abstract class GuiOrderedListEditorScreen<T>
extends GuiListEditorScreen<T> {
    public GuiOrderedListEditorScreen(class_2561 title, class_437 lastScreen, boolean fixedEntryCount, Supplier<List<T>> valuesSupplier, Runnable loadDefaults, Consumer<List<T>> save) {
        super(title, lastScreen, fixedEntryCount, valuesSupplier, loadDefaults, save);
        this.searchable = false;
    }

    private void moveEntry(int from, int offset, boolean remove) {
        Object value = this.elements.get(from);
        this.elements.remove(from);
        if (!remove) {
            this.elements.add(Math.clamp((long)(from + offset), 0, this.elements.size()), value);
        }
        this.reinit = true;
    }

    protected class OrderedEntry<T>
    extends GuiListEditorScreen.ValueEntry<T> {
        protected final T value;
        private final int index;
        private final class_4185 upButton;
        private final class_4185 downButton;
        private final class_4185 removeButton;

        public OrderedEntry(class_2561 name, T value, int index) {
            super(name, null);
            this.value = value;
            this.index = index;
            this.upButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, -1, false)).method_46434(0, 0, 20, 20).method_46431();
            this.downButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, 1, false)).method_46434(0, 0, 20, 20).method_46431();
            this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, 0, true)).method_46434(0, 0, 20, 20).method_46431();
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.method_25343(guiGraphics, mouseX, mouseY, hovering, partialTick);
            int n = this.method_46427() + this.method_25364() / 2;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int textY = n - 9 / 2 + 2;
            guiGraphics.method_27535(class_310.method_1551().field_1772, this.name, this.method_73380(), textY, this.textColor());
            this.upButton.field_22763 = this.isActive() && this.index != 0;
            this.downButton.field_22763 = this.isActive() && this.index != GuiOrderedListEditorScreen.this.elements.size() - 1;
            this.removeButton.field_22763 = this.isActive();
            int i = 0;
            for (class_364 child : this.method_25396()) {
                class_4185 b = (class_4185)child;
                b.method_46421(this.method_73389() - (2 - i) * 22 - 20);
                b.method_46419(this.method_73382());
                b.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                ++i;
            }
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.upButton, (Object)this.downButton, (Object)this.removeButton);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.upButton, (Object)this.downButton, (Object)this.removeButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.upButton.field_22763 = active;
            this.downButton.field_22763 = active;
            this.removeButton.field_22763 = active;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

