/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.render.helpers.GuiRenderHelper;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class RenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final class_310 MC = class_310.method_1551();
    public static final class_2960 WHITE_TEXTURE = class_2960.method_60654((String)"vivecraft:textures/white.png");
    public static final class_2960 BLACK_TEXTURE = class_2960.method_60654((String)"vivecraft:textures/black.png");

    public static GpuTextureView getGpuTexture(class_2960 resourceLocation) {
        return MC.method_1531().method_4619(resourceLocation).method_71659();
    }

    public static Matrix4f getVRModelView(RenderPass renderPass) {
        return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix().transpose();
    }

    public static void applyVRModelView(RenderPass renderPass, class_4587 poseStack) {
        Matrix4f modelView = RenderHelper.getVRModelView(renderPass);
        poseStack.method_23760().method_23761().mul((Matrix4fc)modelView);
        poseStack.method_23760().method_23762().mul((Matrix3fc)new Matrix3f((Matrix4fc)modelView));
    }

    public static void applyVRModelView(RenderPass renderPass, Matrix4f matrix) {
        Matrix4f modelView = RenderHelper.getVRModelView(renderPass);
        matrix.mul((Matrix4fc)modelView);
    }

    public static void applyStereo(RenderPass renderPass, class_4587 poseStack) {
        if (renderPass == RenderPass.LEFT || renderPass == RenderPass.RIGHT) {
            class_243 eye = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition().method_1020(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition());
            poseStack.method_22904(-eye.field_1352, -eye.field_1351, -eye.field_1350);
        }
    }

    public static class_243 getControllerRenderPos(int c) {
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && c < 2) {
            int mainHand = class_1268.field_5808.ordinal();
            if (RenderHelper.DATA_HOLDER.vrSettings.reverseHands) {
                c = 1 - c;
                mainHand = class_1268.field_5810.ordinal();
            }
            if (RenderHelper.MC.field_1724 != null && RenderHelper.MC.field_1687 != null && TelescopeTracker.isTelescope(RenderHelper.MC.field_1724.method_6030()) && TelescopeTracker.isTelescope(c == mainHand ? RenderHelper.MC.field_1724.method_6047() : RenderHelper.MC.field_1724.method_6079())) {
                VRData.VRDevicePose eye = c == 0 ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye0 : RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye1;
                Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection().mul(0.2f * RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale);
                return eye.getPosition().method_1031((double)dir.x, (double)dir.y, (double)dir.z);
            }
            float worldScale = RenderHelper.MC.field_1724 != null && RenderHelper.MC.field_1687 != null ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale : 1.0f;
            Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir.rotateY((float)Math.PI / 180 * (c == 0 ? -35.0f : 35.0f));
            dir.y = 0.0f;
            dir.normalize();
            return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition().method_1031((double)dir.x * 0.3 * (double)worldScale, -0.4 * (double)worldScale, (double)dir.z * 0.3 * (double)worldScale);
        }
        return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getPosition();
    }

    public static void setupRenderingAtController(int c, Matrix4f matrix) {
        class_243 aimSource = RenderHelper.getControllerRenderPos(c);
        aimSource = aimSource.method_1020(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(RenderHelper.DATA_HOLDER.currentPass).getPosition());
        matrix.translate((float)aimSource.field_1352, (float)aimSource.field_1351, (float)aimSource.field_1350);
        float sc = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && RenderHelper.MC.field_1724 != null && RenderHelper.MC.field_1687 != null && TelescopeTracker.isTelescope(RenderHelper.MC.field_1724.method_6030()) && TelescopeTracker.isTelescope(c == 0 ? RenderHelper.MC.field_1724.method_6047() : RenderHelper.MC.field_1724.method_6079())) {
            matrix.mul((Matrix4fc)RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getMatrix().invert().transpose());
            matrix.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
            matrix.translate((c == (RenderHelper.DATA_HOLDER.vrSettings.reverseHands ? 1 : 0) ? 0.075f : -0.075f) * sc, -0.025f * sc, 0.0325f * sc);
        } else {
            matrix.mul((Matrix4fc)RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getMatrix().invert().transpose());
        }
        matrix.scale(sc, sc, sc);
    }

    public static void drawScreen(class_437 screen, boolean maxGuiScale) {
        double guiScale = maxGuiScale ? (double)GuiHandler.GUI_SCALE_FACTOR_MAX : (double)MC.method_22683().method_4495();
        int backupGuiScale = GuiHandler.GUI_SCALE_FACTOR;
        GuiHandler.GUI_SCALE_FACTOR = (int)guiScale;
        GuiRenderHelper.renderScreen(screen);
        GuiHandler.GUI_SCALE_FACTOR = backupGuiScale;
        if (RenderHelper.DATA_HOLDER.vrSettings.guiMipmaps) {
            OpenGLHelper.genMipmaps(RenderHelper.MC.field_1689.method_30277());
        }
    }

    public static void drawMouseMenuQuad(class_332 guiGraphics, int mouseX, int mouseY) {
        float size = 15.0f * Math.max(ClientDataHolderVR.getInstance().vrSettings.menuCrosshairScale, 1.0f / (float)MC.method_22683().method_4495());
        guiGraphics.method_52706(VRShaders.CROSSHAIR_MENU, class_329.field_45304, (int)((float)mouseX - size * 0.5f + 1.0f), (int)((float)mouseY - size * 0.5f + 1.0f), (int)size, (int)size);
    }

    public static void drawVRConnectingMessage() {
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(MC.method_1522().method_30278(), 1.0);
        class_332 guiGraphics = GuiRenderHelper.getGuiGraphics();
        int width = 200;
        List formattedChars = RenderHelper.MC.field_1772.method_1728((class_5348)class_2561.method_43471((String)"vivecraft.messages.connectingtoruntime"), width - 10);
        int height = formattedChars.size() * 8 + Math.max(formattedChars.size() - 1, 0) * 4 + 10;
        int x = guiGraphics.method_51421() / 2 - width / 2;
        int y = guiGraphics.method_51443() / 2 - height / 2;
        guiGraphics.method_25294(0, 0, guiGraphics.method_51421(), guiGraphics.method_51443(), 0x40000000);
        guiGraphics.method_25294(x, y, x + width, y + height, -16777216);
        guiGraphics.method_73198(x, y, width, height, -1);
        for (int line = 0; line < formattedChars.size(); ++line) {
            guiGraphics.method_35719(RenderHelper.MC.field_1772, (class_5481)formattedChars.get(line), guiGraphics.method_51421() / 2, y + 5 + line * 12, -1);
        }
        guiGraphics.method_73199();
        GuiRenderHelper.finish();
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix, class_276 source) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        class_1921 renderType = VRRenderTypes.guiTextureAlways(source.method_71639());
        class_4588 consumer = MC.method_22940().method_23000().method_73477(renderType);
        consumer.method_22918(matrix, -sizeX, -sizeY, 0.0f).method_22913(0.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]);
        consumer.method_22918(matrix, sizeX, -sizeY, 0.0f).method_22913(1.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]);
        consumer.method_22918(matrix, sizeX, sizeY, 0.0f).method_22913(1.0f, 1.0f).method_22915(color[0], color[1], color[2], color[3]);
        consumer.method_22918(matrix, -sizeX, sizeY, 0.0f).method_22913(0.0f, 1.0f).method_22915(color[0], color[1], color[2], color[3]);
        MC.method_22940().method_23000().method_22994(renderType);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, Matrix4f matrix, class_1921 renderType, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, packedLight, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, matrix, renderType, flipY);
    }

    public static void drawSizedQuadFullbright(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix, class_1921 renderType) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, 0xF000F0, color, matrix, renderType, false);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, float[] color, Matrix4f matrix, class_1921 renderType, boolean flipY) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        Vector3f normal = new Matrix3f((Matrix4fc)matrix).transform(new Vector3f(0.0f, 0.0f, 1.0f)).normalize();
        class_4588 consumer = MC.method_22940().method_23000().method_73477(renderType);
        consumer.method_22918(matrix, -sizeX, -sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(0.0f, flipY ? 1.0f : 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_22914(normal.x, normal.y, normal.z);
        consumer.method_22918(matrix, sizeX, -sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(1.0f, flipY ? 1.0f : 0.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_22914(normal.x, normal.y, normal.z);
        consumer.method_22918(matrix, sizeX, sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(1.0f, flipY ? 0.0f : 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_22914(normal.x, normal.y, normal.z);
        consumer.method_22918(matrix, -sizeX, sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(0.0f, flipY ? 0.0f : 1.0f).method_22922(class_4608.field_21444).method_60803(packedLight).method_22914(normal.x, normal.y, normal.z);
        MC.method_22940().method_23000().method_22994(renderType);
    }

    public static void renderFlatQuad(class_243 pos, float width, float height, float yaw, int r, int g, int b, int a, Matrix4f matrix, boolean depthAlways) {
        class_1921 renderType = VRRenderTypes.quads(depthAlways);
        class_4588 consumer = MC.method_22940().method_23000().method_73477(renderType);
        class_243 offset = new class_243((double)(width * 0.5f), 0.0, (double)(height * 0.5f)).method_1024((float)Math.PI / 180 * -yaw);
        ShadersHelper.bindTexture(WHITE_TEXTURE);
        consumer.method_22918(matrix, (float)(pos.field_1352 + offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 + offset.field_1350)).method_1336(r, g, b, a);
        consumer.method_22918(matrix, (float)(pos.field_1352 + offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 - offset.field_1350)).method_1336(r, g, b, a);
        consumer.method_22918(matrix, (float)(pos.field_1352 - offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 - offset.field_1350)).method_1336(r, g, b, a);
        consumer.method_22918(matrix, (float)(pos.field_1352 - offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 + offset.field_1350)).method_1336(r, g, b, a);
        MC.method_22940().method_23000().method_22994(renderType);
    }

    public static void renderBox(class_4588 consumer, class_243 start, class_243 end, float xSize, float ySize, class_2382 color, byte alpha, Matrix4f matrix) {
        RenderHelper.renderBox(consumer, start, end, -xSize * 0.5f, xSize * 0.5f, -ySize * 0.5f, ySize * 0.5f, color, alpha, matrix);
    }

    public static void renderBox(class_4588 consumer, class_243 start, class_243 end, float minX, float maxX, float minY, float maxY, class_2382 color, byte alpha, Matrix4f matrix) {
        class_243 forward = start.method_1020(end).method_1029();
        class_243 right = forward.method_1036(MathUtils.UP_D);
        right = right.method_1027() == 0.0 ? MathUtils.LEFT_D : right.method_1029();
        class_243 up = right.method_1036(forward);
        class_243 left = right.method_1021((double)minX);
        right = right.method_1021((double)maxX);
        class_243 down = up.method_1021((double)minY);
        up = up.method_1021((double)maxY);
        class_243 backRightBottom = start.method_1031(right.field_1352 + down.field_1352, right.field_1351 + down.field_1351, right.field_1350 + down.field_1350);
        class_243 backRightTop = start.method_1031(right.field_1352 + up.field_1352, right.field_1351 + up.field_1351, right.field_1350 + up.field_1350);
        class_243 backLeftBottom = start.method_1031(left.field_1352 + down.field_1352, left.field_1351 + down.field_1351, left.field_1350 + down.field_1350);
        class_243 backLeftTop = start.method_1031(left.field_1352 + up.field_1352, left.field_1351 + up.field_1351, left.field_1350 + up.field_1350);
        class_243 frontRightBottom = end.method_1031(right.field_1352 + down.field_1352, right.field_1351 + down.field_1351, right.field_1350 + down.field_1350);
        class_243 frontRightTop = end.method_1031(right.field_1352 + up.field_1352, right.field_1351 + up.field_1351, right.field_1350 + up.field_1350);
        class_243 frontLeftBottom = end.method_1031(left.field_1352 + down.field_1352, left.field_1351 + down.field_1351, left.field_1350 + down.field_1350);
        class_243 frontLeftTop = end.method_1031(left.field_1352 + up.field_1352, left.field_1351 + up.field_1351, left.field_1350 + up.field_1350);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha);
    }

    private static void addVertex(class_4588 consumer, Matrix4f matrix, class_243 pos, class_2382 color, int alpha) {
        consumer.method_22918(matrix, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_1336(color.method_10263(), color.method_10264(), color.method_10260(), alpha);
    }

    public static String checkGLError(String errorSection) {
        int error = GlStateManager._getError();
        if (error != 0) {
            String errorString = switch (error) {
                case 1280 -> "invalid enum";
                case 1281 -> "invalid value";
                case 1282 -> "invalid operation";
                case 1283 -> "stack overflow";
                case 1284 -> "stack underflow";
                case 1285 -> "out of memory";
                case 1286 -> "framebuffer is not complete";
                default -> "unknown error";
            };
            VRSettings.LOGGER.error("Vivecraft: ########## GL ERROR ##########");
            VRSettings.LOGGER.error("Vivecraft: @ {}", (Object)errorSection);
            VRSettings.LOGGER.error("Vivecraft: {}: {}", (Object)error, (Object)errorString);
            return errorString;
        }
        return "";
    }
}

