/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiListScreen;
import org.vivecraft.client.gui.framework.widgets.SettingsList;

public class GuiStringListEditorScreen
extends GuiListScreen {
    private final Supplier<List<String>> valuesSupplier;
    private final Runnable loadDefaults;
    private final Consumer<List<String>> save;
    private final boolean fixedEntryCount;
    private List<String> elements;

    public GuiStringListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<String>> valuesSupplier, Runnable loadDefaults, Consumer<List<String>> save) {
        super(title, lastScreen);
        this.fixedEntryCount = fixedEntryCount;
        this.valuesSupplier = valuesSupplier;
        this.loadDefaults = loadDefaults;
        this.save = save;
        this.searchable = false;
    }

    @Override
    protected void addLowerButtons(int top) {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"vivecraft.gui.loaddefaults"), button -> {
            this.loadDefaults.run();
            this.elements = null;
            this.reinit = true;
        }).m_252987_(this.f_96543_ / 2 - 155, top, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 5, top, 150, 20).m_253136_());
    }

    @Override
    public void m_7379_() {
        this.save.accept(this.elements);
        super.m_7379_();
    }

    private List<String> getCurrentValues() {
        return this.list.m_6702_().stream().map(entry -> {
            if (entry instanceof StringValueEntry) {
                StringValueEntry listValueEntry = (StringValueEntry)((Object)entry);
                return listValueEntry.getString();
            }
            return "";
        }).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        if (this.elements == null) {
            this.elements = new ArrayList<String>((Collection)this.valuesSupplier.get());
        }
        int i = 0;
        for (String item : this.elements) {
            EditBox box = new EditBox(this.f_96541_.f_91062_, 0, 0, 350, 20, (Component)Component.m_237113_((String)item));
            box.m_94199_(1000);
            box.m_94144_(item);
            int index = i++;
            box.m_94151_(s -> this.elements.set(index, (String)s));
            entries.add(new StringValueEntry((Component)Component.m_237119_(), box, button -> {
                this.elements.remove(index);
                this.reinit = true;
            }, !this.fixedEntryCount));
        }
        if (!this.fixedEntryCount) {
            entries.add(new SettingsList.WidgetEntry((Component)Component.m_237113_((String)""), (AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)"vivecraft.options.addnew"), button -> {
                this.elements = this.getCurrentValues();
                this.elements.add("");
                this.reinit = true;
            }).m_253046_(145, 20).m_253136_()));
        }
        return entries;
    }

    private static class StringValueEntry
    extends SettingsList.BaseEntry {
        private final EditBox editBox;
        private final Button deleteButton;

        public StringValueEntry(Component name, EditBox editBox, Button.OnPress deleteAction, boolean deletable) {
            super(name, null);
            this.editBox = editBox;
            this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)(deletable ? "-" : "X")), (Button.OnPress)(deletable ? deleteAction : b -> this.editBox.m_94144_(""))).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"selectWorld.delete"))).m_252987_(0, 0, 20, 20).m_253136_();
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editBox.m_252865_(left);
            this.editBox.m_253211_(top);
            this.editBox.m_93674_(width - 20);
            this.editBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.m_252865_(left + width - 20);
            this.deleteButton.m_253211_(top);
            this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.m_7222_() == this.editBox && keyCode == 262 && this.editBox.m_94155_().length() == this.editBox.m_94207_()) {
                return false;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.editBox.f_93623_ = active;
            this.deleteButton.f_93623_ = active;
        }

        public String getString() {
            return this.editBox.m_94155_();
        }
    }
}

