/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.MinecraftExtension;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;

public class ClientUtils {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();
    private static final Random AV_RANDOMIZER = new Random();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWinRegistry(String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + key.substring(0, key.lastIndexOf(92)) + "\" /v \"" + key.substring(key.lastIndexOf(92) + 1) + "\"");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    String[] split = line.split("REG_SZ|REG_DWORD");
                    if (split.length > 1) {
                        String string = split[1].trim();
                        return string;
                    }
                    line = reader.readLine();
                }
                return null;
            }
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: error reading registry key: ", (Throwable)e);
        }
        return null;
    }

    public static void spawnParticles(ParticleOptions type, int count, Vec3 position, Vec3 size, double speed) {
        Minecraft minecraft = Minecraft.m_91087_();
        for (int k = 0; k < count; ++k) {
            double offX = AV_RANDOMIZER.nextGaussian() * size.f_82479_;
            double offY = AV_RANDOMIZER.nextGaussian() * size.f_82480_;
            double offZ = AV_RANDOMIZER.nextGaussian() * size.f_82481_;
            double dirX = AV_RANDOMIZER.nextGaussian() * speed;
            double dirY = AV_RANDOMIZER.nextGaussian() * speed;
            double dirZ = AV_RANDOMIZER.nextGaussian() * speed;
            try {
                minecraft.f_91073_.m_7106_(type, position.f_82479_ + offX, position.f_82480_ + offY, position.f_82481_ + offZ, dirX, dirY, dirZ);
                continue;
            }
            catch (Throwable throwable) {
                VRSettings.LOGGER.warn("Vivecraft: Could not spawn particle effect {}", (Object)type);
                return;
            }
        }
    }

    public static int getCombinedLightWithMin(BlockAndTintGetter lightReader, BlockPos pos, int minLight) {
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)lightReader, (BlockPos)pos);
        int blockLight = light >> 4 & 0xF;
        if (blockLight < minLight) {
            light &= 0xFFFFFF00;
            light |= minLight << 4;
        }
        return light;
    }

    public static void takeScreenshot(RenderTarget fb) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screenshot.m_92289_((File)minecraft.f_91069_, (RenderTarget)fb, text -> minecraft.execute(() -> ClientUtils.addChatMessage(text)));
    }

    public static float getCurrentPartialTick() {
        return ((MinecraftExtension)MC).vivecraft$getPartialTick();
    }

    public static <T extends Enum<T>> T getNextEnum(T current, int offset) {
        Enum[] values = (Enum[])current.getClass().getEnumConstants();
        int index = (current.ordinal() + offset + values.length) % values.length;
        return (T)values[index];
    }

    public static long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static long milliTime() {
        return System.nanoTime() / 1000000L;
    }

    public static Component getNameFromSoundEvent(ResourceLocation soundLocation) {
        String jukebox;
        String key = soundLocation.m_135815_();
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        if (I18n.m_118936_((String)("subtitles." + key))) {
            return Component.m_237115_((String)("subtitles." + key));
        }
        if (key.startsWith("music_disc.") && I18n.m_118936_((String)(jukebox = key.replace("music_disc.", "jukebox_song.minecraft.")))) {
            return Component.m_237115_((String)jukebox);
        }
        return Component.m_237113_((String)key);
    }

    public static void addChatMessage(Component message) {
        if (ClientUtils.MC.f_91065_ != null) {
            ClientUtils.MC.f_91065_.m_93076_().m_93785_(message);
        }
        if (VRState.VR_RUNNING) {
            ClientUtils.triggerChatHapticSound();
        }
    }

    public static void triggerChatHapticSound() {
        if (ClientUtils.DH.vrSettings.chatNotifications != VRSettings.ChatNotifications.NONE) {
            if (!(ClientUtils.DH.vrSettings.seated || ClientUtils.DH.vrSettings.chatNotifications != VRSettings.ChatNotifications.HAPTIC && ClientUtils.DH.vrSettings.chatNotifications != VRSettings.ChatNotifications.BOTH)) {
                ClientUtils.DH.vr.triggerHapticPulse(ControllerType.LEFT, 0.2f, 1000.0f, 1.0f);
            }
            if (ClientUtils.DH.vrSettings.chatNotifications == VRSettings.ChatNotifications.SOUND || ClientUtils.DH.vrSettings.chatNotifications == VRSettings.ChatNotifications.BOTH) {
                Vec3 controllerPos = ClientUtils.DH.vrPlayer.vrdata_world_pre.getController(1).getPosition();
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(ClientUtils.DH.vrSettings.chatNotificationSound));
                if (soundEvent != null) {
                    if (ClientUtils.MC.f_91073_ != null) {
                        ClientUtils.MC.f_91073_.m_7785_(controllerPos.m_7096_(), controllerPos.m_7098_(), controllerPos.m_7094_(), soundEvent, SoundSource.NEUTRAL, 0.3f, 0.1f, false);
                    } else {
                        MC.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)0.1f, (float)0.3f));
                    }
                }
            }
        }
    }
}

