/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import com.bhaptics.haptic.models.PositionType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.bodylink.Haptics;
import org.vivecraft.client_vr.bodylink.RiggedBody;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.packet.c2s.DamageDirectionPayloadC2S;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;

public class HapticTracker
implements Tracker {
    private static final int HUNGER_THRESHOLD = 15;
    private static final double MAX_EXPLOSION_DIST = 5.0;
    private final Random random = new Random();
    private final ArrayList<HapticsModule> modules = new ArrayList();
    private float lastHealth;
    private Vector3fc lastHitDirection = null;
    private float lastVanillaHurtYaw = 0.0f;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public HapticTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
        this.modules.add(new RainModule());
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        return player != null && Haptics.isConnected();
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        RiggedBody.getInstance().updatePose(this.dh.vrPlayer.getVRDataWorld());
        if (NetworkVersion.DAMAGE_DIRECTION.accepts(ClientNetworking.USED_NETWORK_VERSION) && !ClientNetworking.REQUESTED_DAMAGE_DIRECTION) {
            ClientNetworking.sendServerPacket(new DamageDirectionPayloadC2S());
            ClientNetworking.REQUESTED_DAMAGE_DIRECTION = true;
        }
        float thresholdLowHealth = 5.0f;
        float thresholdCriticalHealth = 2.0f;
        Haptics.setLoopState(Haptics.Animations.FIRE, player.m_6060_());
        Haptics.setLoopState(Haptics.Animations.POTION_POSITIVE, this.hasPotionPositive(player));
        Haptics.setLoopState(Haptics.Animations.POTION_NEGATIVE, this.hasPotionNegative(player));
        Haptics.setLoopState(Haptics.Animations.LOW_HEALTH, player.m_21223_() < thresholdLowHealth && !(player.m_21223_() < thresholdCriticalHealth));
        Haptics.setLoopState(Haptics.Animations.CRITICAL_HEALTH, player.m_21223_() < thresholdCriticalHealth);
        Haptics.setLoopState(Haptics.Animations.RAIN, this.isInRain(player));
        for (HapticsModule module : this.modules) {
            if (!module.enabled) continue;
            module.tick(player);
        }
        if (player.m_21223_() != this.lastHealth) {
            float damage = this.lastHealth - player.m_21223_();
            if (damage > 0.0f) {
                this.handleHit(player.m_21225_(), damage);
            }
            this.lastHealth = player.m_21223_();
        }
        this.doHunger(player);
        Haptics.tick();
    }

    private void doHunger(LocalPlayer player) {
        float foodPerc;
        int food = player.m_36324_().m_38702_();
        if (food < 15 && this.random.nextInt(60 + (int)((foodPerc = (float)food / 20.0f) * 30.0f * 20.0f)) == 0) {
            Haptics.getAnimation(Haptics.Animations.HUNGER).playSingle(false, null);
        }
    }

    private boolean hasPotionPositive(LocalPlayer player) {
        for (MobEffectInstance effect : player.m_21220_()) {
            if (!effect.m_19544_().m_19486_() || effect.m_19571_()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPotionNegative(LocalPlayer player) {
        return player.m_21220_().stream().anyMatch(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && !effect.m_19571_());
    }

    private boolean isInRain(LocalPlayer player) {
        BlockPos blockpos = player.m_20183_();
        return player.f_108545_.m_46758_(blockpos) || player.f_108545_.m_46758_(new BlockPos(blockpos.m_123341_(), (int)player.m_20191_().f_82292_, blockpos.m_123343_()));
    }

    private void handleHit(DamageSource damageSrc, float damageAmount) {
        Vector3fc dmgVec = null;
        if (damageSrc != null) {
            dmgVec = Utils.getDirFromDamageSource(damageSrc, (Entity)this.mc.f_91074_);
        }
        if (dmgVec == null || MathUtils.isZero(dmgVec)) {
            if (this.lastHitDirection != null) {
                dmgVec = this.lastHitDirection;
            } else if (this.lastVanillaHurtYaw != this.mc.f_91074_.m_264297_()) {
                this.lastVanillaHurtYaw = this.mc.f_91074_.m_264297_();
                dmgVec = new Vector3f(1.0f, 0.0f, 0.0f).rotateY((-this.lastVanillaHurtYaw - this.mc.f_91074_.m_146908_()) * ((float)Math.PI / 180));
            }
        }
        this.lastHitDirection = null;
        if (dmgVec != null && !MathUtils.isZero(dmgVec)) {
            if (dmgVec.y() == 1.0f) {
                Haptics.getAnimation(Haptics.Animations.TOP_HIT).playSingle(true, null);
            } else if (dmgVec.y() == -1.0f) {
                Haptics.getAnimation(Haptics.Animations.BOTTOM_HIT).playSingle(true, null);
            } else {
                dmgVec = dmgVec.rotateY(this.dh.vrPlayer.getVRDataWorld().getBodyYawRad() + (float)Math.PI, new Vector3f());
                Haptics.getAnimation(Haptics.Animations.GENERIC_HIT).playSingle(true, dmgVec);
            }
        } else {
            Haptics.getAnimation(Haptics.Animations.ALL_AROUND_HIT).playSingle(true, null);
        }
    }

    public void handleExplode(Vec3 explosionPos) {
        double explosionDist;
        if (this.isActive(this.mc.f_91074_) && (explosionDist = explosionPos.m_82546_(this.mc.f_91074_.m_20182_()).m_82553_()) < 5.0) {
            double distFactor = 1.0 - explosionDist / 5.0;
            Haptics.getAnimation(Haptics.Animations.EXPLOSION).playSingle(true, null, distFactor);
        }
    }

    public void handleEat(ItemStack itemStack) {
        if (this.isActive(this.mc.f_91074_) && itemStack.m_41614_() && itemStack.m_41720_().m_41473_() != null) {
            if (itemStack.m_41720_().m_41473_().m_38749_().isEmpty()) {
                Haptics.getAnimation(Haptics.Animations.CONSUME).playSingle(true, null);
            } else {
                Haptics.getAnimation(Haptics.Animations.CONSUME_EFFECT).playSingle(true, null);
            }
        }
    }

    public void setLastHitDirection(Vector3fc lastHitDirection) {
        this.lastHitDirection = lastHitDirection;
    }

    private static class RainModule
    extends HapticsModule {
        private static final double MIN_ANGLE = 0.0;
        private static final double DROP_CHANCE_THRESHOLD = 0.2;
        Random random = new Random();

        public RainModule() {
            this.enabled = false;
        }

        @Override
        void tick(LocalPlayer player) {
            if (!player.f_108545_.m_46471_()) {
                return;
            }
            boolean isSnow = ((Biome)player.f_108545_.m_204166_(player.m_20183_()).m_203334_()).m_198904_(player.m_20183_());
            Vec3 rainFall = new Vec3(0.0, -9.0, 0.0);
            Vector3f rainDir = MathUtils.subtractToVector3f(rainFall, player.m_20184_()).normalize().mul(-1.0f);
            ArrayList<RiggedBody.HapticPoint> points = RiggedBody.getInstance().getHapticPoints(PositionType.All);
            for (RiggedBody.HapticPoint p : points) {
                double snowFactor;
                if (!player.f_108545_.m_46758_(player.m_20183_())) continue;
                Vector3f normal = p.getNormal(true);
                double exposure = normal.dot((Vector3fc)rainDir);
                if (exposure < 0.0) {
                    exposure = 0.0;
                }
                double d = snowFactor = isSnow ? 2.0 : 1.0;
                if (!(Math.abs(this.random.nextGaussian()) * exposure > 0.2 * snowFactor)) continue;
                int intensity = 10;
                int duration = 10;
                p.motor.dot(intensity, duration);
            }
        }
    }

    private static abstract class HapticsModule {
        boolean enabled = false;

        private HapticsModule() {
        }

        abstract void tick(LocalPlayer var1);
    }
}

