/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.s2c;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.server.config.enums.ClimbeyBlockmode;

public record ClimbingPayloadS2C(boolean allowed, ClimbeyBlockmode blockmode, @Nullable List<String> blocks) implements VivecraftPayloadS2C
{
    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.CLIMBING;
    }

    @Override
    public void m_293110_(FriendlyByteBuf buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        buffer.writeBoolean(this.allowed);
        buffer.writeByte(this.blockmode.ordinal());
        if (this.blocks != null) {
            for (String block : this.blocks) {
                try {
                    Block b = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(block));
                    if (b == Blocks.f_50016_) continue;
                    buffer.m_130070_(block);
                }
                catch (ResourceLocationException resourceLocationException) {}
            }
        }
    }

    public static ClimbingPayloadS2C read(FriendlyByteBuf buffer) {
        boolean allowed = buffer.readBoolean();
        if (buffer.readableBytes() > 0) {
            ClimbeyBlockmode blockmode = ClimbeyBlockmode.values()[buffer.readByte()];
            ArrayList<String> blocks = new ArrayList<String>();
            if (buffer.readableBytes() > 0) {
                while (buffer.readableBytes() > 0) {
                    blocks.add(buffer.m_130277_());
                }
            }
            return new ClimbingPayloadS2C(allowed, blockmode, blocks);
        }
        return new ClimbingPayloadS2C(allowed, ClimbeyBlockmode.DISABLED, null);
    }
}

