/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.server;

import io.netty.channel.ChannelHandler;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.common.api_impl.VRAPIImpl;
import org.vivecraft.server.AimFixHandler;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerUtil;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin
extends ServerCommonPacketListenerImpl {
    @Shadow
    public ServerPlayer f_9743_;

    public ServerGamePacketListenerImplMixin(MinecraftServer server, Connection connection, CommonListenerCookie cookie) {
        super(server, connection, cookie);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vivecraft$addAimFix(CallbackInfo ci) {
        if (this.f_291338_.f_129468_ != null && this.f_291338_.f_129468_.pipeline().get("packet_handler") != null) {
            this.f_291338_.f_129468_.pipeline().addBefore("packet_handler", "vr_aim_fix", (ChannelHandler)new AimFixHandler(this.f_291338_));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void vivecraft$sendVRPlayers(CallbackInfo ci) {
        ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(this.f_9743_);
        if (vivePlayer != null) {
            if (this.f_9743_.m_9232_()) {
                ServerVRPlayers.getPlayersWithVivecraft(this.f_9743_.f_8924_).remove(this.f_9743_.m_20148_());
            } else if (vivePlayer.isVR() && vivePlayer.vrPlayerState() != null) {
                ServerNetworking.sendVrPlayerStateToClients(vivePlayer);
                if (((Boolean)ServerConfig.DEBUG_PARTICLES.get()).booleanValue()) {
                    ServerUtil.debugParticleAxes(vivePlayer);
                }
            }
        }
    }

    @Inject(method={"onDisconnect"}, at={@At(value="TAIL")})
    private void vivecraft$doPlayerLeave(CallbackInfo ci) {
        String message;
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() && !(message = (String)ServerConfig.MESSAGES_LEAVE_MESSAGE.get()).isEmpty()) {
            this.f_291389_.m_6846_().m_240416_((Component)Component.m_237113_((String)message.formatted(this.f_9743_.m_6302_())), false);
        }
        ServerVRPlayers.getPlayersWithVivecraft(this.f_291389_).remove(this.f_9743_.m_20148_());
        VRAPIImpl.INSTANCE.clearPoseHistory(this.f_9743_.m_20148_(), false);
    }
}

