/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.vivecraft.api.client.HeldInteractModule;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.common.network.packet.c2s.DrawPayloadC2S;

public class BowModule
implements HeldInteractModule {
    private static final class_2960 ID = class_2960.method_60655((String)"vivecraft", (String)"roomscale_bow");
    private final ClientDataHolderVR dh;
    private final boolean[] isPressed = new boolean[2];

    public BowModule(ClientDataHolderVR dh) {
        this.dh = dh;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public boolean onHoldTick(class_746 player, class_1268 hand) {
        return this.dh.bowTracker.isActive(player);
    }

    @Override
    public boolean isActive(class_746 player, class_1268 hand, class_243 handPosition) {
        return this.dh.bowTracker.isNotched() && hand == (this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow() ? class_1268.field_5810 : class_1268.field_5808);
    }

    @Override
    public void reset(class_746 player, class_1268 hand) {
        this.isPressed[hand.ordinal()] = false;
    }

    public boolean isPressed() {
        return this.isPressed[0] || this.isPressed[1];
    }

    @Override
    public boolean onPress(class_746 player, class_1268 hand) {
        this.isPressed[hand.ordinal()] = true;
        boolean bowInMain = BowTracker.isHoldingBow((class_1309)player, class_1268.field_5808);
        class_310.method_1551().field_1761.method_2919((class_1657)player, bowInMain ? class_1268.field_5808 : class_1268.field_5810);
        return false;
    }

    @Override
    public void onRelease(@Nullable class_746 player, class_1268 hand) {
        int arrowHand = hand == class_1268.field_5808 ? 0 : 1;
        int bowHand = 1 - arrowHand;
        this.dh.vr.triggerHapticPulse(arrowHand, 500);
        this.dh.vr.triggerHapticPulse(bowHand, 3000);
        ClientNetworking.sendServerPacket(new DrawPayloadC2S(this.dh.bowTracker.getDrawPercent()));
        ClientNetworking.sendActiveBodyPart(arrowHand == 0 ? VRBodyPart.MAIN_HAND : VRBodyPart.OFF_HAND, true);
        class_310.method_1551().field_1761.method_2897((class_1657)player);
        ClientNetworking.sendServerPacket(new DrawPayloadC2S(0.0f));
        ClientNetworking.resetActiveBodyPart();
    }
}

