/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.ItemInUseTracker;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveItemTags;

public class BowTracker
implements ItemInUseTracker,
DebugRenderTracker {
    private static final long MAX_DRAW_MILLIS = 1100L;
    private static final double NOTCH_DOT_THRESHOLD = 20.0;
    public long startDrawTime;
    private boolean wasDrawing;
    private boolean canDraw;
    private float currentDraw;
    private float maxDraw;
    private Vector3f aim;
    private float tsNotch = 0.0f;
    private int hapCounter = 0;
    private int lastHapStep = 0;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public BowTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    public Vector3fc getAimVector() {
        return this.aim;
    }

    public float getDrawPercent() {
        return this.currentDraw / this.maxDraw;
    }

    public boolean isNotched() {
        return this.canDraw || this.isDrawing();
    }

    public boolean isCharged() {
        return class_156.method_658() - this.startDrawTime >= 1100L;
    }

    public boolean isDrawing() {
        return this.dh.bowModule.isPressed();
    }

    public static boolean isBow(class_1799 itemStack) {
        if (itemStack == class_1799.field_8037) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.OFF) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.VANILLA) {
            return itemStack.method_7909() == class_1802.field_8102;
        }
        return itemStack.method_7909().method_7853(itemStack) == class_1839.field_8953 && !itemStack.method_31573(ViveItemTags.VIVECRAFT_BOW_EXCLUSION);
    }

    public static boolean isHoldingBow(class_1309 entity, class_1268 hand) {
        return !ClientDataHolderVR.getInstance().vrSettings.seated && BowTracker.isBow(entity.method_5998(hand));
    }

    public static boolean isHoldingBowEither(class_1309 entity) {
        return BowTracker.isHoldingBow(entity, class_1268.field_5808) || BowTracker.isHoldingBow(entity, class_1268.field_5810);
    }

    @Override
    public boolean itemInUse(class_746 player) {
        return this.isDrawing();
    }

    @Override
    public boolean isActive(class_746 player) {
        if (player == null) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (this.mc.field_1755 != null) {
            return false;
        }
        if (KeyboardHandler.SHOWING) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (player.method_6113()) {
            return false;
        }
        return BowTracker.isHoldingBowEither((class_1309)player);
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.wasDrawing = false;
        this.canDraw = false;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_FRAME;
    }

    @Override
    public void activeProcess(class_746 player) {
        VRData vrData = this.dh.vrPlayer.getVRDataWorld();
        boolean lastCanDraw = this.canDraw;
        this.maxDraw = this.mc.field_1724.method_17682() * 0.22f;
        this.maxDraw /= ScaleHelper.getEntityBbScale((class_1309)player, ClientUtils.getCurrentPartialTick());
        int bowHand = 1;
        int arrowHand = 0;
        if (this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
            bowHand = 0;
            arrowHand = 1;
        }
        class_243 arrowPos = vrData.getController(arrowHand).getPosition();
        class_243 bowPos = vrData.getController(bowHand).getPosition();
        float controllersDist = (float)bowPos.method_1022(arrowPos);
        Vector3f up = new Vector3f(0.0f, vrData.worldScale, 0.0f);
        class_243 stringPos = new class_243(vrData.getHand(bowHand).getCustomVector((Vector3fc)up).mul(this.maxDraw * 0.5f)).method_1019(bowPos);
        double notchDist = arrowPos.method_1022(stringPos);
        this.aim = MathUtils.subtractToVector3f(bowPos, arrowPos).normalize();
        Vector3f arrowAim = vrData.getController(arrowHand).getCustomVector(MathUtils.BACK);
        Vector3f bowAim = vrData.getHand(bowHand).getCustomVector(MathUtils.DOWN);
        double controllersDot = Math.toDegrees(Math.acos(bowAim.dot((Vector3fc)arrowAim)));
        float notchDistThreshold = 0.15f * vrData.worldScale;
        boolean main = BowTracker.isHoldingBow((class_1309)player, class_1268.field_5808);
        class_1799 ammo = class_1799.field_8037;
        class_1799 bow = class_1799.field_8037;
        if (main) {
            bow = player.method_6047();
            ammo = player.method_18808(bow);
        } else {
            if (player.method_6047().method_31573(class_3489.field_18317)) {
                ammo = player.method_6047();
            }
            bow = player.method_6079();
        }
        int stage0 = bow.method_7935((class_1309)player);
        int stage1 = bow.method_7935((class_1309)player) - 15;
        int stage2 = 0;
        if (ammo != class_1799.field_8037 && notchDist <= (double)notchDistThreshold && controllersDot <= 20.0) {
            this.canDraw = true;
            this.tsNotch = class_156.method_658();
            if (!this.isDrawing()) {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage0);
            }
        } else if (!this.isDrawing() && (float)class_156.method_658() - this.tsNotch > 500.0f) {
            this.canDraw = false;
        }
        if (this.isDrawing() && !this.wasDrawing) {
            this.startDrawTime = class_156.method_658();
        }
        if (!this.isDrawing() && this.canDraw && !lastCanDraw) {
            this.dh.vr.triggerHapticPulse(arrowHand, 800);
            this.dh.vr.triggerHapticPulse(bowHand, 800);
        }
        if (this.isDrawing()) {
            double drawPercent;
            this.currentDraw = (controllersDist - notchDistThreshold) / vrData.worldScale;
            if (this.currentDraw > this.maxDraw) {
                this.currentDraw = this.maxDraw;
            }
            int hapStrength = 0;
            if (this.getDrawPercent() > 0.0f) {
                hapStrength = (int)(this.getDrawPercent() * 500.0f) + 700;
            }
            if ((drawPercent = (double)this.getDrawPercent()) >= 1.0) {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage2);
            } else if (drawPercent > 0.4) {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage1);
            } else {
                ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage0);
            }
            int hapStep = (int)(drawPercent * 4.0 * 4.0 * 3.0);
            if (hapStep % 2 == 0 && this.lastHapStep != hapStep) {
                this.dh.vr.triggerHapticPulse(arrowHand, hapStrength);
                if (drawPercent == 1.0) {
                    this.dh.vr.triggerHapticPulse(bowHand, hapStrength);
                }
            }
            if (this.isCharged() && this.hapCounter % 4 == 0) {
                this.dh.vr.triggerHapticPulse(bowHand, 200);
            }
            this.lastHapStep = hapStep;
            ++this.hapCounter;
        } else {
            this.hapCounter = 0;
            this.lastHapStep = 0;
        }
        this.wasDrawing = this.isDrawing();
    }

    @Override
    public void renderDebug() {
        VRData world = this.dh.vrPlayer.getVRDataWorld();
        class_243 cam = world.getEye(this.dh.currentPass).getPosition();
        int bowHand = this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow() ? 0 : 1;
        Vector3f bowPos = MathUtils.subtractToVector3f(world.getController(bowHand).getPosition(), cam);
        if (this.isDrawing() || this.dh.vrSettings.seated) {
            DebugRenderHelper.renderLine(MathUtils.RED, new Vector3fc[]{bowPos, this.aim.mul(-1.0f, new Vector3f()).add((Vector3fc)bowPos)});
        } else {
            float dist = 0.15f * world.worldScale;
            VRData.VRDevicePose bowHandPose = world.getHand(bowHand);
            VRData.VRDevicePose arrowPose = world.getController(1 - bowHand);
            Vector3f stringPos = bowHandPose.getCustomVector(MathUtils.UP).mul(world.worldScale * this.maxDraw * 0.5f).add((Vector3fc)bowPos);
            DebugRenderHelper.renderSphere((Vector3fc)stringPos, dist, this.isNotched() ? MathUtils.GREEN : MathUtils.RED);
            Vector3f bowDir = bowHandPose.getCustomVector(MathUtils.DOWN);
            DebugRenderHelper.renderCone((Vector3fc)bowDir.mul(-dist, new Vector3f()).add((Vector3fc)stringPos), (Vector3fc)bowDir, 20.0f, 0.25f * world.worldScale, this.isNotched() ? MathUtils.GREEN : MathUtils.RED);
            DebugRenderHelper.renderLine(this.isNotched() ? MathUtils.GREEN : MathUtils.RED, new Vector3fc[]{MathUtils.subtractToVector3f(arrowPose.getPosition(), cam), MathUtils.subtractToVector3f(arrowPose.getPosition(), cam).add((Vector3fc)arrowPose.getDirection().mul(world.worldScale))});
        }
    }
}

