/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct PathWrite_t")
public class PathWrite
extends Struct<PathWrite>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ULPATH;
    public static final int WRITETYPE;
    public static final int ESETERROR;
    public static final int PVBUFFER;
    public static final int UNBUFFERSIZE;
    public static final int UNTAG;
    public static final int EERROR;
    public static final int PSZPATH;

    protected PathWrite(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected PathWrite create(long address, @Nullable ByteBuffer container) {
        return new PathWrite(address, container);
    }

    public PathWrite(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), PathWrite.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PathHandle_t")
    public long ulPath() {
        return PathWrite.nulPath(this.address());
    }

    @NativeType(value="EPropertyWriteType")
    public int writeType() {
        return PathWrite.nwriteType(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eSetError() {
        return PathWrite.neSetError(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pvBuffer() {
        return PathWrite.npvBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int unBufferSize() {
        return PathWrite.nunBufferSize(this.address());
    }

    @NativeType(value="PropertyTypeTag_t")
    public int unTag() {
        return PathWrite.nunTag(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eError() {
        return PathWrite.neError(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer pszPath() {
        return PathWrite.npszPath(this.address());
    }

    @NativeType(value="char *")
    public String pszPathString() {
        return PathWrite.npszPathString(this.address());
    }

    public PathWrite ulPath(@NativeType(value="PathHandle_t") long value) {
        PathWrite.nulPath(this.address(), value);
        return this;
    }

    public PathWrite writeType(@NativeType(value="EPropertyWriteType") int value) {
        PathWrite.nwriteType(this.address(), value);
        return this;
    }

    public PathWrite eSetError(@NativeType(value="ETrackedPropertyError") int value) {
        PathWrite.neSetError(this.address(), value);
        return this;
    }

    public PathWrite pvBuffer(@NativeType(value="void *") ByteBuffer value) {
        PathWrite.npvBuffer(this.address(), value);
        return this;
    }

    public PathWrite unTag(@NativeType(value="PropertyTypeTag_t") int value) {
        PathWrite.nunTag(this.address(), value);
        return this;
    }

    public PathWrite eError(@NativeType(value="ETrackedPropertyError") int value) {
        PathWrite.neError(this.address(), value);
        return this;
    }

    public PathWrite pszPath(@NativeType(value="char *") ByteBuffer value) {
        PathWrite.npszPath(this.address(), value);
        return this;
    }

    public PathWrite set(long ulPath, int writeType, int eSetError, ByteBuffer pvBuffer, int unTag, int eError, ByteBuffer pszPath) {
        this.ulPath(ulPath);
        this.writeType(writeType);
        this.eSetError(eSetError);
        this.pvBuffer(pvBuffer);
        this.unTag(unTag);
        this.eError(eError);
        this.pszPath(pszPath);
        return this;
    }

    public PathWrite set(PathWrite src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static PathWrite malloc() {
        return new PathWrite(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static PathWrite calloc() {
        return new PathWrite(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static PathWrite create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new PathWrite(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static PathWrite create(long address) {
        return new PathWrite(address, null);
    }

    @Nullable
    public static PathWrite createSafe(long address) {
        return address == 0L ? null : new PathWrite(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)PathWrite.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = PathWrite.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static PathWrite malloc(MemoryStack stack) {
        return new PathWrite(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static PathWrite calloc(MemoryStack stack) {
        return new PathWrite(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nulPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)ULPATH);
    }

    public static int nwriteType(long struct) {
        return UNSAFE.getInt(null, struct + (long)WRITETYPE);
    }

    public static int neSetError(long struct) {
        return UNSAFE.getInt(null, struct + (long)ESETERROR);
    }

    public static ByteBuffer npvBuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)), (int)PathWrite.nunBufferSize(struct));
    }

    public static int nunBufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNBUFFERSIZE);
    }

    public static int nunTag(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNTAG);
    }

    public static int neError(long struct) {
        return UNSAFE.getInt(null, struct + (long)EERROR);
    }

    public static ByteBuffer npszPath(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PSZPATH)));
    }

    public static String npszPathString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)PSZPATH)));
    }

    public static void nulPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ULPATH, value);
    }

    public static void nwriteType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WRITETYPE, value);
    }

    public static void neSetError(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ESETERROR, value);
    }

    public static void npvBuffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVBUFFER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        PathWrite.nunBufferSize(struct, value.remaining());
    }

    public static void nunBufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNBUFFERSIZE, value);
    }

    public static void nunTag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNTAG, value);
    }

    public static void neError(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EERROR, value);
    }

    public static void npszPath(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PSZPATH), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSZPATH)));
    }

    static {
        Struct.Layout layout = PathWrite.__struct((Struct.Member[])new Struct.Member[]{PathWrite.__member((int)8), PathWrite.__member((int)4), PathWrite.__member((int)4), PathWrite.__member((int)POINTER_SIZE), PathWrite.__member((int)4), PathWrite.__member((int)4), PathWrite.__member((int)4), PathWrite.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ULPATH = layout.offsetof(0);
        WRITETYPE = layout.offsetof(1);
        ESETERROR = layout.offsetof(2);
        PVBUFFER = layout.offsetof(3);
        UNBUFFERSIZE = layout.offsetof(4);
        UNTAG = layout.offsetof(5);
        EERROR = layout.offsetof(6);
        PSZPATH = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<PathWrite, Buffer>
    implements NativeResource {
        private static final PathWrite ELEMENT_FACTORY = PathWrite.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected PathWrite getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="PathHandle_t")
        public long ulPath() {
            return PathWrite.nulPath(this.address());
        }

        @NativeType(value="EPropertyWriteType")
        public int writeType() {
            return PathWrite.nwriteType(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eSetError() {
            return PathWrite.neSetError(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pvBuffer() {
            return PathWrite.npvBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int unBufferSize() {
            return PathWrite.nunBufferSize(this.address());
        }

        @NativeType(value="PropertyTypeTag_t")
        public int unTag() {
            return PathWrite.nunTag(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eError() {
            return PathWrite.neError(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pszPath() {
            return PathWrite.npszPath(this.address());
        }

        @NativeType(value="char *")
        public String pszPathString() {
            return PathWrite.npszPathString(this.address());
        }

        public Buffer ulPath(@NativeType(value="PathHandle_t") long value) {
            PathWrite.nulPath(this.address(), value);
            return this;
        }

        public Buffer writeType(@NativeType(value="EPropertyWriteType") int value) {
            PathWrite.nwriteType(this.address(), value);
            return this;
        }

        public Buffer eSetError(@NativeType(value="ETrackedPropertyError") int value) {
            PathWrite.neSetError(this.address(), value);
            return this;
        }

        public Buffer pvBuffer(@NativeType(value="void *") ByteBuffer value) {
            PathWrite.npvBuffer(this.address(), value);
            return this;
        }

        public Buffer unTag(@NativeType(value="PropertyTypeTag_t") int value) {
            PathWrite.nunTag(this.address(), value);
            return this;
        }

        public Buffer eError(@NativeType(value="ETrackedPropertyError") int value) {
            PathWrite.neError(this.address(), value);
            return this;
        }

        public Buffer pszPath(@NativeType(value="char *") ByteBuffer value) {
            PathWrite.npszPath(this.address(), value);
            return this;
        }
    }
}

