/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRMovementStyle;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveBlockTags;

public class TeleportTracker
implements Tracker {
    private float teleportEnergy;
    private class_243 movementTeleportDestination = class_243.field_1353;
    private class_2350 movementTeleportDestinationSideHit;
    public double movementTeleportProgress;
    public double movementTeleportDistance;
    private int movementTeleportTimer = 0;
    private final class_243[] movementTeleportArc = new class_243[50];
    public int movementTeleportArcSteps = 0;
    public double lastTeleportArcDisplayOffset = 0.0;
    public VRMovementStyle vrMovementStyle;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public TeleportTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
        this.vrMovementStyle = new VRMovementStyle();
    }

    public float getTeleportEnergy() {
        return this.teleportEnergy;
    }

    public boolean isAiming() {
        return this.movementTeleportProgress > 0.0;
    }

    public class_243 getDestination() {
        return this.movementTeleportDestination;
    }

    @Override
    public boolean isActive(class_746 p) {
        if (p == null) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (!p.method_5805()) {
            return false;
        }
        return !p.method_6113();
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.movementTeleportDestination = class_243.field_1353;
        this.movementTeleportArcSteps = 0;
        this.movementTeleportProgress = 0.0;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        boolean seatedTeleport;
        Random random = new Random();
        if (this.teleportEnergy < 100.0f) {
            this.teleportEnergy += 1.0f;
        }
        boolean doTeleport = false;
        class_243 destination = null;
        boolean bindingTeleport = VivecraftVRMod.INSTANCE.keyTeleport.method_1434() && this.dh.vrPlayer.isTeleportEnabled();
        boolean bl = seatedTeleport = this.dh.vrSettings.seated && !this.dh.vrPlayer.getFreeMove() && (player.field_3913.field_3905 != 0.0f || player.field_3913.field_3907 != 0.0f);
        if ((bindingTeleport || seatedTeleport) && !player.method_5765()) {
            destination = this.movementTeleportDestination;
            if (this.vrMovementStyle.teleportOnRelease || this.movementTeleportTimer >= 0 && (destination.field_1352 != 0.0 || destination.field_1351 != 0.0 || destination.field_1350 != 0.0)) {
                if (this.movementTeleportTimer == 0 && this.vrMovementStyle.startTeleportingSound != null) {
                    player.method_5783(this.vrMovementStyle.startTeleportingSound, this.vrMovementStyle.startTeleportingSoundVolume, 1.0f / (random.nextFloat() * 0.4f + 1.2f) + 0.5f);
                }
                ++this.movementTeleportTimer;
                if (this.movementTeleportTimer > 0) {
                    if (this.vrMovementStyle.teleportOnRelease) {
                        this.movementTeleportProgress = 1.0;
                    } else {
                        class_243 playerPos = player.method_19538();
                        double dist = destination.method_1022(playerPos);
                        this.movementTeleportProgress = (double)this.movementTeleportTimer / (dist + 3.0);
                    }
                    if (destination.field_1352 != 0.0 || destination.field_1351 != 0.0 || destination.field_1350 != 0.0) {
                        if (this.vrMovementStyle.destinationSparkles) {
                            // empty if block
                        }
                        if (this.vrMovementStyle.airSparkles) {
                            class_243 eyeCenterPos = this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition();
                            if (!this.vrMovementStyle.teleportOnRelease) {
                                eyeCenterPos = player.method_19538();
                            }
                            class_243 motionDir = destination.method_1020(eyeCenterPos).method_1029();
                            class_243 forward = player.method_5720();
                            class_243 right = forward.method_1036(MathUtils.UP_D);
                            class_243 up = right.method_1036(forward);
                            for (int iParticle = 0; iParticle < 3; ++iParticle) {
                                double forwardDist = random.nextDouble() + 3.5;
                                double upDist = random.nextDouble() * 2.5;
                                double rightDist = random.nextDouble() * 4.0 - 2.0;
                                class_243 sparkPos = new class_243(eyeCenterPos.field_1352 + forward.field_1352 * forwardDist, eyeCenterPos.field_1351 + forward.field_1351 * forwardDist, eyeCenterPos.field_1350 + forward.field_1350 * forwardDist);
                                sparkPos = sparkPos.method_1031(right.field_1352 * rightDist, right.field_1351 * rightDist, right.field_1350 * rightDist);
                                sparkPos.method_1031(up.field_1352 * upDist, up.field_1351 * upDist, up.field_1350 * upDist);
                                double d = -0.6;
                            }
                        }
                    }
                } else if (!this.vrMovementStyle.teleportOnRelease) {
                    this.movementTeleportProgress = 0.0;
                }
                if (!this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                    doTeleport = true;
                }
            }
        } else {
            if (this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                destination = this.movementTeleportDestination;
                doTeleport = true;
            }
            this.movementTeleportTimer = 0;
            this.movementTeleportProgress = 0.0;
        }
        if (doTeleport && destination != null && (destination.field_1352 != 0.0 || destination.field_1351 != 0.0 || destination.field_1350 != 0.0)) {
            this.movementTeleportDistance = destination.method_1022(player.method_19538());
            if (!this.dh.vrPlayer.isTeleportSupported()) {
                String command = "/tp " + destination.field_1352 + " " + destination.field_1351 + " " + destination.field_1350;
                player.method_3142(command);
            } else {
                if (ClientNetworking.SERVER_SUPPORTS_DIRECT_TELEPORT) {
                    ((PlayerExtension)player).vivecraft$setTeleported(true);
                }
                player.method_24203(destination.field_1352, destination.field_1351, destination.field_1350);
            }
            this.doTeleportCallback();
            if (this.movementTeleportDistance > 0.0 && this.vrMovementStyle.endTeleportingSound != null) {
                player.method_5783(this.vrMovementStyle.endTeleportingSound, this.vrMovementStyle.endTeleportingSoundVolume, 1.0f);
            } else {
                ((PlayerExtension)player).vivecraft$stepSound(new class_2338(destination), destination);
            }
        }
    }

    public void updateTeleportDestinations(class_746 player) {
        this.mc.method_16011().method_15396("updateTeleportDestinations");
        if (this.vrMovementStyle.arcAiming) {
            this.movementTeleportDestination = class_243.field_1353;
            if (this.movementTeleportProgress > 0.0) {
                this.updateTeleportArc(player);
            }
        }
        this.mc.method_16011().method_15407();
    }

    private void updateTeleportArc(class_746 player) {
        int controller = this.dh.vrSettings.seated ? 0 : 1;
        class_243 start = RenderHelper.getControllerRenderPos(controller);
        VRData.VRDevicePose controllerWorld = this.dh.vrPlayer.vrdata_world_render.getController(controller);
        int maxSteps = 50;
        this.movementTeleportArc[0] = new class_243(start.field_1352, start.field_1351, start.field_1350);
        this.movementTeleportArcSteps = 1;
        float gravityAcceleration = 0.098f;
        Vector3f gravity = controllerWorld.getMatrix().rotateZ(controllerWorld.getRollRad()).transformDirection(MathUtils.DOWN, new Vector3f()).mul(0.098f);
        float speed = 0.5f;
        Vector3f velocity = controllerWorld.getDirection().mul(0.5f);
        class_243 pos = new class_243(start.field_1352, start.field_1351, start.field_1350);
        for (int i = this.movementTeleportArcSteps; i < maxSteps && (float)(i * 4) <= this.teleportEnergy; ++i) {
            class_243 newPos = new class_243(pos.field_1352 + (double)velocity.x, pos.field_1351 + (double)velocity.y, pos.field_1350 + (double)velocity.z);
            class_3965 blockhitresult = this.mc.field_1687.method_17742(new class_3959(pos, newPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)player));
            if (blockhitresult.method_17783() != class_239.class_240.field_1333) {
                boolean ok;
                this.movementTeleportArc[i] = blockhitresult.method_17784();
                this.movementTeleportArcSteps = i + 1;
                this.checkAndSetTeleportDestination(player, start, blockhitresult);
                class_243 diff = player.method_19538().method_1020(this.movementTeleportDestination);
                double yDiff = diff.field_1351;
                this.movementTeleportDistance = diff.method_1033();
                double xzDiff = Math.sqrt(diff.field_1352 * diff.field_1352 + diff.field_1350 * diff.field_1350);
                boolean bl = ok = !player.method_5715() || !(yDiff > 0.2);
                if (!player.method_31549().field_7478 && ClientNetworking.isLimitedSurvivalTeleport()) {
                    if (ClientNetworking.getTeleportDownLimit() > 0 && yDiff > (double)ClientNetworking.getTeleportDownLimit() + 0.2) {
                        ok = false;
                    } else if (ClientNetworking.getTeleportUpLimit() > 0 && -yDiff > (double)((float)ClientNetworking.getTeleportUpLimit() * ((PlayerExtension)player).vivecraft$getMuhJumpFactor()) + 0.2) {
                        ok = false;
                    } else if (ClientNetworking.getTeleportHorizLimit() > 0 && xzDiff > (double)((float)ClientNetworking.getTeleportHorizLimit() * ((PlayerExtension)player).vivecraft$getMuhSpeedFactor()) + 0.2) {
                        ok = false;
                    }
                }
                if (ok) break;
                this.movementTeleportDestination = class_243.field_1353;
                this.movementTeleportDistance = 0.0;
                break;
            }
            pos = new class_243(newPos.field_1352, newPos.field_1351, newPos.field_1350);
            this.movementTeleportArc[i] = new class_243(newPos.field_1352, newPos.field_1351, newPos.field_1350);
            this.movementTeleportArcSteps = i + 1;
            velocity = velocity.add((Vector3fc)gravity);
        }
    }

    private void doTeleportCallback() {
        this.dh.swingTracker.disableSwing = 3;
        if (ClientNetworking.isLimitedSurvivalTeleport()) {
            this.mc.field_1724.method_7322((float)(this.movementTeleportDistance / 16.0 * 1.2));
            if (this.mc.field_1761.method_2924() && this.vrMovementStyle.arcAiming) {
                this.teleportEnergy -= (float)this.movementTeleportDistance * 4.0f;
            }
        }
        this.mc.field_1724.field_6017 = 0.0f;
        this.movementTeleportTimer = -1;
    }

    private boolean checkAndSetTeleportDestination(class_746 player, class_243 start, class_3965 collision) {
        class_2338 blockpos = collision.method_17777();
        class_2680 blockState = player.field_6002.method_8320(blockpos);
        if (!this.mc.field_1687.method_8316(blockpos).method_15769()) {
            class_243 hitVec = new class_243(collision.method_17784().field_1352, (double)blockpos.method_10264(), collision.method_17784().field_1350);
            class_243 offset = hitVec.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
            class_238 aabb = player.method_5829().method_989(offset.field_1352, offset.field_1351, offset.field_1350);
            boolean emptySpotReq = this.mc.field_1687.method_8587((class_1297)player, aabb);
            if (!emptySpotReq) {
                class_243 center = class_243.method_24955((class_2382)blockpos);
                offset = center.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
                aabb = player.method_5829().method_989(offset.field_1352, offset.field_1351, offset.field_1350);
                emptySpotReq = this.mc.field_1687.method_8587((class_1297)player, aabb);
            }
            float ex = 0.0f;
            if (this.dh.vrSettings.seated) {
                ex = 0.5f;
            }
            if (emptySpotReq) {
                this.movementTeleportDestination = new class_243(aabb.method_1005().field_1352, aabb.field_1322 + (double)ex, aabb.method_1005().field_1350);
                this.movementTeleportDestinationSideHit = collision.method_17780();
                return true;
            }
        } else if (collision.method_17780() != class_2350.field_11036) {
            if (blockState.method_26204() instanceof class_2399 || blockState.method_26204() instanceof class_2541 || blockState.method_26164(ViveBlockTags.VIVECRAFT_CLIMBABLE)) {
                class_243 dest = new class_243((double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264() + 0.5, (double)blockpos.method_10260() + 0.5);
                class_2248 block = this.mc.field_1687.method_8320(blockpos.method_10074()).method_26204();
                if (block == blockState.method_26204()) {
                    dest = dest.method_1031(0.0, -1.0, 0.0);
                }
                this.movementTeleportDestination = dest.method_1021(1.0);
                this.movementTeleportDestinationSideHit = collision.method_17780();
                return true;
            }
            if (!player.method_31549().field_7478 && ClientNetworking.isLimitedSurvivalTeleport()) {
                return false;
            }
        }
        class_2338 hitBlock = collision.method_17777().method_10074();
        for (int i = 0; i < 2; ++i) {
            blockState = player.field_6002.method_8320(hitBlock);
            if (!blockState.method_26220((class_1922)this.mc.field_1687, hitBlock).method_1110()) {
                boolean emptySpotReq;
                double height = blockState.method_26220((class_1922)this.mc.field_1687, hitBlock).method_1105(class_2350.class_2351.field_11052);
                class_243 hitVec = new class_243(collision.method_17784().field_1352, (double)hitBlock.method_10264() + height, collision.method_17784().field_1350);
                class_243 offset = hitVec.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
                class_238 aabb = player.method_5829().method_989(offset.field_1352, offset.field_1351, offset.field_1350);
                double ex = 0.0;
                if (blockState.method_26204() == class_2246.field_10114 || blockState.method_26204() == class_2246.field_21211) {
                    ex = 0.05;
                }
                boolean bl = emptySpotReq = this.mc.field_1687.method_8587((class_1297)player, aabb) && !this.mc.field_1687.method_8587((class_1297)player, aabb.method_1009(0.0, 0.125 + ex, 0.0));
                if (!emptySpotReq) {
                    class_243 center = class_243.method_26410((class_2382)hitBlock, (double)height);
                    offset = center.method_1023(player.method_23317(), player.method_5829().field_1322, player.method_23321());
                    aabb = player.method_5829().method_989(offset.field_1352, offset.field_1351, offset.field_1350);
                    boolean bl2 = emptySpotReq = this.mc.field_1687.method_8587((class_1297)player, aabb) && !this.mc.field_1687.method_8587((class_1297)player, aabb.method_1009(0.0, 0.125 + ex, 0.0));
                }
                if (emptySpotReq) {
                    class_243 dest = new class_243(aabb.method_1005().field_1352, (double)hitBlock.method_10264() + height, aabb.method_1005().field_1350);
                    this.movementTeleportDestination = dest.method_1021(1.0);
                    return true;
                }
            }
            hitBlock = hitBlock.method_10084();
        }
        return false;
    }

    public class_243 getInterpolatedArcPosition(float progress) {
        if (this.movementTeleportArcSteps == 1 || progress <= 0.0f) {
            return new class_243(this.movementTeleportArc[0].field_1352, this.movementTeleportArc[0].field_1351, this.movementTeleportArc[0].field_1350);
        }
        if (progress >= 1.0f) {
            return new class_243(this.movementTeleportArc[this.movementTeleportArcSteps - 1].field_1352, this.movementTeleportArc[this.movementTeleportArcSteps - 1].field_1351, this.movementTeleportArc[this.movementTeleportArcSteps - 1].field_1350);
        }
        float stepFloat = progress * (float)(this.movementTeleportArcSteps - 1);
        int step = (int)Math.floor(stepFloat);
        double deltaX = this.movementTeleportArc[step + 1].field_1352 - this.movementTeleportArc[step].field_1352;
        double deltaY = this.movementTeleportArc[step + 1].field_1351 - this.movementTeleportArc[step].field_1351;
        double deltaZ = this.movementTeleportArc[step + 1].field_1350 - this.movementTeleportArc[step].field_1350;
        float stepProgress = stepFloat - (float)step;
        return new class_243(this.movementTeleportArc[step].field_1352 + deltaX * (double)stepProgress, this.movementTeleportArc[step].field_1351 + deltaY * (double)stepProgress, this.movementTeleportArc[step].field_1350 + deltaZ * (double)stepProgress);
    }
}

