/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui.keyboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.settings.VRSettings;

public class KeyboardKeys {
    public static final int COLUMNS = 13;
    public static final int ROWS = 4;
    public static final int MAX_ROWS = 7;
    public static final int SPECIAL_KEY_WIDTH = 2;
    private static final List<Key> SPECIAL_KEYS = new ArrayList<Key>();
    private static int SPECIAL_INDEX = 1000;
    public static final Key SHIFT_1 = KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 0, 4, "shift", () -> {}));
    public static final Key SHIFT_2 = KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 15, 4, "shift", () -> {}));

    private static Key addSpecial(Key key) {
        SPECIAL_KEYS.add(key);
        return key;
    }

    public static List<Key> getSpecialKeys(Runnable shiftTask) {
        ArrayList<Key> keys = new ArrayList<Key>(SPECIAL_KEYS.size());
        for (Key key : SPECIAL_KEYS) {
            if (key.isShift()) {
                keys.add(new Key(key.id, key.x, key.y, key.width, key.height, key.label, shiftTask, () -> {}));
                continue;
            }
            keys.add(key);
        }
        return keys;
    }

    public static List<Key> getSpecialKeys() {
        return Collections.unmodifiableList(SPECIAL_KEYS);
    }

    public static Layout getRegularKeys(boolean shift, Runnable afterPress) {
        return KeyboardKeys.getRegularKeys(ClientDataHolderVR.getInstance().vrSettings.getKeyboardLayout(), shift, afterPress);
    }

    public static Layout getRegularKeys(VRSettings.KeyboardLayout layout, boolean shift, Runnable afterPress) {
        VRSettings vrSettings = ClientDataHolderVR.getInstance().vrSettings;
        String chars = shift ? layout.shift().get() : layout.regular().get();
        int rows = 4;
        float calcRows = (float)chars.length() / 13.0f;
        if (Math.abs(4.0f - calcRows) > 0.01f) {
            rows = class_3532.method_15386((float)calcRows);
        }
        ArrayList<Key> keys = new ArrayList<Key>(rows * 13);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < 13; ++column) {
                int index = row * 13 + column;
                char ch = index < chars.length() ? chars.charAt(index) : (char)'\u0000';
                int code = index < vrSettings.keyboardCodes.length ? vrSettings.keyboardCodes[index] : -1;
                keys.add(Key.single(shift ? index + 500 : index, column + 2, 1 + row, code, ch, afterPress));
            }
        }
        return new Layout(keys, 13, rows);
    }

    static {
        KeyboardKeys.addSpecial(new Key(SPECIAL_INDEX++, 6, -1, 5, 1, " ", 32, ' '));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 0, 2, "tab", 258));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 0, 1, "esc", 256));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 15, 1, "backspace", 259));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 15, 3, "enter", 257));
        KeyboardKeys.addSpecial(Key.single(SPECIAL_INDEX++, 16, 5, "\u2191", 265));
        KeyboardKeys.addSpecial(Key.single(SPECIAL_INDEX++, 16, 6, "\u2193", 264));
        KeyboardKeys.addSpecial(Key.single(SPECIAL_INDEX++, 15, 6, "\u2190", 263));
        KeyboardKeys.addSpecial(Key.single(SPECIAL_INDEX++, 17, 6, "\u2192", 262));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 2, 0, "cut", () -> {
            InputSimulator.pressKey(341);
            InputSimulator.pressKey(88);
            InputSimulator.releaseKey(88);
            InputSimulator.releaseKey(341);
        }));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 4, 0, "copy", () -> {
            InputSimulator.pressKey(341);
            InputSimulator.pressKey(67);
            InputSimulator.releaseKey(67);
            InputSimulator.releaseKey(341);
        }));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 6, 0, "paste", () -> {
            InputSimulator.pressKey(341);
            InputSimulator.pressKey(86);
            InputSimulator.releaseKey(86);
            InputSimulator.releaseKey(341);
        }));
        KeyboardKeys.addSpecial(Key.wide(SPECIAL_INDEX++, 8, 0, "switch", () -> ClientDataHolderVR.getInstance().vrSettings.nextKeyboardLayout()));
    }

    public record Key(int id, int x, int y, int width, int height, class_2561 label, Runnable onPress, Runnable onRelease) {
        private Key(int id, int x, int y, int width, int height, String label, int keyCode, char keyChar) {
            this(id, x, y, width, height, label, keyCode, keyChar, () -> {});
        }

        private Key(int id, int x, int y, int width, int height, String label, int keyCode, char keyChar, Runnable afterPress) {
            this(id, x, y, width, height, (class_2561)new class_2585(label), () -> {
                InputSimulator.pressKeyForBind(keyCode);
                if (keyChar != '\u0000') {
                    InputSimulator.typeChar(keyChar);
                }
                if (keyChar == '/' && class_310.method_1551().field_1755 == null) {
                    InputSimulator.pressKey(47);
                    InputSimulator.releaseKey(47);
                }
                afterPress.run();
            }, () -> InputSimulator.releaseKeyForBind(keyCode));
        }

        private static Key single(int id, int x, int y, int keyCode, char keyChar, Runnable afterPress) {
            return new Key(id, x, y, 1, 1, keyChar != '\u0000' ? String.valueOf(keyChar) : "", keyCode, keyChar, afterPress);
        }

        private static Key single(int id, int x, int y, String label, int keyCode) {
            return new Key(id, x, y, 1, 1, (class_2561)new class_2585(label), () -> InputSimulator.pressKey(keyCode), () -> InputSimulator.releaseKey(keyCode));
        }

        private static Key wide(int id, int x, int y, String langKey, int keyCode) {
            return new Key(id, x, y, 2, 1, (class_2561)new class_2588("vivecraft.keyboard.key." + langKey), () -> InputSimulator.pressKey(keyCode), () -> InputSimulator.releaseKey(keyCode));
        }

        private static Key wide(int id, int x, int y, String langKey, Runnable onPress) {
            return new Key(id, x, y, 2, 1, (class_2561)new class_2588("vivecraft.keyboard.key." + langKey), onPress, () -> {});
        }

        public boolean isShift() {
            return this.id == KeyboardKeys.SHIFT_1.id || this.id == KeyboardKeys.SHIFT_2.id;
        }
    }

    public record Layout(List<Key> keys, int columns, int rows) {
    }
}

