/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1160;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2378;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.utils.UpdateChecker;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ConfigBuilder;
import org.vivecraft.server.config.ServerConfig;

public class ServerUtil {
    public static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();

    public static void scheduleWelcomeMessageOrKick(class_3222 serverPlayer) {
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() || ((Boolean)ServerConfig.VIVE_ONLY.get()).booleanValue() || ((Boolean)ServerConfig.VR_ONLY.get()).booleanValue()) {
            SCHEDULER.schedule(() -> {
                if (!serverPlayer.method_14239()) {
                    ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                    String message = "";
                    if (ServerUtil.kickIfNotAllowed(serverPlayer)) {
                        return;
                    }
                    if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue() && !(message = vivePlayer == null ? (String)ServerConfig.MESSAGES_WELCOME_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_WELCOME_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_WELCOME_SEATED.get() : (String)ServerConfig.MESSAGES_WELCOME_VR.get()))).isEmpty()) {
                        try {
                            serverPlayer.field_13995.method_3760().method_14616((class_2561)new class_2585(message.formatted(serverPlayer.method_5477().getString())), class_2556.field_11735, class_156.field_25140);
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("Vivecraft: Welcome message '{}' has errors: ", (Object)message, (Object)e);
                        }
                    }
                }
            }, (long)((Double)ServerConfig.MESSAGE_KICK_DELAY.get() * 1000.0), TimeUnit.MILLISECONDS);
        }
    }

    public static boolean kickIfNotAllowed(class_3222 player) {
        if (!player.method_14239()) {
            boolean isOpAndAllowed;
            ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(player);
            boolean bl = isOpAndAllowed = (Boolean)ServerConfig.ALLOW_OP.get() != false && player.field_13995.method_3760().method_14569(player.method_7334());
            if (!(isOpAndAllowed || !((Boolean)ServerConfig.VR_ONLY.get()).booleanValue() || vivePlayer != null && vivePlayer.isVR())) {
                String kickMessage = (String)ServerConfig.MESSAGES_KICK_VR_ONLY.get();
                try {
                    kickMessage = kickMessage.formatted(player.method_5477().getString());
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: KickVROnly message '{}' has errors: ", (Object)kickMessage, (Object)e);
                }
                player.field_13987.method_14367((class_2561)new class_2585(kickMessage));
                return true;
            }
            if (!isOpAndAllowed && ((Boolean)ServerConfig.VIVE_ONLY.get()).booleanValue() && vivePlayer == null) {
                String kickMessage = (String)ServerConfig.MESSAGES_KICK_VIVE_ONLY.get();
                try {
                    kickMessage = kickMessage.formatted(player.method_5477().getString());
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: KickViveOnly message '{}' has errors: ", (Object)kickMessage, (Object)e);
                }
                player.field_13987.method_14367((class_2561)new class_2585(kickMessage));
                return true;
            }
        }
        return false;
    }

    public static void sendUpdateNotificationIfOP(class_3222 serverPlayer) {
        if (((Boolean)ServerConfig.CHECK_FOR_UPDATES.get()).booleanValue() && serverPlayer.field_13995.method_3816() && serverPlayer.field_13995.method_3760().method_14569(serverPlayer.method_7334())) {
            SCHEDULER.schedule(() -> {
                if (UpdateChecker.checkForUpdates()) {
                    serverPlayer.method_9203((class_2561)new class_2585("Vivecraft update available: \u00a7a" + UpdateChecker.NEWEST_VERSION), class_156.field_25140);
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"reload").executes(context -> {
            ServerConfig.init((action, path, incorrectValue, correctedValue) -> {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Corrected \u00a7a[%s]\u00a7r: was '(%s)%s', is now '(%s)%s'".formatted(String.join((CharSequence)"\u00a7r.\u00a7a", path), incorrectValue.getClass().getSimpleName(), incorrectValue, correctedValue.getClass().getSimpleName(), correctedValue)), true);
                String pathString = String.join((CharSequence)".", path);
                ServerConfig.getConfigValues().stream().filter(c -> c.getPath().equals(pathString)).findFirst().ifPresent(setting -> {
                    setting.onUpdate(((class_2168)context.getSource()).method_9211());
                    ServerNetworking.sendUpdatePacketToAll(((class_2168)context.getSource()).method_9211(), setting);
                });
            });
            return 1;
        })));
        for (ConfigBuilder.ConfigValue setting : ServerConfig.getConfigValues()) {
            IntegerArgumentType argument;
            String argumentName;
            Class<?> clazz = setting.get().getClass();
            if (clazz == Integer.class) {
                argumentName = "int";
                argument = IntegerArgumentType.integer();
            } else if (clazz == Double.class) {
                argumentName = "double";
                argument = DoubleArgumentType.doubleArg();
            } else if (clazz == Boolean.class) {
                argumentName = "bool";
                argument = BoolArgumentType.bool();
            } else {
                argumentName = "string";
                argument = StringArgumentType.string();
            }
            LiteralArgumentBuilder baseCommand = class_2170.method_9247((String)setting.getPath());
            if (setting instanceof ConfigBuilder.InListValue) {
                ConfigBuilder.InListValue inListValue = (ConfigBuilder.InListValue)setting;
                baseCommand.then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Object value : inListValue.getValidValues()) {
                        if (!value.toString().toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    Object newValue = context.getArgument(argumentName, clazz);
                    if (inListValue.getValidValues().contains(newValue)) {
                        setting.set(newValue);
                        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)), true);
                        setting.onUpdate(((class_2168)context.getSource()).method_9211());
                        ServerNetworking.sendUpdatePacketToAll(((class_2168)context.getSource()).method_9211(), setting);
                        return 1;
                    }
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)new class_2585("Unsupported value: " + newValue.toString()));
                })));
            } else if (setting instanceof ConfigBuilder.EnumValue) {
                ConfigBuilder.EnumValue enumValue = (ConfigBuilder.EnumValue)setting;
                baseCommand.then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Enum value : enumValue.getValidValues()) {
                        if (!value.toString().toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    Object newValue = context.getArgument(argumentName, String.class);
                    Object newEnumValue = enumValue.getEnumValue(newValue);
                    if (newEnumValue != null) {
                        setting.set(newEnumValue);
                        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newEnumValue)), true);
                        setting.onUpdate(((class_2168)context.getSource()).method_9211());
                        ServerNetworking.sendUpdatePacketToAll(((class_2168)context.getSource()).method_9211(), setting);
                        return 1;
                    }
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)new class_2585("Unsupported value: " + newValue.toString()));
                })));
            } else if (!(setting.get() instanceof List)) {
                baseCommand.then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)argumentName, (ArgumentType)argument).executes(context -> {
                    Object newValue = context.getArgument(argumentName, clazz);
                    setting.set(newValue);
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("set \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)), true);
                    setting.onUpdate(((class_2168)context.getSource()).method_9211());
                    ServerNetworking.sendUpdatePacketToAll(((class_2168)context.getSource()).method_9211(), setting);
                    return 1;
                })));
            } else {
                ConfigBuilder.ConfigValue listConfig = setting;
                baseCommand.then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).executes(context -> {
                    try {
                        String newValue = class_2378.field_11146.method_10221((Object)((class_2247)context.getArgument("block", class_2247.class)).method_9494().method_26204()).toString();
                        List list = (List)listConfig.get();
                        list.add(newValue);
                        listConfig.set(list);
                        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("added '%s' to \u00a7a[%s]\u00a7r".formatted(newValue, setting.getPath())), true);
                        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("is now '%s'".formatted(setting.get())), true);
                        setting.onUpdate(((class_2168)context.getSource()).method_9211());
                        ServerNetworking.sendUpdatePacketToAll(((class_2168)context.getSource()).method_9211(), setting);
                        return 1;
                    }
                    catch (Exception e) {
                        ServerNetworking.LOGGER.error("Vivecraft: error adding block to list:", (Throwable)e);
                        return 0;
                    }
                })));
                baseCommand.then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                    for (String block : (List)listConfig.get()) {
                        if (!block.contains(builder.getRemaining())) continue;
                        builder.suggest(block);
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    String newValue = (String)context.getArgument("block", String.class);
                    List list = (List)listConfig.get();
                    list.remove(newValue);
                    listConfig.set(list);
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("removed '%s' from \u00a7a[%s]\u00a7r".formatted(newValue, setting.getPath())), true);
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("is now '%s'".formatted(setting.get())), true);
                    setting.onUpdate(((class_2168)context.getSource()).method_9211());
                    ServerNetworking.sendUpdatePacketToAll(((class_2168)context.getSource()).method_9211(), setting);
                    return 1;
                })));
            }
            baseCommand.then(class_2170.method_9247((String)"reset").executes(context -> {
                Object newValue = setting.reset();
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("reset \u00a7a[%s]\u00a7r to '%s'".formatted(setting.getPath(), newValue)), true);
                setting.onUpdate(((class_2168)context.getSource()).method_9211());
                ServerNetworking.sendUpdatePacketToAll(((class_2168)context.getSource()).method_9211(), setting);
                return 1;
            }));
            baseCommand.executes(context -> {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("\u00a7a[%s]\u00a7r is set to '%s'".formatted(setting.getPath(), setting.get())), true);
                return 1;
            });
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vivecraft-server-config").requires(source -> source.method_9259(4))).then((ArgumentBuilder)baseCommand));
        }
    }

    public static void debugParticleAxes(ServerVivePlayer vivePlayer) {
        if (vivePlayer.isVR() && vivePlayer.vrPlayerState() != null) {
            for (VRBodyPart bodyPart : VRBodyPart.values()) {
                if (!bodyPart.availableInMode(vivePlayer.vrPlayerState().fbtMode()) || bodyPart == VRBodyPart.HEAD) continue;
                ServerUtil.debugParticleAxes(vivePlayer.player.method_14220(), vivePlayer.getBodyPartPos(bodyPart), vivePlayer.vrPlayerState().getBodyPartPose(bodyPart).orientation());
            }
            if (((Boolean)ServerConfig.DEBUG_PARTICLES_HEAD.get()).booleanValue()) {
                ServerUtil.debugParticleAxes(vivePlayer.player.method_14220(), vivePlayer.getHMDPos(), vivePlayer.vrPlayerState().hmd().orientation());
            }
        }
    }

    public static void debugParticleAxes(class_3218 level, class_243 position, Quaternionfc rot) {
        Vector3f red = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f green = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f blue = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f forward = rot.transform(MathUtils.BACK, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f());
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f());
        ServerUtil.spawnParticlesDirection(level, blue, position, forward);
        ServerUtil.spawnParticlesDirection(level, green, position, up);
        ServerUtil.spawnParticlesDirection(level, red, position, right);
    }

    public static void spawnParticlesDirection(class_3218 level, Vector3f color, class_243 position, Vector3f direction) {
        class_2390 particle = new class_2390(new class_1160(color.x, color.y, color.z), 0.25f);
        for (int i = 0; i < 5; ++i) {
            Vector3f offset = direction.mul(0.0625f * (float)i, new Vector3f());
            level.method_14199((class_2394)particle, position.field_1352 + (double)offset.x, position.field_1351 + (double)offset.y, position.field_1350 + (double)offset.z, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(SCHEDULER::shutdownNow));
    }
}

