/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected ItemStack useItem;

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract boolean isBlocking();

    @Shadow
    public abstract ItemStack getMainHandItem();

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"hasLineOfSight(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Block;Lnet/minecraft/world/level/ClipContext$Fluid;D)Z"}, at={@At(value="NEW", target="Lnet/minecraft/world/phys/Vec3;", ordinal=0)})
    private Vec3 vivecraft$modifyOwnHeadPos(double x, double y, double z, Operation<Vec3> original) {
        ServerPlayer player;
        ServerVivePlayer serverVivePlayer;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof ServerPlayer && (serverVivePlayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)livingEntityMixin)) != null && serverVivePlayer.isVR()) {
            return serverVivePlayer.getHMDPos();
        }
        return (Vec3)original.call(new Object[]{x, y, z});
    }

    @WrapOperation(method={"hasLineOfSight(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Block;Lnet/minecraft/world/level/ClipContext$Fluid;D)Z"}, at={@At(value="NEW", target="Lnet/minecraft/world/phys/Vec3;", ordinal=1)})
    private Vec3 vivecraft$modifyOtherHeadPos(double x, double y, double z, Operation<Vec3> original, @Local(argsOnly=true) Entity other) {
        ServerPlayer player;
        ServerVivePlayer serverVivePlayer;
        if (other instanceof ServerPlayer && (serverVivePlayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)other)) != null && serverVivePlayer.isVR()) {
            Vec3 hmdPos = serverVivePlayer.getHMDPos();
            return (Vec3)original.call(new Object[]{hmdPos.x, y == other.getEyeY() ? hmdPos.y : y, hmdPos.z});
        }
        return (Vec3)original.call(new Object[]{x, y, z});
    }

    @WrapOperation(method={"isLookingAtMe(Lnet/minecraft/world/entity/LivingEntity;DZZ[D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 vivecraft$hmdDir(LivingEntity instance, float partialTick, Operation<Vec3> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        ServerPlayer serverPlayer;
        if (instance instanceof ServerPlayer && ServerVRPlayers.isVRPlayer(serverPlayer = (ServerPlayer)instance)) {
            ServerVivePlayer serverVivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
            hmdPos.set((Object)serverVivePlayer.getHMDPos());
            return serverVivePlayer.getHMDDir();
        }
        return (Vec3)original.call(new Object[]{instance, Float.valueOf(partialTick)});
    }

    @WrapOperation(method={"isLookingAtMe(Lnet/minecraft/world/entity/LivingEntity;DZZ[D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=1)})
    private double vivecraft$hmdPosX(LivingEntity instance, Operation<Double> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        return hmdPos.get() != null ? ((Vec3)hmdPos.get()).x : (Double)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"isLookingAtMe(Lnet/minecraft/world/entity/LivingEntity;DZZ[D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEyeY()D")})
    private double vivecraft$hmdPosY(LivingEntity instance, Operation<Double> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        return hmdPos.get() != null ? ((Vec3)hmdPos.get()).y : (Double)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"isLookingAtMe(Lnet/minecraft/world/entity/LivingEntity;DZZ[D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=1)})
    private double vivecraft$hmdPosZ(LivingEntity instance, Operation<Double> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        return hmdPos.get() != null ? ((Vec3)hmdPos.get()).z : (Double)original.call(new Object[]{instance});
    }

    @ModifyExpressionValue(method={"applyItemBlocking(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getItemBlockingWith()Lnet/minecraft/world/item/ItemStack;")})
    protected ItemStack vivecraft$roomscaleShieldBlockingItem(ItemStack original, @Local(argsOnly=true) DamageSource damageSource, @Share(value="roomscaleBlockAngle") LocalDoubleRef roomscaleBlockAngle) {
        return original;
    }

    @ModifyArg(method={"applyItemBlocking(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BlocksAttacks;resolveBlockedDamage(Lnet/minecraft/world/damagesource/DamageSource;FD)F"))
    private double vivecraft$roomscaleShieldBlockingAngle(double blockAngle, @Share(value="roomscaleBlockAngle") LocalDoubleRef roomscaleBlockAngle) {
        return roomscaleBlockAngle.get() > 0.0 ? roomscaleBlockAngle.get() : blockAngle;
    }

    @ModifyArg(method={"applyItemBlocking(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BlocksAttacks;hurtBlockingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;F)V"), index=3)
    private InteractionHand vivecraft$roomscaleShieldBlockingHand(InteractionHand original, @Local ItemStack itemStack, @Share(value="roomscaleBlockAngle") LocalDoubleRef roomscaleBlockAngle) {
        return roomscaleBlockAngle.get() > 0.0 ? (itemStack == this.getMainHandItem() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : original;
    }

    @ModifyExpressionValue(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getUseItem()Lnet/minecraft/world/item/ItemStack;")})
    protected ItemStack vivecraft$roomscaleShieldActualBlockingItem(ItemStack original) {
        return original;
    }
}

