/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.api_impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.vivecraft.api.client.VRClientAPI;
import org.vivecraft.api.client.data.CloseKeyboardContext;
import org.vivecraft.api.client.data.OpenKeyboardContext;
import org.vivecraft.api.client.event.VivecraftClientRegistrationEvent;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import org.vivecraft.client.api_impl.event.VivecraftClientRegistrationEventImpl;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.common.api_impl.data.VRPoseHistoryImpl;

public final class VRClientAPIImpl
implements VRClientAPI {
    public static final VRClientAPIImpl INSTANCE = new VRClientAPIImpl();
    private final VRPoseHistoryImpl poseHistory = new VRPoseHistoryImpl();
    private final List<Consumer<VivecraftClientRegistrationEvent>> registrationHandlers = new ArrayList<Consumer<VivecraftClientRegistrationEvent>>();
    private boolean registrationClosed = false;

    private VRClientAPIImpl() {
    }

    public void clearPoseHistory() {
        this.poseHistory.clear();
    }

    public void addPoseToHistory(VRPose pose) {
        this.poseHistory.addPose(pose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRegistrationEvent() {
        List<Consumer<VivecraftClientRegistrationEvent>> list = this.registrationHandlers;
        synchronized (list) {
            this.registrationClosed = true;
            this.registrationHandlers.forEach(event -> event.accept(VivecraftClientRegistrationEventImpl.INSTANCE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientRegistrationHandler(Consumer<VivecraftClientRegistrationEvent> handler) {
        List<Consumer<VivecraftClientRegistrationEvent>> list = this.registrationHandlers;
        synchronized (list) {
            if (this.registrationClosed) {
                throw new IllegalStateException("Registration handlers were already processed, this needs to be called before the game loop starts!");
            }
            this.registrationHandlers.add(handler);
        }
    }

    @Override
    public boolean isVRInitialized() {
        return VRState.VR_INITIALIZED;
    }

    @Override
    public boolean isVRActive() {
        return VRState.VR_RUNNING;
    }

    @Override
    @Nullable
    public VRPose getLatestRoomPose() {
        if (!this.isVRActive()) {
            return null;
        }
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.asVRPose();
    }

    @Override
    @Nullable
    public VRPose getPostTickRoomPose() {
        if (!this.isVRActive()) {
            return null;
        }
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.asVRPose();
    }

    @Override
    @Nullable
    public VRPose getPreTickWorldPose() {
        if (!this.isVRActive()) {
            return null;
        }
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.asVRPose();
    }

    @Override
    @Nullable
    public VRPose getPostTickWorldPose() {
        if (!this.isVRActive()) {
            return null;
        }
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_post.asVRPose();
    }

    @Override
    @Nullable
    public VRPose getWorldRenderPose() {
        if (!this.isVRActive()) {
            return null;
        }
        return ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().asVRPose();
    }

    @Override
    @Nullable
    public VRPoseHistory getHistoricalVRPoses() {
        if (!this.isVRActive() || this.poseHistory.isEmpty()) {
            return null;
        }
        return this.poseHistory;
    }

    @Override
    public void triggerHapticPulse(VRBodyPart bodyPart, float duration, float frequency, float amplitude, float delay) {
        if (amplitude < 0.0f || amplitude > 1.0f) {
            throw new IllegalArgumentException("The amplitude of a haptic pulse must be between 0 and 1.");
        }
        if (this.isVRActive() && !this.isSeated()) {
            ClientDataHolderVR.getInstance().vr.triggerHapticPulse(bodyPart, duration, frequency, amplitude, delay);
        }
    }

    @Override
    public boolean isSeated() {
        return ClientDataHolderVR.getInstance().vrSettings.seated;
    }

    @Override
    public boolean isLeftHanded() {
        return ClientDataHolderVR.getInstance().vrSettings.reverseHands;
    }

    @Override
    public FBTMode getFBTMode() {
        if (!this.isVRActive()) {
            return FBTMode.ARMS_ONLY;
        }
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.fbtMode;
    }

    @Override
    public float getWorldScale() {
        if (this.isVRActive()) {
            return ClientDataHolderVR.getInstance().vrPlayer.worldScale;
        }
        return 1.0f;
    }

    @Override
    public boolean openKeyboard(OpenKeyboardContext context) {
        return this.isVRActive() && KeyboardHandler.showOverlay(context);
    }

    @Override
    public boolean closeKeyboard(CloseKeyboardContext context) {
        return this.isVRActive() && KeyboardHandler.hideOverlay(context);
    }
}

