/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11C;
import org.vivecraft.Xevents;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.gui.VivecraftClickEvent;
import org.vivecraft.client.gui.settings.GuiOtherHUDSettings;
import org.vivecraft.client.gui.settings.GuiRenderOpticsSettings;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.StencilHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.LevelRendererExtension;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VRArmHelper;
import org.vivecraft.client_vr.render.helpers.VRWidgetHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VREffectsHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.getInstance();
    private static final ResourceLocation SCOPE_TEXTURE = new ResourceLocation("textures/misc/spyglass_scope.png");
    private static boolean WAS_STENCIL_ON;
    private static final ResourceLocation CUBE_FRONT;
    private static final ResourceLocation CUBE_RIGHT;
    private static final ResourceLocation CUBE_BACK;
    private static final ResourceLocation CUBE_LEFT;
    private static final ResourceLocation CUBE_UP;
    private static final ResourceLocation CUBE_DOWN;
    private static final ResourceLocation DIRT;
    private static final ResourceLocation GRASS;

    public static boolean isInsideOpaqueBlock(Vec3 pos) {
        if (VREffectsHelper.MC.level == null) {
            return false;
        }
        BlockPos blockpos = BlockPos.containing((Position)pos);
        return VREffectsHelper.MC.level.getBlockState(blockpos).isSolidRender((BlockGetter)VREffectsHelper.MC.level, blockpos);
    }

    public static Triple<Float, BlockState, BlockPos> getNearOpaqueBlock(Vec3 pos, double dist) {
        if (VREffectsHelper.MC.level == null) {
            return null;
        }
        AABB aabb = new AABB(pos.subtract(dist, dist, dist), pos.add(dist, dist, dist));
        Stream<BlockPos> stream = BlockPos.betweenClosedStream((AABB)aabb).filter(bp -> VREffectsHelper.MC.level.getBlockState(bp).isSolidRender((BlockGetter)VREffectsHelper.MC.level, bp));
        Optional<BlockPos> optional = stream.findFirst();
        return optional.map(blockPos -> Triple.of((Object)Float.valueOf(1.0f), (Object)VREffectsHelper.MC.level.getBlockState(blockPos), (Object)blockPos)).orElse(null);
    }

    public static boolean isFirstPersonPlayer(Entity entity) {
        return VRState.VR_RUNNING && entity == VREffectsHelper.MC.player && entity == MC.getCameraEntity();
    }

    public static boolean isRenderingFirstPersonPlayer(Entity entity) {
        return VREffectsHelper.isFirstPersonPlayer(entity) && VREffectsHelper.isFirstPersonEntityPass();
    }

    public static boolean isFirstPersonEntityPass() {
        return VREffectsHelper.DATA_HOLDER.vrSettings.shouldRenderSelf && RenderPass.isFirstPerson(VREffectsHelper.DATA_HOLDER.currentPass) && !ShadersHelper.isRenderingShadows() && (!ImmersivePortalsHelper.isLoaded() || !ImmersivePortalsHelper.isRenderingPortal());
    }

    public static void drawScopeFB(PoseStack poseStack, int c) {
        poseStack.pushPose();
        RenderSystem.enableDepthTest();
        if (c == 0) {
            VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferR.bindRead();
            RenderSystem.setShaderTexture((int)0, (int)VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferR.getColorTextureId());
        } else {
            VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferL.bindRead();
            RenderSystem.setShaderTexture((int)0, (int)VREffectsHelper.DATA_HOLDER.vrRenderer.telescopeFramebufferL.getColorTextureId());
        }
        float scale = 0.125f;
        float alpha = TelescopeTracker.viewPercent(c);
        RenderSystem.disableBlend();
        RenderHelper.drawSizedQuadFullbright(720.0f, 720.0f, scale, new float[]{alpha, alpha, alpha, 1.0f}, poseStack.last().pose(), GameRenderer::getRendertypeEntitySolidShader);
        ShadersHelper.bindTexture(SCOPE_TEXTURE);
        RenderSystem.enableBlend();
        poseStack.translate(0.0f, 0.0f, 1.0E-5f);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)VREffectsHelper.MC.level, (BlockPos)BlockPos.containing((Position)VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getPosition()));
        RenderHelper.drawSizedQuadWithLightmap(720.0f, 720.0f, scale, light, poseStack.last().pose(), GameRenderer::getRendertypeEntityTranslucentShader, true);
        poseStack.popPose();
    }

    public static void drawEyeStencil() {
        if (VREffectsHelper.DATA_HOLDER.vrSettings.vrUseStencil) {
            if (StencilHelper.stencilBufferSupported() && (WAS_STENCIL_ON = GL11C.glIsEnabled((int)2960)) && !VREffectsHelper.DATA_HOLDER.showedStencilMessage && VREffectsHelper.DATA_HOLDER.vrSettings.showChatMessageStencil) {
                VREffectsHelper.DATA_HOLDER.showedStencilMessage = true;
                ClientUtils.addChatMessage((Component)Component.translatable((String)"vivecraft.messages.stencil", (Object[])new Object[]{Component.translatable((String)"vivecraft.messages.3options", (Object[])new Object[]{Component.translatable((String)"options.title"), Component.translatable((String)"vivecraft.options.screen.main"), Component.translatable((String)"vivecraft.options.screen.stereorendering")}).withStyle(style -> style.withClickEvent((ClickEvent)new VivecraftClickEvent(VivecraftClickEvent.VivecraftAction.OPEN_SCREEN, (Object)new GuiRenderOpticsSettings(null))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"vivecraft.messages.openSettings"))).withColor(ChatFormatting.GREEN).withItalic(Boolean.valueOf(true))), Component.translatable((String)"vivecraft.messages.3options", (Object[])new Object[]{Component.translatable((String)"options.title"), Component.translatable((String)"vivecraft.options.screen.main"), Component.translatable((String)"vivecraft.options.screen.guiother")}).withStyle(style -> style.withClickEvent((ClickEvent)new VivecraftClickEvent(VivecraftClickEvent.VivecraftAction.OPEN_SCREEN, (Object)new GuiOtherHUDSettings(null))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"vivecraft.messages.openSettings"))).withColor(ChatFormatting.GREEN).withItalic(Boolean.valueOf(true)))}));
            }
            if (!(VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.LEFT && VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.RIGHT || ImmersivePortalsHelper.isLoaded() && ImmersivePortalsHelper.isRenderingPortal())) {
                VREffectsHelper.DATA_HOLDER.vrRenderer.doStencil(false);
            }
        }
    }

    public static void disableStencilTest() {
        if (StencilHelper.stencilBufferSupported() && !WAS_STENCIL_ON) {
            GL11C.glDisable((int)2960);
        }
    }

    public static void renderMenuPanorama(Matrix4fStack poseStack) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.pushMatrix();
        poseStack.translate(-50.0f, -50.0f, -50.0f);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_DOWN);
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 0.0f).uv(0.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 100.0f).uv(0.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 0.0f, 100.0f).uv(1.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 0.0f, 0.0f).uv(1.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_UP);
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 100.0f, 100.0f).uv(0.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 100.0f, 0.0f).uv(0.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 100.0f, 0.0f).uv(1.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 100.0f, 100.0f).uv(1.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_LEFT);
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 0.0f).uv(1.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 100.0f, 0.0f).uv(1.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 100.0f, 100.0f).uv(0.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 100.0f).uv(0.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_RIGHT);
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 0.0f, 0.0f).uv(0.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 0.0f, 100.0f).uv(1.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 100.0f, 100.0f).uv(1.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 100.0f, 0.0f).uv(0.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_FRONT);
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 0.0f).uv(0.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 0.0f, 0.0f).uv(1.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 100.0f, 0.0f).uv(1.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 100.0f, 0.0f).uv(0.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CUBE_BACK);
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 100.0f).uv(1.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 100.0f, 100.0f).uv(1.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 100.0f, 100.0f).uv(0.0f, 0.0f).color(255, 255, 255, 255).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 100.0f, 0.0f, 100.0f).uv(0.0f, 1.0f).color(255, 255, 255, 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        poseStack.popMatrix();
        Vector2fc area = VREffectsHelper.DATA_HOLDER.vr.getPlayAreaSize();
        if (area == null) {
            area = new Vector2f(2.0f, 2.0f);
        }
        for (int i = 0; i < 2; ++i) {
            int b;
            int g;
            int r;
            float width = area.x() + (float)(i * 2);
            float length = area.y() + (float)(i * 2);
            poseStack.pushMatrix();
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            if (i == 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)GRASS);
                r = 114;
                g = 148;
                b = 70;
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)DIRT);
                b = 128;
                g = 128;
                r = 128;
            }
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            poseStack.translate(-width * 0.5f, 0.0f, -length * 0.5f);
            int repeat = 4;
            bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.005f * (float)(-i), 0.0f).uv(0.0f, 0.0f).color(r, g, b, 255).endVertex();
            bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.005f * (float)(-i), length).uv(0.0f, 4.0f * length).color(r, g, b, 255).endVertex();
            bufferBuilder.vertex((Matrix4f)poseStack, width, 0.005f * (float)(-i), length).uv(4.0f * width, 4.0f * length).color(r, g, b, 255).endVertex();
            bufferBuilder.vertex((Matrix4f)poseStack, width, 0.005f * (float)(-i), 0.0f).uv(4.0f * width, 0.0f).color(r, g, b, 255).endVertex();
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
            poseStack.popMatrix();
        }
    }

    public static void renderJrbuddasAwesomeMainMenuRoomNew(Matrix4fStack poseStack) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DIRT);
        int repeat = 4;
        float height = 2.5f;
        float oversize = 1.3f;
        Vector2fc area = VREffectsHelper.DATA_HOLDER.vr.getPlayAreaSize();
        if (area == null) {
            area = new Vector2f(2.0f, 2.0f);
        }
        float width = area.x() + oversize;
        float length = area.y() + oversize;
        float b = 0.8f;
        float g = 0.8f;
        float r = 0.8f;
        float a = 1.0f;
        poseStack.pushMatrix();
        poseStack.translate(-width * 0.5f, 0.0f, -length * 0.5f);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 0.0f).uv(0.0f, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, length).uv(0.0f, (float)repeat * length).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, 0.0f, length).uv((float)repeat * width, (float)repeat * length).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, 0.0f, 0.0f).uv((float)repeat * width, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, height, length).uv(0.0f, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, height, 0.0f).uv(0.0f, (float)repeat * length).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, height, 0.0f).uv((float)repeat * width, (float)repeat * length).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, height, length).uv((float)repeat * width, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 0.0f).uv(0.0f, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, height, 0.0f).uv(0.0f, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, height, length).uv((float)repeat * length, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, length).uv((float)repeat * length, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, 0.0f, 0.0f).uv(0.0f, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, 0.0f, length).uv((float)repeat * length, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, height, length).uv((float)repeat * length, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, height, 0.0f).uv(0.0f, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, 0.0f).uv(0.0f, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, 0.0f, 0.0f).uv((float)repeat * width, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, height, 0.0f).uv((float)repeat * width, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, height, 0.0f).uv(0.0f, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.0f, length).uv(0.0f, 0.0f).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, height, length).uv(0.0f, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, height, length).uv((float)repeat * width, (float)repeat * height).color(r, g, b, a).endVertex();
        bufferBuilder.vertex((Matrix4f)poseStack, width, 0.0f, length).uv((float)repeat * width, 0.0f).color(r, g, b, a).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        poseStack.popMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderTechjarsAwesomeMainMenuRoom(Matrix4fStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.pushMatrix();
        RenderSystem.getModelViewStack().mul((Matrix4fc)poseStack, (Matrix4f)poseStack);
        RenderSystem.getModelViewStack().pushMatrix().identity();
        RenderSystem.applyModelViewMatrix();
        try {
            int tzOffset = Calendar.getInstance().get(15);
            VREffectsHelper.DATA_HOLDER.menuWorldRenderer.time = VREffectsHelper.DATA_HOLDER.menuWorldRenderer.fastTime ? (long)((float)((long)VREffectsHelper.DATA_HOLDER.menuWorldRenderer.ticks * 10L) + 10.0f * ClientUtils.getCurrentPartialTick()) : (long)((double)(System.currentTimeMillis() + (long)tzOffset - 21600000L) / 8.64E7 * 24000.0);
            VREffectsHelper.DATA_HOLDER.menuWorldRenderer.fogRenderer.setupFogColor();
            RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
            VREffectsHelper.DATA_HOLDER.menuWorldRenderer.updateLightmap();
            VREffectsHelper.DATA_HOLDER.menuWorldRenderer.render(poseStack);
            Vector2fc area = VREffectsHelper.DATA_HOLDER.vr.getPlayAreaSize();
            if (area == null) {
                area = new Vector2f(2.0f, 2.0f);
            }
            float width = area.x();
            float length = area.y();
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DIRT);
            float sun = VREffectsHelper.DATA_HOLDER.menuWorldRenderer.getSkyDarken();
            RenderSystem.setShaderColor((float)sun, (float)sun, (float)sun, (float)0.3f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableBlend();
            poseStack.pushMatrix();
            poseStack.translate(-width / 2.0f, 0.0f, -length / 2.0f);
            BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.005f, 0.0f).uv(0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            bufferBuilder.vertex((Matrix4f)poseStack, 0.0f, 0.005f, length).uv(0.0f, 4.0f * length).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            bufferBuilder.vertex((Matrix4f)poseStack, width, 0.005f, length).uv(4.0f * width, 4.0f * length).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            bufferBuilder.vertex((Matrix4f)poseStack, width, 0.005f, 0.0f).uv(4.0f * width, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
            poseStack.popMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
        }
        finally {
            poseStack.popMatrix();
            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void renderVRFabulous(float partialTick, LevelRenderer levelRenderer) {
        if (VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPEL || VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPER) {
            return;
        }
        MC.renderBuffers().bufferSource().endBatch();
        MC.getProfiler().popPush("VR");
        VREffectsHelper.renderCrosshairAtDepth(!VREffectsHelper.DATA_HOLDER.vrSettings.useCrosshairOcclusion);
        DebugRenderHelper.renderDebug(partialTick);
        MC.getMainRenderTarget().unbindWrite();
        RenderTarget occluded = ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVROccludedFramebuffer();
        occluded.clear(Minecraft.ON_OSX);
        occluded.copyDepthFrom(MC.getMainRenderTarget());
        occluded.bindWrite(true);
        boolean renderHands = VRArmHelper.shouldRenderHands();
        if (VREffectsHelper.shouldOccludeGui()) {
            VREffectsHelper.renderGuiAndShadow(partialTick, false, false);
            VRArmHelper.renderVRHands(partialTick, renderHands && VREffectsHelper.DATA_HOLDER.menuHandMain, renderHands && VREffectsHelper.DATA_HOLDER.menuHandOff, true, true);
        }
        RenderTarget unOccluded = ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRUnoccludedFramebuffer();
        unOccluded.clear(Minecraft.ON_OSX);
        unOccluded.bindWrite(true);
        if (!VREffectsHelper.shouldOccludeGui()) {
            VREffectsHelper.renderGuiAndShadow(partialTick, false, false);
        }
        VREffectsHelper.renderVRSelfEffects(partialTick, true);
        VRWidgetHelper.renderVRThirdPersonCamWidget();
        VRWidgetHelper.renderVRHandheldCameraWidget();
        if (!VREffectsHelper.shouldOccludeGui()) {
            VRArmHelper.renderVRHands(partialTick, renderHands && VREffectsHelper.DATA_HOLDER.menuHandMain, renderHands && VREffectsHelper.DATA_HOLDER.menuHandOff, true, true);
        }
        RenderTarget hands = ((LevelRendererExtension)levelRenderer).vivecraft$getAlphaSortVRHandsFramebuffer();
        hands.clear(Minecraft.ON_OSX);
        hands.copyDepthFrom(MC.getMainRenderTarget());
        hands.bindWrite(true);
        VRArmHelper.renderVRHands(partialTick, renderHands && !VREffectsHelper.DATA_HOLDER.menuHandMain, renderHands && !VREffectsHelper.DATA_HOLDER.menuHandOff, false, false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MC.getMainRenderTarget().bindWrite(true);
    }

    public static void renderVrFast(float partialTick, boolean secondPass) {
        boolean renderHandsSecond;
        if (VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPEL || VREffectsHelper.DATA_HOLDER.currentPass == RenderPass.SCOPER) {
            return;
        }
        MC.renderBuffers().bufferSource().endBatch();
        MC.getProfiler().popPush("VR");
        VREffectsHelper.MC.gameRenderer.lightTexture().turnOffLightLayer();
        if (!secondPass) {
            VREffectsHelper.renderCrosshairAtDepth(!VREffectsHelper.DATA_HOLDER.vrSettings.useCrosshairOcclusion);
            VRWidgetHelper.renderVRThirdPersonCamWidget();
            VRWidgetHelper.renderVRHandheldCameraWidget();
            DebugRenderHelper.renderDebug(partialTick);
        } else {
            VREffectsHelper.renderGuiAndShadow(partialTick, !VREffectsHelper.shouldOccludeGui(), true);
        }
        boolean bl = renderHandsSecond = RadialHandler.isShowing() || KeyboardHandler.SHOWING || Minecraft.getInstance().screen != null;
        if (secondPass == renderHandsSecond) {
            VRArmHelper.renderVRHands(partialTick, VRArmHelper.shouldRenderHands(), VRArmHelper.shouldRenderHands(), VREffectsHelper.DATA_HOLDER.menuHandMain, VREffectsHelper.DATA_HOLDER.menuHandOff);
        }
        VREffectsHelper.renderVRSelfEffects(partialTick, !secondPass);
    }

    private static boolean shouldOccludeGui() {
        if (RenderPass.isThirdPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            return true;
        }
        return VREffectsHelper.DATA_HOLDER.vrSettings.hudOcclusion && !MethodHolder.isInMenuRoom() && VREffectsHelper.MC.screen == null && !KeyboardHandler.SHOWING && !RadialHandler.isShowing() && !VREffectsHelper.isInsideOpaqueBlock(VREffectsHelper.MC.gameRenderer.getMainCamera().getPosition());
    }

    private static void renderGuiAndShadow(float partialTick, boolean depthAlways, boolean shadowFirst) {
        if (shadowFirst) {
            VREffectsHelper.renderVrShadow(partialTick, depthAlways);
        }
        if (Minecraft.getInstance().screen != null || !KeyboardHandler.SHOWING) {
            VREffectsHelper.renderGuiLayer(partialTick, depthAlways);
        }
        if (!shadowFirst) {
            VREffectsHelper.renderVrShadow(partialTick, depthAlways);
        }
        if (KeyboardHandler.SHOWING) {
            if (VREffectsHelper.DATA_HOLDER.vrSettings.physicalKeyboard) {
                VREffectsHelper.renderPhysicalKeyboard(partialTick);
            } else {
                VREffectsHelper.render2D(partialTick, KeyboardHandler.FRAMEBUFFER, (Vector3fc)KeyboardHandler.POS_ROOM, KeyboardHandler.ROTATION_ROOM, depthAlways);
            }
        }
        if (RadialHandler.isShowing()) {
            VREffectsHelper.render2D(partialTick, RadialHandler.FRAMEBUFFER, (Vector3fc)RadialHandler.POS_ROOM, RadialHandler.ROTATION_ROOM, depthAlways);
        }
    }

    public static void renderVrShadow(float partialTick, boolean depthAlways) {
        if (RenderPass.isThirdPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            return;
        }
        if (!VREffectsHelper.MC.player.isAlive()) {
            return;
        }
        if (VREffectsHelper.MC.player.isPassenger() || VREffectsHelper.MC.player != MC.getCameraEntity()) {
            return;
        }
        if (((PlayerExtension)VREffectsHelper.MC.player).vivecraft$getRoomYOffsetFromPose() < 0.0) {
            return;
        }
        MC.getProfiler().push("vr shadow");
        AABB aabb = VREffectsHelper.MC.player.getBoundingBox();
        if (VREffectsHelper.DATA_HOLDER.vrSettings.vrShowBlueCircleBuddy && aabb != null) {
            Vec3 cameraPos = VREffectsHelper.MC.gameRenderer.getMainCamera().getPosition();
            Vec3 interpolatedPlayerPos = ((GameRendererExtension)VREffectsHelper.MC.gameRenderer).vivecraft$getRvePos(partialTick);
            Vec3 pos = interpolatedPlayerPos.subtract(cameraPos).add(0.0, 0.005, 0.0);
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            if (depthAlways) {
                RenderSystem.depthFunc((int)519);
            } else {
                RenderSystem.depthFunc((int)515);
            }
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
            RenderHelper.renderFlatQuad(pos, (float)(aabb.maxX - aabb.minX), (float)(aabb.maxZ - aabb.minZ), 0.0f, 0, 0, 0, 64, new Matrix4f());
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableCull();
        }
        MC.getProfiler().pop();
    }

    private static void renderVRSelfEffects(float partialTick, boolean firstPass) {
        if (VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.THIRD && VREffectsHelper.DATA_HOLDER.currentPass != RenderPass.CAMERA && !VREffectsHelper.MC.player.isSpectator() && VREffectsHelper.MC.player.isOnFire() && !Xevents.renderFireOverlay((Player)VREffectsHelper.MC.player, new PoseStack())) {
            VREffectsHelper.renderFireInFirstPerson();
        }
        if (firstPass) {
            RenderSystem.getModelViewStack().pushMatrix().identity();
            RenderSystem.applyModelViewMatrix();
            VREffectsHelper.MC.gameRenderer.renderItemActivationAnimation(0, 0, partialTick);
            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void renderFireInFirstPerson() {
        PoseStack posestack = new PoseStack();
        RenderHelper.applyStereo(VREffectsHelper.DATA_HOLDER.currentPass, posestack);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        if (RenderPass.isThirdPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            RenderSystem.depthFunc((int)515);
        } else {
            RenderSystem.depthFunc((int)519);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        TextureAtlasSprite fireSprite = ModelBakery.FIRE_1.sprite();
        if (OptifineHelper.isOptifineLoaded()) {
            OptifineHelper.markTextureAsActive(fireSprite);
        }
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        ShadersHelper.bindTexture(fireSprite.atlasLocation());
        float uMin = fireSprite.getU0();
        float uMax = fireSprite.getU1();
        float uMid = (uMin + uMax) / 2.0f;
        float vMin = fireSprite.getV0();
        float vMax = fireSprite.getV1();
        float vMid = (vMin + vMax) / 2.0f;
        float ShrinkRatio = fireSprite.uvShrinkRatio();
        float u0 = Mth.lerp((float)ShrinkRatio, (float)uMin, (float)uMid);
        float u1 = Mth.lerp((float)ShrinkRatio, (float)uMax, (float)uMid);
        float v0 = Mth.lerp((float)ShrinkRatio, (float)vMin, (float)vMid);
        float v1 = Mth.lerp((float)ShrinkRatio, (float)vMax, (float)vMid);
        float width = 0.3f;
        float headHeight = (float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getHeadPivot().y - ((GameRendererExtension)VREffectsHelper.MC.gameRenderer).vivecraft$getRveY());
        for (int i = 0; i < 4; ++i) {
            posestack.pushPose();
            posestack.mulPose(Axis.YP.rotationDegrees((float)i * 90.0f - VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getBodyYaw()));
            posestack.translate(0.0, (double)(-headHeight), 0.0);
            Matrix4f matrix = posestack.last().pose();
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
            bufferBuilder.vertex(matrix, -width, 0.0f, -width).color(1.0f, 1.0f, 1.0f, 0.9f).uv(u1, v1).endVertex();
            bufferBuilder.vertex(matrix, width, 0.0f, -width).color(1.0f, 1.0f, 1.0f, 0.9f).uv(u0, v1).endVertex();
            bufferBuilder.vertex(matrix, width, headHeight, -width).color(1.0f, 1.0f, 1.0f, 0.9f).uv(u0, v0).endVertex();
            bufferBuilder.vertex(matrix, -width, headHeight, -width).color(1.0f, 1.0f, 1.0f, 0.9f).uv(u1, v0).endVertex();
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
            posestack.popPose();
        }
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
    }

    public static void renderPhysicalKeyboard(float partialTick) {
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isDrawing()) {
            return;
        }
        MC.getProfiler().push("renderPhysicalKeyboard");
        VREffectsHelper.removeNausea(partialTick);
        MC.getProfiler().push("applyPhysicalKeyboardModelView");
        Vec3 eye = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(VREffectsHelper.DATA_HOLDER.currentPass).getPosition();
        Vec3 keyboardPos = VRPlayer.roomToWorldPos((Vector3fc)KeyboardHandler.POS_ROOM, VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render);
        Matrix4f keyboardRot = new Matrix4f().rotationY(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)KeyboardHandler.ROTATION_ROOM);
        Matrix4fStack poseStack = new Matrix4fStack(3);
        poseStack.translate((float)(keyboardPos.x - eye.x), (float)(keyboardPos.y - eye.y), (float)(keyboardPos.z - eye.z));
        poseStack.mul((Matrix4fc)keyboardRot);
        float scale = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        poseStack.scale(scale, scale, scale);
        MC.getProfiler().pop();
        KeyboardHandler.PHYSICAL_KEYBOARD.render(poseStack);
        VREffectsHelper.reAddNausea();
        MC.getProfiler().pop();
    }

    public static void removeNausea(float partialTick) {
        RenderSystem.backupProjectionMatrix();
        ((GameRendererExtension)VREffectsHelper.MC.gameRenderer).vivecraft$resetProjectionMatrix(partialTick);
    }

    public static void reAddNausea() {
        RenderSystem.restoreProjectionMatrix();
    }

    private static void renderScreen(RenderTarget framebuffer, boolean depthAlways, boolean noFog, Vec3 pos, Matrix4f matrix) {
        framebuffer.bindRead();
        RenderSystem.disableCull();
        RenderSystem.setShaderTexture((int)0, (int)framebuffer.getColorTextureId());
        float fogStart = RenderSystem.getShaderFogStart();
        float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (!MethodHolder.isInMenuRoom()) {
            if (VREffectsHelper.MC.screen == null) {
                color[3] = VREffectsHelper.DATA_HOLDER.vrSettings.hudOpacity;
            }
            if (noFog || VREffectsHelper.MC.screen != null) {
                RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
            }
            if (VREffectsHelper.MC.player != null && VREffectsHelper.MC.player.isShiftKeyDown()) {
                color[3] = color[3] * 0.75f;
            }
            if (!ShadersHelper.isShaderActive() || VREffectsHelper.DATA_HOLDER.vrSettings.shaderGUIRender != VRSettings.ShaderGUIRender.BEFORE_TRANSLUCENT_SOLID) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
        } else {
            RenderSystem.enableBlend();
        }
        if (depthAlways) {
            RenderSystem.depthFunc((int)519);
        } else {
            RenderSystem.depthFunc((int)515);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        if (VREffectsHelper.MC.level != null) {
            if (VREffectsHelper.isInsideOpaqueBlock(pos) || ((GameRendererExtension)VREffectsHelper.MC.gameRenderer).vivecraft$isInBlock() > 0.0f) {
                pos = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition();
            }
            int minLight = ShadersHelper.ShaderLight();
            int light = ClientUtils.getCombinedLightWithMin((BlockAndTintGetter)VREffectsHelper.MC.level, BlockPos.containing((Position)pos), minLight);
            if (!ShadersHelper.isShaderActive() || VREffectsHelper.DATA_HOLDER.vrSettings.shaderGUIRender != VRSettings.ShaderGUIRender.BEFORE_TRANSLUCENT_SOLID) {
                RenderHelper.drawSizedQuadWithLightmap(MC.getWindow().getGuiScaledWidth(), MC.getWindow().getGuiScaledHeight(), 1.5f, light, color, matrix, GameRenderer::getRendertypeEntityTranslucentShader, false);
            } else {
                RenderHelper.drawSizedQuadWithLightmap(MC.getWindow().getGuiScaledWidth(), MC.getWindow().getGuiScaledHeight(), 1.5f, light, color, matrix, GameRenderer::getRendertypeEntityCutoutNoCullShader, false);
            }
        } else {
            RenderHelper.drawSizedQuad(MC.getWindow().getGuiScaledWidth(), MC.getWindow().getGuiScaledHeight(), 1.5f, color, matrix);
        }
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
    }

    public static void renderGuiLayer(float partialTick, boolean depthAlways) {
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isDrawing()) {
            return;
        }
        if (VREffectsHelper.MC.screen == null && VREffectsHelper.MC.options.hideGui) {
            return;
        }
        if (RadialHandler.isShowing()) {
            return;
        }
        MC.getProfiler().push("GuiLayer");
        VREffectsHelper.removeNausea(partialTick);
        Matrix4fStack poseStack = new Matrix4fStack(8);
        if (MethodHolder.isInMenuRoom()) {
            depthAlways = true;
            poseStack.pushMatrix();
            Vec3 eye = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(VREffectsHelper.DATA_HOLDER.currentPass).getPosition();
            poseStack.translate((float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.origin.x - eye.x), (float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.origin.y - eye.y), (float)(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.origin.z - eye.z));
            poseStack.rotate((Quaternionfc)Axis.YN.rotation(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.rotation_radians));
            if (VREffectsHelper.DATA_HOLDER.menuWorldRenderer.isReady()) {
                try {
                    VREffectsHelper.renderTechjarsAwesomeMainMenuRoom(poseStack);
                }
                catch (Exception e) {
                    VRSettings.LOGGER.error("Vivecraft: Error rendering main menu world, unloading to prevent more errors: ", (Throwable)e);
                    VREffectsHelper.DATA_HOLDER.menuWorldRenderer.destroy();
                }
            } else if (VREffectsHelper.DATA_HOLDER.vrSettings.menuWorldFallbackPanorama) {
                VREffectsHelper.renderMenuPanorama(poseStack);
            } else {
                VREffectsHelper.renderJrbuddasAwesomeMainMenuRoomNew(poseStack);
            }
            poseStack.popMatrix();
        }
        Vec3 guiPos = GuiHandler.applyGUIModelView(VREffectsHelper.DATA_HOLDER.currentPass, (Matrix4f)poseStack);
        VREffectsHelper.renderScreen(GuiHandler.GUI_FRAMEBUFFER, depthAlways, false, guiPos, (Matrix4f)poseStack);
        VREffectsHelper.reAddNausea();
        MC.getProfiler().pop();
    }

    public static void render2D(float partialTick, RenderTarget framebuffer, Vector3fc pos, Matrix4f rot, boolean depthAlways) {
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isDrawing()) {
            return;
        }
        MC.getProfiler().push("render2D");
        VREffectsHelper.removeNausea(partialTick);
        MC.getProfiler().push("apply2DModelView");
        Matrix4f modelView = new Matrix4f();
        Vec3 eye = VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(VREffectsHelper.DATA_HOLDER.currentPass).getPosition();
        Vec3 worldPos = VRPlayer.roomToWorldPos(pos, VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render);
        Matrix4f worldRotation = new Matrix4f().rotationY(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)rot);
        modelView.translate((float)(worldPos.x - eye.x), (float)(worldPos.y - eye.y), (float)(worldPos.z - eye.z));
        modelView.mul((Matrix4fc)worldRotation);
        float scale = GuiHandler.GUI_SCALE * VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        modelView.scale(scale, scale, scale);
        MC.getProfiler().pop();
        VREffectsHelper.renderScreen(framebuffer, depthAlways, true, worldPos, modelView);
        VREffectsHelper.reAddNausea();
        MC.getProfiler().pop();
    }

    public static void renderFaceOverlay(float partialTick) {
        if (((GameRendererExtension)VREffectsHelper.MC.gameRenderer).vivecraft$isInBlock() > 0.0f) {
            VREffectsHelper.renderFaceInBlock();
            RenderSystem.getModelViewStack().pushMatrix().identity();
            RenderHelper.applyVRModelView(VREffectsHelper.DATA_HOLDER.currentPass, (Matrix4f)RenderSystem.getModelViewStack());
            RenderSystem.applyModelViewMatrix();
            VREffectsHelper.renderGuiAndShadow(partialTick, true, true);
            VRArmHelper.renderVRHands(partialTick, true, true, true, true);
            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void renderFaceInBlock() {
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.depthFunc((int)519);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        bufferBuilder.vertex(-100.0, -100.0, -2.0).endVertex();
        bufferBuilder.vertex(100.0, -100.0, -2.0).endVertex();
        bufferBuilder.vertex(100.0, 100.0, -2.0).endVertex();
        bufferBuilder.vertex(-100.0, 100.0, -2.0).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static boolean shouldRenderCrosshair() {
        if (VREffectsHelper.DATA_HOLDER.viewOnly) {
            return false;
        }
        if (VREffectsHelper.MC.level == null) {
            return false;
        }
        if (VREffectsHelper.MC.screen != null) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.vrSettings.renderInGameCrosshairMode == VRSettings.RenderPointerElement.NEVER || VREffectsHelper.DATA_HOLDER.vrSettings.renderInGameCrosshairMode == VRSettings.RenderPointerElement.WITH_HUD && VREffectsHelper.MC.options.hideGui) {
            return false;
        }
        if (!RenderPass.isFirstPerson(VREffectsHelper.DATA_HOLDER.currentPass)) {
            return false;
        }
        if (KeyboardHandler.SHOWING) {
            return false;
        }
        if (RadialHandler.isUsingController(ControllerType.RIGHT)) {
            return false;
        }
        if (GuiHandler.GUI_POS_ROOM != null) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.bowTracker.isNotched()) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).isEnabledRaw(ControllerType.RIGHT) || VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.RIGHT)) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).isEnabledRaw(ControllerType.RIGHT) || VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT)) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.teleportTracker.isAiming()) {
            return false;
        }
        if (VREffectsHelper.DATA_HOLDER.climbTracker.isGrabbingLadder(0)) {
            return false;
        }
        return !(VREffectsHelper.DATA_HOLDER.vrPlayer.worldScale > 15.0f);
    }

    public static void renderCrosshairAtDepth(boolean depthAlways) {
        if (!VREffectsHelper.shouldRenderCrosshair()) {
            return;
        }
        MC.getProfiler().push("crosshair");
        Vec3 crosshairRenderPos = ((GameRendererExtension)VREffectsHelper.MC.gameRenderer).vivecraft$getCrossVec();
        Vec3 crossDistance = crosshairRenderPos.subtract(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getPosition());
        crosshairRenderPos = crosshairRenderPos.add(crossDistance.normalize().scale(-0.01));
        Matrix4f modelView = new Matrix4f();
        Vector3f translate = MathUtils.subtractToVector3f(crosshairRenderPos, VREffectsHelper.MC.gameRenderer.getMainCamera().getPosition());
        modelView.translate(translate.x, translate.y, translate.z);
        if (VREffectsHelper.MC.hitResult != null && VREffectsHelper.MC.hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)VREffectsHelper.MC.hitResult;
            switch (blockhitresult.getDirection()) {
                case DOWN: {
                    modelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getYaw()));
                    modelView.rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case UP: {
                    modelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getYaw()));
                    modelView.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case WEST: {
                    modelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case EAST: {
                    modelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
                    break;
                }
                case SOUTH: {
                    modelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                }
            }
        } else {
            modelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getYaw()));
            modelView.rotate((Quaternionfc)Axis.XP.rotationDegrees(-VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getAim().getPitch()));
        }
        float scale = (float)((double)(0.125f * VREffectsHelper.DATA_HOLDER.vrSettings.crosshairScale) * Math.sqrt(VREffectsHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale));
        if (VREffectsHelper.DATA_HOLDER.vrSettings.crosshairScalesWithDistance) {
            float depthScale = 0.3f + 0.2f * (float)crossDistance.length();
            scale *= depthScale;
        }
        modelView.scale(scale, scale, scale);
        VREffectsHelper.MC.gameRenderer.lightTexture().turnOnLightLayer();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        if (depthAlways) {
            RenderSystem.depthFunc((int)519);
        } else {
            RenderSystem.depthFunc((int)515);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)VREffectsHelper.MC.level, (BlockPos)BlockPos.containing((Position)crosshairRenderPos));
        float brightness = 1.0f;
        if (VREffectsHelper.MC.hitResult == null || VREffectsHelper.MC.hitResult.getType() == HitResult.Type.MISS) {
            brightness = 0.5f;
        }
        TextureAtlasSprite crosshairSprite = Minecraft.getInstance().getGuiSprites().getSprite(Gui.CROSSHAIR_SPRITE);
        ShadersHelper.bindTexture(crosshairSprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.NEW_ENTITY);
        bufferBuilder.vertex(modelView, -1.0f, 1.0f, 0.0f).color(brightness, brightness, brightness, 1.0f).uv(crosshairSprite.getU1(), crosshairSprite.getV0()).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
        bufferBuilder.vertex(modelView, 1.0f, 1.0f, 0.0f).color(brightness, brightness, brightness, 1.0f).uv(crosshairSprite.getU0(), crosshairSprite.getV0()).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
        bufferBuilder.vertex(modelView, 1.0f, -1.0f, 0.0f).color(brightness, brightness, brightness, 1.0f).uv(crosshairSprite.getU0(), crosshairSprite.getV1()).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
        bufferBuilder.vertex(modelView, -1.0f, -1.0f, 0.0f).color(brightness, brightness, brightness, 1.0f).uv(crosshairSprite.getU1(), crosshairSprite.getV1()).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthFunc((int)515);
        MC.getProfiler().pop();
    }

    static {
        CUBE_FRONT = new ResourceLocation("textures/gui/title/background/panorama_0.png");
        CUBE_RIGHT = new ResourceLocation("textures/gui/title/background/panorama_1.png");
        CUBE_BACK = new ResourceLocation("textures/gui/title/background/panorama_2.png");
        CUBE_LEFT = new ResourceLocation("textures/gui/title/background/panorama_3.png");
        CUBE_UP = new ResourceLocation("textures/gui/title/background/panorama_4.png");
        CUBE_DOWN = new ResourceLocation("textures/gui/title/background/panorama_5.png");
        DIRT = new ResourceLocation("minecraft:textures/block/dirt.png");
        GRASS = new ResourceLocation("minecraft:textures/block/grass_block_top.png");
    }
}

