/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.player;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_vr.utils.external.jinfinadeck;
import org.vivecraft.client_vr.utils.external.jkatvr;
import org.vivecraft.common.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.data.ViveModifiers;
import org.vivecraft.mixin.client_vr.player.LocalPlayer_PlayerVRMixin;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerVRMixin
extends LocalPlayer_PlayerVRMixin
implements PlayerExtension {
    @Unique
    private Vec3 vivecraft$moveMulIn = Vec3.ZERO;
    @Unique
    private boolean vivecraft$initFromServer;
    @Unique
    private boolean vivecraft$teleported;
    @Unique
    private double vivecraft$additionX;
    @Unique
    private double vivecraft$additionZ;
    @Unique
    private final ClientDataHolderVR vivecraft$dataholder = ClientDataHolderVR.getInstance();
    @Final
    @Shadow
    protected Minecraft minecraft;

    @Shadow
    protected abstract void updateAutoJump(float var1, float var2);

    @Shadow
    public abstract boolean isShiftKeyDown();

    @Shadow
    public abstract InteractionHand getUsedItemHand();

    @Shadow
    public abstract boolean isUsingItem();

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="TAIL")})
    private void vivecraft$startRidingTracker(Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> cir) {
        if (VRState.VR_INITIALIZED && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vehicleTracker.onStartRiding(vehicle);
        }
    }

    @Inject(method={"removeVehicle()V"}, at={@At(value="TAIL")})
    private void vivecraft$stopRidingTracker(CallbackInfo ci) {
        if (VRState.VR_INITIALIZED && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vehicleTracker.onStopRiding();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V")})
    private void vivecraft$preTick(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vrPlayer.doPermanentLookOverride((LocalPlayer)this, ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V", shift=At.Shift.AFTER)})
    private void vivecraft$postTick(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientNetworking.overridePose((LocalPlayer)this);
            ClientDataHolderVR.getInstance().vrPlayer.doPermanentLookOverride((LocalPlayer)this, ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre);
        }
    }

    @ModifyVariable(method={"sendPosition()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isPassenger()Z"), ordinal=2)
    private boolean vivecraft$directTeleport(boolean updateRotation) {
        if (this.vivecraft$teleported) {
            updateRotation = true;
            ClientNetworking.sendServerPacket(new TeleportPayloadC2S((float)this.getX(), (float)this.getY(), (float)this.getZ()));
        }
        return updateRotation;
    }

    @WrapWithCondition(method={"sendPosition()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isPassenger()Z"))})
    private boolean vivecraft$noMovePacketsOnTeleport(ClientPacketListener instance, Packet packet) {
        return !this.vivecraft$teleported;
    }

    @Inject(method={"sendPosition()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;lastOnGround:Z", shift=At.Shift.AFTER, ordinal=1)})
    private void vivecraft$noAutoJump(CallbackInfo ci) {
        this.vivecraft$teleported = false;
        if (VRState.VR_RUNNING && ClientDataHolderVR.getInstance().vrSettings.walkUpBlocks) {
            this.minecraft.options.autoJump().set((Object)false);
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;aiStep()V")})
    private void vivecraft$VRPlayerTick(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().vrPlayer.tick((LocalPlayer)this);
        }
    }

    @Inject(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$overwriteMove(MoverType type, Vec3 pos, CallbackInfo ci) {
        if (!VRState.VR_RUNNING || !this.vivecraft$isLocalPlayer(this) || Minecraft.getInstance().getCameraEntity() != this) {
            AttributeInstance attribute = this.getAttribute((Holder<Attribute>)Attributes.STEP_HEIGHT);
            if (attribute != null && attribute.getModifier(ViveModifiers.WALK_UP_BLOCKS) != null) {
                attribute.removeModifier(ViveModifiers.WALK_UP_BLOCKS);
            }
            return;
        }
        this.vivecraft$moveMulIn = this.stuckSpeedMultiplier;
        if (pos.length() == 0.0 || this.isPassenger()) {
            super.move(type, pos);
        } else {
            boolean doY;
            boolean freeMove = VRPlayer.get().getFreeMove();
            boolean bl = doY = freeMove || ClientDataHolderVR.getInstance().vrSettings.simulateFalling && !this.onClimbable() && !this.isShiftKeyDown();
            if (ClientDataHolderVR.getInstance().climbTracker.isActive((LocalPlayer)this) && (freeMove || ClientDataHolderVR.getInstance().climbTracker.isGrabbingLadder())) {
                doY = true;
            }
            Vec3 roomOrigin = VRPlayer.get().roomOrigin;
            if ((ClientDataHolderVR.getInstance().climbTracker.isGrabbingLadder() || freeMove || ClientDataHolderVR.getInstance().swimTracker.isActive((LocalPlayer)this)) && (this.zza != 0.0f || this.isFallFlying() || Math.abs(this.getDeltaMovement().x) > 0.01 || Math.abs(this.getDeltaMovement().z) > 0.01)) {
                double xOffset = roomOrigin.x - this.getX();
                double zOffset = roomOrigin.z - this.getZ();
                double oldX = this.getX();
                double oldZ = this.getZ();
                super.move(type, pos);
                AttributeInstance attribute = this.getAttribute((Holder<Attribute>)Attributes.STEP_HEIGHT);
                if (attribute != null) {
                    if (ClientDataHolderVR.getInstance().vrSettings.walkUpBlocks) {
                        if (this.getBlockJumpFactor() == 1.0f) {
                            if (attribute.getModifier(ViveModifiers.WALK_UP_BLOCKS) == null) {
                                attribute.addTransientModifier(new AttributeModifier(ViveModifiers.WALK_UP_BLOCKS, "walk up block", (double)0.4f, AttributeModifier.Operation.ADD_VALUE));
                            }
                        } else if (attribute.getModifier(ViveModifiers.WALK_UP_BLOCKS) != null) {
                            attribute.removeModifier(ViveModifiers.WALK_UP_BLOCKS);
                        }
                    } else {
                        if (attribute.getModifier(ViveModifiers.WALK_UP_BLOCKS) != null) {
                            attribute.removeModifier(ViveModifiers.WALK_UP_BLOCKS);
                        }
                        this.updateAutoJump((float)(this.getX() - oldX), (float)(this.getZ() - oldZ));
                    }
                }
                VRPlayer.get().setRoomOrigin(this.getX() + xOffset, this.getY() + this.vivecraft$getRoomYOffsetFromPose(), this.getZ() + zOffset, false);
            } else if (doY) {
                super.move(type, new Vec3(0.0, pos.y, 0.0));
                VRPlayer.get().setRoomOrigin(VRPlayer.get().roomOrigin.x, this.getY() + this.vivecraft$getRoomYOffsetFromPose(), VRPlayer.get().roomOrigin.z, false);
            } else {
                this.setOnGround(true);
            }
        }
        ci.cancel();
    }

    @ModifyArg(method={"updateAutoJump(FF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;sin(F)F"))
    private float vivecraft$modifyAutoJumpSin(float original) {
        return VRState.VR_RUNNING ? ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.getBodyYawRad() : original;
    }

    @ModifyArg(method={"updateAutoJump(FF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;cos(F)F"))
    private float vivecraft$modifyAutoJumpCos(float original) {
        return VRState.VR_RUNNING ? ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_pre.getBodyYawRad() : original;
    }

    @Inject(method={"handleEntityEvent(B)V"}, at={@At(value="HEAD")})
    private void vivecraft$hapticsOnEvent(byte id, CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this) && id == 3) {
            ClientDataHolderVR.getInstance().vr.triggerHapticPulse(0, 2000);
            ClientDataHolderVR.getInstance().vr.triggerHapticPulse(1, 2000);
        }
    }

    @Inject(method={"getRopeHoldPosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$vrRopePosition(CallbackInfoReturnable<Vec3> cir) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            cir.setReturnValue((Object)RenderHelper.getControllerRenderPos(0));
        }
    }

    @Override
    protected void vivecraft$beforeEat(CallbackInfoReturnable<ItemStack> cir, @Local(argsOnly=true) ItemStack food) {
        if (VRState.VR_INITIALIZED && food.get(DataComponents.FOOD) != null && this.vivecraft$isLocalPlayer(this)) {
            ClientDataHolderVR.getInstance().hapticTracker.handleEat(food);
            if (food.getHoverName().getString().equals("EAT ME")) {
                ClientDataHolderVR.getInstance().vrPlayer.wfMode = 0.5;
                ClientDataHolderVR.getInstance().vrPlayer.wfCount = 400;
            }
        }
    }

    @Override
    protected void vivecraft$beforeReleaseUsingItem(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this)) {
            ClientNetworking.sendActiveHand(this.isUsingItem() ? this.getUsedItemHand() : InteractionHand.MAIN_HAND, false);
        }
    }

    @Override
    protected void vivecraft$afterAbsMoveTo(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this) && this.vivecraft$initFromServer) {
            ClientDataHolderVR.getInstance().vrPlayer.snapRoomOriginToPlayerEntity((Entity)((LocalPlayer)this), false, false);
        }
    }

    @Override
    protected void vivecraft$wrapSetPos(double x, double y, double z, Operation<Void> original) {
        this.vivecraft$initFromServer = true;
        if (!VRState.VR_RUNNING || !this.vivecraft$isLocalPlayer(this)) {
            original.call(new Object[]{x, y, z});
            return;
        }
        boolean wasZero = this.position() == Vec3.ZERO;
        double oldX = this.getX();
        double oldY = this.getY();
        double oldZ = this.getZ();
        original.call(new Object[]{x, y, z});
        double newX = this.getX();
        double newY = this.getY();
        double newZ = this.getZ();
        if (Minecraft.getInstance().getCameraEntity() == this && this.isPassenger()) {
            ClientDataHolderVR.getInstance().vehicleTracker.updateRiderPos(x, y, z, this.getVehicle());
        } else if (!ClientDataHolderVR.getInstance().vehicleTracker.isRiding()) {
            if (wasZero) {
                VRPlayer.get().snapRoomOriginToPlayerEntity((Entity)((LocalPlayer)this), x + y + z == 0.0, false);
            } else {
                Vec3 roomOrigin = ClientDataHolderVR.getInstance().vrPlayer.roomOrigin;
                VRPlayer.get().setRoomOrigin(roomOrigin.x + (newX - oldX), roomOrigin.y + (newY - oldY), roomOrigin.z + (newZ - oldZ), x + y + z == 0.0);
            }
        }
    }

    @Override
    protected Vec3 vivecraft$controllerMovement(Vec3 relative, float amount, float facing, Operation<Vec3> original) {
        if (!VRState.VR_RUNNING || !this.vivecraft$isLocalPlayer(this)) {
            return (Vec3)original.call(new Object[]{relative, Float.valueOf(amount), Float.valueOf(facing)});
        }
        double up = relative.y;
        double strafe = relative.x;
        double forward = relative.z;
        VRPlayer vrplayer = this.vivecraft$dataholder.vrPlayer;
        Vec3 movement = Vec3.ZERO;
        if (vrplayer.getFreeMove()) {
            double speed = strafe * strafe + forward * forward;
            double mX = 0.0;
            double mZ = 0.0;
            double mY = 0.0;
            double addFactor = 1.0;
            if (speed >= (double)1.0E-4f || ClientDataHolderVR.getInstance().katVr) {
                boolean isFlyingOrSwimming;
                if ((speed = (double)Mth.sqrt((float)((float)speed))) < 1.0 && !ClientDataHolderVR.getInstance().katVr) {
                    speed = 1.0;
                }
                speed = (double)amount / speed;
                Vec3 direction = new Vec3(strafe *= speed, 0.0, forward *= speed);
                boolean bl = isFlyingOrSwimming = !this.isPassenger() && (this.getAbilities().flying || this.isSwimming());
                if (ClientDataHolderVR.getInstance().katVr) {
                    jkatvr.query();
                    speed = jkatvr.getSpeed() * jkatvr.walkDirection() * this.vivecraft$dataholder.vrSettings.movementSpeedMultiplier;
                    direction = new Vec3(0.0, 0.0, speed);
                    if (isFlyingOrSwimming) {
                        direction = direction.xRot(vrplayer.vrdata_world_pre.hmd.getPitchRad());
                    }
                    direction = direction.yRot(-jkatvr.getYaw() * ((float)Math.PI / 180) + vrplayer.vrdata_world_pre.rotation_radians);
                } else if (ClientDataHolderVR.getInstance().infinadeck) {
                    jinfinadeck.query();
                    speed = jinfinadeck.getSpeed() * jinfinadeck.walkDirection() * this.vivecraft$dataholder.vrSettings.movementSpeedMultiplier;
                    direction = new Vec3(0.0, 0.0, speed);
                    if (isFlyingOrSwimming) {
                        direction = direction.xRot(vrplayer.vrdata_world_pre.hmd.getPitchRad());
                    }
                    direction = direction.yRot(-jinfinadeck.getYaw() * ((float)Math.PI / 180) + vrplayer.vrdata_world_pre.rotation_radians);
                } else if (this.vivecraft$dataholder.vrSettings.seated) {
                    int c = 0;
                    if (this.vivecraft$dataholder.vrSettings.seatedUseHMD) {
                        c = 1;
                    }
                    if (isFlyingOrSwimming) {
                        direction = direction.xRot(vrplayer.vrdata_world_pre.getController(c).getPitchRad());
                    }
                    direction = direction.yRot(-vrplayer.vrdata_world_pre.getController(c).getYawRad());
                } else {
                    VRSettings.FreeMove freeMoveType;
                    VRSettings.FreeMove freeMove = freeMoveType = !this.isPassenger() && this.getAbilities().flying && this.vivecraft$dataholder.vrSettings.vrFreeMoveFlyMode != VRSettings.FreeMove.AUTO ? this.vivecraft$dataholder.vrSettings.vrFreeMoveFlyMode : this.vivecraft$dataholder.vrSettings.vrFreeMoveMode;
                    if (isFlyingOrSwimming) {
                        switch (freeMoveType) {
                            case CONTROLLER: {
                                Vec3 vec3 = direction.xRot(vrplayer.vrdata_world_pre.getController(1).getPitchRad());
                                break;
                            }
                            case HMD: 
                            case RUN_IN_PLACE: 
                            case ROOM: {
                                Vec3 vec3 = direction.xRot(vrplayer.vrdata_world_pre.hmd.getPitchRad());
                                break;
                            }
                            default: {
                                Vec3 vec3 = direction = direction;
                            }
                        }
                    }
                    if (this.vivecraft$dataholder.jumpTracker.isjumping()) {
                        direction = direction.yRot(-vrplayer.vrdata_world_pre.hmd.getYawRad());
                    } else {
                        direction = switch (freeMoveType) {
                            case VRSettings.FreeMove.CONTROLLER -> direction.yRot(-vrplayer.vrdata_world_pre.getController(1).getYawRad());
                            case VRSettings.FreeMove.HMD -> direction.yRot(-vrplayer.vrdata_world_pre.hmd.getYawRad());
                            case VRSettings.FreeMove.RUN_IN_PLACE -> direction.yRot((float)(-this.vivecraft$dataholder.runTracker.getYaw())).scale(this.vivecraft$dataholder.runTracker.getSpeed());
                            case VRSettings.FreeMove.ROOM -> direction.yRot((180.0f + this.vivecraft$dataholder.vrSettings.worldRotation) * ((float)Math.PI / 180));
                            default -> direction;
                        };
                    }
                }
                mX = direction.x;
                mY = direction.y;
                mZ = direction.z;
                if (this.onGround() && !this.getAbilities().flying && !this.wasTouchingWater) {
                    addFactor = this.vivecraft$dataholder.vrSettings.inertiaFactor.getFactor();
                }
                float yAdd = 1.0f;
                if (this.getAbilities().flying) {
                    yAdd = 5.0f;
                }
                movement = new Vec3(mX * addFactor, mY * (double)yAdd, mZ * addFactor);
                this.vivecraft$additionX = mX;
                this.vivecraft$additionZ = mZ;
            }
        }
        return movement;
    }

    @Override
    protected void vivecraft$afterMoveRelative(CallbackInfo ci) {
        if (VRState.VR_RUNNING && this.vivecraft$isLocalPlayer(this) && ClientDataHolderVR.getInstance().vrPlayer.getFreeMove() && this.onGround() && !this.getAbilities().flying && !this.wasTouchingWater) {
            this.vivecraft$doDrag();
        }
    }

    @Unique
    private void vivecraft$doDrag() {
        double friction = 0.91;
        if (this.onGround()) {
            friction *= (double)this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction();
        }
        this.setDeltaMovement(this.getDeltaMovement().x / friction, this.getDeltaMovement().y, this.getDeltaMovement().z / friction);
        double addFactor = this.vivecraft$dataholder.vrSettings.inertiaFactor.getFactor();
        double boundedAdditionX = this.vivecraft$getBoundedAddition(this.vivecraft$additionX);
        double targetLimitX = friction * boundedAdditionX / (1.0 - friction);
        double multiFactorX = targetLimitX / (friction * (targetLimitX + boundedAdditionX * addFactor));
        double xFactor = friction * multiFactorX;
        double boundedAdditionZ = this.vivecraft$getBoundedAddition(this.vivecraft$additionZ);
        double targetLimitZ = friction * boundedAdditionZ / (1.0 - friction);
        double multiFactorZ = targetLimitZ / (friction * (targetLimitZ + boundedAdditionZ * addFactor));
        double zFactor = friction * multiFactorZ;
        this.setDeltaMovement(this.getDeltaMovement().x * xFactor, this.getDeltaMovement().y, this.getDeltaMovement().z * zFactor);
    }

    @Unique
    private double vivecraft$getBoundedAddition(double orig) {
        return orig >= -1.0E-6 && orig <= 1.0E-6 ? 1.0E-6 : orig;
    }

    @Unique
    private boolean vivecraft$isLocalPlayer(Object player) {
        return player.getClass().equals(LocalPlayer.class) || Minecraft.getInstance().player == player;
    }

    @Override
    @Unique
    public boolean vivecraft$getInitFromServer() {
        return this.vivecraft$initFromServer;
    }

    @Override
    @Unique
    public float vivecraft$getMuhSpeedFactor() {
        return this.vivecraft$moveMulIn != null && this.vivecraft$moveMulIn.lengthSqr() > 0.0 ? this.getBlockSpeedFactor() * (float)(this.vivecraft$moveMulIn.x + this.vivecraft$moveMulIn.z) * 0.5f : this.getBlockSpeedFactor();
    }

    @Override
    @Unique
    public float vivecraft$getMuhJumpFactor() {
        return this.vivecraft$moveMulIn != null && this.vivecraft$moveMulIn.lengthSqr() > 0.0 ? this.getBlockJumpFactor() * (float)this.vivecraft$moveMulIn.y : this.getBlockJumpFactor();
    }

    @Override
    @Unique
    public void vivecraft$stepSound(BlockPos blockPos, Vec3 soundPos) {
        BlockState blockState = this.level().getBlockState(blockPos);
        SoundType soundType = blockState.getSoundType();
        BlockState aboveBlockState = this.level().getBlockState(blockPos.above());
        if (aboveBlockState.is(Blocks.SNOW)) {
            soundType = aboveBlockState.getSoundType();
        }
        if (!this.isSilent() && !blockState.liquid()) {
            float volume = soundType.getVolume();
            float pitch = soundType.getPitch();
            SoundEvent soundevent = soundType.getStepSound();
            this.level().playSound(null, soundPos.x, soundPos.y, soundPos.z, soundevent, this.getSoundSource(), volume, pitch);
        }
    }

    @Override
    @Unique
    public void vivecraft$setTeleported(boolean teleported) {
        this.vivecraft$teleported = teleported;
    }

    @Override
    @Unique
    public void vivecraft$setItemInUseRemainingClient(int count) {
        this.useItemRemaining = count;
    }

    @Override
    @Unique
    public double vivecraft$getRoomYOffsetFromPose() {
        if (this.getPose() == Pose.FALL_FLYING || this.getPose() == Pose.SPIN_ATTACK || this.getPose() == Pose.SWIMMING && !ClientDataHolderVR.getInstance().crawlTracker.crawlsteresis) {
            return -1.2;
        }
        return 0.0;
    }
}

