/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class InputSimulator {
    private static final Set<Integer> PRESSED_KEYS = new HashSet<Integer>();
    private static final Map<Integer, Integer> PRESSED_MODIFIERS = new HashMap<Integer, Integer>();
    private static long AIR_TYPING_WARNING_TIME;

    public static boolean isKeyDown(int key) {
        return PRESSED_KEYS.contains(key) || PRESSED_MODIFIERS.getOrDefault(key, 0) > 0;
    }

    private static void handleKeyAction(int key, int modifiers, int action) {
        class_310.method_1551().field_1774.method_1466(class_310.method_1551().method_22683().method_4490(), key, 0, action, modifiers);
    }

    public static void pressKey(int key, int modifiers) {
        PRESSED_KEYS.add(key);
        InputSimulator.handleKeyAction(key, modifiers, 1);
    }

    public static void pressKey(int key) {
        InputSimulator.pressKey(key, 0);
    }

    public static void releaseKey(int key, int modifiers) {
        PRESSED_KEYS.remove(key);
        InputSimulator.handleKeyAction(key, modifiers, 0);
    }

    public static void releaseKey(int key) {
        InputSimulator.releaseKey(key, 0);
    }

    public static void pressModifier(int key, int modifiers) {
        PRESSED_MODIFIERS.merge(key, 1, Integer::sum);
        InputSimulator.handleKeyAction(key, modifiers, 1);
    }

    public static void pressModifier(int key) {
        InputSimulator.pressModifier(key, 0);
    }

    public static void releaseModifier(int key, int modifiers) {
        PRESSED_MODIFIERS.merge(key, -1, Integer::sum);
        InputSimulator.handleKeyAction(key, modifiers, 0);
    }

    public static void releaseModifier(int key) {
        InputSimulator.releaseModifier(key, 0);
    }

    public static void typeChar(char character, int modifiers) {
        class_310.method_1551().field_1774.method_1457(class_310.method_1551().method_22683().method_4490(), (int)character, modifiers);
    }

    public static void typeChar(char character) {
        InputSimulator.typeChar(character, 0);
    }

    public static void pressMouse(int button, int modifiers) {
        class_310.method_1551().field_1729.method_1601(class_310.method_1551().method_22683().method_4490(), button, 1, modifiers);
    }

    public static void pressMouse(int button) {
        InputSimulator.pressMouse(button, 0);
    }

    public static void releaseMouse(int button, int modifiers) {
        class_310.method_1551().field_1729.method_1601(class_310.method_1551().method_22683().method_4490(), button, 0, modifiers);
    }

    public static void releaseMouse(int button) {
        InputSimulator.releaseMouse(button, 0);
    }

    public static void setMousePos(double x, double y) {
        class_310.method_1551().field_1729.method_1600(class_310.method_1551().method_22683().method_4490(), x, y);
    }

    public static void scrollMouse(double xOffset, double yOffset) {
        class_310.method_1551().field_1729.method_1598(class_310.method_1551().method_22683().method_4490(), xOffset, yOffset);
    }

    public static void typeChars(CharSequence characters) {
        for (int i = 0; i < characters.length(); ++i) {
            char character = characters.charAt(i);
            InputSimulator.typeChar(character);
        }
    }

    public static void pressKeyForBind(int code) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (dataHolder.vrSettings.keyboardPressBinds) {
            if (code != -1) {
                InputSimulator.pressKey(code);
            }
        } else if (minecraft.field_1755 == null && ClientUtils.milliTime() - AIR_TYPING_WARNING_TIME >= 30000L) {
            ClientUtils.addChatMessage((class_2561)class_2561.method_43471((String)"vivecraft.messages.airtypingwarning"));
            AIR_TYPING_WARNING_TIME = ClientUtils.milliTime();
        }
    }

    public static void releaseKeyForBind(int code) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (dataHolder.vrSettings.keyboardPressBinds && code != -1) {
            InputSimulator.releaseKey(code);
        }
    }
}

