/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mixin.client.blaze3d.RenderSystemAccessor;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class RenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final class_310 MC = class_310.method_1551();
    public static final class_2960 WHITE_TEXTURE = new class_2960("vivecraft:textures/white.png");
    public static final class_2960 BLACK_TEXTURE = new class_2960("vivecraft:textures/black.png");

    public static Matrix4f getVRModelView(RenderPass renderPass) {
        return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix().transpose();
    }

    public static void applyVRModelView(RenderPass renderPass, class_4587 poseStack) {
        Matrix4f modelView = RenderHelper.getVRModelView(renderPass);
        poseStack.method_23760().method_23761().mul((Matrix4fc)modelView);
        poseStack.method_23760().method_23762().mul((Matrix3fc)new Matrix3f((Matrix4fc)modelView));
    }

    public static void applyStereo(RenderPass renderPass, class_4587 poseStack) {
        if (renderPass == RenderPass.LEFT || renderPass == RenderPass.RIGHT) {
            class_243 eye = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition().method_1020(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition());
            poseStack.method_22904(-eye.field_1352, -eye.field_1351, -eye.field_1350);
        }
    }

    public static class_243 getControllerRenderPos(int c) {
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && c < 2) {
            int mainHand = class_1268.field_5808.ordinal();
            if (RenderHelper.DATA_HOLDER.vrSettings.reverseHands) {
                c = 1 - c;
                mainHand = class_1268.field_5810.ordinal();
            }
            if (RenderHelper.MC.field_1724 != null && RenderHelper.MC.field_1687 != null && TelescopeTracker.isTelescope(RenderHelper.MC.field_1724.method_6030()) && TelescopeTracker.isTelescope(c == mainHand ? RenderHelper.MC.field_1724.method_6047() : RenderHelper.MC.field_1724.method_6079())) {
                VRData.VRDevicePose eye = c == 0 ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye0 : RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye1;
                Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection().mul(0.2f * RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale);
                return eye.getPosition().method_1031((double)dir.x, (double)dir.y, (double)dir.z);
            }
            float worldScale = RenderHelper.MC.field_1724 != null && RenderHelper.MC.field_1687 != null ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale : 1.0f;
            Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir.rotateY((float)Math.PI / 180 * (c == 0 ? -35.0f : 35.0f));
            dir.y = 0.0f;
            dir.normalize();
            return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition().method_1031((double)dir.x * 0.3 * (double)worldScale, -0.4 * (double)worldScale, (double)dir.z * 0.3 * (double)worldScale);
        }
        return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getPosition();
    }

    public static void setupRenderingAtController(int c, class_4587 poseStack) {
        class_243 aimSource = RenderHelper.getControllerRenderPos(c);
        aimSource = aimSource.method_1020(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(RenderHelper.DATA_HOLDER.currentPass).getPosition());
        poseStack.method_22904(aimSource.field_1352, aimSource.field_1351, aimSource.field_1350);
        float sc = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && RenderHelper.MC.field_1724 != null && RenderHelper.MC.field_1687 != null && TelescopeTracker.isTelescope(RenderHelper.MC.field_1724.method_6030()) && TelescopeTracker.isTelescope(c == 0 ? RenderHelper.MC.field_1724.method_6047() : RenderHelper.MC.field_1724.method_6079())) {
            poseStack.method_34425(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getMatrix().invert().transpose());
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            poseStack.method_46416((c == (RenderHelper.DATA_HOLDER.vrSettings.reverseHands ? 1 : 0) ? 0.075f : -0.075f) * sc, -0.025f * sc, 0.0325f * sc);
        } else {
            poseStack.method_34425(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getMatrix().invert().transpose());
        }
        poseStack.method_22905(sc, sc, sc);
    }

    public static void drawScreen(class_332 guiGraphics, float partialTick, class_437 screen, boolean maxGuiScale) {
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_34426();
        poseStack.method_46416(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        double guiScale = maxGuiScale ? (double)GuiHandler.GUI_SCALE_FACTOR_MAX : MC.method_22683().method_4495();
        int backupGuiScale = GuiHandler.GUI_SCALE_FACTOR;
        GuiHandler.GUI_SCALE_FACTOR = (int)guiScale;
        Matrix4f guiProjection = new Matrix4f().setOrtho(0.0f, (float)((double)RenderHelper.MC.method_1522().field_1482 / guiScale), (float)((double)RenderHelper.MC.method_1522().field_1481 / guiScale), 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)guiProjection, (class_8251)class_8251.field_43361);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        screen.method_25394(guiGraphics, 0, 0, partialTick);
        guiGraphics.method_51452();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        GuiHandler.GUI_SCALE_FACTOR = backupGuiScale;
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        if (RenderHelper.DATA_HOLDER.vrSettings.guiMipmaps) {
            OpenGLHelper.genMipmaps(RenderHelper.MC.field_1689);
        }
    }

    public static void drawMouseMenuQuad(class_332 guiGraphics, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        float size = 15.0f * Math.max(ClientDataHolderVR.getInstance().vrSettings.menuCrosshairScale, 1.0f / (float)MC.method_22683().method_4495());
        guiGraphics.method_52706(class_329.field_45304, (int)((float)mouseX - size * 0.5f + 1.0f), (int)((float)mouseY - size * 0.5f + 1.0f), (int)size, (int)size);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void drawVRConnectingMessage() {
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_34426();
        poseStack.method_46416(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        float guiScale = (float)MC.method_22683().method_4495();
        Matrix4f guiProjection = new Matrix4f().setOrtho(0.0f, (float)RenderHelper.MC.method_1522().field_1482 / guiScale, (float)RenderHelper.MC.method_1522().field_1481 / guiScale, 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)guiProjection, (class_8251)class_8251.field_43361);
        class_332 guiGraphics = new class_332(MC, MC.method_22940().method_23000());
        int width = 200;
        List formattedChars = RenderHelper.MC.field_1772.method_1728((class_5348)class_2561.method_43471((String)"vivecraft.messages.connectingtoruntime"), width - 10);
        int height = formattedChars.size() * 8 + Math.max(formattedChars.size() - 1, 0) * 4 + 10;
        int x = guiGraphics.method_51421() / 2 - width / 2;
        int y = guiGraphics.method_51443() / 2 - height / 2;
        guiGraphics.method_25294(0, 0, guiGraphics.method_51421(), guiGraphics.method_51443(), 0x40000000);
        guiGraphics.method_25294(x, y, x + width, y + height, -16777216);
        guiGraphics.method_49601(x, y, width, height, -1);
        for (int line = 0; line < formattedChars.size(); ++line) {
            guiGraphics.method_35719(RenderHelper.MC.field_1772, (class_5481)formattedChars.get(line), guiGraphics.method_51421() / 2, y + 5 + line * 12, -1);
        }
        guiGraphics.method_51452();
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, -sizeX, -sizeY, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, sizeX, -sizeY, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, sizeX, sizeY, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix, -sizeX, sizeY, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, Matrix4f matrix, Supplier<class_5944> shader, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, packedLight, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, matrix, shader, flipY);
    }

    public static void drawSizedQuadFullbright(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix, Supplier<class_5944> shader) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, 0xF000F0, color, matrix, shader, false);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, float[] color, Matrix4f matrix, Supplier<class_5944> shader, boolean flipY) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        RenderSystem.setShader(shader);
        RenderHelper.MC.field_1773.method_22974().method_3316();
        RenderHelper.MC.field_1773.method_22975().method_23209();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1580);
        Vector3f light0Old = RenderSystemAccessor.getShaderLightDirections()[0];
        Vector3f light1Old = RenderSystemAccessor.getShaderLightDirections()[1];
        Vector3f normal = new Matrix3f((Matrix4fc)matrix).transform(new Vector3f(0.0f, 0.0f, 1.0f)).normalize();
        RenderSystem.setShaderLights((Vector3f)normal, (Vector3f)normal);
        RenderSystem.setupShaderLights((class_5944)RenderSystem.getShader());
        bufferBuilder.method_22918(matrix, -sizeX, -sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(0.0f, flipY ? 1.0f : 0.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(normal.x, normal.y, normal.z).method_1344();
        bufferBuilder.method_22918(matrix, sizeX, -sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(1.0f, flipY ? 1.0f : 0.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(normal.x, normal.y, normal.z).method_1344();
        bufferBuilder.method_22918(matrix, sizeX, sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(1.0f, flipY ? 0.0f : 1.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(normal.x, normal.y, normal.z).method_1344();
        bufferBuilder.method_22918(matrix, -sizeX, sizeY, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(0.0f, flipY ? 0.0f : 1.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(normal.x, normal.y, normal.z).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderHelper.MC.field_1773.method_22974().method_3315();
        if (light0Old != null && light1Old != null) {
            RenderSystem.setShaderLights((Vector3f)light0Old, (Vector3f)light1Old);
            RenderSystem.setupShaderLights((class_5944)RenderSystem.getShader());
        }
    }

    public static void renderFlatQuad(class_243 pos, float width, float height, float yaw, int r, int g, int b, int a, class_4587 poseStack) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_29337);
        class_243 offset = new class_243((double)(width * 0.5f), 0.0, (double)(height * 0.5f)).method_1024((float)Math.PI / 180 * -yaw);
        ShadersHelper.bindTexture(WHITE_TEXTURE);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, (float)(pos.field_1352 + offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 + offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(pos.field_1352 + offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 - offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(pos.field_1352 - offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 - offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, (float)(pos.field_1352 - offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 + offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void renderBox(class_4588 consumer, class_243 start, class_243 end, float xSize, float ySize, class_2382 color, byte alpha, class_4587 poseStack) {
        RenderHelper.renderBox(consumer, start, end, -xSize * 0.5f, xSize * 0.5f, -ySize * 0.5f, ySize * 0.5f, color, alpha, poseStack);
    }

    public static void renderBox(class_4588 consumer, class_243 start, class_243 end, float minX, float maxX, float minY, float maxY, class_2382 color, byte alpha, class_4587 poseStack) {
        class_243 forward = start.method_1020(end).method_1029();
        class_243 right = forward.method_1036(MathUtils.UP_D);
        right = right.method_1027() == 0.0 ? MathUtils.LEFT_D : right.method_1029();
        class_243 up = right.method_1036(forward);
        class_243 left = right.method_1021((double)minX);
        right = right.method_1021((double)maxX);
        class_243 down = up.method_1021((double)minY);
        up = up.method_1021((double)maxY);
        class_243 upNormal = up.method_1029();
        class_243 rightNormal = right.method_1029();
        class_243 backRightBottom = start.method_1031(right.field_1352 + down.field_1352, right.field_1351 + down.field_1351, right.field_1350 + down.field_1350);
        class_243 backRightTop = start.method_1031(right.field_1352 + up.field_1352, right.field_1351 + up.field_1351, right.field_1350 + up.field_1350);
        class_243 backLeftBottom = start.method_1031(left.field_1352 + down.field_1352, left.field_1351 + down.field_1351, left.field_1350 + down.field_1350);
        class_243 backLeftTop = start.method_1031(left.field_1352 + up.field_1352, left.field_1351 + up.field_1351, left.field_1350 + up.field_1350);
        class_243 frontRightBottom = end.method_1031(right.field_1352 + down.field_1352, right.field_1351 + down.field_1351, right.field_1350 + down.field_1350);
        class_243 frontRightTop = end.method_1031(right.field_1352 + up.field_1352, right.field_1351 + up.field_1351, right.field_1350 + up.field_1350);
        class_243 frontLeftBottom = end.method_1031(left.field_1352 + down.field_1352, left.field_1351 + down.field_1351, left.field_1350 + down.field_1350);
        class_243 frontLeftTop = end.method_1031(left.field_1352 + up.field_1352, left.field_1351 + up.field_1351, left.field_1350 + up.field_1350);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha, forward);
        forward = forward.method_22882();
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha, forward);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha, rightNormal);
        rightNormal = rightNormal.method_22882();
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha, upNormal);
        upNormal = upNormal.method_22882();
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha, upNormal);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha, upNormal);
    }

    private static void addVertex(class_4588 consumer, Matrix4f matrix, class_243 pos, class_2382 color, int alpha, class_243 normal) {
        consumer.method_22918(matrix, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_1336(color.method_10263(), color.method_10264(), color.method_10260(), alpha).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    public static String checkGLError(String errorSection) {
        int error = GlStateManager._getError();
        if (error != 0) {
            String errorString = switch (error) {
                case 1280 -> "invalid enum";
                case 1281 -> "invalid value";
                case 1282 -> "invalid operation";
                case 1283 -> "stack overflow";
                case 1284 -> "stack underflow";
                case 1285 -> "out of memory";
                case 1286 -> "framebuffer is not complete";
                default -> "unknown error";
            };
            VRSettings.LOGGER.error("Vivecraft: ########## GL ERROR ##########");
            VRSettings.LOGGER.error("Vivecraft: @ {}", (Object)errorSection);
            VRSettings.LOGGER.error("Vivecraft: {}: {}", (Object)error, (Object)errorString);
            return errorString;
        }
        return "";
    }
}

