/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.common.utils.MathUtils;

public class CameraTracker
implements Tracker {
    public static final class_2960 CAMERA_MODEL = class_2960.method_60655((String)"vivecraft", (String)"camera");
    public static final class_2960 CAMERA_DISPLAY_MODEL = class_2960.method_60655((String)"vivecraft", (String)"camera_display");
    private boolean visible = false;
    private class_243 position = class_243.field_1353;
    private Quaternionf rotation = new Quaternionf();
    private int startController;
    private VRData.VRDevicePose startControllerPose;
    private class_243 startPosition;
    private Quaternionf startRotation;
    private boolean quickMode;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public CameraTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        return this.isVisible();
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.visible = false;
        this.quickMode = false;
        this.stopMoving();
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_FRAME;
    }

    @Override
    public void activeProcess(class_746 player) {
        if (this.startControllerPose != null) {
            VRData.VRDevicePose controllerPose = this.dh.vrPlayer.vrdata_world_render.getController(this.startController);
            class_243 startPos = this.startControllerPose.getPosition();
            Vector3f deltaPos = MathUtils.subtractToVector3f(controllerPose.getPosition(), startPos);
            Matrix4f deltaMatrix = controllerPose.getMatrix().mul((Matrix4fc)this.startControllerPose.getMatrix().invert());
            Vector3f offset = MathUtils.subtractToVector3f(this.startPosition, startPos);
            Vector3f offsetRotated = deltaMatrix.transformPosition((Vector3fc)offset, new Vector3f());
            this.position = new class_243(this.startPosition.field_1352 + (double)deltaPos.x + (double)offsetRotated.x() - (double)offset.x(), this.startPosition.field_1351 + (double)deltaPos.y + (double)offsetRotated.y() - (double)offset.y(), this.startPosition.field_1350 + (double)deltaPos.z + (double)offsetRotated.z() - (double)offset.z());
            Quaternionf tempQuat = deltaMatrix.getNormalizedRotation(new Quaternionf());
            this.rotation = tempQuat.mul((Quaternionfc)this.startRotation, tempQuat);
        }
        if (this.quickMode && !this.isMoving() && !this.dh.grabScreenShot) {
            this.visible = false;
        }
        if (this.dh.vrPlayer.vrdata_world_render.hmd.getPosition().method_1022(this.position) > (double)(this.mc.field_1690.method_38521() * 12)) {
            this.visible = false;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void toggleVisibility() {
        this.visible = !this.visible;
    }

    public class_243 getPosition() {
        return this.position;
    }

    public Vector3f getRoomPosition(class_243 roomOrigin) {
        if (roomOrigin == class_243.field_1353 && this.dh.vrPlayer != null) {
            return MathUtils.subtractToVector3f(this.position, this.dh.vrPlayer.roomOrigin);
        }
        return MathUtils.subtractToVector3f(this.position, roomOrigin);
    }

    public void setPosition(class_243 position) {
        this.position = position;
    }

    public Quaternionf getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void setRotation(Matrix4fc rotationMat) {
        rotationMat.getNormalizedRotation(this.rotation);
    }

    public boolean isMoving() {
        return this.startControllerPose != null;
    }

    public int getMovingController() {
        return this.startController;
    }

    public boolean isQuickMode() {
        return this.quickMode;
    }

    public void startMoving(int controller, boolean quickMode) {
        this.startController = controller;
        this.startControllerPose = this.dh.vrPlayer.vrdata_world_pre.getController(controller);
        this.startPosition = this.position;
        this.startRotation = new Quaternionf((Quaternionfc)this.rotation);
        this.quickMode = quickMode;
    }

    public void startMoving(int controller) {
        this.startMoving(controller, false);
    }

    public void stopMoving() {
        this.startControllerPose = null;
    }
}

