/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5944;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.MirrorNotification;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;

public class ShaderHelper {
    private static final class_310 MC = class_310.method_1551();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static float FOV_REDUCTION = 1.0f;
    private static float WATER_EFFECT;
    private static boolean WAS_IN_WATER;
    private static float PUMPKIN_EFFECT;
    private static float PORTAL_EFFECT;
    private static float RED;
    private static float BLACK;
    private static float BLUE;
    private static float TIME;

    public static void renderFullscreenQuad(@NotNull class_5944 instance, @NotNull class_276 source) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        instance.method_34583("Sampler0", (Object)source.method_30277());
        instance.method_34586();
        ShaderHelper.drawFullscreenQuad(instance.method_35786());
        instance.method_34585();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private static void drawFullscreenQuad(class_293 format) {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, format);
        if (format == class_290.field_1585) {
            builder.method_22912(-1.0, -1.0, 0.0).method_22913(0.0f, 0.0f).method_1344();
            builder.method_22912(1.0, -1.0, 0.0).method_22913(1.0f, 0.0f).method_1344();
            builder.method_22912(1.0, 1.0, 0.0).method_22913(1.0f, 1.0f).method_1344();
            builder.method_22912(-1.0, 1.0, 0.0).method_22913(0.0f, 1.0f).method_1344();
        } else if (format == class_290.field_1575) {
            builder.method_22912(-1.0, -1.0, 0.0).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            builder.method_22912(1.0, -1.0, 0.0).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            builder.method_22912(1.0, 1.0, 0.0).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
            builder.method_22912(-1.0, 1.0, 0.0).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
        } else {
            throw new IllegalStateException("Unexpected vertex format " + format);
        }
        builder.method_1326();
        class_286.method_34424((class_287)builder);
    }

    public static void doVrPostProcess(RenderPass eye, class_276 source, float partialTick) {
        if (eye == RenderPass.LEFT) {
            RED = 0.0f;
            BLACK = 0.0f;
            BLUE = 0.0f;
            TIME = (float)class_156.method_658() / 1000.0f;
            PUMPKIN_EFFECT = 0.0f;
            PORTAL_EFFECT = 0.0f;
            if (ShaderHelper.MC.field_1724 != null && ShaderHelper.MC.field_1687 != null) {
                boolean isInWater = ((GameRendererExtension)ShaderHelper.MC.field_1773).vivecraft$isInWater();
                if (ShaderHelper.DATA_HOLDER.vrSettings.waterEffect && WAS_IN_WATER != isInWater) {
                    WATER_EFFECT = 2.3f;
                } else {
                    WATER_EFFECT = isInWater ? (WATER_EFFECT -= 0.008333334f) : (WATER_EFFECT -= 0.016666668f);
                    if (WATER_EFFECT < 0.0f) {
                        WATER_EFFECT = 0.0f;
                    }
                }
                WAS_IN_WATER = isInWater;
                if (IrisHelper.isLoaded() && !IrisHelper.hasWaterEffect()) {
                    WATER_EFFECT = 0.0f;
                }
                float portalTime = class_3532.method_16439((float)partialTick, (float)ShaderHelper.MC.field_1724.field_3911, (float)ShaderHelper.MC.field_1724.field_3929);
                PORTAL_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.portalEffect && portalTime > 0.0f && !ShaderHelper.MC.field_1724.method_6059(class_1294.field_5916) ? portalTime : 0.0f;
                class_1799 itemstack = ShaderHelper.MC.field_1724.method_6118(class_1304.field_6169);
                PUMPKIN_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.pumpkinEffect && itemstack.method_7909() == class_2246.field_10147.method_8389() && (!itemstack.method_7985() || itemstack.method_7969().method_10550("CustomModelData") == 0) ? 1.0f : 0.0f;
                float hurtTimer = (float)ShaderHelper.MC.field_1724.field_6235 - partialTick;
                float healthPercent = 1.0f - ShaderHelper.MC.field_1724.method_6032() / ShaderHelper.MC.field_1724.method_6063();
                healthPercent = (healthPercent - 0.5f) * 0.75f;
                if (ShaderHelper.DATA_HOLDER.vrSettings.hitIndicator && hurtTimer > 0.0f) {
                    hurtTimer /= (float)ShaderHelper.MC.field_1724.field_6254;
                    RED = hurtTimer = healthPercent + class_3532.method_15374((float)(hurtTimer * hurtTimer * hurtTimer * hurtTimer * (float)Math.PI)) * 0.5f;
                } else if (ShaderHelper.DATA_HOLDER.vrSettings.lowHealthIndicator) {
                    RED = healthPercent * class_3532.method_15379((float)class_3532.method_15374((float)(2.5f * TIME / (1.0f - healthPercent + 0.1f))));
                    if (ShaderHelper.MC.field_1724.method_7337()) {
                        RED = 0.0f;
                    }
                }
                float freeze = ShaderHelper.MC.field_1724.method_32313();
                if (ShaderHelper.DATA_HOLDER.vrSettings.freezeEffect && freeze > 0.0f) {
                    BLUE = RED;
                    BLUE = Math.max(freeze / 2.0f, BLUE);
                    RED = 0.0f;
                }
                if (ShaderHelper.MC.field_1724.method_6113()) {
                    BLACK = 0.5f + 0.3f * (float)ShaderHelper.MC.field_1724.method_7297() * 0.01f;
                }
                if (ShaderHelper.DATA_HOLDER.vr.isWalkingAbout && BLACK < 0.8f) {
                    BLACK = 0.5f;
                }
                if (ShaderHelper.DATA_HOLDER.vrSettings.useFOVReduction && ShaderHelper.DATA_HOLDER.vrPlayer.getFreeMove()) {
                    FOV_REDUCTION = Math.abs(ShaderHelper.MC.field_1724.field_6250) > 0.0f || Math.abs(ShaderHelper.MC.field_1724.field_6212) > 0.0f ? (FOV_REDUCTION -= 0.05f) : (FOV_REDUCTION += 0.01f);
                    FOV_REDUCTION = class_3532.method_15363((float)FOV_REDUCTION, (float)ShaderHelper.DATA_HOLDER.vrSettings.fovReductionMin, (float)0.8f);
                } else {
                    FOV_REDUCTION = 1.0f;
                }
            } else {
                WATER_EFFECT = 0.0f;
                FOV_REDUCTION = 1.0f;
            }
            if (PUMPKIN_EFFECT > 0.0f) {
                VRShaders.POST_PROCESSING_FOV_REDUCTION_RADIUS_UNIFORM.method_1251(0.3f);
                VRShaders.POST_PROCESSING_FOV_REDUCTION_BORDER_UNIFORM.method_1251(0.0f);
            } else {
                VRShaders.POST_PROCESSING_FOV_REDUCTION_RADIUS_UNIFORM.method_1251(FOV_REDUCTION);
                VRShaders.POST_PROCESSING_FOV_REDUCTION_BORDER_UNIFORM.method_1251(0.06f);
            }
            VRShaders.POST_PROCESSING_FOV_REDUCTION_OFFSET_UNIFORM.method_1251(ShaderHelper.DATA_HOLDER.vrSettings.fovRedutioncOffset);
            VRShaders.POST_PROCESSING_OVERLAY_HEALTH_ALPHA_UNiFORM.method_1251(RED);
            VRShaders.POST_PROCESSING_OVERLAY_FREEZE_ALPHA_UNiFORM.method_1251(BLUE);
            VRShaders.POST_PROCESSING_OVERLAY_BLACK_ALPHA_UNIFORM.method_1251(BLACK);
            VRShaders.POST_PROCESSING_OVERLAY_TIME_UNIFORM.method_1251(TIME);
            VRShaders.POST_PROCESSING_OVERLAY_WATER_AMPLITUDE_UNIFORM.method_1251(WATER_EFFECT);
            VRShaders.POST_PROCESSING_OVERLAY_PORTAL_AMPLITUDE_UNIFORM.method_1251(PORTAL_EFFECT);
            VRShaders.POST_PROCESSING_OVERLAY_PUMPKIN_AMPLITUDE_UNIFORM.method_1251(PUMPKIN_EFFECT);
        }
        VRShaders.POST_PROCESSING_OVERLAY_EYE_UNIFORM.method_35649(eye == RenderPass.LEFT ? 1 : -1);
        ShaderHelper.renderFullscreenQuad(VRShaders.POST_PROCESSING_SHADER, source);
    }

    public static void drawMirror() {
        if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF && ShaderHelper.DATA_HOLDER.vr.isHMDTracking()) {
            MirrorNotification.notify("Mirror is OFF", true, 1000);
        } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            if (VRShaders.MIXED_REALITY_SHADER != null) {
                ShaderHelper.doMixedRealityMirror();
            } else {
                MirrorNotification.notify("Mixed Reality Shader compile failed, see log for info", true, 10000);
            }
        } else if (!(ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.DUAL || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible())) {
            class_276 leftEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            class_276 rightEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
            int screenWidth = ((WindowExtension)MC.method_22683()).vivecraft$getActualScreenWidth() / 2;
            int screenHeight = ((WindowExtension)MC.method_22683()).vivecraft$getActualScreenHeight();
            if (leftEye != null) {
                ShaderHelper.blitToScreen(leftEye, 0, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
            if (rightEye != null) {
                ShaderHelper.blitToScreen(rightEye, screenWidth, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
        } else {
            float xCrop = 0.0f;
            float yCrop = 0.0f;
            boolean keepAspect = false;
            class_276 source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                keepAspect = true;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.GUI) {
                source = GuiHandler.GUI_FRAMEBUFFER;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.SINGLE || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.CROPPED) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
                xCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                yCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                keepAspect = true;
            }
            if (source != null) {
                ShaderHelper.blitToScreen(source, 0, ((WindowExtension)MC.method_22683()).vivecraft$getActualScreenWidth(), ((WindowExtension)MC.method_22683()).vivecraft$getActualScreenHeight(), 0, xCrop, yCrop, keepAspect);
            }
        }
        MirrorNotification.render();
    }

    public static void doMixedRealityMirror() {
        RenderSystem.viewport((int)0, (int)0, (int)((WindowExtension)MC.method_22683()).vivecraft$getActualScreenWidth(), (int)((WindowExtension)MC.method_22683()).vivecraft$getActualScreenHeight());
        Vector3f camPlayer = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getHeadPivotF().sub((Vector3fc)ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getPositionF());
        Matrix4f viewMatrix = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getMatrix().transpose();
        Vector3f cameraLook = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getDirection();
        cameraLook.set(-cameraLook.x, 0.0f, -cameraLook.z);
        boolean alphaMask = ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike && ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityAlphaMask;
        VRShaders.MIXED_REALITY_PROJECTION_MATRIX_UNIFORM.method_1250(((GameRendererExtension)ShaderHelper.MC.field_1773).vivecraft$getThirdPassProjectionMatrix());
        VRShaders.MIXED_REALITY_VIEW_MATRIX_UNIFORM.method_1250(MathUtils.toMcMat4((Matrix4fc)viewMatrix));
        VRShaders.MIXED_REALITY_HMD_VIEW_POSITION_UNIFORM.method_1249(camPlayer.x, camPlayer.y, camPlayer.z);
        VRShaders.MIXED_REALITY_HMD_PLANE_NORMAL_UNIFORM.method_1249(cameraLook.x, cameraLook.y, cameraLook.z);
        if (!alphaMask) {
            VRShaders.MIXED_REALITY_KEY_COLOR_UNIFORM.method_1249((float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getRed() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getGreen() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getBlue() / 255.0f);
        } else {
            VRShaders.MIXED_REALITY_KEY_COLOR_UNIFORM.method_1249(0.0f, 0.0f, 0.0f);
        }
        VRShaders.MIXED_REALITY_ALPHA_MODE_UNIFORM.method_35649(alphaMask ? 1 : 0);
        VRShaders.MIXED_REALITY_FIRST_PERSON_PASS_UNIFORM.method_35649(ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike ? 1 : 0);
        VRShaders.MIXED_REALITY_SHADER.method_34583("thirdPersonColor", (Object)ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.method_30277());
        VRShaders.MIXED_REALITY_SHADER.method_34583("thirdPersonDepth", (Object)ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.method_30278());
        if (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike) {
            class_276 source = ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible() ? ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer : (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUndistorted ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted : (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0 : ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1));
            VRShaders.MIXED_REALITY_SHADER.method_34583("firstPersonColor", (Object)source.method_30277());
        }
        VRShaders.MIXED_REALITY_SHADER.method_34586();
        ShaderHelper.drawFullscreenQuad(VRShaders.MIXED_REALITY_SHADER.method_35786());
        VRShaders.MIXED_REALITY_SHADER.method_34585();
    }

    public static void doFSAA(class_276 source, class_276 firstPass, class_276 secondPass) {
        if (firstPass == null) {
            ShaderHelper.DATA_HOLDER.vrRenderer.reinitFrameBuffers("FSAA Setting Changed");
        } else {
            RenderSystem.disableBlend();
            RenderSystem.depthFunc((int)519);
            firstPass.method_1235(true);
            VRShaders.LANCZOS_SHADER.method_34583("Sampler0", (Object)source.method_30277());
            VRShaders.LANCZOS_SHADER.method_34583("Sampler1", (Object)source.method_30278());
            VRShaders.LANCZOS_TEXEL_WIDTH_OFFSET_UNIFORM.method_1251(1.0f / (3.0f * (float)firstPass.field_1480));
            VRShaders.LANCZOS_TEXEL_HEIGHT_OFFSET_UNIFORM.method_1251(0.0f);
            VRShaders.LANCZOS_SHADER.method_34586();
            ShaderHelper.drawFullscreenQuad(VRShaders.LANCZOS_SHADER.method_35786());
            secondPass.method_1235(true);
            VRShaders.LANCZOS_SHADER.method_34583("Sampler0", (Object)firstPass.method_30277());
            VRShaders.LANCZOS_SHADER.method_34583("Sampler1", (Object)firstPass.method_30278());
            VRShaders.LANCZOS_TEXEL_WIDTH_OFFSET_UNIFORM.method_1251(0.0f);
            VRShaders.LANCZOS_TEXEL_HEIGHT_OFFSET_UNIFORM.method_1251(1.0f / (3.0f * (float)secondPass.field_1477));
            VRShaders.LANCZOS_SHADER.method_34586();
            ShaderHelper.drawFullscreenQuad(VRShaders.LANCZOS_SHADER.method_35786());
            VRShaders.LANCZOS_SHADER.method_34585();
            secondPass.method_1240();
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableBlend();
        }
    }

    public static void blitToScreen(class_276 source, int left, int width, int height, int top, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        float drawAspect = (float)width / (float)height;
        float bufferAspect = (float)source.field_1480 / (float)source.field_1477;
        float xMin = xCropFactor;
        float yMin = yCropFactor;
        float xMax = 1.0f - xCropFactor;
        float yMax = 1.0f - yCropFactor;
        if (keepAspect) {
            if (drawAspect > bufferAspect) {
                float heightAspect = bufferAspect / drawAspect * (0.5f - yCropFactor);
                yMin = 0.5f - heightAspect;
                yMax = 0.5f + heightAspect;
            } else {
                float widthAspect = drawAspect / bufferAspect * (0.5f - xCropFactor);
                xMin = 0.5f - widthAspect;
                xMax = 0.5f + widthAspect;
            }
        }
        VRShaders.BLIT_VR_SHADER.method_34583("DiffuseSampler", (Object)source.method_30277());
        VRShaders.BLIT_VR_SHADER.method_34586();
        class_287 bufferBuilder = RenderSystem.renderThreadTesselator().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, VRShaders.BLIT_VR_SHADER.method_35786());
        float xMinPos = (float)left / (float)ShaderHelper.MC.method_1522().field_1480 * 2.0f - 1.0f;
        float yMinPos = (float)top / (float)ShaderHelper.MC.method_1522().field_1477 * 2.0f - 1.0f;
        float xMaxPos = xMinPos + (float)width / (float)ShaderHelper.MC.method_1522().field_1480 * 2.0f;
        float yMaxPos = yMinPos + (float)height / (float)ShaderHelper.MC.method_1522().field_1477 * 2.0f;
        bufferBuilder.method_22912((double)xMinPos, (double)yMinPos, 0.0).method_22913(xMin, yMin).method_1344();
        bufferBuilder.method_22912((double)xMaxPos, (double)yMinPos, 0.0).method_22913(xMax, yMin).method_1344();
        bufferBuilder.method_22912((double)xMaxPos, (double)yMaxPos, 0.0).method_22913(xMax, yMax).method_1344();
        bufferBuilder.method_22912((double)xMinPos, (double)yMaxPos, 0.0).method_22913(xMin, yMax).method_1344();
        bufferBuilder.method_1326();
        class_286.method_34424((class_287)bufferBuilder);
        VRShaders.BLIT_VR_SHADER.method_34585();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

