/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.api_impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.vivecraft.api.VRAPI;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.api.data.VRPoseHistory;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.api_impl.VRClientAPIImpl;
import org.vivecraft.common.api_impl.data.VRPoseHistoryImpl;
import org.vivecraft.server.ServerVRPlayers;

public final class VRAPIImpl
implements VRAPI {
    public static final VRAPIImpl INSTANCE = new VRAPIImpl();
    public static final int MAX_HISTORY_TICKS = 200;
    private final Map<UUID, VRPoseHistoryImpl> clientPoseHistories = new HashMap<UUID, VRPoseHistoryImpl>();
    private final Map<UUID, VRPoseHistoryImpl> serverPoseHistories = new HashMap<UUID, VRPoseHistoryImpl>();

    private VRAPIImpl() {
    }

    public void clearPoseHistory(UUID player, boolean isClientSide) {
        this.getMap(isClientSide).remove(player);
    }

    public void addPoseToHistory(UUID player, VRPose pose, boolean isClientSide) {
        Map<UUID, VRPoseHistoryImpl> poseHistories = this.getMap(isClientSide);
        VRPoseHistoryImpl poseHistory = poseHistories.get(player);
        if (poseHistory == null) {
            poseHistory = new VRPoseHistoryImpl();
            poseHistories.put(player, poseHistory);
        }
        poseHistory.addPose(pose);
    }

    public void clearAllPoseHistories() {
        this.clientPoseHistories.clear();
        this.serverPoseHistories.clear();
        VRClientAPIImpl.INSTANCE.clearPoseHistory();
    }

    @Override
    public boolean isVRPlayer(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return ServerVRPlayers.isVRPlayer(serverPlayer);
        }
        return ClientVRPlayers.getInstance().isVRPlayer((class_1297)player);
    }

    @Override
    @Nullable
    public VRPose getVRPose(class_1657 player) {
        if (!this.isVRPlayer(player)) {
            return null;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            return ServerVRPlayers.getVivePlayer(serverPlayer).asVRPose();
        }
        return ClientVRPlayers.getInstance().getRotationsForPlayer(player.method_5667()).asVRPose(player.method_19538());
    }

    @Override
    @Nullable
    public VRPoseHistory getHistoricalVRPoses(class_1657 player) {
        if (player.method_7340()) {
            return VRClientAPIImpl.INSTANCE.getHistoricalVRPoses();
        }
        if (this.isVRPlayer(player)) {
            return this.getMap(player.field_6002.field_9236).get(player.method_5667());
        }
        return null;
    }

    private Map<UUID, VRPoseHistoryImpl> getMap(boolean isClientSide) {
        return isClientSide ? this.clientPoseHistories : this.serverPoseHistories;
    }
}

