/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.vivecraft.client.gui.framework.screens.GuiListScreen;
import org.vivecraft.client.gui.framework.widgets.SettingsList;

public class GuiStringListEditorScreen
extends GuiListScreen {
    private final Supplier<List<String>> valuesSupplier;
    private final Runnable loadDefaults;
    private final Consumer<List<String>> save;
    private final boolean fixedEntryCount;
    private List<String> elements;

    public GuiStringListEditorScreen(class_2561 title, class_437 lastScreen, boolean fixedEntryCount, Supplier<List<String>> valuesSupplier, Runnable loadDefaults, Consumer<List<String>> save) {
        super(title, lastScreen);
        this.fixedEntryCount = fixedEntryCount;
        this.valuesSupplier = valuesSupplier;
        this.loadDefaults = loadDefaults;
        this.save = save;
        this.searchable = false;
    }

    @Override
    protected void addLowerButtons(int top) {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"vivecraft.gui.loaddefaults"), button -> {
            this.loadDefaults.run();
            this.elements = null;
            this.reinit = true;
        }).method_46434(this.field_22789 / 2 - 155, top, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.back"), button -> this.method_25419()).method_46434(this.field_22789 / 2 + 5, top, 150, 20).method_46431());
    }

    @Override
    public void method_25419() {
        this.save.accept(this.elements);
        super.method_25419();
    }

    private List<String> getCurrentValues() {
        return this.list.method_25396().stream().map(entry -> {
            if (entry instanceof StringValueEntry) {
                StringValueEntry listValueEntry = (StringValueEntry)((Object)entry);
                return listValueEntry.getString();
            }
            return "";
        }).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    @Override
    protected List<SettingsList.BaseEntry> getEntries() {
        LinkedList<SettingsList.BaseEntry> entries = new LinkedList<SettingsList.BaseEntry>();
        if (this.elements == null) {
            this.elements = new ArrayList<String>((Collection)this.valuesSupplier.get());
        }
        int i = 0;
        for (String item : this.elements) {
            class_342 box = new class_342(this.field_22787.field_1772, 0, 0, 350, 20, (class_2561)class_2561.method_43470((String)item));
            box.method_1880(1000);
            box.method_1852(item);
            int index = i++;
            box.method_1863(s -> this.elements.set(index, (String)s));
            entries.add(new StringValueEntry((class_2561)class_2561.method_43473(), box, button -> {
                this.elements.remove(index);
                this.reinit = true;
            }, !this.fixedEntryCount));
        }
        if (!this.fixedEntryCount) {
            entries.add(new SettingsList.WidgetEntry((class_2561)class_2561.method_43470((String)""), (class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"vivecraft.options.addnew"), button -> {
                this.elements = this.getCurrentValues();
                this.elements.add("");
                this.reinit = true;
            }).method_46437(145, 20).method_46431()));
        }
        return entries;
    }

    private static class StringValueEntry
    extends SettingsList.BaseEntry {
        private final class_342 editBox;
        private final class_4185 deleteButton;

        public StringValueEntry(class_2561 name, class_342 editBox, class_4185.class_4241 deleteAction, boolean deletable) {
            super(name, null);
            this.editBox = editBox;
            this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(deletable ? "-" : "X")), (class_4185.class_4241)(deletable ? deleteAction : b -> this.editBox.method_1852(""))).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"selectWorld.delete"))).method_46434(0, 0, 20, 20).method_46431();
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editBox.method_46421(this.method_73380());
            this.editBox.method_46419(this.method_46427());
            this.editBox.method_25358(this.method_73387() - 20);
            this.editBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.method_46421(this.method_73389() - 20);
            this.deleteButton.method_46419(this.method_46427());
            this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean method_25404(class_11908 keyEvent) {
            if (this.method_25399() == this.editBox && keyEvent.comp_4795() == 262 && this.editBox.method_1882().length() == this.editBox.method_1881()) {
                return false;
            }
            return super.method_25404(keyEvent);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.editBox.field_22763 = active;
            this.deleteButton.field_22763 = active;
        }

        public String getString() {
            return this.editBox.method_1882();
        }
    }
}

