/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.renderer.entity;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11890;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_5599;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_746;
import net.minecraft.class_7920;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderDispatcherExtension;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.extensions.RenderLayerExtension;
import org.vivecraft.client.render.VRPlayerRenderData;
import org.vivecraft.client.render.VRPlayerRenderer;
import org.vivecraft.client.utils.RenderLayerType;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client.renderer.entity.LivingEntityRendererMixin;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

@Mixin(value={class_1007.class})
public abstract class AvatarRendererMixin
extends LivingEntityRendererMixin<class_742, class_10055, class_591> {
    protected AvatarRendererMixin(class_5617.class_5618 context) {
        super(context);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="HEAD")})
    private void vivecraft$addRotInfo(class_11890 entity, class_10055 reusedState, float partialTick, CallbackInfo ci) {
        if (entity.getClass() == class_746.class || entity.getClass() == class_745.class) {
            ((EntityRenderStateExtension)reusedState).vivecraft$setRotInfo(ClientVRPlayers.getInstance().getRotationsForPlayer(entity.method_5667()));
        } else {
            ((EntityRenderStateExtension)reusedState).vivecraft$setRotInfo(null);
        }
        ((EntityRenderStateExtension)reusedState).vivecraft$setFirstPersonPlayer(VREffectsHelper.isFirstPersonPlayer((class_1297)entity));
        ((EntityRenderStateExtension)reusedState).vivecraft$setTotalScale(ScaleHelper.getEntityEyeHeightScale((class_1309)entity, partialTick));
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="TAIL")})
    private void vivecraft$vrPlayerState(class_11890 entity, class_10055 reusedState, float partialTick, CallbackInfo ci) {
        ClientVRPlayers.RotInfo rotInfo = ((EntityRenderStateExtension)reusedState).vivecraft$getRotInfo();
        if (rotInfo != null) {
            ((EntityRenderStateExtension)reusedState).vivecraft$setVRRenderData(this.vivecraft$extractVRModelData(VREffectsHelper.isFirstPersonPlayer((class_1297)entity), rotInfo, reusedState));
        } else {
            ((EntityRenderStateExtension)reusedState).vivecraft$setVRRenderData(null);
        }
    }

    @Unique
    private VRPlayerRenderData vivecraft$extractVRModelData(boolean isMainPlayer, ClientVRPlayers.RotInfo rotInfo, class_10055 renderState) {
        boolean laying = renderState.field_53403 > 0.0f || renderState.field_53411;
        float layAmount = renderState.field_53411 ? 1.0f : renderState.field_53403;
        boolean swimming = laying && renderState.field_53458 || renderState.field_53411;
        boolean noLowerBodyAnimation = swimming || rotInfo.fbtMode == FBTMode.ARMS_ONLY;
        float bodyYaw = isMainPlayer ? ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYawRad() : rotInfo.getBodyYawRad();
        float xRot = swimming ? layAmount * (-1.5707964f - (float)Math.PI / 180 * renderState.field_53448) : layAmount * -1.5707964f;
        float bodyScale = 1.0f;
        float armScale = 1.0f;
        float legScale = 1.0f;
        if (isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && (!ImmersivePortalsHelper.isLoaded() || !ImmersivePortalsHelper.isRenderingPortal()) && !ShadersHelper.isRenderingShadows() && RenderPass.isFirstPerson(ClientDataHolderVR.getInstance().currentPass) || ShadersHelper.isRenderingShadows() && ClientDataHolderVR.getInstance().vrSettings.shaderFullSizeShadowLimbs) {
            bodyScale = ClientDataHolderVR.getInstance().vrSettings.playerModelBodyScale;
            armScale = ClientDataHolderVR.getInstance().vrSettings.playerModelArmsScale;
            legScale = ClientDataHolderVR.getInstance().vrSettings.playerModelLegScale;
        }
        class_1306 attackArm = null;
        if (renderState.field_53404 > 0.0f) {
            attackArm = renderState.field_53408;
            if (rotInfo.leftHanded) {
                attackArm = attackArm.method_5928();
            }
        }
        return new VRPlayerRenderData(isMainPlayer, bodyYaw, xRot, laying, layAmount, swimming, noLowerBodyAnimation, attackArm, rotInfo.leftHanded ? class_1306.field_6182 : class_1306.field_6183, bodyScale, armScale, legScale);
    }

    @Override
    protected void vivecraft$onAddLayer(class_3887<class_10055, class_591> renderLayer, CallbackInfoReturnable<Boolean> cir) {
        EntityRenderDispatcherExtension renderExtension = (EntityRenderDispatcherExtension)this.field_4676;
        if (((Object)((Object)this)).getClass() == class_1007.class && !renderExtension.vivecraft$getSkinMapVRVanilla().isEmpty()) {
            class_7920 modelType;
            Constructor<class_3887<class_10055, class_591>> constructor = null;
            RenderLayerType type = RenderLayerType.OTHER;
            for (Constructor<class_3887<class_10055, class_591>> constructor2 : renderLayer.getClass().getConstructors()) {
                if (constructor2.getParameterCount() == 1 && class_3883.class.isAssignableFrom(constructor2.getParameterTypes()[0])) {
                    constructor = constructor2;
                    type = RenderLayerType.PARENT_ONLY;
                    break;
                }
                if (constructor2.getParameterCount() != 2 || !class_3883.class.isAssignableFrom(constructor2.getParameterTypes()[0]) || !class_5599.class.isAssignableFrom(constructor2.getParameterTypes()[1])) continue;
                constructor = constructor2;
                type = RenderLayerType.PARENT_MODELSET;
            }
            class_7920 class_79202 = modelType = ((class_591)this.field_4737).field_3480 ? class_7920.field_41122 : class_7920.field_41123;
            if (constructor == null) {
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRVanilla().get(modelType));
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRArms().get(modelType));
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRLegs().get(modelType));
            } else {
                if (!constructor.canAccess(null)) {
                    VRSettings.LOGGER.warn("Vivecraft: layer constructor of '{}' was private, making it accessible", renderLayer.getClass());
                    constructor.setAccessible(true);
                }
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRVanilla().get(modelType));
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRArms().get(modelType));
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRLegs().get(modelType));
            }
        }
    }

    @Unique
    private void vivecraft$addLayerClone(class_3887<class_10055, class_591> renderLayer, VRPlayerRenderer target) {
        if (target.hasLayerType(renderLayer)) {
            return;
        }
        try {
            VRSettings.LOGGER.warn("Vivecraft: Copying layer: {} with Object.copy, this could cause issues", renderLayer.getClass());
            class_3887 newLayer = (class_3887)((RenderLayerExtension)renderLayer).clone();
            newLayer.field_17155 = target;
            target.method_4046(newLayer);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private void vivecraft$addLayerConstructor(class_3887<class_10055, class_591> renderLayer, Constructor<class_3887<class_10055, class_591>> constructor, RenderLayerType type, VRPlayerRenderer target) {
        if (target.hasLayerType(renderLayer)) {
            return;
        }
        class_5599 modelSet = class_310.method_1551().method_31974();
        try {
            switch (type) {
                case PARENT_ONLY: {
                    target.method_4046(constructor.newInstance(new Object[]{target}));
                    break;
                }
                case PARENT_MODELSET: {
                    target.method_4046(constructor.newInstance(new Object[]{target, modelSet}));
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

