/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.common.api_impl.VRAPIImpl;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.utils.MathUtils;

public class ServerVivePlayer {
    @Nullable
    private VrPlayerState vrPlayerState;
    private VRPose vrPlayerStateAsPose;
    public float draw;
    public float worldScale = 1.0f;
    public float heightScale = 1.0f;
    public VRBodyPart activeBodyPart = VRBodyPart.MAIN_HAND;
    public class_1799 activeItemOverride = class_1799.field_8037;
    public VRBodyPart delayedDestroyBodyPart = null;
    public boolean useBodyPartForAim = false;
    public boolean crawling;
    private boolean isVR = false;
    public class_243 offset = class_243.field_1353;
    public class_3222 player;
    public NetworkVersion networkVersion = NetworkVersion.fromProtocolVersion(CommonNetworkHelper.MAX_SUPPORTED_NETWORK_PROTOCOL);
    public boolean wantsDamageDirection = false;

    public ServerVivePlayer(class_3222 player) {
        this.player = player;
    }

    public class_243 getBodyPartVectorCustom(VRBodyPart bodyPart, Vector3fc direction) {
        if (this.vrPlayerState != null) {
            if (this.isSeated() || !bodyPart.availableInMode(this.vrPlayerState.fbtMode())) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            return new class_243(this.vrPlayerState.getBodyPartPose(bodyPart).orientation().transform(direction, new Vector3f()));
        }
        return this.player.method_5720();
    }

    public class_243 getBodyPartDir(VRBodyPart bodyPart) {
        return this.getBodyPartVectorCustom(bodyPart, MathUtils.BACK);
    }

    public class_243 getAimDir(boolean ignoreUseForAim) {
        if (!this.isSeated() && this.draw > 0.0f) {
            return this.getBodyPartPos(this.activeBodyPart.opposite()).method_1020(this.getBodyPartPos(this.activeBodyPart)).method_1029();
        }
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartDir(this.activeBodyPart);
        }
        return this.getBodyPartDir(VRBodyPart.MAIN_HAND);
    }

    public class_243 getAimPos(boolean ignoreUseForAim) {
        if (ignoreUseForAim || this.useBodyPartForAim) {
            return this.getBodyPartPos(this.activeBodyPart);
        }
        return this.getBodyPartPos(VRBodyPart.MAIN_HAND);
    }

    public class_243 getHMDDir() {
        if (this.vrPlayerState != null) {
            return new class_243(this.vrPlayerState.hmd().orientation().transform(MathUtils.BACK, new Vector3f()));
        }
        return this.player.method_5720();
    }

    public class_243 getHMDPos() {
        if (this.vrPlayerState != null) {
            Vector3fc hmdPos = this.vrPlayerState.hmd().position();
            return this.player.method_73189().method_1031(this.offset.field_1352 + (double)hmdPos.x(), this.offset.field_1351 + (double)hmdPos.y(), this.offset.field_1350 + (double)hmdPos.z());
        }
        return this.player.method_73189().method_1031(0.0, 1.62, 0.0);
    }

    public class_243 getBodyPartPos(VRBodyPart bodyPart, boolean realPosition) {
        if (this.vrPlayerState != null) {
            if (!bodyPart.availableInMode(this.vrPlayerState.fbtMode())) {
                bodyPart = VRBodyPart.MAIN_HAND;
            }
            if (this.isSeated() && bodyPart.isHand() && !realPosition) {
                class_243 dir = this.getHMDDir();
                dir = dir.method_1024((float)Math.PI / 180 * (bodyPart == VRBodyPart.MAIN_HAND ? -35.0f : 35.0f));
                dir = new class_243(dir.field_1352, 0.0, dir.field_1350);
                dir = dir.method_1029();
                return this.getHMDPos().method_1031(dir.field_1352 * (double)0.3f * (double)this.worldScale, (double)(-0.4f * this.worldScale), dir.field_1350 * (double)0.3f * (double)this.worldScale);
            }
            Vector3fc conPos = this.vrPlayerState.getBodyPartPose(bodyPart).position();
            return this.player.method_73189().method_1031(this.offset.field_1352 + (double)conPos.x(), this.offset.field_1351 + (double)conPos.y(), this.offset.field_1350 + (double)conPos.z());
        }
        return this.player.method_73189().method_1031(0.0, 1.62, 0.0);
    }

    public class_243 getBodyPartPos(VRBodyPart bodyPart) {
        return this.getBodyPartPos(bodyPart, false);
    }

    public boolean isVR() {
        return this.isVR;
    }

    public void setVR(boolean vr) {
        this.isVR = vr;
    }

    public boolean isSeated() {
        return this.vrPlayerState != null && this.vrPlayerState.seated();
    }

    public boolean isLeftHanded() {
        return this.vrPlayerState != null && this.vrPlayerState.leftHanded();
    }

    @Nullable
    public VrPlayerState vrPlayerState() {
        return this.vrPlayerState;
    }

    public void setVrPlayerState(VrPlayerState vrPlayerState) {
        this.vrPlayerState = vrPlayerState;
        this.vrPlayerStateAsPose = null;
        VRAPIImpl.INSTANCE.addPoseToHistory(this.player.method_5667(), vrPlayerState.asVRPose(this.player.method_73189()), this.player.method_73189(), false);
    }

    public VRPose asVRPose() {
        if (this.vrPlayerState == null) {
            return null;
        }
        if (this.vrPlayerStateAsPose == null) {
            this.vrPlayerStateAsPose = this.vrPlayerState.asVRPose(this.player.method_73189());
        }
        return this.vrPlayerStateAsPose;
    }
}

