/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_241;
import net.minecraft.class_437;
import org.vivecraft.client.gui.framework.widgets.GuiVROption;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;

public class VROptionLayout {
    public static final boolean ENABLED = true;
    public static final boolean DISABLED = false;
    private VRSettings.VrOptions _option;
    Position _pos;
    float _row;
    public boolean _enabled;
    String _title = "";
    int _ordinal;
    boolean _defaultb;
    float _defaultf;
    float _maxf;
    float _minf;
    float _incrementf;
    int _defaulti;
    int _maxi;
    int _mini;
    int _incrementi;
    Class<? extends class_437> screen;
    BiFunction<GuiVROption, class_241, Boolean> customHandler;

    public VROptionLayout(VRSettings.VrOptions option, BiFunction<GuiVROption, class_241, Boolean> handler, Position pos, float row, boolean enabled, @Nullable String title) {
        this(option, pos, row, enabled, title);
        this.customHandler = handler;
    }

    public VROptionLayout(VRSettings.VrOptions option, Position pos, float row, boolean enabled, @Nullable String title) {
        this(pos, row, enabled, title);
        this._option = option;
    }

    public VROptionLayout(Class<? extends class_437> screen, BiFunction<GuiVROption, class_241, Boolean> handler, Position pos, float row, boolean enabled, @Nullable String title) {
        this(screen, pos, row, enabled, title);
        this.customHandler = handler;
    }

    public VROptionLayout(Class<? extends class_437> screen, Position pos, float row, boolean enabled, @Nullable String title) {
        this(pos, row, enabled, title);
        this.screen = screen;
    }

    public VROptionLayout(BiFunction<GuiVROption, class_241, Boolean> handler, Position pos, float row, boolean enabled, @Nullable String title) {
        this(pos, row, enabled, title);
        this.customHandler = handler;
    }

    public VROptionLayout(int ordinal, Position pos, float row, boolean enabled, @Nullable String title) {
        this(pos, row, enabled, title);
        this._ordinal = ordinal;
    }

    public VROptionLayout(Position pos, float row, boolean enabled, @Nullable String title) {
        this._pos = pos;
        this._row = row;
        this._enabled = enabled;
        if (title != null) {
            this._title = title;
        }
    }

    public int getX(int screenWidth) {
        return switch (this._pos) {
            default -> throw new IncompatibleClassChangeError();
            case Position.POS_LEFT -> screenWidth / 2 - 155;
            case Position.POS_RIGHT -> screenWidth / 2 - 155 + 160;
            case Position.POS_CENTER -> screenWidth / 2 - 155 + 80;
        };
    }

    public int getY(int screenHeight) {
        return (int)Math.ceil((float)(screenHeight / 6) + 21.0f * this._row - 10.0f);
    }

    public String getButtonText() {
        return this._title.isEmpty() && this._option != null ? ClientDataHolderVR.getInstance().vrSettings.getButtonDisplayString(this._option) : this._title;
    }

    public VRSettings.VrOptions getOption() {
        return this._option;
    }

    public Class<? extends class_437> getScreen() {
        return this.screen;
    }

    public BiFunction<GuiVROption, class_241, Boolean> getCustomHandler() {
        return this.customHandler;
    }

    public int getOrdinal() {
        return this._option == null ? this._ordinal : this._option.returnEnumOrdinal();
    }

    public static enum Position {
        POS_LEFT,
        POS_CENTER,
        POS_RIGHT;

    }
}

