/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;

public class JumpTracker
implements Tracker {
    public Vector3f[] latchStart = new Vector3f[]{new Vector3f(), new Vector3f()};
    public class_243[] latchStartOrigin = new class_243[]{class_243.field_1353, class_243.field_1353};
    public class_243[] latchStartPlayer = new class_243[]{class_243.field_1353, class_243.field_1353};
    private boolean c0Latched = false;
    private boolean c1Latched = false;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public JumpTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    public boolean isClimbeyJump(class_746 player) {
        return this.isActive(player) && JumpTracker.hasClimbeyJumpEquipped((class_1657)player);
    }

    public static boolean hasClimbeyJumpEquipped(class_1657 player) {
        return ClientNetworking.SERVER_ALLOWS_CLIMBEY && JumpTracker.isBoots(player.method_6118(class_1304.field_6166));
    }

    public static boolean isBoots(class_1799 itemStack) {
        class_2588 translatableContent;
        class_7417 class_74172;
        if (itemStack.method_7960()) {
            return false;
        }
        if (!itemStack.method_57826(class_9334.field_49631)) {
            return false;
        }
        if (itemStack.method_7909() != class_1802.field_8370) {
            return false;
        }
        if (!itemStack.method_57826(class_9334.field_49630)) {
            return false;
        }
        return itemStack.method_7964().getString().equals("Jump Boots") || (class_74172 = itemStack.method_7964().method_10851()) instanceof class_2588 && (translatableContent = (class_2588)class_74172).method_11022().equals("vivecraft.item.jumpboots");
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrPlayer.getFreeMove() && !this.dh.vrSettings.simulateFalling) {
            return false;
        }
        if (this.dh.vrSettings.realisticJumpEnabled == VRSettings.RealisticJump.OFF) {
            return false;
        }
        if (player == null || !player.method_5805()) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (player.method_5799() || player.method_5771() || !player.method_24828()) {
            return false;
        }
        return !player.method_5715() && !player.method_5765();
    }

    public boolean isjumping() {
        return this.c1Latched || this.c0Latched;
    }

    @Override
    public void idleProcess(class_746 player) {
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyJump).setEnabled(JumpTracker.hasClimbeyJumpEquipped((class_1657)player) && (this.isActive(player) || ClimbTracker.hasClimbeyClimbEquipped((class_1657)player) && this.dh.climbTracker.isGrabbingLadder()));
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.c1Latched = false;
        this.c0Latched = false;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        boolean climbeyEquipped = JumpTracker.hasClimbeyJumpEquipped((class_1657)player);
        if (climbeyEquipped) {
            boolean[] ok = new boolean[2];
            for (int c = 0; c < 2; ++c) {
                ok[c] = VivecraftVRMod.INSTANCE.keyClimbeyJump.method_1434();
            }
            boolean jump = false;
            if (!ok[0] && this.c0Latched) {
                this.dh.vr.triggerHapticPulse(0, 200);
                jump = true;
            }
            Vector3f now = this.dh.vrPlayer.vrdata_room_pre.getController(0).getPositionF().lerp((Vector3fc)this.dh.vrPlayer.vrdata_room_pre.getController(1).getPositionF(), 0.5f);
            if (ok[0] && !this.c0Latched) {
                this.latchStart[0].set((Vector3fc)now);
                this.latchStartOrigin[0] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[0] = this.mc.field_1724.method_19538();
                this.dh.vr.triggerHapticPulse(0, 1000);
            }
            if (!ok[1] && this.c1Latched) {
                this.dh.vr.triggerHapticPulse(1, 200);
                jump = true;
            }
            if (ok[1] && !this.c1Latched) {
                this.latchStart[1].set((Vector3fc)now);
                this.latchStartOrigin[1] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[1] = this.mc.field_1724.method_19538();
                this.dh.vr.triggerHapticPulse(1, 1000);
            }
            this.c0Latched = ok[0];
            this.c1Latched = ok[1];
            int c = 0;
            Vector3f delta = now.sub((Vector3fc)this.latchStart[c], new Vector3f());
            delta = delta.rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
            if (!jump && this.isjumping()) {
                this.dh.vr.triggerHapticPulse(0, 200);
                this.dh.vr.triggerHapticPulse(1, 200);
            }
            if (jump) {
                this.dh.climbTracker.forceActivate = true;
                Vector3f movement = this.dh.vr.controllerHistory[0].netMovement(0.3).add((Vector3fc)this.dh.vr.controllerHistory[1].netMovement(0.3));
                float speed = this.dh.vr.controllerHistory[0].averageSpeed(0.3) + this.dh.vr.controllerHistory[1].averageSpeed(0.3) * 0.5f;
                movement.mul(0.33f * speed);
                float limit = 0.66f;
                if (movement.length() > 0.66f) {
                    movement.mul(0.66f / movement.length());
                }
                if (player.method_6059(class_1294.field_5913)) {
                    movement.mul((float)player.method_6112(class_1294.field_5913).method_5578() + 1.5f);
                }
                movement.rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
                class_243 lastPosition = this.mc.field_1724.method_19538().method_1023((double)delta.x, (double)delta.y, (double)delta.z);
                if (delta.y < 0.0f && movement.y < 0.0f) {
                    player.method_18800(player.method_18798().field_1352 - (double)movement.x * 1.25, (double)(-movement.y), player.method_18798().field_1350 - (double)movement.z * 1.25);
                    player.field_6038 = lastPosition.field_1352;
                    player.field_5971 = lastPosition.field_1351;
                    player.field_5989 = lastPosition.field_1350;
                    lastPosition = lastPosition.method_1019(player.method_18798());
                    player.method_5814(lastPosition.field_1352, lastPosition.field_1351, lastPosition.field_1350);
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity((class_1297)player, false, true);
                    this.mc.field_1724.method_7322(0.3f);
                    this.mc.field_1724.method_24830(false);
                } else {
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity((class_1297)player, false, true);
                }
            } else if (this.isjumping()) {
                class_243 thing = this.latchStartOrigin[0].method_1020(this.latchStartPlayer[0]).method_1019(this.mc.field_1724.method_19538()).method_1023((double)delta.x, (double)delta.y, (double)delta.z);
                this.dh.vrPlayer.setRoomOrigin(thing.field_1352, thing.field_1351, thing.field_1350, false);
            }
        }
        if ((!climbeyEquipped || this.dh.vrSettings.realisticJumpEnabled == VRSettings.RealisticJump.ON) && (double)this.dh.vr.hmdPivotHistory.netMovement((double)0.25).y > 0.1 && this.dh.vr.hmdPivotHistory.latest().y() - AutoCalibration.getPlayerHeight() > this.dh.vrSettings.jumpThreshold) {
            player.method_6043();
        }
    }
}

