/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui.keyboard;

import org.vivecraft.client_vr.gui.keyboard.CustomKeyboardTheme;
import org.vivecraft.client_vr.settings.OptionEnum;
import org.vivecraft.client_vr.utils.RGBAColor;

public enum KeyboardTheme implements OptionEnum<KeyboardTheme>
{
    DEFAULT(color -> color.setRGB(1.0f, 1.0f, 1.0f)),
    RED(color -> color.setRGB(1.0f, 0.0f, 0.0f)),
    GREEN(color -> color.setRGB(0.0f, 1.0f, 0.0f)),
    BLUE(color -> color.setRGB(0.0f, 0.0f, 1.0f)),
    BLACK(color -> color.setRGB(0.0f, 0.0f, 0.0f)),
    GRASS((color, x, y) -> {
        if (y >= 0 && y < 2) {
            color.setRGB(0.321f, 0.584f, 0.184f);
        } else {
            color.setRGB(0.607f, 0.462f, 0.325f);
        }
    }),
    BEES((color, x, y) -> {
        if (x % 4 < 2) {
            color.setRGB(1.0f, 1.0f, 0.0f);
        } else {
            color.setRGB(0.0f, 0.0f, 0.0f);
        }
    }),
    AESTHETIC((color, key) -> {
        if (key >= 1000) {
            color.setRGB(0.0f, 1.0f, 1.0f);
        } else {
            color.setRGB(1.0f, 0.0f, 1.0f);
        }
    }),
    DOSE((color, key) -> {
        if (key % 2 == 0) {
            color.setRGB(0.5f, 0.0f, 1.0f);
        } else {
            color.setRGB(0.0f, 1.0f, 0.0f);
        }
    }),
    CUSTOM(new CustomKeyboardTheme());

    public final Theme theme;

    private KeyboardTheme(Theme theme) {
        this.theme = theme;
    }

    @FunctionalInterface
    public static interface Theme {
        public void updateColor(RGBAColor var1, int var2, int var3, int var4);

        default public void reload() {
        }

        default public void update() {
        }
    }

    @FunctionalInterface
    static interface SolidTheme
    extends Theme {
        @Override
        default public void updateColor(RGBAColor color, int keyId, int keyX, int keyY) {
            this.updateColor(color);
        }

        public void updateColor(RGBAColor var1);
    }

    @FunctionalInterface
    static interface PositionTheme
    extends Theme {
        @Override
        default public void updateColor(RGBAColor color, int keyId, int keyX, int keyY) {
            this.updateColor(color, keyX, keyY);
        }

        public void updateColor(RGBAColor var1, int var2, int var3);
    }

    @FunctionalInterface
    static interface IdTheme
    extends Theme {
        @Override
        default public void updateColor(RGBAColor color, int keyId, int keyX, int keyY) {
            this.updateColor(color, keyId);
        }

        public void updateColor(RGBAColor var1, int var2);
    }
}

