/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.shaders.patches;

import java.util.regex.Pattern;

public abstract class Patch {
    private static final Pattern GLSL_REGEX_SEARCH = Pattern.compile("(?<!^)(\\\\\\[|\\\\]|\\\\\\(|\\\\\\)|(?<!])\\[|(?<![(?\\\\])\\(|\\\\\\.|\\\\\\+|\\\\\\*|\\\\\\?|(?<!\\?):|[-;=/,]|\\\\\\d+|(?<!\\\\|\\||((?<!\\\\)[\\[(])|\\?:|\\w)\\w+)");
    private static final Pattern GLSL_SWIZZLE_SEARCH = Pattern.compile("\\\\\\.[xyzw]{1,4}(?!\\w)");
    private static final Pattern GLSL_NUMBER_SEARCH = Pattern.compile("\\d+\\\\\\.0");
    private final Pattern[] patterns;
    private final String replacement;
    private final String testString;

    public Patch(String testString, String replacement, Pattern ... patterns) {
        this.testString = testString;
        this.replacement = replacement;
        this.patterns = patterns;
    }

    public Patch(String testString, String replacement, String ... stringPatterns) {
        this.testString = testString;
        this.replacement = replacement;
        this.patterns = new Pattern[stringPatterns.length];
        for (int i = 0; i < stringPatterns.length; ++i) {
            this.patterns[i] = Pattern.compile(Patch.padRegex(stringPatterns[i]), 2);
        }
    }

    public String patch(String shader) {
        for (Pattern pattern : this.patterns) {
            shader = pattern.matcher(shader).replaceAll(this.replacement);
        }
        return shader;
    }

    protected static String padRegex(String regex) {
        regex = GLSL_SWIZZLE_SEARCH.matcher(regex).replaceAll(matchResult -> Patch.swizzle(matchResult.group()));
        regex = GLSL_NUMBER_SEARCH.matcher(regex).replaceAll(matchResult -> Patch.number(matchResult.group()));
        return GLSL_REGEX_SEARCH.matcher(regex).replaceAll("\\\\s*$1").replaceAll(" ", "\\\\s*");
    }

    private static String swizzle(String input) {
        StringBuilder sb = new StringBuilder();
        for (char c : input.toCharArray()) {
            sb.append(switch (c) {
                case 'x' -> "[xrs]";
                case 'y' -> "[ygt]";
                case 'z' -> "[zbp]";
                case 'w' -> "[waq]";
                case '\\' -> "\\\\";
                default -> Character.valueOf(c);
            });
        }
        return sb.toString();
    }

    private static String number(String input) {
        String number = input.substring(0, input.length() - 3);
        return "(?:%s|%s\\\\.|%s\\\\.0)".formatted(number, number, number);
    }

    public String getTestString() {
        return this.testString;
    }

    public Pattern[] getPatterns() {
        return this.patterns;
    }
}

