/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.render.VRPlayerModel;

public class HMDLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation DIAMOND_HMD = new ResourceLocation("vivecraft:textures/diamond_hmd.png");
    private static final ResourceLocation GOLD_HMD = new ResourceLocation("vivecraft:textures/gold_hmd.png");
    private static final ResourceLocation BLACK_HMD = new ResourceLocation("vivecraft:textures/black_hmd.png");

    public HMDLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityModel entityModel;
        if (((PlayerModel)this.getParentModel()).head.visible && (entityModel = this.getParentModel()) instanceof VRPlayerModel) {
            ResourceLocation hmd;
            VRPlayerModel vrPlayerModel = (VRPlayerModel)entityModel;
            switch (ClientVRPlayers.getInstance().getHMD(player.getUUID())) {
                case 1: {
                    ResourceLocation resourceLocation = BLACK_HMD;
                    break;
                }
                case 2: {
                    ResourceLocation resourceLocation = GOLD_HMD;
                    break;
                }
                case 3: 
                case 4: {
                    ResourceLocation resourceLocation = DIAMOND_HMD;
                    break;
                }
                default: {
                    ResourceLocation resourceLocation = hmd = null;
                }
            }
            if (hmd == null) {
                return;
            }
            poseStack.pushPose();
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)hmd));
            vrPlayerModel.renderHMD(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

