/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import org.vivecraft.api.client.ItemInUseTracker;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.extensions.PostChainExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.interact_modules.BlockInteractionModule;
import org.vivecraft.client_vr.gameplay.interact_modules.BowModule;
import org.vivecraft.client_vr.gameplay.interact_modules.EntityInteractionModule;
import org.vivecraft.client_vr.gameplay.interact_modules.InteractiveHotbarModule;
import org.vivecraft.client_vr.gameplay.interact_modules.ScreenshotCameraModule;
import org.vivecraft.client_vr.gameplay.interact_modules.ThirdPersonCameraModule;
import org.vivecraft.client_vr.gameplay.trackers.BackpackTracker;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.gameplay.trackers.CameraTracker;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.CrawlTracker;
import org.vivecraft.client_vr.gameplay.trackers.EatingTracker;
import org.vivecraft.client_vr.gameplay.trackers.HapticTracker;
import org.vivecraft.client_vr.gameplay.trackers.HorseTracker;
import org.vivecraft.client_vr.gameplay.trackers.InteractTracker;
import org.vivecraft.client_vr.gameplay.trackers.JumpTracker;
import org.vivecraft.client_vr.gameplay.trackers.RowTracker;
import org.vivecraft.client_vr.gameplay.trackers.RunTracker;
import org.vivecraft.client_vr.gameplay.trackers.SneakTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwimTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TeleportTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.gameplay.trackers.VehicleTracker;
import org.vivecraft.client_vr.menuworlds.MenuWorldRenderer;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;
import org.vivecraft.client_vr.settings.VRSettings;

public class ClientDataHolderVR {
    public static final ModelResourceLocation THIRD_PERSON_CAMERA_MODEL = new ModelResourceLocation("vivecraft", "camcorder", "");
    public static final ModelResourceLocation THIRD_PERSON_CAMERA_DISPLAY_MODEL = new ModelResourceLocation("vivecraft", "camcorder_display", "");
    private static ClientDataHolderVR INSTANCE = new ClientDataHolderVR();
    public final boolean katVr;
    public final boolean infinadeck;
    public final boolean kiosk;
    public final boolean viewOnly;
    public boolean isMainHand;
    public boolean isFpHand;
    public VRPlayer vrPlayer;
    public MCVR vr;
    public VRRenderer vrRenderer;
    public MenuWorldRenderer menuWorldRenderer;
    private final List<Tracker> trackers = new ArrayList<Tracker>();
    private final List<ItemInUseTracker> itemInUseTrackers = new ArrayList<ItemInUseTracker>();
    public final BackpackTracker backpackTracker;
    public final BowTracker bowTracker;
    public final CameraTracker cameraTracker;
    public final ClimbTracker climbTracker;
    public final CrawlTracker crawlTracker;
    public final EatingTracker eatingTracker;
    public final HorseTracker horseTracker;
    public final InteractTracker interactTracker;
    public final JumpTracker jumpTracker;
    public final RowTracker rowTracker;
    public final RunTracker runTracker;
    public final SneakTracker sneakTracker;
    public final SwimTracker swimTracker;
    public final SwingTracker swingTracker;
    public final TeleportTracker teleportTracker;
    public final TelescopeTracker telescopeTracker;
    public final VehicleTracker vehicleTracker;
    public final HapticTracker hapticTracker;
    public final InteractiveHotbarModule hotbarModule;
    public final BowModule bowModule;
    public final ThirdPersonCameraModule thirdCamModule;
    public final ScreenshotCameraModule screenCamModule;
    public final EntityInteractionModule entityModule;
    public final BlockInteractionModule blockModule;
    public VRSettings vrSettings;
    public boolean grabScreenShot = false;
    public Screen cachedScreen = null;
    public long frameIndex = 0L;
    public RenderPass currentPass = RenderPass.VANILLA;
    public boolean isFirstPass;
    public boolean menuHandOff;
    public boolean menuHandMain;
    public boolean completelyDisabled;
    public int tickCounter;
    public VRFirstPersonArmSwing swingType = VRFirstPersonArmSwing.ATTACK;
    public boolean showedUpdateNotification;
    public boolean showedStencilMessage;
    public boolean showedFbtCalibrationNotification;
    public final Map<String, PostChainExtension> activePostchains = new HashMap<String, PostChainExtension>();

    private ClientDataHolderVR() {
        INSTANCE = this;
        this.kiosk = System.getProperty("kiosk", "false").equals("true");
        if (this.kiosk) {
            VRSettings.LOGGER.info("Vivecraft: Setting kiosk");
            this.viewOnly = System.getProperty("viewonly", "false").equals("true");
            if (this.viewOnly) {
                VRSettings.LOGGER.info("Vivecraft: Setting viewonly");
            }
        } else {
            this.viewOnly = false;
        }
        this.katVr = System.getProperty("katvr", "false").equals("true");
        this.infinadeck = System.getProperty("infinadeck", "false").equals("true");
        this.backpackTracker = this.createTracker(BackpackTracker::new);
        this.bowTracker = this.createTracker(BowTracker::new);
        this.cameraTracker = this.createTracker(CameraTracker::new);
        this.climbTracker = this.createTracker(ClimbTracker::new);
        this.crawlTracker = this.createTracker(CrawlTracker::new);
        this.eatingTracker = this.createTracker(EatingTracker::new);
        this.horseTracker = this.createTracker(HorseTracker::new);
        this.interactTracker = this.createTracker(InteractTracker::new);
        this.jumpTracker = this.createTracker(JumpTracker::new);
        this.rowTracker = this.createTracker(RowTracker::new);
        this.runTracker = this.createTracker(RunTracker::new);
        this.sneakTracker = this.createTracker(SneakTracker::new);
        this.swimTracker = this.createTracker(SwimTracker::new);
        this.swingTracker = this.createTracker(SwingTracker::new);
        this.teleportTracker = this.createTracker(TeleportTracker::new);
        this.telescopeTracker = this.createTracker(TelescopeTracker::new);
        this.vehicleTracker = this.createTracker(VehicleTracker::new);
        this.hapticTracker = this.createTracker(HapticTracker::new);
        this.hotbarModule = new InteractiveHotbarModule(Minecraft.getInstance(), this);
        this.bowModule = new BowModule(this);
        this.thirdCamModule = new ThirdPersonCameraModule(this);
        this.screenCamModule = new ScreenshotCameraModule(this);
        this.entityModule = new EntityInteractionModule(Minecraft.getInstance(), this);
        this.blockModule = new BlockInteractionModule(Minecraft.getInstance(), this);
        this.interactTracker.registerModules(this.hotbarModule, this.bowModule, this.thirdCamModule, this.screenCamModule, this.entityModule, this.blockModule);
    }

    public static ClientDataHolderVR getInstance() {
        return INSTANCE;
    }

    public boolean isMenuHand(HumanoidArm arm) {
        if (arm == HumanoidArm.LEFT) {
            return this.vrSettings.reverseHands ? this.menuHandMain : this.menuHandOff;
        }
        return this.vrSettings.reverseHands ? this.menuHandOff : this.menuHandMain;
    }

    private <T extends Tracker> T createTracker(BiFunction<Minecraft, ClientDataHolderVR, T> constructor) {
        Tracker tracker = (Tracker)constructor.apply(Minecraft.getInstance(), this);
        this.registerTracker(tracker);
        return (T)tracker;
    }

    public void registerTracker(Tracker ... trackers) throws IllegalArgumentException {
        for (Tracker tracker : trackers) {
            if (this.trackers.contains(tracker)) {
                throw new IllegalArgumentException("Tracker is already added and should not be added again!");
            }
            this.trackers.add(tracker);
            if (!(tracker instanceof ItemInUseTracker)) continue;
            ItemInUseTracker itemInUseTracker = (ItemInUseTracker)tracker;
            this.itemInUseTrackers.add(itemInUseTracker);
        }
    }

    public List<Tracker> getTrackers() {
        return Collections.unmodifiableList(this.trackers);
    }

    public boolean isTrackerUsingItem(LocalPlayer player) {
        return this.itemInUseTrackers.stream().anyMatch(tracker -> tracker.itemInUse(player));
    }

    public void updateActivePostChains() throws IOException {
        for (PostChainExtension chain : this.activePostchains.values()) {
            chain.vivecraft$updatePasses();
        }
    }
}

