/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.bodylink;

import com.bhaptics.haptic.models.PositionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.bodylink.Haptics;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.common.utils.MathUtils;

public class RiggedBody {
    private static final float USER_THICCNESS = 0.3f;
    private final HashMap<PositionType, List<HapticPoint>> hapticPoints = new HashMap();
    private final HashMap<AnchorType, BodyAnchor> anchors = new HashMap();
    private final Bone rootBone;
    private final Bone headBone;
    public static RiggedBody instance = new RiggedBody();

    public RiggedBody() {
        float hmdHeight = AutoCalibration.getPlayerHeight();
        this.rootBone = new Bone(null, new Vector3f());
        this.headBone = new Bone(this.rootBone, new Vector3f(0.0f, hmdHeight, 0.0f));
        BodyAnchor hmdAnchor = new BodyAnchor(new Vector3f(0.0f, hmdHeight, 0.0f), new Quaternionf(), AnchorType.HMD);
        this.rootBone.addPoint(hmdAnchor);
        this.anchors.put(AnchorType.HMD, hmdAnchor);
    }

    public void updatePose(VRData vrData) {
        this.rootBone.currentRotRel = new Quaternionf().rotationY(vrData.getBodyYawRad());
        this.headBone.currentPosRel = MathUtils.subtractToVector3f(vrData.hmd.getPosition(), Minecraft.getInstance().player.position()).sub((Vector3fc)this.headBone.basePosition);
        this.headBone.currentRotRel = vrData.hmd.getMatrix().getNormalizedRotation(new Quaternionf());
        this.rootBone.updatePoints();
    }

    public ArrayList<HapticPoint> getHapticPoints(PositionType ... type) {
        ArrayList<HapticPoint> matches = new ArrayList<HapticPoint>();
        for (PositionType t : type) {
            if (t == PositionType.All) {
                matches.clear();
                for (Map.Entry<PositionType, List<HapticPoint>> entry : this.hapticPoints.entrySet()) {
                    matches.addAll((Collection<HapticPoint>)entry.getValue());
                }
                break;
            }
            List<HapticPoint> points = this.hapticPoints.get(t);
            if (points == null) continue;
            matches.addAll(points);
        }
        return matches;
    }

    public void clearHapticPoints() {
        this.hapticPoints.clear();
    }

    public void addHapticPoints(Haptics.DeviceType deviceType) {
        if (deviceType == Haptics.DeviceType.X40) {
            float dimX = 0.23f;
            float dimY = 0.3f;
            float dimZ = 0.3f;
            float chestCenterOffset = 1.2f;
            for (int side = 0; side < 2; ++side) {
                HapticPoint[] points = new HapticPoint[20];
                boolean front = side == 0;
                PositionType type = front ? PositionType.VestFront : PositionType.VestBack;
                for (int x = 0; x < 4; ++x) {
                    for (int y = 0; y < 5; ++y) {
                        float posX = (float)x / 3.0f * dimX - dimX * 0.5f;
                        float posY = (float)x / 4.0f * dimY - dimY * 0.5f + chestCenterOffset;
                        float posZ = (float)(front ? -1 : 1) * dimZ * 0.5f;
                        int index = x + y * 4;
                        Vector3f posVec = new Vector3f(posX, posY, posZ);
                        Quaternionf q = new Quaternionf();
                        int rotationalIndex = front ? x : 7 - x;
                        q = q.rotateY((float)Math.PI / 180 * (-90.0f + ((float)rotationalIndex + 0.5f) / 8.0f * 360.0f));
                        q = q.rotateX((float)Math.PI / 180 * (90.0f - ((float)y + 0.5f) / 5.0f * 180.0f));
                        HapticPoint point = new HapticPoint(posVec, q, new Haptics.HapticMotor(type, index));
                        point.setAnchor(this.rootBone, 1.0);
                        points[index] = point;
                    }
                }
                this.hapticPoints.put(type, new ArrayList<HapticPoint>(Arrays.asList(points)));
            }
        }
    }

    public static RiggedBody getInstance() {
        return instance;
    }

    public class Bone {
        private final Bone parent;
        private final ArrayList<Bone> children = new ArrayList();
        private final ArrayList<BodyPoint> attachedPoints = new ArrayList();
        private final Vector3f basePosition;
        private Vector3f currentPosRel;
        private Quaternionf currentRotRel;

        public Bone(Bone parent, Vector3f origin) {
            this.parent = parent;
            this.basePosition = origin;
            this.currentPosRel = origin;
            this.currentRotRel = new Quaternionf();
            if (parent != null) {
                parent.children.add(this);
            }
        }

        public void addPoint(BodyPoint point) {
            this.attachedPoints.add(point);
        }

        public Quaternionf getAbsRot() {
            Quaternionf totalRot = new Quaternionf();
            if (this.parent != null) {
                totalRot.set((Quaternionfc)this.parent.getAbsRot());
            }
            return totalRot.mul((Quaternionfc)this.currentRotRel);
        }

        public Vector3f getAbsPos() {
            Vector3f parentPos = new Vector3f();
            Quaternionf parentRot = new Quaternionf();
            if (this.parent != null) {
                parentPos.set((Vector3fc)this.parent.getAbsPos());
                parentRot.set((Quaternionfc)this.parent.getAbsRot());
            }
            return parentPos.add((Vector3fc)parentRot.transform((Vector3fc)this.currentPosRel, new Vector3f()));
        }

        public void updatePoints() {
            for (BodyPoint b : this.attachedPoints) {
                this.getAbsRot().transform(b.basePos, b.currentPos).add((Vector3fc)this.getAbsPos());
                this.getAbsRot().mul(b.baseRot, b.currentRot);
            }
            for (Bone child : this.children) {
                child.updatePoints();
            }
        }
    }

    public class BodyAnchor
    extends BodyPoint {
        AnchorType type;

        public BodyAnchor(Vector3f relPos, Quaternionf relRot, AnchorType type) {
            super((Vector3fc)relPos, (Quaternionfc)relRot);
            this.type = type;
        }

        @Override
        boolean isTracked() {
            return true;
        }
    }

    public static enum AnchorType {
        HMD,
        HAND_L,
        HAND_R,
        FOOT_L,
        FOOT_R,
        BELT,
        GENERATED,
        OTHER_SENSOR;

    }

    public abstract class BodyPoint {
        public final Vector3f currentPos;
        public final Quaternionf currentRot;
        private final Vector3fc basePos;
        private final Quaternionfc baseRot;
        Bone parent;

        public BodyPoint(Vector3fc basePos, Quaternionfc baseRot) {
            this.basePos = basePos;
            this.baseRot = baseRot;
            this.currentPos = new Vector3f(basePos);
            this.currentRot = new Quaternionf(baseRot);
        }

        abstract boolean isTracked();

        public Vector3f getNormal(boolean mc) {
            Vector3f n = this.currentRot.transform(0.0f, 0.0f, -1.0f, new Vector3f());
            if (mc) {
                return n.rotateY((float)Math.PI);
            }
            return n;
        }

        public Vec3 getPosWorld(LocalPlayer player) {
            Vec3 playerPos = player.position();
            Vector3f currentPosMC = this.currentPos.rotateY((float)Math.PI, new Vector3f());
            return playerPos.add((double)currentPosMC.x, (double)currentPosMC.y, (double)currentPosMC.z);
        }

        public void setAnchor(Bone parent, double attachPos) {
            this.parent = parent;
        }
    }

    public class HapticPoint
    extends BodyPoint {
        public Haptics.HapticMotor motor;

        public HapticPoint(Vector3f relPos, Quaternionf relRot, Haptics.HapticMotor motor) {
            super((Vector3fc)relPos, (Quaternionfc)relRot);
            this.motor = motor;
        }

        @Override
        boolean isTracked() {
            return false;
        }
    }
}

