/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VRArmHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.getInstance();
    private static final Vec3i TP_UNLIMITED_COLOR = new Vec3i(173, 216, 230);
    private static final Vec3i TP_LIMITED_COLOR = new Vec3i(205, 169, 205);
    private static final Vec3i TP_INVALID_COLOR = new Vec3i(83, 83, 83);

    public static boolean shouldRenderHands() {
        if (VRArmHelper.DATA_HOLDER.viewOnly) {
            return false;
        }
        if (VRArmHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
            return VRArmHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY;
        }
        return VRArmHelper.DATA_HOLDER.currentPass != RenderPass.CAMERA;
    }

    public static void renderVRHands(float partialTick, boolean renderMain, boolean renderOff, boolean menuHandMain, boolean menuHandOff, PoseStack poseStack) {
        if (!renderMain && !renderOff) {
            return;
        }
        MC.getProfiler().push("hands");
        VRArmHelper.DATA_HOLDER.isFpHand = true;
        VREffectsHelper.removeNausea(partialTick, poseStack);
        if (renderMain) {
            VRArmHelper.DATA_HOLDER.isMainHand = true;
            if (menuHandMain) {
                VRArmHelper.renderMainMenuHand(0, false, poseStack);
            } else {
                VRArmHelper.renderVRHand_Main(poseStack, partialTick);
            }
            VRArmHelper.DATA_HOLDER.isMainHand = false;
        }
        if (renderOff) {
            if (menuHandOff) {
                VRArmHelper.renderMainMenuHand(1, false, poseStack);
            } else {
                VRArmHelper.renderVRHand_Offhand(poseStack, partialTick, true);
            }
        }
        VREffectsHelper.reAddNausea(poseStack);
        VRArmHelper.DATA_HOLDER.isFpHand = false;
        MC.getProfiler().pop();
    }

    public static void renderMainMenuHand(int c, boolean depthAlways, PoseStack poseStack) {
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        poseStack.pushPose();
        RenderHelper.setupRenderingAtController(c, poseStack);
        if (MC.getOverlay() == null) {
            ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
        }
        if (depthAlways && c == 0) {
            RenderSystem.depthFunc((int)519);
        } else {
            RenderSystem.depthFunc((int)515);
        }
        Vec3i color = new Vec3i(64, 64, 64);
        byte alpha = -1;
        Vec3 start = Vec3.ZERO;
        Vec3 end = new Vec3(0.0, 0.0, 0.18);
        if (VRArmHelper.MC.level != null) {
            int minLight;
            float light = VRArmHelper.MC.level.getMaxLocalRawBrightness(BlockPos.containing((Position)VRArmHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition()));
            if (light < (float)(minLight = ShadersHelper.ShaderLight())) {
                light = minLight;
            }
            float lightPercent = light / (float)VRArmHelper.MC.level.getMaxLightLevel();
            color = new Vec3i(Mth.floor((float)((float)color.getX() * lightPercent)), Mth.floor((float)((float)color.getY() * lightPercent)), Mth.floor((float)((float)color.getZ() * lightPercent)));
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        RenderHelper.renderBox((VertexConsumer)bufferBuilder, start, end, -0.02f, 0.02f, -0.0125f, 0.0125f, color, alpha, poseStack);
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        poseStack.popPose();
        RenderSystem.depthFunc((int)515);
    }

    public static void renderVRHand_Main(PoseStack poseStack, float partialTick) {
        if ((VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() || ClimbTracker.isClaws(VRArmHelper.MC.player.getMainHandItem())) && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.COMPLETE) {
            return;
        }
        poseStack.pushPose();
        RenderHelper.setupRenderingAtController(0, poseStack);
        ItemStack item = VRArmHelper.MC.player.getMainHandItem();
        Object override = null;
        if (override != null) {
            item = override;
        }
        if (VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() && !ClimbTracker.isClaws(item) && override == null) {
            item = VRArmHelper.MC.player.getOffhandItem();
        }
        item = VRArmHelper.getBowOverride(item, InteractionHand.MAIN_HAND);
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.beginEntities();
        }
        VRArmHelper.MC.gameRenderer.lightTexture().turnOnLightLayer();
        MultiBufferSource.BufferSource bufferSource = MC.renderBuffers().bufferSource();
        VRArmHelper.MC.gameRenderer.itemInHandRenderer.renderArmWithItem((AbstractClientPlayer)VRArmHelper.MC.player, partialTick, 0.0f, InteractionHand.MAIN_HAND, VRArmHelper.MC.player.getAttackAnim(partialTick), item, 0.0f, poseStack, (MultiBufferSource)bufferSource, MC.getEntityRenderDispatcher().getPackedLightCoords((Entity)VRArmHelper.MC.player, partialTick));
        bufferSource.endBatch();
        VRArmHelper.MC.gameRenderer.lightTexture().turnOffLightLayer();
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.endEntities();
        }
        poseStack.popPose();
    }

    public static void renderVRHand_Offhand(PoseStack poseStack, float partialTick, boolean renderTeleport) {
        if (!ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf || ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.COMPLETE || !VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() && !ClimbTracker.isClaws(VRArmHelper.MC.player.getOffhandItem())) {
            poseStack.pushPose();
            RenderHelper.setupRenderingAtController(1, poseStack);
            ItemStack item = VRArmHelper.MC.player.getOffhandItem();
            Object override = null;
            if (override != null) {
                item = override;
            }
            if (VRArmHelper.DATA_HOLDER.climbTracker.isClimbeyClimb() && !ClimbTracker.isClaws(item) && override == null) {
                item = VRArmHelper.MC.player.getMainHandItem();
            }
            item = VRArmHelper.getBowOverride(item, InteractionHand.OFF_HAND);
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                OptifineHelper.beginEntities();
            }
            VRArmHelper.MC.gameRenderer.lightTexture().turnOnLightLayer();
            MultiBufferSource.BufferSource bufferSource = MC.renderBuffers().bufferSource();
            VRArmHelper.MC.gameRenderer.itemInHandRenderer.renderArmWithItem((AbstractClientPlayer)VRArmHelper.MC.player, partialTick, 0.0f, InteractionHand.OFF_HAND, VRArmHelper.MC.player.getAttackAnim(partialTick), item, 0.0f, poseStack, (MultiBufferSource)bufferSource, MC.getEntityRenderDispatcher().getPackedLightCoords((Entity)VRArmHelper.MC.player, partialTick));
            bufferSource.endBatch();
            VRArmHelper.MC.gameRenderer.lightTexture().turnOffLightLayer();
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                OptifineHelper.endEntities();
            }
            poseStack.popPose();
        }
        if (renderTeleport) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (ClientNetworking.isLimitedSurvivalTeleport() && !VRArmHelper.DATA_HOLDER.vrPlayer.getFreeMove() && VRArmHelper.MC.gameMode.hasMissTime() && VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.arcAiming && !VRArmHelper.DATA_HOLDER.bowTracker.isActive(VRArmHelper.MC.player)) {
                poseStack.pushPose();
                RenderHelper.setupRenderingAtController(1, poseStack);
                Vec3 start = new Vec3(0.0, 0.005, 0.03);
                float max = 0.03f;
                float size = VRArmHelper.DATA_HOLDER.teleportTracker.isAiming() ? 2.0f * (VRArmHelper.DATA_HOLDER.teleportTracker.getTeleportEnergy() - 4.0f * (float)VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportDistance) / 100.0f * max : 2.0f * VRArmHelper.DATA_HOLDER.teleportTracker.getTeleportEnergy() / 100.0f * max;
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
                if (size > 0.0f) {
                    RenderHelper.renderFlatQuad(start.add(0.0, 0.05001, 0.0), size, size, 0.0f, TP_LIMITED_COLOR.getX(), TP_LIMITED_COLOR.getY(), TP_LIMITED_COLOR.getZ(), 128, poseStack);
                }
                RenderHelper.renderFlatQuad(start.add(0.0, 0.05, 0.0), max, max, 0.0f, TP_LIMITED_COLOR.getX(), TP_LIMITED_COLOR.getY(), TP_LIMITED_COLOR.getZ(), 50, poseStack);
                poseStack.popPose();
            }
            if (VRArmHelper.DATA_HOLDER.teleportTracker.isAiming()) {
                RenderSystem.enableDepthTest();
                if (VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.arcAiming) {
                    VRArmHelper.renderTeleportArc(poseStack);
                }
            }
            RenderSystem.defaultBlendFunc();
        }
    }

    private static ItemStack getBowOverride(ItemStack itemStack, InteractionHand interactionHand) {
        if (VRArmHelper.DATA_HOLDER.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
            InteractionHand interactionHand2 = interactionHand = interactionHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        }
        if (interactionHand == InteractionHand.MAIN_HAND) {
            if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.MC.player, InteractionHand.MAIN_HAND)) {
                ItemStack ammo = VRArmHelper.MC.player.getProjectile(VRArmHelper.MC.player.getMainHandItem());
                itemStack = ammo != ItemStack.EMPTY && !VRArmHelper.DATA_HOLDER.bowTracker.isNotched() ? ammo : ItemStack.EMPTY;
            } else if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.MC.player, InteractionHand.OFF_HAND) && VRArmHelper.DATA_HOLDER.bowTracker.isNotched()) {
                itemStack = ItemStack.EMPTY;
            }
        } else if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.MC.player, InteractionHand.MAIN_HAND)) {
            itemStack = VRArmHelper.MC.player.getMainHandItem();
        }
        return itemStack;
    }

    public static void renderTeleportArc(PoseStack poseStack) {
        if (VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.showBeam && VRArmHelper.DATA_HOLDER.teleportTracker.isAiming() && VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportArcSteps > 1) {
            Vec3i color;
            MC.getProfiler().push("teleportArc");
            RenderSystem.enableCull();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
            BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
            bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_NORMAL);
            double VOffset = VRArmHelper.DATA_HOLDER.teleportTracker.lastTeleportArcDisplayOffset;
            Vec3 dest = VRArmHelper.DATA_HOLDER.teleportTracker.getDestination();
            boolean validLocation = dest.x != 0.0 || dest.y != 0.0 || dest.z != 0.0;
            byte alpha = -1;
            if (!validLocation) {
                color = TP_INVALID_COLOR;
                alpha = -128;
            } else {
                color = ClientNetworking.isLimitedSurvivalTeleport() && !VRArmHelper.MC.player.getAbilities().mayfly ? TP_LIMITED_COLOR : TP_UNLIMITED_COLOR;
                VRArmHelper.DATA_HOLDER.teleportTracker.lastTeleportArcDisplayOffset = VOffset = (double)Util.getMillis() * 0.001 * (double)VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.textureScrollSpeed * 0.6;
            }
            float segmentHalfWidth = VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.beamHalfWidth * 0.15f;
            int segments = VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportArcSteps - 1;
            if (VRArmHelper.DATA_HOLDER.teleportTracker.vrMovementStyle.beamGrow) {
                segments = (int)((double)segments * VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportProgress);
            }
            double segmentProgress = 1.0 / (double)segments;
            Vec3 cameraPosition = VRArmHelper.MC.gameRenderer.getMainCamera().getPosition();
            for (int i = 0; i < segments; ++i) {
                double progress = (double)i / (double)segments + VOffset * segmentProgress;
                int progressBase = Mth.floor((double)progress);
                Vec3 start = VRArmHelper.DATA_HOLDER.teleportTracker.getInterpolatedArcPosition((float)((progress -= (double)progressBase) - segmentProgress * 0.4)).subtract(cameraPosition);
                Vec3 end = VRArmHelper.DATA_HOLDER.teleportTracker.getInterpolatedArcPosition((float)progress).subtract(cameraPosition);
                float shift = (float)progress * 2.0f;
                RenderHelper.renderBox((VertexConsumer)bufferBuilder, start, end, -segmentHalfWidth, segmentHalfWidth, (-1.0f + shift) * segmentHalfWidth, (1.0f + shift) * segmentHalfWidth, color, alpha, poseStack);
            }
            BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
            if (validLocation && VRArmHelper.DATA_HOLDER.teleportTracker.movementTeleportProgress >= 1.0) {
                RenderSystem.disableCull();
                Vec3 targetPos = new Vec3(dest.x, dest.y, dest.z).subtract(cameraPosition);
                float offset = 0.01f;
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                RenderHelper.renderFlatQuad(targetPos.add(x, y += (double)offset, z), 0.6f, 0.6f, 0.0f, (int)((double)color.getX() * 1.03), (int)((double)color.getY() * 1.03), (int)((double)color.getZ() * 1.03), 64, poseStack);
                RenderHelper.renderFlatQuad(targetPos.add(x, y += (double)offset, z), 0.4f, 0.4f, 0.0f, (int)((double)color.getX() * 1.04), (int)((double)color.getY() * 1.04), (int)((double)color.getZ() * 1.04), 64, poseStack);
                RenderHelper.renderFlatQuad(targetPos.add(x, y += (double)offset, z), 0.2f, 0.2f, 0.0f, (int)((double)color.getX() * 1.05), (int)((double)color.getY() * 1.05), (int)((double)color.getZ() * 1.05), 64, poseStack);
                RenderSystem.enableCull();
            }
            MC.getProfiler().pop();
        }
    }
}

