/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.common.api_impl.data.VRPoseImpl;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.common.network.Pose;
import org.vivecraft.common.network.TrackerPose;
import org.vivecraft.common.utils.MathUtils;

public record VrPlayerState(boolean seated, Pose hmd, boolean leftHanded, Pose mainHand, boolean reverseHands1legacy, Pose offHand, FBTMode fbtMode, @Nullable Pose waist, @Nullable Pose rightFoot, @Nullable Pose leftFoot, @Nullable Pose rightKnee, @Nullable Pose leftKnee, @Nullable Pose rightElbow, @Nullable Pose leftElbow) {
    public VrPlayerState(VrPlayerState other, NetworkVersion version) {
        this(other.seated, other.hmd, other.leftHanded, other.mainHand, other.reverseHands1legacy, other.offHand, NetworkVersion.FBT.accepts(version) ? other.fbtMode : FBTMode.ARMS_ONLY, NetworkVersion.FBT.accepts(version) ? other.waist : null, NetworkVersion.FBT.accepts(version) ? other.rightFoot : null, NetworkVersion.FBT.accepts(version) ? other.leftFoot : null, NetworkVersion.FBT.accepts(version) ? other.rightKnee : null, NetworkVersion.FBT.accepts(version) ? other.leftKnee : null, NetworkVersion.FBT.accepts(version) ? other.rightElbow : null, NetworkVersion.FBT.accepts(version) ? other.leftElbow : null);
    }

    public static VrPlayerState create(VRPlayer vrPlayer) {
        FBTMode fbtMode = vrPlayer.vrdata_world_post.fbtMode;
        if (!NetworkVersion.FBT.accepts(ClientNetworking.USED_NETWORK_VERSION)) {
            fbtMode = FBTMode.ARMS_ONLY;
        }
        boolean hasFbt = fbtMode != FBTMode.ARMS_ONLY;
        boolean hasExtendedFbt = fbtMode == FBTMode.WITH_JOINTS;
        return new VrPlayerState(ClientDataHolderVR.getInstance().vrSettings.seated, VrPlayerState.hmdPose(vrPlayer), ClientDataHolderVR.getInstance().vrSettings.reverseHands, VrPlayerState.devicePose(vrPlayer, 0), ClientDataHolderVR.getInstance().vrSettings.reverseHands, VrPlayerState.devicePose(vrPlayer, 1), fbtMode, hasFbt ? VrPlayerState.devicePose(vrPlayer, 3) : null, hasFbt ? VrPlayerState.devicePose(vrPlayer, 4) : null, hasFbt ? VrPlayerState.devicePose(vrPlayer, 5) : null, hasExtendedFbt ? VrPlayerState.devicePose(vrPlayer, 8) : null, hasExtendedFbt ? VrPlayerState.devicePose(vrPlayer, 9) : null, hasExtendedFbt ? VrPlayerState.devicePose(vrPlayer, 6) : null, hasExtendedFbt ? VrPlayerState.devicePose(vrPlayer, 7) : null);
    }

    private static Pose hmdPose(VRPlayer vrPlayer) {
        Vector3f position = MathUtils.subtractToVector3f(vrPlayer.vrdata_world_post.hmd.getPosition(), Minecraft.getInstance().player.position());
        Quaternionf orientation = vrPlayer.vrdata_world_post.hmd.getMatrix().getNormalizedRotation(new Quaternionf());
        return new Pose((Vector3fc)position, (Quaternionfc)orientation);
    }

    private static Pose devicePose(VRPlayer vrPlayer, int device) {
        Vector3f position = MathUtils.subtractToVector3f(vrPlayer.vrdata_world_post.getDevice(device).getPosition(), Minecraft.getInstance().player.position());
        Quaternionf orientation = vrPlayer.vrdata_world_post.getDevice(device).getMatrix().getNormalizedRotation(new Quaternionf());
        return new Pose((Vector3fc)position, (Quaternionfc)orientation);
    }

    private static TrackerPose trackerPose(VRPlayer vrPlayer, int tracker) {
        Vector3f position = MathUtils.subtractToVector3f(vrPlayer.vrdata_world_post.getDevice(tracker).getPosition(), Minecraft.getInstance().player.position());
        return new TrackerPose((Vector3fc)position);
    }

    public static VrPlayerState deserialize(FriendlyByteBuf buffer, int bytesAfter) {
        boolean seated = buffer.readBoolean();
        Pose hmd = Pose.deserialize(buffer);
        boolean reverseHands = buffer.readBoolean();
        Pose mainController = Pose.deserialize(buffer);
        boolean reverseHandsLegacy = buffer.readBoolean();
        Pose offController = Pose.deserialize(buffer);
        FBTMode fbtMode = FBTMode.ARMS_ONLY;
        Pose waist = null;
        Pose rightFoot = null;
        Pose leftFoot = null;
        Pose rightKnee = null;
        Pose leftKnee = null;
        Pose rightElbow = null;
        Pose leftElbow = null;
        if (buffer.readableBytes() > bytesAfter) {
            fbtMode = FBTMode.values()[buffer.readByte()];
        }
        if (fbtMode != FBTMode.ARMS_ONLY) {
            waist = Pose.deserialize(buffer);
            rightFoot = Pose.deserialize(buffer);
            leftFoot = Pose.deserialize(buffer);
        }
        if (fbtMode == FBTMode.WITH_JOINTS) {
            rightKnee = Pose.deserialize(buffer);
            leftKnee = Pose.deserialize(buffer);
            rightElbow = Pose.deserialize(buffer);
            leftElbow = Pose.deserialize(buffer);
        }
        return new VrPlayerState(seated, hmd, reverseHands, mainController, reverseHandsLegacy, offController, fbtMode, waist, rightFoot, leftFoot, rightKnee, leftKnee, rightElbow, leftElbow);
    }

    @Nullable
    public Pose getBodyPartPose(VRBodyPart bodyPart) {
        return switch (bodyPart) {
            default -> throw new IncompatibleClassChangeError();
            case VRBodyPart.MAIN_HAND -> this.mainHand;
            case VRBodyPart.OFF_HAND -> this.offHand;
            case VRBodyPart.LEFT_FOOT -> this.leftFoot;
            case VRBodyPart.RIGHT_FOOT -> this.rightFoot;
            case VRBodyPart.LEFT_ELBOW -> this.leftElbow;
            case VRBodyPart.RIGHT_ELBOW -> this.rightElbow;
            case VRBodyPart.LEFT_KNEE -> this.leftKnee;
            case VRBodyPart.RIGHT_KNEE -> this.rightKnee;
            case VRBodyPart.WAIST -> this.waist;
            case VRBodyPart.HEAD -> this.hmd;
        };
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.seated);
        this.hmd.serialize(buffer);
        buffer.writeBoolean(this.leftHanded);
        this.mainHand.serialize(buffer);
        buffer.writeBoolean(this.leftHanded);
        this.offHand.serialize(buffer);
        if (this.fbtMode != FBTMode.ARMS_ONLY) {
            buffer.writeByte(this.fbtMode.ordinal());
            this.waist.serialize(buffer);
            this.rightFoot.serialize(buffer);
            this.leftFoot.serialize(buffer);
            if (this.fbtMode == FBTMode.WITH_JOINTS) {
                this.rightKnee.serialize(buffer);
                this.leftKnee.serialize(buffer);
                this.rightElbow.serialize(buffer);
                this.leftElbow.serialize(buffer);
            }
        }
    }

    public VRPoseImpl asVRPose(Vec3 playerPos) {
        return new VRPoseImpl(this.hmd.asBodyPartData(playerPos), this.mainHand.asBodyPartData(playerPos), this.offHand.asBodyPartData(playerPos), VrPlayerState.getDataOrNull(this.rightFoot, playerPos), VrPlayerState.getDataOrNull(this.leftFoot, playerPos), VrPlayerState.getDataOrNull(this.waist, playerPos), VrPlayerState.getDataOrNull(this.rightKnee, playerPos), VrPlayerState.getDataOrNull(this.leftKnee, playerPos), VrPlayerState.getDataOrNull(this.rightElbow, playerPos), VrPlayerState.getDataOrNull(this.leftElbow, playerPos), this.seated, this.leftHanded, this.fbtMode);
    }

    @Nullable
    private static VRBodyPartData getDataOrNull(Pose pose, Vec3 playerPos) {
        return pose == null ? null : pose.asBodyPartData(playerPos);
    }
}

