/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.utils;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;
import org.vivecraft.common.utils.MathUtils;

public class Utils {
    public static AABB getEntityHeadHitbox(Entity entity, double inflate) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).isSwimming() || entity instanceof Zombie || entity instanceof AbstractPiglin || entity instanceof AbstractSkeleton || entity instanceof Witch || entity instanceof AbstractIllager || entity instanceof Blaze || entity instanceof Creeper || entity instanceof EnderMan || entity instanceof AbstractVillager || entity instanceof SnowGolem || entity instanceof Vex || entity instanceof Strider) {
            Vec3 headPos = entity.getEyePosition();
            double headsize = (double)entity.getBbWidth() * 0.5;
            if (((LivingEntity)entity).isBaby()) {
                headsize *= 1.2;
            }
            return new AABB(headPos.subtract(headsize, headsize - inflate, headsize), headPos.add(headsize, headsize + inflate, headsize)).inflate(inflate);
        }
        if (!(entity instanceof EnderDragon) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float yRot = -livingEntity.yBodyRot * ((float)Math.PI / 180);
            Vec3 headPos = entity.getEyePosition().add(new Vec3((double)Mth.sin((float)yRot), 0.0, (double)Mth.cos((float)yRot)).scale((double)(livingEntity.getBbWidth() * 0.5f)));
            double headsize = (double)livingEntity.getBbWidth() * 0.25;
            if (livingEntity.isBaby()) {
                headsize *= 1.5;
            }
            return new AABB(headPos.subtract(headsize, headsize, headsize), headPos.add(headsize, headsize, headsize)).inflate(inflate * 0.25).expandTowards(headPos.subtract(entity.position()).scale(inflate));
        }
        return null;
    }

    public static AABB includePoint(AABB aabb, Vec3 point) {
        return new AABB(Math.min(aabb.minX, point.x), Math.min(aabb.minY, point.y), Math.min(aabb.minZ, point.z), Math.max(aabb.maxX, point.x), Math.max(aabb.maxY, point.y), Math.max(aabb.maxZ, point.z));
    }

    public static Vector3fc getDirFromDamageSource(DamageSource source, Entity target) {
        if (source.getEntity() instanceof FallingBlockEntity) {
            return MathUtils.UP;
        }
        if (source.getSourcePosition() != null) {
            return MathUtils.subtractToVector3f(source.getSourcePosition(), target.getBoundingBox().getCenter()).normalize();
        }
        if (source.getEntity() != null) {
            return MathUtils.subtractToVector3f(source.getEntity().position(), target.getBoundingBox().getCenter()).normalize();
        }
        if (source.is(DamageTypeTags.IS_FALL) || source.is(DamageTypes.HOT_FLOOR)) {
            return MathUtils.DOWN;
        }
        return MathUtils.ZERO;
    }
}

