/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.Xevents;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.render.XRCamera;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VRArmHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererVRMixin
implements ResourceManagerReloadListener,
AutoCloseable,
GameRendererExtension {
    @Unique
    private static final ClientDataHolderVR vivecraft$DATA_HOLDER = ClientDataHolderVR.getInstance();
    @Unique
    private static final float vivecraft$MIN_CLIP_DISTANCE = 0.02f;
    @Unique
    private Vec3 vivecraft$crossVec;
    @Unique
    private Matrix4f vivecraft$thirdPassProjectionMatrix = new Matrix4f();
    @Unique
    private boolean vivecraft$inwater;
    @Unique
    private float vivecraft$inBlock = 0.0f;
    @Unique
    private double vivecraft$rveX;
    @Unique
    private double vivecraft$rveY;
    @Unique
    private double vivecraft$rveZ;
    @Unique
    private double vivecraft$rvelastX;
    @Unique
    private double vivecraft$rvelastY;
    @Unique
    private double vivecraft$rvelastZ;
    @Unique
    private double vivecraft$rveprevX;
    @Unique
    private double vivecraft$rveprevY;
    @Unique
    private double vivecraft$rveprevZ;
    @Unique
    private float vivecraft$rveyaw;
    @Unique
    private float vivecraft$rvepitch;
    @Unique
    private float vivecraft$rvelastyaw;
    @Unique
    private float vivecraft$rvelastpitch;
    @Unique
    private float vivecraft$rveHeight;
    @Unique
    private boolean vivecraft$cached;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private float fov;
    @Shadow
    private float oldFov;
    @Shadow
    @Final
    private Camera mainCamera;
    @Unique
    private boolean vivecraft$shouldDrawScreen = false;
    @Unique
    private boolean vivecraft$shouldDrawGui = false;

    @Shadow
    public abstract Matrix4f getProjectionMatrix(double var1);

    @Shadow
    protected abstract double getFov(Camera var1, float var2, boolean var3);

    @Shadow
    public abstract void resetProjectionMatrix(Matrix4f var1);

    @Redirect(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/renderer/ItemInHandRenderer;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/RenderBuffers;)V"}, at=@At(value="NEW", target="Lnet/minecraft/client/Camera;"))
    private Camera vivecraft$replaceCamera() {
        return new XRCamera();
    }

    @Inject(method={"shutdownEffect()V", "checkEntityPostEffect(Lnet/minecraft/world/entity/Entity;)V", "cycleEffect()V", "loadEffect(Lnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="HEAD")})
    private void vivecraft$shutdownVREffects(CallbackInfo ci) {
        if (VRState.VR_INITIALIZED) {
            RenderPassManager.setVanillaRenderPass();
        }
    }

    @WrapMethod(method={"pick(F)V"})
    private void vivecraft$vrPick(float partialTick, Operation<Void> original) {
        if (VRState.VR_RUNNING) {
            if (this.minecraft.screen != null && this.minecraft.hitResult != null) {
                return;
            }
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render == null || this.minecraft.getCameraEntity() == null) {
                this.minecraft.hitResult = this.minecraft.player != null ? BlockHitResult.miss((Vec3)this.minecraft.player.position(), (Direction)this.minecraft.player.getDirection(), (BlockPos)this.minecraft.player.blockPosition()) : BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.UP, (BlockPos)BlockPos.ZERO);
                return;
            }
            AABB originalBB = this.minecraft.getCameraEntity().getBoundingBox();
            this.vivecraft$cacheRVEPos(this.minecraft.getCameraEntity());
            this.vivecraft$setupRVEAtDevice(GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render.getAim());
            this.minecraft.getCameraEntity().setBoundingBox(originalBB.move(this.minecraft.getCameraEntity().getX() - this.vivecraft$rveX, this.minecraft.getCameraEntity().getY() - this.vivecraft$rveY, this.minecraft.getCameraEntity().getZ() - this.vivecraft$rveZ));
            original.call(new Object[]{Float.valueOf(partialTick)});
            this.vivecraft$restoreRVEPos(this.minecraft.getCameraEntity());
            this.minecraft.getCameraEntity().setBoundingBox(originalBB);
        } else {
            original.call(new Object[]{Float.valueOf(partialTick)});
        }
    }

    @ModifyArg(method={"pick(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;pick(DFZ)Lnet/minecraft/world/phys/HitResult;"), index=0)
    private double vivecraft$getCrossVec(double hitDistance) {
        if (VRState.VR_RUNNING) {
            this.vivecraft$crossVec = GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.AimedPointAtDistance(GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render.getAim(), hitDistance);
        }
        return hitDistance;
    }

    @ModifyArg(method={"pick(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"))
    private Predicate<Entity> vivecraft$dontHitRiddenEntity(Predicate<Entity> filter) {
        if (VRState.VR_RUNNING) {
            return filter.and(entity -> entity != Minecraft.getInstance().getCameraEntity().getVehicle());
        }
        return filter;
    }

    @Inject(method={"tickFov()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$noFOVChangeInVR(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            this.fov = 1.0f;
            this.oldFov = 1.0f;
            ci.cancel();
        }
    }

    @Inject(method={"getFov(Lnet/minecraft/client/Camera;FZ)D"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$fixedFOV(CallbackInfoReturnable<Double> cir) {
        if (this.minecraft.level == null || MethodHolder.isInMenuRoom()) {
            cir.setReturnValue((Object)((Integer)this.minecraft.options.fov().get()));
        }
    }

    @WrapOperation(method={"getProjectionMatrix(D)Lorg/joml/Matrix4f;"}, at={@At(value="INVOKE", target="Lorg/joml/Matrix4f;setPerspective(FFFF)Lorg/joml/Matrix4f;", remap=false)}, remap=true)
    private Matrix4f vivecraft$customProjectionMatrix(Matrix4f instance, float fovy, float aspect, float zNear, float zFar, Operation<Matrix4f> original) {
        if (!RenderPassType.isVanilla()) {
            zNear = 0.02f;
            if (MethodHolder.isInMenuRoom()) {
                zFar = Math.max(zFar, 1024.0f);
            }
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.LEFT || GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.RIGHT) {
                return GameRendererVRMixin.vivecraft$DATA_HOLDER.vrRenderer.getCachedProjectionMatrix(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass.ordinal(), zNear, zFar);
            }
            aspect = switch (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass) {
                case RenderPass.THIRD, RenderPass.CENTER -> {
                    if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                        yield GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityAspectRatio;
                    }
                    if (ShadersHelper.needsSameSizeBuffers()) {
                        WindowExtension window = (WindowExtension)this.minecraft.getWindow();
                        yield (float)window.vivecraft$getActualScreenWidth() / (float)window.vivecraft$getActualScreenHeight();
                    }
                    yield aspect;
                }
                case RenderPass.CAMERA -> (float)GameRendererVRMixin.vivecraft$DATA_HOLDER.vrRenderer.cameraFramebuffer.viewWidth / (float)GameRendererVRMixin.vivecraft$DATA_HOLDER.vrRenderer.cameraFramebuffer.viewHeight;
                case RenderPass.SCOPEL, RenderPass.SCOPER -> 1.0f;
                default -> aspect;
            };
            fovy = switch (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass) {
                case RenderPass.THIRD -> (float)Math.PI / 180 * GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityFov;
                case RenderPass.CAMERA -> (float)Math.PI / 180 * GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.handCameraFov;
                case RenderPass.SCOPEL, RenderPass.SCOPER -> 0.15271631f;
                default -> fovy;
            };
        }
        Matrix4f proj = (Matrix4f)original.call(new Object[]{instance, Float.valueOf(fovy), Float.valueOf(aspect), Float.valueOf(zNear), Float.valueOf(zFar)});
        if (VRState.VR_RUNNING && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.THIRD) {
            this.vivecraft$thirdPassProjectionMatrix = proj;
        }
        return proj;
    }

    @Inject(method={"shouldRenderBlockOutline()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$shouldDrawBlockOutline(CallbackInfoReturnable<Boolean> cir) {
        if (!RenderPassType.isVanilla()) {
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.blockModule.isActive(0)) {
                cir.setReturnValue((Object)false);
            } else if (GameRendererVRMixin.vivecraft$DATA_HOLDER.teleportTracker.isAiming() || GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.renderBlockOutlineMode == VRSettings.RenderPointerElement.NEVER) {
                cir.setReturnValue((Object)false);
            } else if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.renderBlockOutlineMode == VRSettings.RenderPointerElement.ALWAYS) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @WrapOperation(method={"render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V")})
    private void vivecraft$renderFaceOverlay(GameRenderer instance, float partialTick, long finishTimeNano, PoseStack poseStack, Operation<Void> original) {
        original.call(new Object[]{instance, Float.valueOf(partialTick), finishTimeNano, poseStack});
        if (!RenderPassType.isVanilla() && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.THIRD && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.CAMERA) {
            VREffectsHelper.renderFaceOverlay(partialTick, poseStack);
        }
    }

    @ModifyExpressionValue(method={"render(FJZ)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/GameRenderer;effectActive:Z")})
    private boolean vivecraft$noEffectInThird(boolean effectActive) {
        return effectActive && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.THIRD;
    }

    @Override
    @Unique
    public void vivecraft$setShouldDrawScreen(boolean shouldDrawScreen) {
        this.vivecraft$shouldDrawScreen = shouldDrawScreen;
    }

    @Override
    @Unique
    public void vivecraft$setShouldDrawGui(boolean shouldDrawGui) {
        this.vivecraft$shouldDrawGui = shouldDrawGui;
    }

    @Inject(method={"render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getWindow()Lcom/mojang/blaze3d/platform/Window;", ordinal=6)}, cancellable=true)
    private void vivecraft$mainMenu(float partialTick, long nanoTime, boolean renderLevel, CallbackInfo ci) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        if (!renderLevel && this.vivecraft$shouldDrawScreen) {
            this.vivecraft$shouldDrawScreen = false;
            if (this.vivecraft$shouldDrawGui) {
                this.minecraft.getProfiler().push("vanillaGuiSetup");
            }
            return;
        }
        if (!renderLevel || this.minecraft.level == null || MethodHolder.isInMenuRoom()) {
            if (!renderLevel || this.minecraft.level == null) {
                this.minecraft.getProfiler().push("MainMenu");
            } else {
                this.minecraft.getProfiler().popPush("MainMenu");
            }
            GL11.glDisable((int)2960);
            PoseStack poseStack = new PoseStack();
            RenderHelper.applyVRModelView(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass, poseStack);
            this.vivecraft$resetProjectionMatrix(partialTick);
            VREffectsHelper.renderGuiLayer(partialTick, true, poseStack);
            DebugRenderHelper.renderDebug(poseStack, partialTick);
            if (KeyboardHandler.SHOWING) {
                if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.physicalKeyboard) {
                    VREffectsHelper.renderPhysicalKeyboard(partialTick, poseStack);
                } else {
                    VREffectsHelper.render2D(partialTick, KeyboardHandler.FRAMEBUFFER, (Vector3fc)KeyboardHandler.POS_ROOM, KeyboardHandler.ROTATION_ROOM, GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.menuAlwaysFollowFace && MethodHolder.isInMenuRoom(), poseStack);
                }
            }
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.CAMERA && (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.THIRD || GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityRenderHands)) {
                VRArmHelper.renderVRHands(partialTick, true, true, true, true, poseStack);
            }
        }
        this.minecraft.getProfiler().pop();
        ci.cancel();
    }

    @ModifyVariable(method={"render(FJZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getWindow()Lcom/mojang/blaze3d/platform/Window;", shift=At.Shift.AFTER, ordinal=6), ordinal=0, argsOnly=true)
    private boolean vivecraft$renderGui(boolean renderLevel) {
        return RenderPassType.isVanilla() ? renderLevel : this.vivecraft$shouldDrawGui;
    }

    @WrapWithCondition(method={"render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderItemActivationAnimation(IIF)V")})
    private boolean vivecraft$noItemActivationAnimationOnGUI(GameRenderer instance, int width, int height, float partialTicks) {
        return RenderPassType.isVanilla();
    }

    @WrapWithCondition(method={"render(FJZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;render(Lnet/minecraft/client/gui/GuiGraphics;F)V")})
    private boolean vivecraft$noGUIWithViewOnly(Gui instance, GuiGraphics guiGraphics, float partialTick) {
        return RenderPassType.isVanilla() || !GameRendererVRMixin.vivecraft$DATA_HOLDER.viewOnly;
    }

    @Inject(method={"takeAutoScreenshot(Ljava/nio/file/Path;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$noScreenshotInMenu(CallbackInfo ci) {
        if (VRState.VR_RUNNING && MethodHolder.isInMenuRoom()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderConfusionOverlay(Lnet/minecraft/client/gui/GuiGraphics;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$cancelConfusionOverlayOnGUI(CallbackInfo ci) {
        if (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.GUI) {
            ci.cancel();
        }
    }

    @Inject(method={"bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$cancelBobHurt(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            ci.cancel();
        }
    }

    @Inject(method={"bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$cancelBobView(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"renderItemActivationAnimation(IIF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private void vivecraft$noTranslateItemInVR(PoseStack instance, float x, float y, float z, Operation<Void> original) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{instance, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)});
        }
    }

    @WrapOperation(method={"renderItemActivationAnimation(IIF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V")})
    private void vivecraft$noScaleItem(PoseStack poseStack, float x, float y, float z, Operation<Void> original, @Local(ordinal=5) float progress) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{poseStack, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)});
        } else {
            float sinProgress = Mth.sin((float)progress) * 0.5f;
            poseStack.translate(0.0f, 0.0f, sinProgress - 1.0f);
            RenderPass pass = GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass;
            if (pass == RenderPass.THIRD) {
                sinProgress *= GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityFov / 70.0f;
            } else if (pass == RenderPass.CENTER) {
                sinProgress *= (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue() / 70.0f;
            } else if (pass == RenderPass.LEFT || pass == RenderPass.RIGHT) {
                VRData data = GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.getVRDataWorld();
                Vector3f offset = MathUtils.subtractToVector3f(data.getEye(pass).getPosition(), data.hmd.getPosition());
                data.hmd.getMatrix().invert().transformPosition(offset);
                poseStack.translate(-offset.x, -offset.y, -offset.z);
            }
            original.call(new Object[]{poseStack, Float.valueOf(sinProgress), Float.valueOf(sinProgress), Float.valueOf(sinProgress)});
        }
    }

    @WrapOperation(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;pick(F)V")})
    private void vivecraft$onlyOnePick(GameRenderer instance, float partialTick, Operation<Void> original) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{instance, Float.valueOf(partialTick)});
            return;
        }
        if (!(!GameRendererVRMixin.vivecraft$DATA_HOLDER.isFirstPass || ImmersivePortalsHelper.isLoaded() && ImmersivePortalsHelper.isRenderingPortal())) {
            original.call(new Object[]{instance, Float.valueOf(partialTick)});
            if (this.minecraft.hitResult != null && this.minecraft.hitResult.getType() != HitResult.Type.MISS) {
                this.vivecraft$crossVec = this.minecraft.hitResult.getLocation();
            }
            if (this.minecraft.screen == null) {
                GameRendererVRMixin.vivecraft$DATA_HOLDER.teleportTracker.updateTeleportDestinations(this.minecraft.player);
            }
        }
        this.vivecraft$cacheRVEPos(this.minecraft.getCameraEntity());
        this.vivecraft$setupRVE();
        this.vivecraft$setupOverlayStatus();
    }

    @ModifyVariable(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at=@At(value="STORE"))
    private int vivecraft$reduceNauseaSpeed(int oldVal) {
        if (!RenderPassType.isVanilla()) {
            return oldVal / 5;
        }
        return oldVal;
    }

    @WrapOperation(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;lerp(FFF)F")})
    private float vivecraft$reduceNauseaAffect(float delta, float start, float end, Operation<Float> original) {
        if (!RenderPassType.isVanilla()) {
            return ((Float)original.call(new Object[]{Float.valueOf(delta), Float.valueOf(start), Float.valueOf(end)})).floatValue() * 0.4f;
        }
        return ((Float)original.call(new Object[]{Float.valueOf(delta), Float.valueOf(start), Float.valueOf(end)})).floatValue();
    }

    @ModifyExpressionValue(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/GameRenderer;renderHand:Z")})
    private boolean vivecraft$noHandsInVR(boolean renderHand) {
        return renderHand && RenderPassType.isVanilla();
    }

    @Inject(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="TAIL")})
    private void vivecraft$disableStencil(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            VREffectsHelper.disableStencilTest();
        }
    }

    @Inject(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="TAIL")})
    private void vivecraft$restoreRVE(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            this.vivecraft$restoreRVEPos(this.minecraft.getCameraEntity());
        }
    }

    @Override
    @Unique
    public void vivecraft$setupRVE() {
        this.vivecraft$setupRVEAtDevice(GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass));
    }

    @Unique
    private void vivecraft$setupRVEAtDevice(VRData.VRDevicePose eyePose) {
        if (this.vivecraft$cached) {
            Vec3 eye = eyePose.getPosition();
            Entity entity = this.minecraft.getCameraEntity();
            entity.setPosRaw(eye.x, eye.y, eye.z);
            entity.xOld = eye.x;
            entity.yOld = eye.y;
            entity.zOld = eye.z;
            entity.xo = eye.x;
            entity.yo = eye.y;
            entity.zo = eye.z;
            entity.setXRot(-eyePose.getPitch());
            entity.xRotO = entity.getXRot();
            entity.setYRot(eyePose.getYaw());
            entity.yRotO = entity.getYRot();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.yHeadRot = entity.getYRot();
                livingEntity.yHeadRotO = entity.getYRot();
            }
            entity.eyeHeight = 1.0E-4f;
        }
    }

    @Override
    @Unique
    public void vivecraft$cacheRVEPos(Entity entity) {
        if (this.minecraft.getCameraEntity() != null && !this.vivecraft$cached) {
            this.vivecraft$rveX = entity.getX();
            this.vivecraft$rveY = entity.getY();
            this.vivecraft$rveZ = entity.getZ();
            this.vivecraft$rvelastX = entity.xOld;
            this.vivecraft$rvelastY = entity.yOld;
            this.vivecraft$rvelastZ = entity.zOld;
            this.vivecraft$rveprevX = entity.xo;
            this.vivecraft$rveprevY = entity.yo;
            this.vivecraft$rveprevZ = entity.zo;
            this.vivecraft$rvepitch = entity.getXRot();
            this.vivecraft$rvelastpitch = entity.xRotO;
            this.vivecraft$rveHeight = entity.getEyeHeight();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.vivecraft$rveyaw = livingEntity.yHeadRot;
                this.vivecraft$rvelastyaw = livingEntity.yHeadRotO;
            } else {
                this.vivecraft$rveyaw = entity.getYRot();
                this.vivecraft$rvelastyaw = entity.yRotO;
            }
            this.vivecraft$cached = true;
        }
    }

    @Override
    @Unique
    public void vivecraft$restoreRVEPos(Entity entity) {
        if (entity != null) {
            entity.setPosRaw(this.vivecraft$rveX, this.vivecraft$rveY, this.vivecraft$rveZ);
            entity.xOld = this.vivecraft$rvelastX;
            entity.yOld = this.vivecraft$rvelastY;
            entity.zOld = this.vivecraft$rvelastZ;
            entity.xo = this.vivecraft$rveprevX;
            entity.yo = this.vivecraft$rveprevY;
            entity.zo = this.vivecraft$rveprevZ;
            entity.setXRot(this.vivecraft$rvepitch);
            entity.xRotO = this.vivecraft$rvelastpitch;
            entity.setYRot(this.vivecraft$rveyaw);
            entity.yRotO = this.vivecraft$rvelastyaw;
            entity.eyeHeight = this.vivecraft$rveHeight;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.yHeadRot = this.vivecraft$rveyaw;
                livingEntity.yHeadRotO = this.vivecraft$rvelastyaw;
            }
            this.vivecraft$cached = false;
        }
    }

    @Override
    @Unique
    public double vivecraft$getRveY() {
        return this.vivecraft$rveY;
    }

    @Override
    @Unique
    public Vec3 vivecraft$getRvePos(float partialTick) {
        return new Vec3(Mth.lerp((double)partialTick, (double)this.vivecraft$rvelastX, (double)this.vivecraft$rveX), Mth.lerp((double)partialTick, (double)this.vivecraft$rvelastY, (double)this.vivecraft$rveY), Mth.lerp((double)partialTick, (double)this.vivecraft$rvelastZ, (double)this.vivecraft$rveZ));
    }

    @Unique
    private void vivecraft$setupOverlayStatus() {
        this.vivecraft$inBlock = 0.0f;
        this.vivecraft$inwater = false;
        if (!this.minecraft.player.isSpectator() && !MethodHolder.isInMenuRoom() && this.minecraft.player.isAlive()) {
            Vec3 cameraPos = GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.getVRDataWorld().getEye(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass).getPosition();
            Triple<Float, BlockState, BlockPos> triple = VREffectsHelper.getNearOpaqueBlock(cameraPos, 0.02f);
            this.vivecraft$inBlock = triple != null && !Xevents.renderBlockOverlay((Player)this.minecraft.player, new PoseStack(), (BlockState)triple.getMiddle(), (BlockPos)triple.getRight()) ? ((Float)triple.getLeft()).floatValue() : 0.0f;
            this.vivecraft$inwater = this.minecraft.player.isEyeInFluid(FluidTags.WATER) && !Xevents.renderWaterOverlay((Player)this.minecraft.player, new PoseStack());
        }
    }

    @Override
    @Unique
    public boolean vivecraft$isInWater() {
        return this.vivecraft$inwater;
    }

    @Override
    @Unique
    public float vivecraft$isInBlock() {
        return this.vivecraft$inBlock;
    }

    @Override
    @Unique
    public Vec3 vivecraft$getCrossVec() {
        return this.vivecraft$crossVec;
    }

    @Override
    @Unique
    public float vivecraft$getMinClipDistance() {
        return 0.02f;
    }

    @Override
    @Unique
    public Matrix4f vivecraft$getThirdPassProjectionMatrix() {
        return this.vivecraft$thirdPassProjectionMatrix;
    }

    @Override
    @Unique
    public void vivecraft$resetProjectionMatrix(float partialTick) {
        this.resetProjectionMatrix(this.getProjectionMatrix(this.getFov(this.mainCamera, partialTick, true)));
    }
}

