/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.Vector3fHistory;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.data.ViveBlockTags;
import org.vivecraft.data.ViveItemTags;
import org.vivecraft.mod_compat_vr.epicfight.EpicFightHelper;

public class SwingTracker
implements DebugRenderTracker {
    private static final int[] CONTROLLER_AND_FEET = new int[]{0, 1, 4, 5};
    private static final VRBodyPart[] BODYPARTS = new VRBodyPart[]{VRBodyPart.MAIN_HAND, VRBodyPart.OFF_HAND, VRBodyPart.RIGHT_FOOT, VRBodyPart.LEFT_FOOT};
    private static final float SPEED_THRESH = 3.0f;
    public int disableSwing = 3;
    private final Quaternionf[] lastHandRot = new Quaternionf[4];
    private final Vec3[] lastHandPos = new Vec3[4];
    private final List<Vec3>[] miningPoints = new List[4];
    private final boolean[] lastWeaponSolid = new boolean[4];
    private final List<Entity>[] lastHitEntities = new List[]{Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()};
    private final Vec3[] miningPoint = new Vec3[4];
    private final Vec3[] attackingPoint = new Vec3[4];
    private final Vec3[] weaponTip = new Vec3[4];
    private final Vector3fHistory[] tipHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory()};
    private final boolean[] canAct = new boolean[4];
    private final AABB[] lastAttackAABB = new AABB[4];
    private final Vec3[] lastBlockHit = new Vec3[4];
    private final int[] lastMiningPointHit = new int[4];
    private final List<Pair<Vec3, Vector3fc>>[] previousMiningPoints = new List[]{new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList()};
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public SwingTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.disableSwing > 0) {
            --this.disableSwing;
            return false;
        }
        if (this.mc.gameMode == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.isAlive()) {
            return false;
        }
        if (player.isSleeping()) {
            return false;
        }
        if (this.mc.screen != null) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.OFF) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.AUTO && player.isCreative()) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (this.dh.vrSettings.getVrFreeMoveMode(false, this.dh.vrPlayer.vrdata_world_pre.fbtMode) == VRSettings.FreeMove.RUN_IN_PLACE && player.zza > 0.0f) {
            return false;
        }
        if (player.isBlocking() && !ClientNetworking.SERVER_ALLOWS_ATTACKING_WHILE_BLOCKING) {
            return false;
        }
        return !this.dh.jumpTracker.isjumping();
    }

    public static boolean isTool(ItemStack itemStack) {
        return SwingTracker.isToolItem(itemStack.getItem()) || itemStack.is(ViveItemTags.VIVECRAFT_TOOLS) || itemStack.is(ItemTags.PICKAXES) || itemStack.is(ItemTags.AXES) || itemStack.is(ItemTags.SHOVELS) || itemStack.is(ItemTags.HOES);
    }

    private static boolean isToolItem(Item item) {
        return item instanceof DiggerItem || item instanceof ArrowItem || item instanceof FishingRodItem || item instanceof FoodOnAStickItem || item instanceof ShearsItem || item == Items.BONE || item == Items.BLAZE_ROD || item == Items.BAMBOO || item == Items.TORCH || item == Items.REDSTONE_TORCH || item == Items.STICK || item == Items.DEBUG_STICK || item instanceof FlintAndSteelItem || item instanceof BrushItem;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        for (int i = 0; i < 4; ++i) {
            this.lastHandPos[i] = null;
            this.attackingPoint[i] = null;
            this.weaponTip[i] = null;
            this.miningPoints[i] = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void activeProcess(LocalPlayer player) {
        float speedTreshhold = 3.0f;
        if (player.isCreative()) {
            speedTreshhold *= 1.5f;
        }
        Profiler.get().push("updateSwingAttack");
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        for (int i = 0; i < trackers; ++i) {
            BlockHitResult blockhitresult;
            boolean isHand;
            int c = CONTROLLER_AND_FEET[i];
            boolean bl = isHand = i < 2;
            if (isHand && this.dh.climbTracker.isGrabbingLadder(c)) continue;
            Vec3 handPos = this.dh.vrPlayer.vrdata_world_pre.getDevice(c).getPosition();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(MathUtils.BACK);
            ItemStack itemstack = player.getItemInHand(c == 1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            Item item = itemstack.getItem();
            boolean isTool = false;
            boolean isSword = false;
            if (this.dh.vrSettings.onlySwordCollision && !(item instanceof SwordItem) && !itemstack.is(ViveItemTags.VIVECRAFT_SWORDS)) continue;
            if (!(item instanceof SwordItem || itemstack.is(ViveItemTags.VIVECRAFT_SWORDS) || item instanceof TridentItem || itemstack.is(ViveItemTags.VIVECRAFT_SPEARS))) {
                if (SwingTracker.isTool(itemstack)) {
                    isTool = true;
                }
            } else {
                isSword = true;
                isTool = true;
            }
            float weaponLength = 0.0f;
            float entityReachAdd = 0.3f;
            if (isHand) {
                double playerEntityReach = player.entityInteractionRange();
                playerEntityReach = Math.min(playerEntityReach, 6.0) - 0.5;
                if (isSword) {
                    weaponLength = 0.6f;
                    entityReachAdd = (float)playerEntityReach - weaponLength;
                } else if (isTool) {
                    weaponLength = 0.35f;
                    entityReachAdd = (float)playerEntityReach * 0.62f - weaponLength;
                } else if (!itemstack.isEmpty()) {
                    weaponLength = 0.1f;
                    entityReachAdd = (float)playerEntityReach * 0.16f - weaponLength;
                }
            }
            Vec3 prevMiningPoint = this.miningPoint[i];
            Vector3f weaponEnd = handDirection.mul(weaponLength *= this.dh.vrPlayer.vrdata_world_pre.worldScale, new Vector3f());
            this.miningPoint[i] = handPos.add((double)weaponEnd.x, (double)weaponEnd.y, (double)weaponEnd.z);
            Vector3f tip = this.dh.vrPlayer.vrdata_room_pre.getDevice(c).getPositionF().add((Vector3fc)this.dh.vrPlayer.vrdata_room_pre.getHand(c).getCustomVector(MathUtils.BACK).mul(0.3f));
            this.tipHistory[i].add((Vector3fc)tip);
            float speed = this.tipHistory[i].averageSpeed(0.33);
            boolean inAnEntity = false;
            this.canAct[i] = speed > speedTreshhold && !this.lastWeaponSolid[i];
            boolean entityAct = this.canAct[i];
            if (entityAct && (blockhitresult = this.mc.level.clip(new ClipContext(this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition(), handPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.player))).getType() != HitResult.Type.MISS) {
                entityAct = false;
            }
            Vec3 lastAttackPoint = this.attackingPoint[i];
            Vec3 lastWeaponTip = this.weaponTip[i];
            this.attackingPoint[i] = this.constrain(handPos, this.miningPoint[i]);
            Vector3f weaponEntityEnd = handDirection.mul(weaponLength + entityReachAdd, new Vector3f());
            this.weaponTip[i] = handPos.add((double)weaponEntityEnd.x, (double)weaponEntityEnd.y, (double)weaponEntityEnd.z);
            this.weaponTip[i] = this.constrain(handPos, this.weaponTip[i]);
            AABB weaponBB = new AABB(handPos, this.attackingPoint[i]);
            AABB weaponTipBB = new AABB(handPos, this.weaponTip[i]);
            if (lastAttackPoint != null) {
                weaponBB = Utils.includePoint(weaponBB, lastAttackPoint);
            }
            if (lastWeaponTip != null) {
                weaponTipBB = Utils.includePoint(weaponTipBB, lastWeaponTip);
            }
            this.lastAttackAABB[i] = weaponTipBB;
            List<Object> mobs = this.mc.level.getEntities((Entity)this.mc.player, weaponTipBB);
            if (this.dh.vrSettings.reducedPlayerReach) {
                mobs.removeIf(e -> e instanceof Player);
                List players = this.mc.level.getEntities((Entity)this.mc.player, weaponBB);
                players.removeIf(e -> !(e instanceof Player));
                mobs.addAll(players);
            }
            for (Entity entity : mobs) {
                if (!entity.isPickable() || entity == this.mc.getCameraEntity().getVehicle() || this.lastHitEntities[i].contains(entity)) continue;
                if (entityAct) {
                    if (!EpicFightHelper.isLoaded() || !EpicFightHelper.attack()) {
                        ClientNetworking.sendActiveBodyPart(BODYPARTS[i], true);
                        this.mc.gameMode.attack((Player)player, entity);
                    } else {
                        entityAct = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 1000);
                    this.lastWeaponSolid[i] = true;
                }
                inAnEntity = true;
            }
            this.lastHitEntities[i] = speed > speedTreshhold ? mobs : Collections.emptyList();
            int n = i;
            this.canAct[n] = this.canAct[n] & !inAnEntity;
            if (isHand && this.dh.climbTracker.isClimbeyClimb() && (!isTool || c == 0 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) || c == 1 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT))) {
                this.lastHandPos[i] = null;
                this.lastHandRot[i] = null;
                continue;
            }
            BlockHitResult blockHit = null;
            Object var28_31 = null;
            this.lastMiningPointHit[i] = 0;
            Quaternionf weaponRotation = new Quaternionf().setFromNormalized((Matrix4fc)this.dh.vrPlayer.vrdata_world_pre.getHand(c).getMatrix());
            if (this.canAct[i]) {
                this.miningPoints[i] = new ArrayList<Vec3>();
                if (this.lastHandPos[i] != null && prevMiningPoint != null) {
                    float dot = Math.abs(weaponRotation.dot(this.lastHandRot[i]));
                    float angle = 2.0f * (float)Math.acos(dot);
                    float subdivisions = Mth.floor((float)(angle / (float)Math.PI * 8.0f));
                    Quaternionf temp = new Quaternionf();
                    Vector3f lerpHandDir = new Vector3f();
                    this.miningPoints[i].add(prevMiningPoint);
                    int s = 1;
                    while ((float)s < subdivisions) {
                        float lerp = (float)s / subdivisions;
                        this.lastHandRot[i].slerp((Quaternionfc)weaponRotation, lerp, temp);
                        Vec3 lerpHand = MathUtils.vecDLerp(this.lastHandPos[i], handPos, lerp);
                        temp.transform(0.0f, 0.0f, -weaponLength, lerpHandDir);
                        this.miningPoints[i].add(lerpHand.add((double)lerpHandDir.x, (double)lerpHandDir.y, (double)lerpHandDir.z));
                        ++s;
                    }
                } else {
                    this.miningPoints[i].add(this.miningPoint[i]);
                }
                this.miningPoints[i].add(this.miningPoint[i]);
                for (int p = 1; p < this.miningPoints[i].size(); ++p) {
                    Vec3 endPos;
                    Vec3 startPos = this.miningPoints[i].get(p - 1);
                    if (startPos.subtract(endPos = this.miningPoints[i].get(p)).lengthSqr() < 1.0E-7) {
                        endPos = endPos.add(0.001);
                    }
                    blockHit = this.mc.level.clip(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                    BlockState blockState = this.mc.level.getBlockState(blockHit.getBlockPos());
                    ClientNetworking.BODY_PART_CLIENT_OVERRIDE = BODYPARTS[i];
                    boolean mineableByItem = this.dh.vrSettings.swordBlockCollision && (itemstack.isCorrectToolForDrops(blockState) || blockState.getDestroyProgress((Player)player, (BlockGetter)player.level(), blockHit.getBlockPos()) == 1.0f);
                    ClientNetworking.BODY_PART_CLIENT_OVERRIDE = null;
                    boolean protectedBlock = this.dh.vrSettings.realisticClimbEnabled && (blockState.getBlock() instanceof LadderBlock || blockState.getBlock() instanceof VineBlock || blockState.is(ViveBlockTags.VIVECRAFT_CLIMBABLE));
                    this.lastMiningPointHit[i] = p;
                    if (isSword && !mineableByItem || protectedBlock) {
                        blockHit = null;
                        Object var28_34 = null;
                        continue;
                    }
                    if (blockHit.getType() == HitResult.Type.BLOCK) break;
                }
            }
            this.lastHandPos[i] = handPos;
            this.lastHandRot[i] = weaponRotation;
            if (blockHit != null && blockHit.getType() == HitResult.Type.BLOCK && !blockHit.isInside() && this.canAct[i]) {
                void var28_32;
                this.lastWeaponSolid[i] = true;
                this.lastBlockHit[i] = blockHit.getLocation();
                int totalHits = 3;
                if (!this.dh.vrSettings.doorHitting || !this.isOpenable((BlockState)var28_32, blockHit.getDirection()) || this.mc.gameMode.useItemOn(player, c == 1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, blockHit) == InteractionResult.PASS) {
                    InteractionResult.Success success;
                    InteractionResult endPos;
                    if (isHand && (item instanceof HoeItem || itemstack.is(ViveItemTags.VIVECRAFT_HOES) || itemstack.is(ViveItemTags.VIVECRAFT_SCYTHES)) && (var28_32.getBlock() instanceof CropBlock || var28_32.getBlock() instanceof StemBlock || var28_32.getBlock() instanceof AttachedStemBlock || var28_32.is(ViveBlockTags.VIVECRAFT_CROPS) || (endPos = item.useOn(new UseOnContext((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit))) instanceof InteractionResult.Success && (success = (InteractionResult.Success)endPos).swingSource() == InteractionResult.SwingSource.CLIENT)) {
                        InteractionResult.Success success2;
                        boolean useSuccessful;
                        InteractionResult interactionResult = this.mc.gameMode.useItemOn(player, i == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit);
                        boolean bl2 = useSuccessful = interactionResult instanceof InteractionResult.Success && (success2 = (InteractionResult.Success)interactionResult).swingSource() == InteractionResult.SwingSource.CLIENT;
                        if (itemstack.is(ViveItemTags.VIVECRAFT_SCYTHES) && !useSuccessful) {
                            this.mc.gameMode.useItem((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                        }
                    } else if (isHand && item instanceof BrushItem) {
                        ((BrushItem)item).spawnDustParticles(player.level(), blockHit, (BlockState)var28_32, player.getViewVector(0.0f), c == 0 ? player.getMainArm() : player.getMainArm().getOpposite());
                        player.level().playSound((Player)player, blockHit.getBlockPos(), var28_32.getBlock() instanceof BrushableBlock ? ((BrushableBlock)var28_32.getBlock()).getBrushSound() : SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS);
                        this.mc.gameMode.useItemOn(player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit);
                    } else if (var28_32.getBlock() instanceof NoteBlock || var28_32.is(ViveBlockTags.VIVECRAFT_MUSIC_BLOCKS)) {
                        this.mc.gameMode.continueDestroyBlock(blockHit.getBlockPos(), blockHit.getDirection());
                    } else {
                        totalHits = (int)((float)totalHits + Math.min(speed - speedTreshhold, 4.0f));
                        ClientNetworking.sendActiveBodyPart(BODYPARTS[i], true);
                        this.mc.gameMode.startDestroyBlock(blockHit.getBlockPos(), blockHit.getDirection());
                        if (this.getIsHittingBlock()) {
                            for (int hit = 0; hit < totalHits; ++hit) {
                                if (this.mc.gameMode.continueDestroyBlock(blockHit.getBlockPos(), blockHit.getDirection())) {
                                    this.mc.particleEngine.crack(blockHit.getBlockPos(), blockHit.getDirection());
                                }
                                this.clearBlockHitDelay();
                                if (!this.getIsHittingBlock()) break;
                            }
                            this.mc.gameMode.destroyDelay = 0;
                        }
                        this.dh.vrPlayer.blockDust(blockHit.getLocation().x, blockHit.getLocation().y, blockHit.getLocation().z, 3 * totalHits, blockHit.getBlockPos(), (BlockState)var28_32, 0.6f, 1.0f);
                    }
                }
                this.dh.vr.triggerHapticPulse(c, 250 * totalHits);
                continue;
            }
            this.lastWeaponSolid[i] = false;
        }
        ClientNetworking.resetActiveBodyPart();
        Profiler.get().pop();
    }

    private boolean getIsHittingBlock() {
        return this.mc.gameMode.isDestroying();
    }

    private void clearBlockHitDelay() {
    }

    private Vec3 constrain(Vec3 start, Vec3 end) {
        BlockHitResult blockhitresult = this.mc.level.clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.player));
        return blockhitresult.getType() == HitResult.Type.BLOCK ? blockhitresult.getLocation() : end;
    }

    private boolean isOpenable(BlockState state, Direction direction) {
        if (state.is(BlockTags.DOORS) || state.getBlock() instanceof DoorBlock) {
            Direction facing = (Direction)state.getValue((Property)DoorBlock.FACING);
            boolean open = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)DoorBlock.HINGE);
            if (!open) {
                return facing == direction.getOpposite();
            }
            return switch (direction) {
                case Direction.SOUTH -> {
                    if (facing == Direction.WEST && hinge == DoorHingeSide.LEFT || facing == Direction.EAST && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (facing == Direction.EAST && hinge == DoorHingeSide.LEFT || facing == Direction.WEST && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> {
                    if (facing == Direction.SOUTH && hinge == DoorHingeSide.LEFT || facing == Direction.NORTH && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.WEST -> {
                    if (facing == Direction.NORTH && hinge == DoorHingeSide.LEFT || facing == Direction.SOUTH && hinge == DoorHingeSide.RIGHT) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        if (state.is(BlockTags.TRAPDOORS) || state.getBlock() instanceof TrapDoorBlock) {
            Direction facing = (Direction)state.getValue((Property)TrapDoorBlock.FACING);
            boolean open = (Boolean)state.getValue((Property)TrapDoorBlock.OPEN);
            return !open && direction == Direction.DOWN || open && direction.getOpposite() == facing;
        }
        if (state.is(BlockTags.FENCE_GATES) || state.getBlock() instanceof FenceGateBlock) {
            Direction facing = (Direction)state.getValue((Property)FenceGateBlock.FACING);
            boolean open = (Boolean)state.getValue((Property)FenceGateBlock.OPEN);
            return !open && direction.getAxis() == facing.getAxis();
        }
        return false;
    }

    public static float getItemFade(LocalPlayer player, ItemStack itemStack) {
        float fade = player.getAttackStrengthScale(0.0f) * 0.75f + 0.25f;
        if (player.isShiftKeyDown()) {
            fade = 0.75f;
        }
        if (ClientDataHolderVR.getInstance().swingTracker.lastWeaponSolid[ClientDataHolderVR.getInstance().isMainHand ? 0 : 1]) {
            fade -= 0.25f;
        }
        if (itemStack != ItemStack.EMPTY) {
            if (player.isBlocking() && player.getUseItem() != itemStack) {
                fade -= 0.25f;
            }
            if (itemStack.getItem() == Items.SHIELD && !player.isBlocking()) {
                fade -= 0.25f;
            }
        }
        if ((double)fade < 0.1) {
            fade = 0.1f;
        }
        if (fade > 1.0f) {
            fade = 1.0f;
        }
        return fade;
    }

    @Override
    public void renderDebug() {
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        VRData world = this.dh.vrPlayer.getVRDataWorld();
        Vec3 camWorld = world.getEye(this.dh.currentPass).getPosition();
        Vec3 cam = camWorld.add(this.dh.vrPlayer.vrdata_world_pre.origin).subtract(world.origin);
        for (int i = 0; i < trackers; ++i) {
            Vector3fc failColor;
            Vector3fc vector3fc = failColor = this.tipHistory[i].averageSpeed(0.33) > 3.0f * (this.mc.player.isCreative() ? 1.5f : 1.0f) ? MathUtils.ORANGE : MathUtils.RED;
            if (this.miningPoints[i] != null || this.miningPoint[i] != null) {
                Object color;
                if (this.previousMiningPoints[i].isEmpty() || !((Vec3)this.previousMiningPoints[i].getLast().getLeft()).equals((Object)this.miningPoint[i])) {
                    if (this.miningPoints[i] != null && this.canAct[i]) {
                        for (int p = 1; p < this.miningPoints[i].size(); ++p) {
                            Object object = color = p <= this.lastMiningPointHit[i] ? MathUtils.GREEN : MathUtils.LIGHT_GRAY;
                            if (p < this.miningPoints[i].size() - 1) {
                                color = color.mul(0.5f, new Vector3f());
                            }
                            this.previousMiningPoints[i].addLast((Pair<Vec3, Vector3fc>)Pair.of((Object)this.miningPoints[i].get(p), (Object)color));
                        }
                    } else {
                        this.previousMiningPoints[i].addLast((Pair<Vec3, Vector3fc>)Pair.of((Object)this.miningPoint[i], (Object)(this.canAct[i] ? MathUtils.GREEN : failColor)));
                    }
                    while (this.previousMiningPoints[i].size() > 20) {
                        this.previousMiningPoints[i].removeFirst();
                    }
                }
                DebugRenderHelper.renderCube((Vector3fc)MathUtils.subtractToVector3f(this.miningPoint[i], cam), 0.025f, this.canAct[i] ? MathUtils.GREEN : failColor);
                if (!this.previousMiningPoints[i].isEmpty()) {
                    Pair prev = null;
                    color = this.previousMiningPoints[i].iterator();
                    while (color.hasNext()) {
                        Pair p = (Pair)color.next();
                        DebugRenderHelper.renderCube((Vector3fc)MathUtils.subtractToVector3f((Vec3)p.getLeft(), cam), 0.0125f, (Vector3fc)p.getRight());
                        if (prev != null) {
                            DebugRenderHelper.renderLine((Vector3fc)p.getRight(), new Vector3fc[]{MathUtils.subtractToVector3f((Vec3)prev.getLeft(), cam), MathUtils.subtractToVector3f((Vec3)p.getLeft(), cam)});
                        }
                        prev = p;
                    }
                }
            }
            if (this.lastBlockHit[i] != null) {
                DebugRenderHelper.renderCube((Vector3fc)MathUtils.subtractToVector3f(this.lastBlockHit[i], camWorld), 0.025f, MathUtils.GREEN);
            }
            if (this.lastAttackAABB[i] != null) {
                DebugRenderHelper.renderAABB(this.lastAttackAABB[i].move(-cam.x, -cam.y, -cam.z), this.lastHitEntities[i].isEmpty() ? failColor : MathUtils.GREEN);
            }
            if (this.weaponTip[i] != null) {
                DebugRenderHelper.renderCube((Vector3fc)MathUtils.subtractToVector3f(this.weaponTip[i], cam), 0.025f, this.lastHitEntities[i].isEmpty() ? failColor : MathUtils.GREEN);
            }
            for (Entity entity : this.lastHitEntities[i]) {
                DebugRenderHelper.renderCube((Vector3fc)MathUtils.subtractToVector3f(entity.getBoundingBox().getCenter(), camWorld), (float)entity.getBoundingBox().getSize() / 2.0f, MathUtils.GREEN);
            }
        }
    }
}

