/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.vivecraft.Xplat;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.StencilHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRTextureTarget;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.resolutioncontrol.ResolutionControlHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;
import oshi.SystemInfo;
import oshi.hardware.GraphicsCard;

public abstract class VRRenderer {
    public Matrix4f[] eyeProj = new Matrix4f[2];
    private float lastFarClip = 0.0f;
    public RenderTarget framebufferEye0;
    public RenderTarget framebufferEye1;
    protected int LeftEyeTextureId = -1;
    protected int RightEyeTextureId = -1;
    public RenderTarget framebufferMR;
    public RenderTarget framebufferUndistorted;
    public RenderTarget framebufferVrRender;
    public RenderTarget fsaaFirstPassResultFBO;
    public RenderTarget fsaaLastPassResultFBO;
    public RenderTarget cameraFramebuffer;
    public RenderTarget cameraRenderFramebuffer;
    public RenderTarget telescopeFramebufferL;
    public RenderTarget telescopeFramebufferR;
    public RenderTarget mirrorFramebuffer;
    protected float[][] hiddenMeshVertices = new float[2][];
    private GraphicsStatus previousGraphics = null;
    protected VRSettings.MirrorMode lastMirror;
    public long lastWindow = 0L;
    public int mirrorFBHeight;
    public int mirrorFBWidth;
    protected boolean reinitFrameBuffers = true;
    protected boolean resizeFrameBuffers = false;
    public float renderScale;
    protected Tuple<Integer, Integer> resolution;
    public float ss = -1.0f;
    protected MCVR vr;
    protected String lastError = "";

    public VRRenderer(MCVR vr) {
        this.vr = vr;
    }

    public abstract void createRenderTexture(int var1, int var2);

    public Matrix4f getCachedProjectionMatrix(int eyeType, float nearClip, float farClip) {
        if (farClip != this.lastFarClip) {
            this.lastFarClip = farClip;
            this.eyeProj[0] = this.getProjectionMatrix(0, nearClip, farClip);
            this.eyeProj[1] = this.getProjectionMatrix(1, nearClip, farClip);
        }
        return this.eyeProj[eyeType];
    }

    protected abstract Matrix4f getProjectionMatrix(int var1, float var2, float var3);

    public abstract void endFrame() throws RenderConfigException;

    public abstract boolean providesStencilMask();

    public float[] getStencilMask(RenderPass eye) {
        if (eye == RenderPass.LEFT || eye == RenderPass.RIGHT) {
            return eye == RenderPass.LEFT ? this.hiddenMeshVertices[0] : this.hiddenMeshVertices[1];
        }
        return null;
    }

    public void doStencil(boolean inverse) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (StencilHelper.stencilBufferSupported()) {
            GL11.glEnable((int)2960);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            RenderSystem.stencilMask((int)255);
        }
        if (inverse) {
            RenderSystem.clearStencil((int)255);
            RenderSystem.clearDepth((double)0.0);
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        } else {
            RenderSystem.clearStencil((int)0);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.stencilFunc((int)519, (int)255, (int)255);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (StencilHelper.stencilBufferSupported()) {
            RenderSystem.clear((int)1280);
        } else {
            RenderSystem.clear((int)256);
        }
        RenderSystem.clearStencil((int)0);
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderTarget fb = minecraft.getMainRenderTarget();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)fb.viewWidth, 0.0f, (float)fb.viewHeight, 0.0f, 20.0f), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
        if (inverse) {
            RenderSystem.getModelViewStack().translate(0.0f, 0.0f, -20.0f);
        }
        CompiledShaderProgram lastShader = RenderSystem.getShader();
        if (dataholder.currentPass == RenderPass.SCOPEL || dataholder.currentPass == RenderPass.SCOPER) {
            this.drawCircle(fb.viewWidth, fb.viewHeight);
        } else if (this.providesStencilMask() && (dataholder.currentPass == RenderPass.LEFT || dataholder.currentPass == RenderPass.RIGHT)) {
            this.drawMask();
        }
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.setShader((CompiledShaderProgram)lastShader);
        if (StencilHelper.stencilBufferSupported()) {
            RenderSystem.stencilFunc((int)517, (int)255, (int)1);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.stencilMask((int)0);
        }
        RenderSystem.depthFunc((int)515);
    }

    private void drawCircle(float width, float height) {
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        float edges = 32.0f;
        float radius = width / 2.0f;
        builder.addVertex(radius, radius, 0.0f);
        int i = 0;
        while ((float)i < 33.0f) {
            float startAngle = (float)i / 32.0f * ((float)Math.PI * 2);
            builder.addVertex(radius + Mth.cos((float)startAngle) * radius, radius + Mth.sin((float)startAngle) * radius, 0.0f);
            ++i;
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    private void drawMask() {
        float[] verts = this.getStencilMask(ClientDataHolderVR.getInstance().currentPass);
        if (verts == null) {
            return;
        }
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION);
        ShadersHelper.bindTexture(RenderHelper.BLACK_TEXTURE);
        for (int i = 0; i < verts.length; i += 2) {
            builder.addVertex(verts[i] * this.renderScale + 0.5f, verts[i + 1] * this.renderScale + 0.5f, 0.0f);
        }
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public String getInitError() {
        return this.vr.initStatus;
    }

    public String getLastError() {
        return this.lastError;
    }

    public abstract String getName();

    public List<RenderPass> getRenderPasses(boolean includeNonRendered) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        ArrayList<RenderPass> passes = new ArrayList<RenderPass>();
        passes.add(RenderPass.LEFT);
        passes.add(RenderPass.RIGHT);
        WindowExtension window = (WindowExtension)minecraft.getWindow();
        if (includeNonRendered || window.vivecraft$getActualScreenWidth() > 0 && window.vivecraft$getActualScreenHeight() > 0) {
            if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                passes.add(RenderPass.CENTER);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                if (dataholder.vrSettings.mixedRealityUndistorted && dataholder.vrSettings.mixedRealityUnityLike) {
                    passes.add(RenderPass.CENTER);
                }
                passes.add(RenderPass.THIRD);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                passes.add(RenderPass.THIRD);
            }
        }
        if (minecraft.player != null) {
            if (TelescopeTracker.isTelescope(minecraft.player.getMainHandItem()) && TelescopeTracker.isViewing(0)) {
                passes.add(RenderPass.SCOPER);
            }
            if (TelescopeTracker.isTelescope(minecraft.player.getOffhandItem()) && TelescopeTracker.isViewing(1)) {
                passes.add(RenderPass.SCOPEL);
            }
            if (dataholder.cameraTracker.isVisible()) {
                passes.add(RenderPass.CAMERA);
            }
        }
        return passes;
    }

    public abstract Tuple<Integer, Integer> getRenderTextureSizes();

    public Tuple<Integer, Integer> getMirrorTextureSize(int eyeFBWidth, int eyeFBHeight, float resolutionScale) {
        this.mirrorFBWidth = (int)Math.ceil((float)((WindowExtension)Minecraft.getInstance().getWindow()).vivecraft$getActualScreenWidth() * resolutionScale);
        this.mirrorFBHeight = (int)Math.ceil((float)((WindowExtension)Minecraft.getInstance().getWindow()).vivecraft$getActualScreenHeight() * resolutionScale);
        if (ClientDataHolderVR.getInstance().vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            this.mirrorFBWidth /= 2;
            if (ClientDataHolderVR.getInstance().vrSettings.mixedRealityUnityLike) {
                this.mirrorFBHeight /= 2;
            }
        }
        if (ShadersHelper.needsSameSizeBuffers()) {
            this.mirrorFBWidth = eyeFBWidth;
            this.mirrorFBHeight = eyeFBHeight;
        }
        return new Tuple((Object)this.mirrorFBWidth, (Object)this.mirrorFBHeight);
    }

    public Tuple<Integer, Integer> getTelescopeTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int telescopeFBwidth = 720;
        int telescopeFBheight = 720;
        if (ShadersHelper.needsSameSizeBuffers()) {
            telescopeFBwidth = eyeFBWidth;
            telescopeFBheight = eyeFBHeight;
        }
        return new Tuple((Object)telescopeFBwidth, (Object)telescopeFBheight);
    }

    public Tuple<Integer, Integer> getCameraTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int cameraFBwidth = Math.round(1920.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        int cameraFBheight = Math.round(1080.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        if (ShadersHelper.needsSameSizeBuffers()) {
            float aspect = (float)cameraFBwidth / (float)cameraFBheight;
            if (aspect > (float)(eyeFBWidth / eyeFBHeight)) {
                cameraFBwidth = eyeFBWidth;
                cameraFBheight = Math.round((float)eyeFBWidth / aspect);
            } else {
                cameraFBwidth = Math.round((float)eyeFBHeight * aspect);
                cameraFBheight = eyeFBHeight;
            }
        }
        return new Tuple((Object)cameraFBwidth, (Object)cameraFBheight);
    }

    public boolean isInitialized() {
        return this.vr.initSuccess;
    }

    public void reinitFrameBuffersMaybe(String cause) {
        if (this.allFramebuffersInitialized()) {
            this.resizeFrameBuffers(cause);
        } else {
            this.reinitFrameBuffers(cause);
        }
    }

    public void reinitFrameBuffers(String cause) {
        if (!this.reinitFrameBuffers) {
            VRSettings.LOGGER.info("Vivecraft: Reinit Render: {}", (Object)cause);
        }
        this.reinitFrameBuffers = true;
    }

    public void resizeFrameBuffers(String cause) {
        if (!cause.isEmpty() && !this.resizeFrameBuffers) {
            VRSettings.LOGGER.info("Vivecraft: Resizing Buffers: {}", (Object)cause);
        }
        this.resizeFrameBuffers = true;
    }

    private boolean allFramebuffersInitialized() {
        return ShadersHelper.isShaderActive() || ClientDataHolderVR.getInstance().vrSettings.fullReloadOnInit;
    }

    public void setupRenderConfiguration() throws RenderConfigException, IOException {
        Tuple<Integer, Integer> cameraSize;
        Tuple<Integer, Integer> telescopeSize;
        int eyeFBHeight;
        int eyeFBWidth;
        float resolutionScale;
        int eyeh;
        int eyew;
        Tuple<Integer, Integer> tuple;
        Minecraft minecraft = Minecraft.getInstance();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (minecraft.getWindow().getWindow() != this.lastWindow) {
            this.lastWindow = minecraft.getWindow().getWindow();
            this.reinitFrameBuffers("Window Handle Changed");
        }
        if (this.lastMirror != dataholder.vrSettings.displayMirrorMode) {
            this.reinitFrameBuffersMaybe("Mirror Changed");
            this.lastMirror = dataholder.vrSettings.displayMirrorMode;
        }
        if ((this.framebufferMR == null || this.framebufferUndistorted == null) && this.allFramebuffersInitialized()) {
            this.reinitFrameBuffers("All buffers needed, but some buffers not initialized");
        }
        if (minecraft.options.graphicsMode().get() != this.previousGraphics) {
            this.previousGraphics = (GraphicsStatus)minecraft.options.graphicsMode().get();
            this.reinitFrameBuffers("gfx setting changed to: " + String.valueOf(this.previousGraphics));
        }
        if (minecraft.options.graphicsMode().get() == GraphicsStatus.FABULOUS) {
            try {
                minecraft.getShaderManager().getProgramForLoading(VRShaders.VR_TRANSPARENCY_SHADER);
            }
            catch (Exception e) {
                VRSettings.LOGGER.error("Failed to load fabulous vr shader program: ", (Throwable)e);
                ClientUtils.addChatMessage((Component)Component.translatable((String)"vivecraft.messages.fabulousFailed"));
                minecraft.options.graphicsMode().set((Object)GraphicsStatus.FAST);
                minecraft.levelRenderer.allChanged();
                this.reinitFrameBuffers("fabulous missing");
            }
        }
        if (this.resizeFrameBuffers && !this.reinitFrameBuffers) {
            boolean mipmapChanged;
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.getA();
            eyeh = (Integer)tuple.getB();
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            Tuple<Integer, Integer> mirrorSize = this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            if (dataholder.vrSettings.vrUseStencil && StencilHelper.stencilBufferSupported()) {
                ((RenderTargetExtension)WorldRenderPass.STEREO_XR.target).vivecraft$setStencil(!Xplat.enableRenderTargetStencil(WorldRenderPass.STEREO_XR.target));
            } else {
                ((RenderTargetExtension)WorldRenderPass.STEREO_XR.target).vivecraft$setStencil(false);
            }
            WorldRenderPass.STEREO_XR.resize(eyeFBWidth, eyeFBHeight);
            if (dataholder.vrSettings.useFsaa) {
                this.fsaaFirstPassResultFBO.resize(eyew, eyeFBHeight);
            }
            if ((Integer)mirrorSize.getA() > 0 && (Integer)mirrorSize.getB() > 0) {
                if (WorldRenderPass.CENTER != null) {
                    WorldRenderPass.CENTER.resize((Integer)mirrorSize.getA(), (Integer)mirrorSize.getB());
                }
                if (WorldRenderPass.MIXED_REALITY != null) {
                    WorldRenderPass.MIXED_REALITY.resize((Integer)mirrorSize.getA(), (Integer)mirrorSize.getB());
                }
                this.mirrorFramebuffer.resize(Math.max(1, ((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenWidth()), Math.max(1, ((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenHeight()));
            }
            WorldRenderPass.LEFT_TELESCOPE.resize((Integer)telescopeSize.getA(), (Integer)telescopeSize.getB());
            WorldRenderPass.RIGHT_TELESCOPE.resize((Integer)telescopeSize.getA(), (Integer)telescopeSize.getB());
            this.cameraFramebuffer.resize(((Integer)cameraSize.getA()).intValue(), ((Integer)cameraSize.getB()).intValue());
            if (ShadersHelper.needsSameSizeBuffers()) {
                WorldRenderPass.CAMERA.resize(eyeFBWidth, eyeFBHeight);
            } else {
                WorldRenderPass.CAMERA.resize((Integer)cameraSize.getA(), (Integer)cameraSize.getB());
            }
            boolean mipmaps = dataholder.vrSettings.guiMipmaps;
            boolean anisotropicFiltering = dataholder.vrSettings.guiAnisotropicFiltering;
            boolean bl = mipmapChanged = mipmaps != ((RenderTargetExtension)GuiHandler.GUI_FRAMEBUFFER).vivecraft$hasMipmaps() || anisotropicFiltering != ((VRTextureTarget)GuiHandler.GUI_FRAMEBUFFER).anisotropicFiltering;
            if (GuiHandler.updateResolution() || mipmapChanged) {
                ((RenderTargetExtension)GuiHandler.GUI_FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                ((VRTextureTarget)GuiHandler.GUI_FRAMEBUFFER).anisotropicFiltering = anisotropicFiltering;
                GuiHandler.GUI_FRAMEBUFFER.resize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT);
                ((RenderTargetExtension)RadialHandler.FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                ((VRTextureTarget)RadialHandler.FRAMEBUFFER).anisotropicFiltering = anisotropicFiltering;
                RadialHandler.FRAMEBUFFER.resize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT);
                ((RenderTargetExtension)KeyboardHandler.FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                ((VRTextureTarget)KeyboardHandler.FRAMEBUFFER).anisotropicFiltering = anisotropicFiltering;
                KeyboardHandler.FRAMEBUFFER.resize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT);
                if (minecraft.screen != null) {
                    int guiWidth = minecraft.getWindow().getGuiScaledWidth();
                    int guiHeight = minecraft.getWindow().getGuiScaledHeight();
                    minecraft.screen.init(minecraft, guiWidth, guiHeight);
                }
            }
            minecraft.resizeDisplay();
            this.resizeFrameBuffers = false;
        }
        if (this.reinitFrameBuffers) {
            RenderHelper.checkGLError("Start Init");
            if (Util.getPlatform() == Util.OS.WINDOWS && GlUtil.getRenderer().toLowerCase().contains("intel") && dataholder.vrSettings.blockIntelWindows) {
                StringBuilder gpus = new StringBuilder();
                boolean onlyIntel = true;
                for (GraphicsCard gpu : new SystemInfo().getHardware().getGraphicsCards()) {
                    gpus.append("\n");
                    if (gpu.getVendor().toLowerCase().contains("intel") || gpu.getName().toLowerCase().contains("intel")) {
                        gpus.append("\u00a7c\u274c\u00a7r ");
                    } else {
                        onlyIntel = false;
                        gpus.append("\u00a7a\u2714\u00a7r ");
                    }
                    gpus.append(gpu.getVendor()).append(": ").append(gpu.getName());
                }
                throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.incompatiblegpu"), (Component)Component.translatable((String)"vivecraft.messages.intelgraphics1", (Object[])new Object[]{Component.literal((String)GlUtil.getRenderer()).withStyle(ChatFormatting.GOLD), gpus.toString(), onlyIntel ? Component.empty() : Component.translatable((String)"vivecraft.messages.intelgraphics2", (Object[])new Object[]{Component.literal((String)"https://www.vivecraft.org/faq/#gpu").withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)CommonComponents.GUI_OPEN_IN_BROWSER)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.vivecraft.org/faq/#gpu")))})}));
            }
            if (!this.isInitialized()) {
                throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (Component)Component.literal((String)this.getInitError()));
            }
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.getA();
            eyeh = (Integer)tuple.getB();
            this.destroyBuffers();
            if (this.LeftEyeTextureId == -1) {
                this.createRenderTexture(eyew, eyeh);
                if (this.LeftEyeTextureId == -1) {
                    throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (Component)Component.literal((String)this.getLastError()));
                }
                VRSettings.LOGGER.info("Vivecraft: VR Provider supplied render texture IDs: {}, {}", (Object)this.LeftEyeTextureId, (Object)this.RightEyeTextureId);
                VRSettings.LOGGER.info("Vivecraft: VR Provider supplied texture resolution: {} x {}", (Object)eyew, (Object)eyeh);
            }
            RenderHelper.checkGLError("Render Texture setup");
            if (this.framebufferEye0 == null) {
                this.framebufferEye0 = VRTextureTarget.builder("L Eye").withSize(eyew, eyeh).withTexId(this.LeftEyeTextureId).withLinearFilter().build();
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferEye0);
                RenderHelper.checkGLError("Left Eye framebuffer setup");
            }
            if (this.framebufferEye1 == null) {
                this.framebufferEye1 = VRTextureTarget.builder("R Eye").withSize(eyew, eyeh).withTexId(this.RightEyeTextureId).withLinearFilter().build();
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferEye1);
                RenderHelper.checkGLError("Right Eye framebuffer setup");
            }
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            this.framebufferVrRender = VRTextureTarget.builder("3D Render").withSize(eyeFBWidth, eyeFBHeight).withDepth().withLinearFilter().withStencil(dataholder.vrSettings.vrUseStencil && StencilHelper.stencilBufferSupported()).build();
            WorldRenderPass.STEREO_XR = new WorldRenderPass(this.framebufferVrRender);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferVrRender);
            RenderHelper.checkGLError("3D framebuffer setup");
            this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            List<RenderPass> list = this.getRenderPasses(true);
            VRSettings.LOGGER.info("Vivecraft: Active RenderPasses: {}", (Object)list.stream().map(Enum::toString).collect(Collectors.joining(", ")));
            if (list.contains((Object)RenderPass.THIRD) || this.allFramebuffersInitialized()) {
                this.framebufferMR = VRTextureTarget.builder("Mixed Reality Render").withSize(Math.max(1, this.mirrorFBWidth), Math.max(1, this.mirrorFBHeight)).withDepth().withLinearFilter().build();
                WorldRenderPass.MIXED_REALITY = new WorldRenderPass(this.framebufferMR);
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferMR);
                RenderHelper.checkGLError("Mixed reality framebuffer setup");
            }
            if (list.contains((Object)RenderPass.CENTER) || this.allFramebuffersInitialized()) {
                this.framebufferUndistorted = VRTextureTarget.builder("Undistorted View Render").withSize(Math.max(1, this.mirrorFBWidth), Math.max(1, this.mirrorFBHeight)).withDepth().withLinearFilter().build();
                WorldRenderPass.CENTER = new WorldRenderPass(this.framebufferUndistorted);
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferUndistorted);
                RenderHelper.checkGLError("Undistorted view framebuffer setup");
            }
            this.mirrorFramebuffer = VRTextureTarget.builder("Mirror").withSize(Math.max(1, ((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenWidth()), Math.max(1, ((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenHeight())).withClearColor(0.0f, 0.0f, 0.0f, 1.0f).build();
            GuiHandler.updateResolution();
            GuiHandler.GUI_FRAMEBUFFER = VRTextureTarget.builder("GUI").withSize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT).withDepth().withLinearFilter().withMipmaps(dataholder.vrSettings.guiMipmaps).withAnisotropicFiltering(dataholder.vrSettings.guiAnisotropicFiltering).build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)GuiHandler.GUI_FRAMEBUFFER);
            RenderHelper.checkGLError("GUI framebuffer setup");
            KeyboardHandler.FRAMEBUFFER = VRTextureTarget.builder("Keyboard").withSize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT).withDepth().withLinearFilter().withMipmaps(dataholder.vrSettings.guiMipmaps).withAnisotropicFiltering(dataholder.vrSettings.guiAnisotropicFiltering).build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)KeyboardHandler.FRAMEBUFFER);
            RenderHelper.checkGLError("Keyboard framebuffer setup");
            RadialHandler.FRAMEBUFFER = VRTextureTarget.builder("Radial Menu").withSize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT).withDepth().withLinearFilter().withMipmaps(dataholder.vrSettings.guiMipmaps).withAnisotropicFiltering(dataholder.vrSettings.guiAnisotropicFiltering).build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)RadialHandler.FRAMEBUFFER);
            RenderHelper.checkGLError("Radial framebuffer setup");
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            this.telescopeFramebufferR = VRTextureTarget.builder("TelescopeR").withSize((Integer)telescopeSize.getA(), (Integer)telescopeSize.getB()).withDepth().withClearColor(0.0f, 0.0f, 0.0f, 1.0f).build();
            WorldRenderPass.RIGHT_TELESCOPE = new WorldRenderPass(this.telescopeFramebufferR);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.telescopeFramebufferR);
            RenderHelper.checkGLError("TelescopeR framebuffer setup");
            this.telescopeFramebufferL = VRTextureTarget.builder("TelescopeL").withSize((Integer)telescopeSize.getA(), (Integer)telescopeSize.getB()).withDepth().withClearColor(0.0f, 0.0f, 0.0f, 1.0f).build();
            WorldRenderPass.LEFT_TELESCOPE = new WorldRenderPass(this.telescopeFramebufferL);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.telescopeFramebufferL);
            RenderHelper.checkGLError("TelescopeL framebuffer setup");
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            int cameraRenderFBwidth = (Integer)cameraSize.getA();
            int cameraRenderFBheight = (Integer)cameraSize.getB();
            if (ShadersHelper.needsSameSizeBuffers()) {
                cameraRenderFBwidth = eyeFBWidth;
                cameraRenderFBheight = eyeFBHeight;
            }
            this.cameraFramebuffer = VRTextureTarget.builder("Handheld Camera").withSize((Integer)cameraSize.getA(), (Integer)cameraSize.getB()).withDepth().build();
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.cameraFramebuffer);
            RenderHelper.checkGLError("Camera framebuffer setup");
            this.cameraRenderFramebuffer = VRTextureTarget.builder("Handheld Camera Render").withSize(cameraRenderFBwidth, cameraRenderFBheight).withDepth().withLinearFilter().build();
            WorldRenderPass.CAMERA = new WorldRenderPass(this.cameraRenderFramebuffer);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.cameraRenderFramebuffer);
            RenderHelper.checkGLError("Camera render framebuffer setup");
            if (dataholder.vrSettings.useFsaa) {
                try {
                    RenderHelper.checkGLError("pre FSAA FBO creation");
                    this.fsaaFirstPassResultFBO = VRTextureTarget.builder("FSAA Pass1 FBO").withSize(eyew, eyeFBHeight).withDepth().build();
                    this.fsaaLastPassResultFBO = VRTextureTarget.builder("FSAA Pass2 FBO").withSize(eyew, eyeh).withDepth().build();
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.fsaaFirstPassResultFBO);
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.fsaaLastPassResultFBO);
                    RenderHelper.checkGLError("FSAA FBO creation");
                }
                catch (Exception exception) {
                    dataholder.vrSettings.useFsaa = false;
                    dataholder.vrSettings.saveOptions();
                    VRSettings.LOGGER.error("Vivecraft: FSAA init failed: ", (Throwable)exception);
                    this.reinitFrameBuffers = true;
                    return;
                }
            }
            if (!VRShaders.isReady()) {
                throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (Component)Component.literal((String)"Failed to load VR shaders, see log for full error."));
            }
            RenderPassManager.setGUIRenderPass();
            minecraft.gameRenderer.checkEntityPostEffect(minecraft.getCameraEntity());
            if (minecraft.screen != null) {
                int w = minecraft.getWindow().getGuiScaledWidth();
                int h = minecraft.getWindow().getGuiScaledHeight();
                minecraft.screen.init(minecraft, w, h);
            }
            long windowPixels = (long)((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenWidth() * (long)((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenHeight();
            long mirrorPixels = (long)this.mirrorFBWidth * (long)this.mirrorFBHeight;
            long vrPixels = (long)eyeFBWidth * (long)eyeFBHeight;
            long pixelsPerFrame = vrPixels * 2L;
            if (list.contains((Object)RenderPass.CENTER)) {
                pixelsPerFrame += mirrorPixels;
            }
            if (list.contains((Object)RenderPass.THIRD)) {
                pixelsPerFrame += mirrorPixels;
            }
            VRSettings.LOGGER.info("Vivecraft:\nNew VR render config:\nVR target: {}x{} [{}MP]\nRender target: {}x{} [Render scale: {}%, {}MP]\nMain window: {}x{} [{}MP]\nTotal shaded pixels per frame: {}MP (eye stencil not accounted for)", new Object[]{eyew, eyeh, String.format("%.1f", Float.valueOf((float)(eyew * eyeh) / 1000000.0f)), eyeFBWidth, eyeFBHeight, Float.valueOf(dataholder.vrSettings.renderScaleFactor * 100.0f), String.format("%.1f", Float.valueOf((float)vrPixels / 1000000.0f)), ((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenWidth(), ((WindowExtension)minecraft.getWindow()).vivecraft$getActualScreenHeight(), String.format("%.1f", Float.valueOf((float)windowPixels / 1000000.0f)), String.format("%.1f", Float.valueOf((float)pixelsPerFrame / 1000000.0f))});
            if (ClientDataHolderVR.getInstance().vrSettings.fullReloadOnInit) {
                minecraft.reloadResourcePacks();
            } else {
                minecraft.levelRenderer.onResourceManagerReload(minecraft.getResourceManager());
            }
            ShadersHelper.maybeReloadShaders();
            this.reinitFrameBuffers = false;
            this.resizeFrameBuffers = false;
        }
    }

    protected void destroyBuffers() {
        if (this.framebufferVrRender != null) {
            WorldRenderPass.STEREO_XR.close();
            WorldRenderPass.STEREO_XR = null;
            this.framebufferVrRender.destroyBuffers();
            this.framebufferVrRender = null;
        }
        if (this.framebufferMR != null) {
            WorldRenderPass.MIXED_REALITY.close();
            WorldRenderPass.MIXED_REALITY = null;
            this.framebufferMR.destroyBuffers();
            this.framebufferMR = null;
        }
        if (this.framebufferUndistorted != null) {
            WorldRenderPass.CENTER.close();
            WorldRenderPass.CENTER = null;
            this.framebufferUndistorted.destroyBuffers();
            this.framebufferUndistorted = null;
        }
        if (GuiHandler.GUI_FRAMEBUFFER != null) {
            GuiHandler.GUI_FRAMEBUFFER.destroyBuffers();
            GuiHandler.GUI_FRAMEBUFFER = null;
        }
        if (KeyboardHandler.FRAMEBUFFER != null) {
            KeyboardHandler.FRAMEBUFFER.destroyBuffers();
            KeyboardHandler.FRAMEBUFFER = null;
        }
        if (RadialHandler.FRAMEBUFFER != null) {
            RadialHandler.FRAMEBUFFER.destroyBuffers();
            RadialHandler.FRAMEBUFFER = null;
        }
        if (this.telescopeFramebufferL != null) {
            WorldRenderPass.LEFT_TELESCOPE.close();
            WorldRenderPass.LEFT_TELESCOPE = null;
            this.telescopeFramebufferL.destroyBuffers();
            this.telescopeFramebufferL = null;
        }
        if (this.telescopeFramebufferR != null) {
            WorldRenderPass.RIGHT_TELESCOPE.close();
            WorldRenderPass.RIGHT_TELESCOPE = null;
            this.telescopeFramebufferR.destroyBuffers();
            this.telescopeFramebufferR = null;
        }
        if (this.cameraFramebuffer != null) {
            this.cameraFramebuffer.destroyBuffers();
            this.cameraFramebuffer = null;
        }
        if (this.cameraRenderFramebuffer != null) {
            WorldRenderPass.CAMERA.close();
            WorldRenderPass.CAMERA = null;
            this.cameraRenderFramebuffer.destroyBuffers();
            this.cameraRenderFramebuffer = null;
        }
        if (this.fsaaFirstPassResultFBO != null) {
            this.fsaaFirstPassResultFBO.destroyBuffers();
            this.fsaaFirstPassResultFBO = null;
        }
        if (this.fsaaLastPassResultFBO != null) {
            this.fsaaLastPassResultFBO.destroyBuffers();
            this.fsaaLastPassResultFBO = null;
        }
        if (this.framebufferEye0 != null) {
            this.framebufferEye0.destroyBuffers();
            this.framebufferEye0 = null;
            this.LeftEyeTextureId = -1;
        }
        if (this.framebufferEye1 != null) {
            this.framebufferEye1.destroyBuffers();
            this.framebufferEye1 = null;
            this.RightEyeTextureId = -1;
        }
        if (this.mirrorFramebuffer != null) {
            this.mirrorFramebuffer.destroyBuffers();
            this.mirrorFramebuffer = null;
        }
    }

    public void destroy() {
        this.destroyBuffers();
    }
}

