/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.trackers.CameraTracker;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VRWidgetHelper {
    private static final Minecraft MC = Minecraft.getInstance();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final RandomSource RANDOM = RandomSource.create();
    private static final ResourceLocation TRANSPARENT_TEXTURE = ResourceLocation.parse((String)"vivecraft:transparent");
    public static boolean DEBUG = false;

    public static void renderVRThirdPersonCamWidget() {
        if (!VRWidgetHelper.DATA_HOLDER.vrSettings.mixedRealityRenderCameraModel) {
            return;
        }
        if (!(VRWidgetHelper.DATA_HOLDER.currentPass != RenderPass.LEFT && VRWidgetHelper.DATA_HOLDER.currentPass != RenderPass.RIGHT || VRWidgetHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.MIXED_REALITY && VRWidgetHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.THIRD_PERSON || VRWidgetHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && VRWidgetHelper.DATA_HOLDER.cameraTracker.isVisible())) {
            float scale = 0.35f;
            if (VRWidgetHelper.DATA_HOLDER.thirdCamModule.isActive() && !VRHotkeys.isMovingThirdPersonCam()) {
                scale *= 1.03f;
            }
            VRWidgetHelper.renderVRCameraWidget(-0.748f, -0.438f, -0.06f, scale, RenderPass.THIRD, ClientDataHolderVR.THIRD_PERSON_CAMERA_MODEL, ClientDataHolderVR.THIRD_PERSON_CAMERA_DISPLAY_MODEL, () -> {
                VRWidgetHelper.DATA_HOLDER.vrRenderer.framebufferMR.bindRead();
                RenderSystem.setShaderTexture((int)0, (int)VRWidgetHelper.DATA_HOLDER.vrRenderer.framebufferMR.getColorTextureId());
            }, face -> {
                if (face == Direction.NORTH) {
                    return DisplayFace.MIRROR;
                }
                return face == Direction.SOUTH ? DisplayFace.NORMAL : DisplayFace.NONE;
            });
        }
    }

    public static void renderVRHandheldCameraWidget() {
        if (VRWidgetHelper.DATA_HOLDER.currentPass != RenderPass.CAMERA && VRWidgetHelper.DATA_HOLDER.cameraTracker.isVisible()) {
            float scale = 0.25f;
            if (VRWidgetHelper.DATA_HOLDER.screenCamModule.isActive() && !VRWidgetHelper.DATA_HOLDER.cameraTracker.isMoving()) {
                scale *= 1.03f;
            }
            VRWidgetHelper.renderVRCameraWidget(-0.5f, -0.25f, -0.22f, scale, RenderPass.CAMERA, CameraTracker.CAMERA_MODEL, CameraTracker.CAMERA_DISPLAY_MODEL, () -> {
                if (VREffectsHelper.getNearOpaqueBlock(VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(RenderPass.CAMERA).getPosition(), ((GameRendererExtension)VRWidgetHelper.MC.gameRenderer).vivecraft$getMinClipDistance()) == null) {
                    VRWidgetHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.bindRead();
                    RenderSystem.setShaderTexture((int)0, (int)VRWidgetHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.getColorTextureId());
                } else {
                    ShadersHelper.bindTexture(RenderHelper.BLACK_TEXTURE);
                }
            }, face -> face == Direction.SOUTH ? DisplayFace.NORMAL : DisplayFace.NONE);
        }
    }

    public static void renderVRCameraWidget(float offsetX, float offsetY, float offsetZ, float scale, RenderPass renderPass, ModelResourceLocation model, ModelResourceLocation displayModel, Runnable displayBindFunc, Function<Direction, DisplayFace> displayFaceFunc) {
        PoseStack poseStack = new PoseStack();
        Vec3 widgetPosition = VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition();
        Vec3 eye = VRWidgetHelper.MC.gameRenderer.getMainCamera().getPosition();
        Vector3f widgetOffset = MathUtils.subtractToVector3f(widgetPosition, eye);
        poseStack.translate(widgetOffset.x, widgetOffset.y, widgetOffset.z);
        Matrix4f rotation = VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix();
        poseStack.last().pose().mul((Matrix4fc)rotation);
        poseStack.last().normal().mul((Matrix3fc)new Matrix3f((Matrix4fc)rotation));
        poseStack.scale(scale *= VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale, scale, scale);
        if (DEBUG) {
            DebugRenderHelper.renderLocalAxes(poseStack.last().pose());
        }
        poseStack.translate(offsetX, offsetY, offsetZ);
        BlockPos blockpos = BlockPos.containing((Position)VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition());
        int combinedLight = ClientUtils.getCombinedLightWithMin((BlockAndTintGetter)VRWidgetHelper.MC.level, blockpos, 0);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        ShadersHelper.bindTexture(InventoryMenu.BLOCK_ATLAS);
        if (VRWidgetHelper.MC.level != null) {
            RenderSystem.setShader((ShaderProgram)CoreShaders.RENDERTYPE_ENTITY_CUTOUT_NO_CULL);
        } else {
            RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX_COLOR);
        }
        VRWidgetHelper.MC.gameRenderer.lightTexture().turnOnLightLayer();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.NEW_ENTITY);
        MC.getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), (VertexConsumer)bufferBuilder, null, MC.getModelManager().getModel(model), 1.0f, 1.0f, 1.0f, combinedLight, OverlayTexture.NO_OVERLAY);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
        displayBindFunc.run();
        RenderSystem.setShader((ShaderProgram)CoreShaders.RENDERTYPE_ENTITY_SOLID);
        bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.NEW_ENTITY);
        for (BakedQuad bakedquad : MC.getModelManager().getModel(displayModel).getQuads(null, null, RANDOM)) {
            if (displayFaceFunc.apply(bakedquad.getDirection()) == DisplayFace.NONE || !bakedquad.getSprite().contents().name().equals((Object)TRANSPARENT_TEXTURE)) continue;
            int[] vertexList = bakedquad.getVertices();
            boolean mirrored = displayFaceFunc.apply(bakedquad.getDirection()) == DisplayFace.MIRROR;
            int step = vertexList.length / 4;
            bufferBuilder.addVertex(poseStack.last().pose(), Float.intBitsToFloat(vertexList[0]), Float.intBitsToFloat(vertexList[1]), Float.intBitsToFloat(vertexList[2])).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(mirrored ? 1.0f : 0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            bufferBuilder.addVertex(poseStack.last().pose(), Float.intBitsToFloat(vertexList[step]), Float.intBitsToFloat(vertexList[step + 1]), Float.intBitsToFloat(vertexList[step + 2])).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(mirrored ? 1.0f : 0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            bufferBuilder.addVertex(poseStack.last().pose(), Float.intBitsToFloat(vertexList[step * 2]), Float.intBitsToFloat(vertexList[step * 2 + 1]), Float.intBitsToFloat(vertexList[step * 2 + 2])).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(mirrored ? 0.0f : 1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            bufferBuilder.addVertex(poseStack.last().pose(), Float.intBitsToFloat(vertexList[step * 3]), Float.intBitsToFloat(vertexList[step * 3 + 1]), Float.intBitsToFloat(vertexList[step * 3 + 2])).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(mirrored ? 0.0f : 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        VRWidgetHelper.MC.gameRenderer.lightTexture().turnOffLightLayer();
        RenderSystem.enableBlend();
    }

    public static enum DisplayFace {
        NONE,
        NORMAL,
        MIRROR;

    }
}

