/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.renderer.entity;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderDispatcherExtension;
import org.vivecraft.client.extensions.EntityRenderStateExtension;
import org.vivecraft.client.extensions.RenderLayerExtension;
import org.vivecraft.client.render.VRPlayerRenderer;
import org.vivecraft.client.utils.RenderLayerType;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client.renderer.entity.LivingEntityRendererMixin;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRendererMixin<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    protected PlayerRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @ModifyArg(method={"extractFlightData(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at=@At(value="INVOKE", target="Ljava/lang/Math;acos(D)D"))
    private static double vivecraft$fixFlicker(double acos) {
        return Math.min(1.0, acos);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="HEAD")})
    private void vivecraft$addRotInfo(AbstractClientPlayer entity, PlayerRenderState reusedState, float partialTick, CallbackInfo ci) {
        if (entity.getClass() == LocalPlayer.class || entity.getClass() == RemotePlayer.class) {
            ((EntityRenderStateExtension)reusedState).vivecraft$setRotInfo(ClientVRPlayers.getInstance().getRotationsForPlayer(entity.getUUID()));
        } else {
            ((EntityRenderStateExtension)reusedState).vivecraft$setRotInfo(null);
        }
        ((EntityRenderStateExtension)reusedState).vivecraft$setFirstPersonPlayer(VREffectsHelper.isFirstPersonPlayer((Entity)entity));
        ((EntityRenderStateExtension)reusedState).vivecraft$setTotalScale(ScaleHelper.getEntityEyeHeightScale((LivingEntity)entity, partialTick));
    }

    @Override
    protected void vivecraft$onAddLayer(RenderLayer<PlayerRenderState, PlayerModel> renderLayer, CallbackInfoReturnable<Boolean> cir) {
        EntityRenderDispatcherExtension renderExtension = (EntityRenderDispatcherExtension)this.entityRenderDispatcher;
        if (((Object)((Object)this)).getClass() == PlayerRenderer.class && !renderExtension.vivecraft$getSkinMapVRVanilla().isEmpty()) {
            String modelType;
            Constructor<RenderLayer<PlayerRenderState, PlayerModel>> constructor = null;
            RenderLayerType type = RenderLayerType.OTHER;
            for (Constructor<RenderLayer<PlayerRenderState, PlayerModel>> constructor2 : renderLayer.getClass().getConstructors()) {
                if (constructor2.getParameterCount() == 1 && RenderLayerParent.class.isAssignableFrom(constructor2.getParameterTypes()[0])) {
                    constructor = constructor2;
                    type = RenderLayerType.PARENT_ONLY;
                    break;
                }
                if (constructor2.getParameterCount() == 2 && RenderLayerParent.class.isAssignableFrom(constructor2.getParameterTypes()[0]) && EntityModelSet.class.isAssignableFrom(constructor2.getParameterTypes()[1])) {
                    constructor = constructor2;
                    type = RenderLayerType.PARENT_MODELSET;
                    continue;
                }
                if (constructor2.getParameterCount() != 3 || !RenderLayerParent.class.isAssignableFrom(constructor2.getParameterTypes()[0]) || !HumanoidModel.class.isAssignableFrom(constructor2.getParameterTypes()[1]) || !HumanoidModel.class.isAssignableFrom(constructor2.getParameterTypes()[2]) || !(renderLayer instanceof HumanoidArmorLayer)) continue;
                constructor = constructor2;
                type = RenderLayerType.PARENT_MODEL_MODEL;
            }
            String string = modelType = ((PlayerModel)this.model).slim ? "slim" : "default";
            if (constructor == null) {
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRVanilla().get(modelType));
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRArms().get(modelType));
                this.vivecraft$addLayerClone(renderLayer, renderExtension.vivecraft$getSkinMapVRLegs().get(modelType));
            } else {
                if (!constructor.canAccess(null)) {
                    VRSettings.LOGGER.warn("Vivecraft: layer constructor of '{}' was private, making it accessible", renderLayer.getClass());
                    constructor.setAccessible(true);
                }
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRVanilla().get(modelType));
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRArms().get(modelType));
                this.vivecraft$addLayerConstructor(renderLayer, constructor, type, renderExtension.vivecraft$getSkinMapVRLegs().get(modelType));
            }
        }
    }

    @Unique
    private void vivecraft$addLayerClone(RenderLayer<PlayerRenderState, PlayerModel> renderLayer, VRPlayerRenderer target) {
        if (target.hasLayerType(renderLayer)) {
            return;
        }
        try {
            VRSettings.LOGGER.warn("Vivecraft: Copying layer: {} with Object.copy, this could cause issues", renderLayer.getClass());
            RenderLayer newLayer = (RenderLayer)((RenderLayerExtension)renderLayer).clone();
            newLayer.renderer = target;
            target.addLayer(newLayer);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private void vivecraft$addLayerConstructor(RenderLayer<PlayerRenderState, PlayerModel> renderLayer, Constructor<RenderLayer<PlayerRenderState, PlayerModel>> constructor, RenderLayerType type, VRPlayerRenderer target) {
        if (target.hasLayerType(renderLayer)) {
            return;
        }
        EntityModelSet modelSet = Minecraft.getInstance().getEntityModels();
        try {
            switch (type) {
                case PARENT_ONLY: {
                    target.addLayer(constructor.newInstance(new Object[]{target}));
                    break;
                }
                case PARENT_MODELSET: {
                    target.addLayer(constructor.newInstance(new Object[]{target, modelSet}));
                    break;
                }
                case PARENT_MODEL_MODEL: {
                    if (((PlayerModel)this.model).slim) {
                        target.addLayer(constructor.newInstance(new Object[]{target, new HumanoidModel(modelSet.bakeLayer(ModelLayers.PLAYER_SLIM_INNER_ARMOR)), new HumanoidModel(modelSet.bakeLayer(ModelLayers.PLAYER_SLIM_OUTER_ARMOR))}));
                        break;
                    }
                    target.addLayer(constructor.newInstance(new Object[]{target, new HumanoidModel(modelSet.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(modelSet.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR))}));
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

