/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected ItemStack useItem;

    @Shadow
    public abstract boolean isBlocking();

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"hasLineOfSight(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Block;Lnet/minecraft/world/level/ClipContext$Fluid;Ljava/util/function/DoubleSupplier;)Z"}, at={@At(value="NEW", target="Lnet/minecraft/world/phys/Vec3;", ordinal=0)})
    private Vec3 vivecraft$modifyOwnHeadPos(double x, double y, double z, Operation<Vec3> original) {
        ServerPlayer player;
        ServerVivePlayer serverVivePlayer;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof ServerPlayer && (serverVivePlayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)livingEntityMixin)) != null && serverVivePlayer.isVR()) {
            return serverVivePlayer.getHMDPos();
        }
        return (Vec3)original.call(new Object[]{x, y, z});
    }

    @WrapOperation(method={"hasLineOfSight(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/ClipContext$Block;Lnet/minecraft/world/level/ClipContext$Fluid;Ljava/util/function/DoubleSupplier;)Z"}, at={@At(value="NEW", target="Lnet/minecraft/world/phys/Vec3;", ordinal=1)})
    private Vec3 vivecraft$modifyOtherHeadPos(double x, double y, double z, Operation<Vec3> original, @Local(argsOnly=true) Entity other) {
        ServerPlayer player;
        ServerVivePlayer serverVivePlayer;
        if (other instanceof ServerPlayer && (serverVivePlayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)other)) != null && serverVivePlayer.isVR()) {
            Vec3 hmdPos = serverVivePlayer.getHMDPos();
            return (Vec3)original.call(new Object[]{hmdPos.x, y == other.getEyeY() ? hmdPos.y : y, hmdPos.z});
        }
        return (Vec3)original.call(new Object[]{x, y, z});
    }

    @WrapOperation(method={"method_64619*", "isLookingAtMe*"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;", remap=true)}, remap=false)
    private Vec3 vivecraft$hmdDir(LivingEntity instance, float partialTick, Operation<Vec3> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        ServerPlayer serverPlayer;
        if (instance instanceof ServerPlayer && ServerVRPlayers.isVRPlayer(serverPlayer = (ServerPlayer)instance)) {
            ServerVivePlayer serverVivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
            hmdPos.set((Object)serverVivePlayer.getHMDPos());
            return serverVivePlayer.getHMDDir();
        }
        return (Vec3)original.call(new Object[]{instance, Float.valueOf(partialTick)});
    }

    @WrapOperation(method={"method_64619*", "isLookingAtMe*"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=1, remap=true)}, remap=false)
    private double vivecraft$hmdPosX(LivingEntity instance, Operation<Double> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        return hmdPos.get() != null ? ((Vec3)hmdPos.get()).x : (Double)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"method_64619*", "isLookingAtMe*"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEyeY()D", remap=true)}, remap=false)
    private double vivecraft$hmdPosY(LivingEntity instance, Operation<Double> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        return hmdPos.get() != null ? ((Vec3)hmdPos.get()).y : (Double)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"method_64619*", "isLookingAtMe*"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=1, remap=true)}, remap=false)
    private double vivecraft$hmdPosZ(LivingEntity instance, Operation<Double> original, @Share(value="hmdPos") LocalRef<Vec3> hmdPos) {
        return hmdPos.get() != null ? ((Vec3)hmdPos.get()).z : (Double)original.call(new Object[]{instance});
    }

    @ModifyExpressionValue(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getItemBlockingWith()Lnet/minecraft/world/item/ItemStack;")})
    protected ItemStack vivecraft$roomscaleShieldBlockingItem(ItemStack original, @Local(argsOnly=true) DamageSource damageSource, @Share(value="roomscaleBlocked") LocalBooleanRef roomscaleBlocked) {
        return original;
    }

    @ModifyReturnValue(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="RETURN", ordinal=0)})
    private boolean vivecraft$roomscaleShieldIsBlocked(boolean blocked, @Share(value="roomscaleBlocked") LocalBooleanRef roomscaleBlocked) {
        return blocked || roomscaleBlocked.get();
    }
}

