/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;

public class MultiPassTextureTarget
extends TextureTarget {
    private boolean isVanilla = false;
    private RenderPass passOverride = null;
    private RenderTarget last = null;
    @Nullable
    private final EnumMap<RenderPass, TextureTarget> vrTargets;
    private final TextureTarget vanilla;

    public MultiPassTextureTarget(int width, int height, boolean useDepth) {
        super(width, height, useDepth);
        super.destroyBuffers();
        this.vrTargets = new EnumMap(RenderPass.class);
        this.isVanilla = true;
        this.vanilla = new TextureTarget(width, height, useDepth);
        this.isVanilla = false;
        for (RenderPass pass : RenderPass.values()) {
            WorldRenderPass worldPass = WorldRenderPass.getByRenderPass(pass);
            if (worldPass == null) continue;
            RenderTarget original = worldPass.target;
            this.vrTargets.put(pass, new TextureTarget(original.width, original.height, useDepth));
        }
        this.setLast(this.vanilla);
    }

    public void resize(int width, int height) {
        if (this.vrTargets == null) {
            super.resize(width, height);
            return;
        }
        this.isVanilla = true;
        this.vanilla.resize(width, height);
        this.isVanilla = false;
        for (Map.Entry<RenderPass, TextureTarget> entry : this.vrTargets.entrySet()) {
            WorldRenderPass pass = WorldRenderPass.getByRenderPass(entry.getKey());
            if (pass == null) continue;
            this.passOverride = entry.getKey();
            entry.getValue().resize(pass.target.width, pass.target.height);
            this.passOverride = null;
        }
    }

    public void destroyBuffers() {
        if (this.vrTargets == null) {
            super.destroyBuffers();
            return;
        }
        this.callOnAllTargets(RenderTarget::destroyBuffers);
    }

    public void copyDepthFrom(RenderTarget otherTarget) {
        if (this.vrTargets == null) {
            super.copyDepthFrom(otherTarget);
            return;
        }
        this.callOnTarget(r -> r.copyDepthFrom(otherTarget));
    }

    public void createBuffers(int width, int height) {
        if (this.vrTargets == null) {
            super.createBuffers(width, height);
            return;
        }
        this.callOnTarget(r -> r.createBuffers(width, height));
    }

    public void setFilterMode(int filterMode) {
        if (this.vrTargets == null) {
            super.setFilterMode(filterMode);
            return;
        }
        this.callOnTarget(r -> r.setFilterMode(filterMode));
    }

    public void checkStatus() {
        if (this.vrTargets == null) {
            super.checkStatus();
            return;
        }
        this.callOnTarget(RenderTarget::checkStatus);
    }

    public void bindRead() {
        if (this.vrTargets == null) {
            super.bindRead();
            return;
        }
        this.callOnTarget(RenderTarget::bindRead);
    }

    public void unbindRead() {
        if (this.vrTargets == null) {
            super.unbindRead();
            return;
        }
        this.callOnTarget(RenderTarget::unbindRead);
    }

    public void bindWrite(boolean setViewport) {
        if (this.vrTargets == null) {
            super.bindWrite(setViewport);
            return;
        }
        this.callOnTarget(r -> r.bindWrite(setViewport));
    }

    public void unbindWrite() {
        if (this.vrTargets == null) {
            super.unbindWrite();
            return;
        }
        this.callOnTarget(RenderTarget::unbindWrite);
    }

    public void setClearColor(float red, float green, float blue, float alpha) {
        if (this.vrTargets == null) {
            super.setClearColor(red, green, blue, alpha);
            return;
        }
        this.callOnAllTargets(r -> r.setClearColor(red, green, blue, alpha));
    }

    public void blitToScreen(int width, int height) {
        if (this.vrTargets == null) {
            super.blitToScreen(width, height);
            return;
        }
        this.callOnTarget(r -> r.blitToScreen(width, height));
    }

    public void blitAndBlendToScreen(int width, int height) {
        if (this.vrTargets == null) {
            super.blitAndBlendToScreen(width, height);
            return;
        }
        this.callOnTarget(r -> r.blitAndBlendToScreen(width, height));
    }

    public void clear() {
        if (this.vrTargets == null) {
            super.clear();
            return;
        }
        this.callOnTarget(RenderTarget::clear);
    }

    public int getColorTextureId() {
        if (this.vrTargets == null) {
            return super.getColorTextureId();
        }
        return this.callOnTargetRet(RenderTarget::getColorTextureId);
    }

    public int getDepthTextureId() {
        if (this.vrTargets == null) {
            return super.getDepthTextureId();
        }
        return this.callOnTargetRet(RenderTarget::getDepthTextureId);
    }

    private void callOnAllTargets(Consumer<TextureTarget> consumer) {
        this.isVanilla = true;
        consumer.accept(this.vanilla);
        this.isVanilla = false;
        for (Map.Entry<RenderPass, TextureTarget> entry : this.vrTargets.entrySet()) {
            this.passOverride = entry.getKey();
            consumer.accept(entry.getValue());
            this.passOverride = null;
        }
    }

    private void callOnTarget(Consumer<TextureTarget> consumer) {
        TextureTarget current = this.getCurrent();
        if (current != this.last) {
            this.setLast(current);
        }
        consumer.accept(current);
    }

    private <T> T callOnTargetRet(Function<TextureTarget, T> function) {
        TextureTarget current = this.getCurrent();
        if (current != this.last) {
            this.setLast(current);
        }
        return function.apply(current);
    }

    private TextureTarget getCurrent() {
        if (this.isVanilla || RenderPassType.isVanilla()) {
            return this.vanilla;
        }
        return this.vrTargets.get((Object)(this.passOverride != null ? this.passOverride : ClientDataHolderVR.getInstance().currentPass));
    }

    private void setLast(TextureTarget current) {
        this.last = current;
        this.width = current.width;
        this.height = current.height;
        this.viewWidth = current.viewWidth;
        this.viewHeight = current.viewHeight;
        this.frameBufferId = current.frameBufferId;
        this.filterMode = current.filterMode;
    }
}

