/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.renderer.entity;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.extensions.EntityRenderDispatcherExtension;
import org.vivecraft.client.render.VRPlayerRenderer;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.Utils;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin
implements ResourceManagerReloadListener,
EntityRenderDispatcherExtension {
    @Unique
    private final Map<String, VRPlayerRenderer> vivecraft$skinMapVRVanilla = new HashMap<String, VRPlayerRenderer>();
    @Unique
    private final Map<String, VRPlayerRenderer> vivecraft$skinMapVRArms = new HashMap<String, VRPlayerRenderer>();
    @Unique
    private final Map<String, VRPlayerRenderer> vivecraft$skinMapVRLegs = new HashMap<String, VRPlayerRenderer>();
    @Unique
    private VRPlayerRenderer vivecraft$playerRendererVRVanilla;
    @Unique
    private VRPlayerRenderer vivecraft$playerRendererVRArms;
    @Unique
    private VRPlayerRenderer vivecraft$playerRendererVRLegs;

    @Override
    public Map<String, VRPlayerRenderer> vivecraft$getSkinMapVRVanilla() {
        return this.vivecraft$skinMapVRVanilla;
    }

    @Override
    public Map<String, VRPlayerRenderer> vivecraft$getSkinMapVRArms() {
        return this.vivecraft$skinMapVRArms;
    }

    @Override
    public Map<String, VRPlayerRenderer> vivecraft$getSkinMapVRLegs() {
        return this.vivecraft$skinMapVRLegs;
    }

    @Inject(method={"renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;FFFF)V"}, at={@At(value="HEAD")})
    private static void vivecraft$renderHeadHitbox(CallbackInfo ci, @Local(argsOnly=true) PoseStack poseStack, @Local(argsOnly=true) VertexConsumer buffer, @Local(argsOnly=true) Entity entity) {
        AABB headBox;
        if (ClientDataHolderVR.getInstance().vrSettings.renderHeadHitbox && (headBox = Utils.getEntityHeadHitbox(entity, 0.0)) != null) {
            ShapeRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)headBox.move(-entity.getX(), -entity.getY(), -entity.getZ()), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            AABB headBoxArrow = Utils.getEntityHeadHitbox(entity, 0.3);
            ShapeRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (AABB)headBoxArrow.move(-entity.getX(), -entity.getY(), -entity.getZ()), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @Inject(method={"getRenderer(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/client/renderer/entity/EntityRenderer;"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$getVRPlayerRenderer(Entity entity, CallbackInfoReturnable<EntityRenderer> cir) {
        AbstractClientPlayer player;
        if (entity instanceof AbstractClientPlayer && ((player = (AbstractClientPlayer)entity).getClass() == LocalPlayer.class || player.getClass() == RemotePlayer.class)) {
            String skinType = player.getSkin().model().id();
            if (ClientVRPlayers.getInstance().isVRPlayer((Entity)player)) {
                cir.setReturnValue((Object)this.vivecraft$getVRRenderer(skinType, ClientVRPlayers.getInstance().isVRAndSeated(player.getUUID())));
            }
        }
    }

    @Unique
    private VRPlayerRenderer vivecraft$getVRRenderer(String skinType, boolean seated) {
        VRPlayerRenderer vrPlayerRenderer = seated || ClientDataHolderVR.getInstance().vrSettings.playerModelType == VRSettings.PlayerModelType.VANILLA ? this.vivecraft$skinMapVRVanilla.getOrDefault(skinType, this.vivecraft$playerRendererVRVanilla) : (ClientDataHolderVR.getInstance().vrSettings.playerModelType == VRSettings.PlayerModelType.SPLIT_ARMS ? this.vivecraft$skinMapVRArms.getOrDefault(skinType, this.vivecraft$playerRendererVRArms) : this.vivecraft$skinMapVRLegs.getOrDefault(skinType, this.vivecraft$playerRendererVRLegs));
        return vrPlayerRenderer;
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="HEAD")})
    private void vivecraft$clearVRPlayerRenderer(CallbackInfo ci) {
        this.vivecraft$skinMapVRVanilla.clear();
        this.vivecraft$skinMapVRArms.clear();
        this.vivecraft$skinMapVRLegs.clear();
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderers;createPlayerRenderers(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)Ljava/util/Map;")})
    private void vivecraft$reloadVRPlayerRenderer(CallbackInfo ci, @Local EntityRendererProvider.Context context) {
        this.vivecraft$playerRendererVRVanilla = new VRPlayerRenderer(context, false, VRPlayerRenderer.ModelType.VANILLA);
        this.vivecraft$skinMapVRVanilla.put("default", this.vivecraft$playerRendererVRVanilla);
        this.vivecraft$skinMapVRVanilla.put("slim", new VRPlayerRenderer(context, true, VRPlayerRenderer.ModelType.VANILLA));
        this.vivecraft$playerRendererVRArms = new VRPlayerRenderer(context, false, VRPlayerRenderer.ModelType.SPLIT_ARMS);
        this.vivecraft$skinMapVRArms.put("default", this.vivecraft$playerRendererVRArms);
        this.vivecraft$skinMapVRArms.put("slim", new VRPlayerRenderer(context, true, VRPlayerRenderer.ModelType.SPLIT_ARMS));
        this.vivecraft$playerRendererVRLegs = new VRPlayerRenderer(context, false, VRPlayerRenderer.ModelType.SPLIT_ARMS_LEGS);
        this.vivecraft$skinMapVRLegs.put("default", this.vivecraft$playerRendererVRLegs);
        this.vivecraft$skinMapVRLegs.put("slim", new VRPlayerRenderer(context, true, VRPlayerRenderer.ModelType.SPLIT_ARMS_LEGS));
    }
}

