/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils.math;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_746;

public class BezierCurve {
    public ArrayList<Node> nodes = new ArrayList();
    boolean circular;

    public BezierCurve(Node[] nodes, boolean circular) {
        this.nodes.addAll(Arrays.asList(nodes));
        this.circular = circular;
    }

    public BezierCurve(boolean circular) {
        this.circular = circular;
    }

    class_243 getIntermediate(Node n1, Node n2, double perc) {
        class_243 p0 = n1.vertex;
        class_243 p1 = n1.controlOut;
        class_243 p2 = n2.controlIn;
        class_243 p3 = n2.vertex;
        return p0.method_1021(Math.pow(1.0 - perc, 3.0)).method_1019(p1.method_1021(3.0 * Math.pow(1.0 - perc, 2.0) * perc)).method_1019(p2.method_1021(3.0 * (1.0 - perc) * Math.pow(perc, 2.0))).method_1019(p3.method_1021(Math.pow(perc, 3.0)));
    }

    public class_243 getPointOnPath(double perc) {
        int upperIndex;
        int nodeCount = this.circular ? this.nodes.size() : this.nodes.size() - 1;
        double exactIndex = perc * (double)nodeCount;
        int lowerIndex = (int)Math.floor(exactIndex) % this.nodes.size();
        if (lowerIndex == (upperIndex = (int)Math.ceil(exactIndex) % this.nodes.size())) {
            return this.nodes.get((int)lowerIndex).vertex;
        }
        Node node1 = this.nodes.get(lowerIndex);
        Node node2 = this.nodes.get(upperIndex);
        return this.getIntermediate(node1, node2, exactIndex - (double)lowerIndex);
    }

    public class_243[] getLinearInterpolation(int verticesPerNode) {
        if (this.nodes.isEmpty()) {
            return new class_243[0];
        }
        int totalVertices = verticesPerNode * (this.circular ? this.nodes.size() : this.nodes.size() - 1) + 1;
        class_243[] out = new class_243[totalVertices];
        for (int i = 0; i < totalVertices; ++i) {
            double perc = (double)i / (double)Math.max(1, totalVertices - 1);
            out[i] = this.getPointOnPath(perc);
        }
        return out;
    }

    public void render(int vertexCount, Color c, float partialTick) {
        class_746 player = class_310.method_1551().field_1724;
        double x = player.field_6038 + (player.method_23317() - player.field_6038) * (double)partialTick;
        double y = player.field_5971 + (player.method_23318() - player.field_5971) * (double)partialTick;
        double z = player.field_5989 + (player.method_23321() - player.field_5989) * (double)partialTick;
        RenderSystem.disableTexture();
        RenderSystem.depthMask((boolean)false);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_1576);
        class_243[] avec3 = this.getLinearInterpolation(vertexCount / this.nodes.size());
        for (int i = 0; i < avec3.length; ++i) {
            this.renderVertex((class_4588)bufferBuilder, avec3[i], c, x, y, z);
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
    }

    void renderVertex(class_4588 buffer, class_243 vert, Color color, double offX, double offY, double offZ) {
        buffer.method_22912(vert.field_1352 - offX, vert.field_1351 - offY, vert.field_1350 - offZ).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
    }

    public static class Node {
        class_243 vertex;
        class_243 controlIn;
        class_243 controlOut;

        public Node(class_243 vertex, class_243 controlIn, class_243 controlOut) {
            this.vertex = vertex;
            this.controlIn = controlIn;
            this.controlOut = controlOut;
        }

        public Node(class_243 vertex, class_243 controlDir, double controlLenIn, double controlLenOut) {
            this(vertex, vertex.method_1019(controlDir.method_1029().method_1021(-controlLenIn)), vertex.method_1019(controlDir.method_1029().method_1021(controlLenOut)));
        }
    }
}

