/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.multiplayer;

import net.minecraft.class_243;
import net.minecraft.class_2664;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7438;
import net.minecraft.class_7439;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;

@Mixin(value={class_634.class})
public abstract class ClientPacketListenerVRMixin {
    @Final
    @Shadow
    private class_310 field_3690;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vivecraft$init(CallbackInfo ci) {
        if (ClientNetworking.NEEDS_RESET) {
            ClientNetworking.resetServerSettings();
            ClientNetworking.resetOnceServerSettings();
            ClientNetworking.NEEDS_RESET = false;
        }
    }

    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void vivecraft$resetOnLogin(CallbackInfo ci) {
        this.vivecraft$resetServerState();
    }

    @Inject(method={"handleRespawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V", shift=At.Shift.AFTER)})
    private void vivecraft$resetOnDimensionChange(CallbackInfo ci) {
        this.vivecraft$resetServerState();
    }

    @Unique
    private void vivecraft$resetServerState() {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        ClientNetworking.CHAT_WARNING_TIMER = 200;
        ClientNetworking.ABLE_TO_DISPLAY_CHAT_WARNINGS = false;
        ClientNetworking.TELEPORT_WARNING = true;
        ClientNetworking.VR_SWITCHING_WARNING = false;
        ClientNetworking.HEAD_AIM_WARNING = false;
        ClientNetworking.REQUESTED_DAMAGE_DIRECTION = false;
    }

    @Inject(method={"cleanup"}, at={@At(value="TAIL")})
    private void vivecraft$cleanup(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.resetOnceServerSettings();
        ClientNetworking.NEEDS_RESET = true;
    }

    @Inject(method={"handlePlayerChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsPlayer(class_7438 packet, CallbackInfo ci) {
        String lastMsg = ((PlayerExtension)this.field_3690.field_1724).vivecraft$getLastMsg();
        ((PlayerExtension)this.field_3690.field_1724).vivecraft$setLastMsg(null);
        if (VRState.VR_RUNNING && (this.field_3690.field_1724 == null || lastMsg == null || packet.comp_942().comp_926().comp_937() == this.field_3690.field_1724.method_5667())) {
            ClientUtils.triggerChatHapticSound();
        }
    }

    @Inject(method={"handleSystemChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsSystem(class_7439 packet, CallbackInfo ci) {
        String lastMsg = ((PlayerExtension)this.field_3690.field_1724).vivecraft$getLastMsg();
        ((PlayerExtension)this.field_3690.field_1724).vivecraft$setLastMsg(null);
        if (VRState.VR_RUNNING && (this.field_3690.field_1724 == null || lastMsg == null || packet.comp_763().getString().contains(lastMsg))) {
            ClientUtils.triggerChatHapticSound();
        }
    }

    @Inject(method={"handleOpenScreen"}, at={@At(value="HEAD")})
    private void vivecraft$markScreenActive(CallbackInfo ci) {
        GuiHandler.GUI_APPEAR_OVER_BLOCK_ACTIVE = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"handleExplosion"})
    public void vivecraft$handleExplosion(class_2664 clientboundExplodePacket, CallbackInfo ci) {
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().hapticTracker.handleExplode(new class_243(clientboundExplodePacket.method_11475(), clientboundExplodePacket.method_11477(), clientboundExplodePacket.method_11478()));
        }
    }
}

