/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider.openvr_lwjgl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.sun.jna.NativeLibrary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.Version;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.openvr.InputAnalogActionData;
import org.lwjgl.openvr.InputDigitalActionData;
import org.lwjgl.openvr.InputOriginInfo;
import org.lwjgl.openvr.InputPoseActionData;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.RenderModelComponentState;
import org.lwjgl.openvr.RenderModelControllerModeState;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VR;
import org.lwjgl.openvr.VRActiveActionSet;
import org.lwjgl.openvr.VRApplications;
import org.lwjgl.openvr.VRChaperone;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.openvr.VRInput;
import org.lwjgl.openvr.VRRenderModels;
import org.lwjgl.openvr.VRSettings;
import org.lwjgl.openvr.VRSystem;
import org.lwjgl.openvr.VRTextureBounds;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.FileUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.provider.ControllerTransform;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.HardwareType;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRHapticScheduler;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRStereoRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRUtil;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;
import org.vivecraft.client_vr.provider.openvr_lwjgl.control.TrackpadSwipeSampler;
import org.vivecraft.client_vr.provider.openvr_lwjgl.control.VRInputActionSet;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.utils.external.jinfinadeck;
import org.vivecraft.client_vr.utils.external.jkatvr;
import org.vivecraft.common.utils.MathUtils;

public class MCOpenVR
extends MCVR {
    protected static MCOpenVR OME;
    private static final String ACTION_EXTERNAL_CAMERA = "/actions/mixedreality/in/externalcamera";
    private static final String ACTION_LEFT_HAND = "/actions/global/in/lefthand";
    private static final String ACTION_LEFT_HAPTIC = "/actions/global/out/lefthaptic";
    private static final String ACTION_RIGHT_HAND = "/actions/global/in/righthand";
    private static final String ACTION_RIGHT_HAPTIC = "/actions/global/out/righthaptic";
    private final Map<VRInputActionSet, Long> actionSetHandles = new EnumMap<VRInputActionSet, Long>(VRInputActionSet.class);
    private VRActiveActionSet.Buffer activeActionSetsBuffer;
    private final Map<VRInputActionSet, Set<VRInputAction>> unpressedSetKeys = new EnumMap<VRInputActionSet, Set<VRInputAction>>(VRInputActionSet.class);
    private List<VRInputActionSet> activeActionSets = new ArrayList<VRInputActionSet>();
    private Map<Long, String> controllerComponentNames;
    private Map<String, Matrix4f[]> controllerComponentTransforms;
    private boolean debugInfo = true;
    private final boolean fullDebugInfo = false;
    private boolean getXforms = true;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final TrackedDevicePose.Buffer trackedDevicePoses;
    private long leftHapticHandle;
    private long rightHapticHandle;
    private long leftPoseHandle;
    private long rightPoseHandle;
    private long cameraPoseHandle;
    private final long[] deviceHandle = new long[10];
    private boolean inputInitialized;
    private final InputOriginInfo originInfo;
    private final InputPoseActionData poseData;
    private final InputDigitalActionData digital;
    private final InputAnalogActionData analog;
    private boolean paused = false;
    private final Map<String, TrackpadSwipeSampler> trackpadSwipeSamplers = new HashMap<String, TrackpadSwipeSampler>();
    private boolean triedToInit;
    private final Queue<VREvent> vrEvents = new LinkedList<VREvent>();
    private final VRTextureBounds texBounds;
    protected final Texture texType0;
    protected final Texture texType1;
    private final IntBuffer errorBuffer;
    private static final Map<String, String> STEAM_LANGUAGES;
    private static final Map<String, String> STEAM_LANGUAGE_WRONG_MAPPINGS;

    public static MCOpenVR get() {
        return OME;
    }

    public MCOpenVR(Minecraft mc, ClientDataHolderVR dh) throws RenderConfigException {
        super(mc, dh, VivecraftVRMod.INSTANCE);
        OME = this;
        String[] lwjglVersions = new String[]{"3.3.3"};
        if (Arrays.stream(lwjglVersions).noneMatch(v -> Version.getVersion().startsWith((String)v))) {
            String suppliedJar = "";
            try {
                suppliedJar = new File(Version.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
            }
            catch (Exception e) {
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: couldn't check lwjgl source:", (Throwable)e);
            }
            throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.vriniterror"), (Component)Component.translatable((String)"vivecraft.messages.rendersetupfailed", (Object[])new Object[]{I18n.get((String)"vivecraft.messages.invalidlwjgl", (Object[])new Object[]{Version.getVersion(), lwjglVersions.length == 1 ? lwjglVersions[0] : lwjglVersions[0] + " - " + lwjglVersions[lwjglVersions.length - 1], suppliedJar}), "OpenVR_LWJGL"}));
        }
        this.hapticScheduler = new OpenVRHapticScheduler();
        this.poseMatrices = new Matrix4f[64];
        this.deviceVelocity = new Vector3f[64];
        for (int i = 0; i < 64; ++i) {
            this.poseMatrices[i] = new Matrix4f();
            this.deviceVelocity[i] = new Vector3f();
        }
        for (VRInputActionSet set : VRInputActionSet.values()) {
            this.unpressedSetKeys.put(set, new HashSet());
        }
        this.poseData = InputPoseActionData.calloc();
        this.originInfo = InputOriginInfo.calloc();
        this.errorBuffer = MemoryUtil.memCallocInt((int)1);
        this.texBounds = VRTextureBounds.calloc();
        this.texType0 = Texture.calloc();
        this.texType1 = Texture.calloc();
        this.digital = InputDigitalActionData.calloc();
        this.analog = InputAnalogActionData.calloc();
        this.trackedDevicePoses = TrackedDevicePose.calloc(64);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.initialized) {
            try {
                VR.VR_ShutdownInternal();
                this.initialized = false;
                if (this.dh.katVr) {
                    jkatvr.Halt();
                }
                if (this.dh.infinadeck) {
                    jinfinadeck.Destroy();
                }
            }
            catch (Throwable throwable) {
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Error destroying OpenVR:", throwable);
            }
        }
        this.trackedDevicePoses.free();
        this.poseData.free();
        this.originInfo.free();
        this.texBounds.free();
        this.texType0.free();
        this.texType1.free();
        this.digital.free();
        this.analog.free();
        if (this.activeActionSetsBuffer != null) {
            this.activeActionSetsBuffer.free();
        }
    }

    protected static String getInputErrorName(int EVRInputError) {
        return switch (EVRInputError) {
            case 0 -> "None";
            case 1 -> "NameNotFound";
            case 2 -> "WrongType";
            case 3 -> "InvalidHandle";
            case 4 -> "InvalidParam";
            case 5 -> "NoSteam";
            case 6 -> "MaxCapacityReached";
            case 7 -> "IPCError";
            case 8 -> "NoActiveActionSet";
            case 9 -> "InvalidDevice";
            case 10 -> "InvalidSkeleton";
            case 11 -> "InvalidBoneCount";
            case 12 -> "InvalidCompressedData";
            case 13 -> "NoData";
            case 14 -> "BufferTooSmall";
            case 15 -> "MismatchedActionManifest";
            case 16 -> "MissingSkeletonData";
            case 17 -> "InvalidBoneIndex";
            case 18 -> "InvalidPriority";
            case 19 -> "PermissionDenied";
            case 20 -> "InvalidRenderModel";
            default -> "Unknown";
        };
    }

    @Override
    public String getName() {
        return "OpenVR_LWJGL";
    }

    @Override
    public Vector2fc getPlayAreaSize() {
        if (OpenVR.VRChaperone == null || OpenVR.VRChaperone.GetPlayAreaSize == 0L) {
            return null;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer pSizeZ = stack.callocFloat(1);
            FloatBuffer pSizeX = stack.callocFloat(1);
            boolean valid = VRChaperone.VRChaperone_GetPlayAreaSize(pSizeX, pSizeZ);
            Vector2f vector2f = valid ? new Vector2f(pSizeX.get(0) * this.dh.vrSettings.walkMultiplier, pSizeZ.get(0) * this.dh.vrSettings.walkMultiplier) : null;
            return vector2f;
        }
    }

    @Override
    public boolean init() throws RenderConfigException {
        if (this.initialized) {
            return true;
        }
        if (this.triedToInit) {
            return this.initialized;
        }
        this.triedToInit = true;
        try {
            this.initializeOpenVR();
            this.initOpenVRCompositor();
        }
        catch (Exception exception) {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Error initializing OpenVR:", (Throwable)exception);
            this.initSuccess = false;
            this.initStatus = exception.getLocalizedMessage();
            return false;
        }
        if (OpenVR.VRInput == null) {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Controller input not available. Forcing seated mode.");
            this.dh.vrSettings.seated = true;
        }
        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: OpenVR initialized & VR connected.");
        this.initInputAndApplication();
        this.initialized = true;
        if (this.dh.katVr) {
            try {
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Waiting for KATVR....");
                FileUtils.unpackFolder("natives/katvr", "openvr/katvr");
                NativeLibrary.addSearchPath((String)"WalkerBase.dll", (String)new File("openvr/katvr").getAbsolutePath());
                jkatvr.Init(1);
                jkatvr.Launch();
                if (jkatvr.CheckForLaunch()) {
                    org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: KATVR Loaded");
                } else {
                    org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: KATVR Failed to load");
                }
            }
            catch (Exception exception) {
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: KATVR crashed:", (Throwable)exception);
            }
        }
        if (this.dh.infinadeck) {
            try {
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Waiting for Infinadeck....");
                FileUtils.unpackFolder("natives/infinadeck", "openvr/infinadeck");
                NativeLibrary.addSearchPath((String)"InfinadeckAPI.dll", (String)new File("openvr/infinadeck").getAbsolutePath());
                if (jinfinadeck.InitConnection()) {
                    jinfinadeck.CheckConnection();
                    org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Infinadeck Loaded");
                } else {
                    org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Infinadeck Failed to load");
                }
            }
            catch (Exception exception) {
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Infinadeck crashed:", (Throwable)exception);
            }
        }
        return true;
    }

    private void initializeOpenVR() throws RuntimeException {
        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Connecting to OpenVR");
        int token = VR.VR_InitInternal(this.errorBuffer, 1);
        if (!this.isError()) {
            OpenVR.create(token);
        }
        if (OpenVR.VRApplications == null || OpenVR.VRCompositor == null || OpenVR.VRRenderModels == null || OpenVR.VRSystem == null || this.isError()) {
            if (this.isError()) {
                int error = this.getError();
                Object errorString = VR.VR_GetVRInitErrorAsEnglishDescription(error);
                if (error == 100 || error == 110) {
                    errorString = (String)errorString + "\n\n" + I18n.get((String)"vivecraft.messages.steamvrnotfound", (Object[])new Object[0]);
                    if (this.mc.gameDirectory.getPath().contains("/.var/app/")) {
                        errorString = (String)errorString + "\n\n" + I18n.get((String)"vivecraft.messages.steamvrrunningflatpak", (Object[])new Object[0]);
                    }
                }
                throw new RuntimeException((String)errorString);
            }
            throw new RuntimeException(I18n.get((String)"vivecraft.messages.outdatedsteamvr", (Object[])new Object[0]));
        }
        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: OpenVR System Initialized OK.");
        this.initSuccess = true;
    }

    @Override
    public void poll(long frameIndex) {
        if (!this.initialized) {
            return;
        }
        this.paused = VRSystem.VRSystem_ShouldApplicationPause();
        this.mc.getProfiler().push("pollEvents");
        this.pollVREvents();
        this.mc.getProfiler().popPush("processEvents");
        this.processVREvents();
        this.mc.getProfiler().popPush("updatePose/Vsync");
        this.updatePose();
        this.mc.getProfiler().popPush("processInputs");
        this.processInputs();
        this.mc.getProfiler().popPush("hmdSampling");
        this.hmdSampling();
        this.mc.getProfiler().pop();
    }

    @Override
    public void processInputs() {
        if (this.dh.vrSettings.seated || this.dh.viewOnly || !this.inputInitialized) {
            this.ignorePressesNextFrame = false;
            return;
        }
        for (VRInputAction action : this.inputActions.values()) {
            if (action.isHanded()) {
                for (ControllerType controllertype : ControllerType.values()) {
                    action.setCurrentHand(controllertype);
                    this.processInputAction(action);
                }
                continue;
            }
            this.processInputAction(action);
        }
        this.processScrollInput(GuiHandler.KEY_SCROLL_AXIS, () -> InputSimulator.scrollMouse(0.0, 1.0), () -> InputSimulator.scrollMouse(0.0, -1.0));
        this.processScrollInput(VivecraftVRMod.INSTANCE.keyHotbarScroll, () -> this.changeHotbar(-1), () -> this.changeHotbar(1));
        this.processSwipeInput(VivecraftVRMod.INSTANCE.keyHotbarSwipeX, () -> this.changeHotbar(1), () -> this.changeHotbar(-1), null, null);
        this.processSwipeInput(VivecraftVRMod.INSTANCE.keyHotbarSwipeY, null, null, () -> this.changeHotbar(-1), () -> this.changeHotbar(1));
        this.ignorePressesNextFrame = false;
    }

    private boolean isError() {
        return (long)this.errorBuffer.get(0) != 0L;
    }

    private int getError() {
        return this.errorBuffer.get(0);
    }

    private void debugOut(int deviceIndex) {
        Objects.requireNonNull(this);
        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: VR DEVICE: {}, Manufacturer: {}, Model: {}", new Object[]{deviceIndex, VRSystem.VRSystem_GetStringTrackedDeviceProperty(deviceIndex, 1005, this.errorBuffer), VRSystem.VRSystem_GetStringTrackedDeviceProperty(deviceIndex, 1001, this.errorBuffer)});
    }

    @Override
    protected ControllerType findActiveBindingControllerType(KeyMapping keyMapping) {
        if (!this.inputInitialized) {
            return null;
        }
        long origin = this.getInputAction(keyMapping).getLastOrigin();
        return origin != 0L ? this.getOriginControllerType(origin) : null;
    }

    private void generateActionManifest() {
        HashMap map = new HashMap();
        ArrayList<ImmutableMap> actionSets = new ArrayList<ImmutableMap>();
        for (VRInputActionSet actionSet : VRInputActionSet.values()) {
            String usage = actionSet.usage;
            if (actionSet.advanced && !this.dh.vrSettings.allowAdvancedBindings) {
                usage = "hidden";
            }
            actionSets.add(ImmutableMap.builder().put((Object)"name", (Object)actionSet.name).put((Object)"usage", (Object)usage).build());
        }
        map.put("action_sets", actionSets);
        ArrayList sortedActions = new ArrayList(this.inputActions.values());
        sortedActions.sort(Comparator.comparing(a -> a.keyBinding).thenComparing(a -> a.keyBinding.getName()));
        ArrayList<ImmutableMap> actions = new ArrayList<ImmutableMap>();
        for (VRInputAction action : sortedActions) {
            actions.add(ImmutableMap.builder().put((Object)"name", (Object)action.name).put((Object)"requirement", (Object)action.requirement).put((Object)"type", (Object)action.type).build());
        }
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)ACTION_LEFT_HAND).put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"pose").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)ACTION_RIGHT_HAND).put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"pose").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)ACTION_LEFT_HAPTIC).put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"vibration").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)ACTION_RIGHT_HAPTIC).put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"vibration").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)ACTION_EXTERNAL_CAMERA).put((Object)"requirement", (Object)"optional").put((Object)"type", (Object)"pose").build());
        map.put("actions", actions);
        ArrayList<Object> languages = new ArrayList<Object>();
        languages.add("en_US");
        boolean gotRegistryValue = false;
        if (Util.getPlatform() == Util.OS.WINDOWS) {
            String language = ClientUtils.readWinRegistry("HKCU\\SOFTWARE\\Valve\\Steam\\Language");
            if (language != null) {
                gotRegistryValue = true;
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Steam language setting: {}", (Object)language);
                if (!language.equals("english") && STEAM_LANGUAGES.containsKey(language)) {
                    languages.add(STEAM_LANGUAGES.get(language));
                }
            } else {
                org.vivecraft.client_vr.settings.VRSettings.LOGGER.warn("Vivecraft: Unable to read Steam language setting");
            }
        }
        if (!gotRegistryValue && !this.mc.options.languageCode.startsWith("en_")) {
            String ucLanguageCode = this.mc.options.languageCode.substring(0, this.mc.options.languageCode.indexOf(95)) + this.mc.options.languageCode.substring(this.mc.options.languageCode.indexOf(95)).toUpperCase();
            if (STEAM_LANGUAGES.containsValue(ucLanguageCode)) {
                languages.add(ucLanguageCode);
            } else {
                Optional<String> langCode = STEAM_LANGUAGES.values().stream().filter(s -> ucLanguageCode.substring(0, ucLanguageCode.indexOf(95)).equals(s.substring(0, s.indexOf(95)))).findFirst();
                langCode.ifPresent(languages::add);
            }
        }
        ArrayList localeList = new ArrayList();
        for (String string : languages) {
            HashMap<String, Object> localeMap = new HashMap<String, Object>();
            ArrayList<String> langs = new ArrayList<String>();
            langs.add("en_us");
            if (!string.equals("en_US")) {
                langs.add(string.toLowerCase());
            }
            ClientLanguage lang = ClientLanguage.loadFrom((ResourceManager)this.mc.getResourceManager(), langs, (boolean)false);
            for (VRInputAction action : sortedActions) {
                localeMap.put(action.name, lang.getOrDefault(action.keyBinding.getCategory()) + " - " + lang.getOrDefault(action.keyBinding.getName()));
            }
            for (VRInputActionSet actionSet : VRInputActionSet.values()) {
                localeMap.put(actionSet.name, lang.getOrDefault(actionSet.localizedName));
            }
            localeMap.put(ACTION_LEFT_HAND, "Left Hand Pose");
            localeMap.put(ACTION_RIGHT_HAND, "Right Hand Pose");
            localeMap.put(ACTION_LEFT_HAPTIC, "Left Hand Haptic");
            localeMap.put(ACTION_RIGHT_HAPTIC, "Right Hand Haptic");
            localeMap.put(ACTION_EXTERNAL_CAMERA, "External Camera");
            localeMap.put("language_tag", STEAM_LANGUAGE_WRONG_MAPPINGS.getOrDefault(string, string));
            localeList.add(localeMap);
        }
        map.put("localization", localeList);
        ArrayList defaults = new ArrayList();
        BiConsumer<String, String> biConsumer = (type, url) -> defaults.add(ImmutableMap.builder().put((Object)"controller_type", type).put((Object)"binding_url", url).build());
        biConsumer.accept("vive_controller", "vive_defaults.json");
        biConsumer.accept("oculus_touch", "oculus_defaults.json");
        biConsumer.accept("holographic_controller", "wmr_defaults.json");
        biConsumer.accept("knuckles", "knuckles_defaults.json");
        biConsumer.accept("vive_cosmos_controller", "cosmos_defaults.json");
        biConsumer.accept("vive_tracker_camera", "tracker_defaults.json");
        biConsumer.accept("vive_tracker_waist", "tracker_waist_defaults.json");
        biConsumer.accept("vive_tracker_left_foot", "tracker_left_foot_defaults.json");
        biConsumer.accept("vive_tracker_right_foot", "tracker_right_foot_defaults.json");
        biConsumer.accept("vive_tracker_left_elbow", "tracker_left_elbow_defaults.json");
        biConsumer.accept("vive_tracker_right_elbow", "tracker_right_elbow_defaults.json");
        biConsumer.accept("vive_tracker_left_knee", "tracker_left_knee_defaults.json");
        biConsumer.accept("vive_tracker_right_knee", "tracker_right_knee_defaults.json");
        map.put("default_bindings", defaults);
        try {
            new File("openvr/input").mkdirs();
            try (OutputStreamWriter outputstreamwriter = new OutputStreamWriter((OutputStream)new FileOutputStream("openvr/input/action_manifest.json"), StandardCharsets.UTF_8);){
                this.GSON.toJson(map, (Appendable)outputstreamwriter);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to write action manifest", exception);
        }
        String rev = this.dh.vrSettings.reverseHands ? "_reversed" : "";
        FileUtils.unpackAsset("input/vive_defaults" + rev + ".json", "openvr/input/vive_defaults.json", false);
        FileUtils.unpackAsset("input/oculus_defaults" + rev + ".json", "openvr/input/oculus_defaults.json", false);
        FileUtils.unpackAsset("input/wmr_defaults" + rev + ".json", "openvr/input/wmr_defaults.json", false);
        FileUtils.unpackAsset("input/knuckles_defaults" + rev + ".json", "openvr/input/knuckles_defaults.json", false);
        FileUtils.unpackAsset("input/cosmos_defaults" + rev + ".json", "openvr/input/cosmos_defaults.json", false);
        FileUtils.unpackAssetToFolder("input/tracker_defaults.json", "openvr", false);
    }

    private long getActionHandle(String name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer longRef = stack.callocLong(1);
            int error = VRInput.VRInput_GetActionHandle(name, longRef);
            if (error != 0) {
                throw new RuntimeException("Error getting action handle for '" + name + "': " + MCOpenVR.getInputErrorName(error));
            }
            long l = longRef.get(0);
            return l;
        }
    }

    private boolean updateActiveActionSets() {
        ArrayList<VRInputActionSet> activeSets = new ArrayList<VRInputActionSet>();
        activeSets.add(VRInputActionSet.GLOBAL);
        activeSets.add(VRInputActionSet.MOD);
        activeSets.add(VRInputActionSet.MIXED_REALITY);
        activeSets.add(VRInputActionSet.TECHNICAL);
        if (this.mc.screen == null) {
            activeSets.add(VRInputActionSet.INGAME);
            activeSets.add(VRInputActionSet.CONTEXTUAL);
        } else {
            activeSets.add(VRInputActionSet.GUI);
            if (ClientDataHolderVR.getInstance().vrSettings.ingameBindingsInGui) {
                activeSets.add(VRInputActionSet.INGAME);
            }
            if (this.mc.screen instanceof FBTCalibrationScreen) {
                activeSets.add(VRInputActionSet.CONTEXTUAL);
            }
        }
        if (KeyboardHandler.SHOWING || RadialHandler.isShowing()) {
            activeSets.add(VRInputActionSet.KEYBOARD);
        }
        if (this.activeActionSetsBuffer == null) {
            this.activeActionSetsBuffer = VRActiveActionSet.calloc(activeSets.size());
        } else if (this.activeActionSetsBuffer.capacity() != activeSets.size()) {
            this.activeActionSetsBuffer.free();
            this.activeActionSetsBuffer = VRActiveActionSet.calloc(activeSets.size());
        }
        for (int i = 0; i < activeSets.size(); ++i) {
            ((VRActiveActionSet)this.activeActionSetsBuffer.get(i)).set(this.getActionSetHandle((VRInputActionSet)((Object)activeSets.get(i))), 0L, 0L, 0);
        }
        this.activeActionSets.removeAll(activeSets);
        for (VRInputActionSet set : this.activeActionSets) {
            this.unpressedSetKeys.get((Object)set).clear();
        }
        this.activeActionSets = activeSets;
        return !activeSets.isEmpty();
    }

    @Override
    public void refreshControllerTransforms() {
        this.getXforms = true;
    }

    @Override
    public Matrix4fc getControllerComponentTransform(int controllerIndex, String componentName) {
        return this.controllerComponentTransforms != null && this.controllerComponentTransforms.containsKey(componentName) && this.controllerComponentTransforms.get(componentName)[controllerIndex] != null ? this.controllerComponentTransforms.get(componentName)[controllerIndex] : new Matrix4f();
    }

    private Matrix4fc getControllerComponentTransformFromButton(int controllerIndex, long button) {
        return this.controllerComponentNames != null && this.controllerComponentNames.containsKey(button) ? this.getControllerComponentTransform(controllerIndex, this.controllerComponentNames.get(button)) : new Matrix4f();
    }

    protected long getHapticHandle(ControllerType hand) {
        return hand == ControllerType.RIGHT ? this.rightHapticHandle : this.leftHapticHandle;
    }

    private String memUTF8NullTerminated(ByteBuffer buf) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memAddress((ByteBuffer)buf));
    }

    protected float getSuperSampling() {
        return VRSettings.VRSettings_GetFloat("steamvr", "supersampleScale", this.errorBuffer);
    }

    private void getTransforms() {
        if (this.getXforms) {
            this.controllerComponentTransforms = new HashMap<String, Matrix4f[]>();
        }
        if (this.controllerComponentNames == null) {
            this.controllerComponentNames = new HashMap<Long, String>();
        }
        int count = VRRenderModels.VRRenderModels_GetRenderModelCount();
        ArrayList<String> componentNames = new ArrayList<String>();
        componentNames.add("tip");
        componentNames.add("handgrip");
        boolean failed = false;
        for (String component : componentNames) {
            this.controllerComponentTransforms.put(component, new Matrix4f[2]);
            for (int c = 0; c < 2; ++c) {
                if (this.dh.vrSettings.controllerTransform != ControllerTransform.AUTO) {
                    org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: forcing {} controller transforms!", (Object)this.dh.vrSettings.controllerTransform);
                    this.controllerComponentTransforms.get((Object)component)[c] = component.equals("tip") ? new Matrix4f((Matrix4fc)(c == 0 ? this.dh.vrSettings.controllerTransform.tipR : this.dh.vrSettings.controllerTransform.tipL)) : new Matrix4f((Matrix4fc)(c == 0 ? this.dh.vrSettings.controllerTransform.handGripR : this.dh.vrSettings.controllerTransform.handGripL));
                } else {
                    if (this.deviceSource[c].source != DeviceSource.Source.OPENVR || this.deviceSource[c].deviceIndex == -1) {
                        failed = true;
                        continue;
                    }
                    try (MemoryStack stack = MemoryStack.stackPush();){
                        Matrix4f localTransform;
                        long sourceHandle;
                        long button;
                        ByteBuffer stringBuffer = stack.calloc(32768);
                        VRSystem.VRSystem_GetStringTrackedDeviceProperty(this.deviceSource[c].deviceIndex, 1003, stringBuffer, this.errorBuffer);
                        String renderModelName = this.memUTF8NullTerminated(stringBuffer);
                        VRSystem.VRSystem_GetStringTrackedDeviceProperty(this.deviceSource[c].deviceIndex, 1037, stringBuffer, this.errorBuffer);
                        String inputProfilePath = this.memUTF8NullTerminated(stringBuffer);
                        boolean isWMR = inputProfilePath.contains("holographic");
                        boolean isRifts = inputProfilePath.contains("rifts");
                        String componentName = component;
                        if (isWMR && component.equals("handgrip")) {
                            componentName = "body";
                        }
                        if ((button = VRRenderModels.VRRenderModels_GetComponentButtonMask(renderModelName, componentName)) > 0L) {
                            this.controllerComponentNames.put(button, component);
                        }
                        if ((sourceHandle = this.deviceHandle[c]) == 0L) {
                            failed = true;
                            continue;
                        }
                        RenderModelComponentState renderModelComponentState = RenderModelComponentState.calloc(stack);
                        boolean valid = VRRenderModels.VRRenderModels_GetComponentStateForDevicePath(renderModelName, componentName, sourceHandle, RenderModelControllerModeState.calloc(stack), renderModelComponentState);
                        if (!valid) {
                            failed = true;
                            continue;
                        }
                        this.controllerComponentTransforms.get((Object)component)[c] = localTransform = OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(renderModelComponentState.mTrackingToComponentLocal(), new Matrix4f());
                        if (c == 1 && isRifts && component.equals("handgrip")) {
                            this.controllerComponentTransforms.get((Object)component)[1] = this.controllerComponentTransforms.get(component)[0];
                        }
                    }
                }
                if (failed || c != 0) continue;
                try {
                    Matrix4fc tip = this.getControllerComponentTransform(0, "tip");
                    Matrix4fc hand = this.getControllerComponentTransform(0, "handgrip");
                    Vector3f tipVec = tip.transformDirection(MathUtils.BACK, new Vector3f());
                    Vector3f handVec = hand.transformDirection(MathUtils.BACK, new Vector3f());
                    float dot = Math.abs(tipVec.dot((Vector3fc)handVec));
                    float angleRad = (float)Math.acos(dot);
                    float angleDeg = 57.295776f * angleRad;
                    this.gunStyle = angleDeg > 10.0f;
                    this.gunAngle = angleDeg;
                    continue;
                }
                catch (Exception exception) {
                    failed = true;
                }
            }
            this.getXforms = failed;
        }
    }

    private void initInputAndApplication() throws RenderConfigException {
        this.populateInputActions();
        if (OpenVR.VRInput == null) {
            return;
        }
        this.generateActionManifest();
        this.loadActionManifest();
        this.loadActionHandles();
        this.installApplicationManifest(false);
        this.inputInitialized = true;
    }

    private void initOpenVRCompositor() {
        VRCompositor.VRCompositor_SetTrackingSpace(1);
        String actualTrackingSpace = switch (VRCompositor.VRCompositor_GetTrackingSpace()) {
            case 0 -> "seated";
            case 1 -> "standing";
            case 2 -> "raw uncalibrated";
            default -> "unknown";
        };
        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: TrackingSpace: {}", (Object)actualTrackingSpace);
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer stringBuffer = stack.calloc(20);
            VRSystem.VRSystem_GetStringTrackedDeviceProperty(0, 1005, stringBuffer, this.errorBuffer);
            String deviceName = this.memUTF8NullTerminated(stringBuffer);
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Device manufacturer is: {}", (Object)deviceName);
            this.detectedHardware = HardwareType.fromManufacturer(deviceName);
        }
        this.texBounds.uMax(1.0f);
        this.texBounds.uMin(0.0f);
        this.texBounds.vMax(1.0f);
        this.texBounds.vMin(0.0f);
        this.texType0.eColorSpace(1);
        this.texType0.eType(1);
        this.texType0.handle(-1L);
        this.texType1.eColorSpace(1);
        this.texType1.eType(1);
        this.texType1.handle(-1L);
        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: OpenVR Compositor initialized OK.");
    }

    private void checkPathValid(String path, String knownError, boolean alwaysThrow) throws RenderConfigException {
        Object pathFormatted = "";
        boolean hasInvalidChars = false;
        for (char c : path.toCharArray()) {
            if (c > '\u007f') {
                hasInvalidChars = true;
                pathFormatted = (String)pathFormatted + "\u00a7c" + c + "\u00a7r";
                continue;
            }
            pathFormatted = (String)pathFormatted + c;
        }
        if (hasInvalidChars || alwaysThrow) {
            String error = knownError + (hasInvalidChars ? "\nInvalid characters in path: \n" : "\n");
            if (hasInvalidChars) {
                throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.vriniterror"), (Component)Component.translatable((String)"vivecraft.messages.steamvrInvalidCharacters", (Object[])new Object[]{pathFormatted}));
            }
            throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.vriniterror"), (Component)Component.empty().append(error).append((String)pathFormatted));
        }
    }

    private void installApplicationManifest(boolean force) throws RenderConfigException {
        int pid;
        String appKey;
        File manifestFile = new File("openvr/vivecraft.vrmanifest");
        FileUtils.unpackAssetToFolder("vivecraft.vrmanifest", "openvr", true);
        File customFile = new File("openvr/custom.vrmanifest");
        if (customFile.exists()) {
            manifestFile = customFile;
        }
        try (FileReader fileReader = new FileReader(manifestFile);){
            Map map = (Map)this.GSON.fromJson((Reader)fileReader, Map.class);
            appKey = ((Map)((List)map.get("applications")).get(0)).get("app_key").toString();
        }
        catch (Exception e) {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Error reading appkey from manifest:", (Throwable)e);
            return;
        }
        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Appkey: {}", (Object)appKey);
        this.checkPathValid(manifestFile.getAbsolutePath(), "Failed to install application manifest", false);
        if (!force && VRApplications.VRApplications_IsApplicationInstalled(appKey)) {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Application manifest already installed");
        } else {
            int error = VRApplications.VRApplications_AddApplicationManifest(manifestFile.getAbsolutePath(), true);
            if (error != 0) {
                this.checkPathValid(manifestFile.getAbsolutePath(), "Failed to install application manifest: " + VRApplications.VRApplications_GetApplicationsErrorNameFromEnum(error), true);
            }
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Application manifest installed successfully");
        }
        try {
            String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
            pid = Integer.parseInt(runtimeName.split("@")[0]);
        }
        catch (Exception e) {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Error getting process id:", (Throwable)e);
            return;
        }
        int error = VRApplications.VRApplications_IdentifyApplication(pid, appKey);
        if (error != 0) {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Failed to identify application: {}", (Object)VRApplications.VRApplications_GetApplicationsErrorNameFromEnum(error));
        } else {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: Application identified successfully");
        }
    }

    private void loadActionHandles() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer longRef = stack.callocLong(1);
            for (VRInputAction action : this.inputActions.values()) {
                int error = VRInput.VRInput_GetActionHandle(action.name, longRef);
                if (error != 0) {
                    throw new RuntimeException("Error getting action handle for '" + action.name + "': " + MCOpenVR.getInputErrorName(error));
                }
                action.setHandle(longRef.get(0));
            }
            this.rightPoseHandle = this.getActionHandle(ACTION_RIGHT_HAND);
            this.leftPoseHandle = this.getActionHandle(ACTION_LEFT_HAND);
            this.rightHapticHandle = this.getActionHandle(ACTION_RIGHT_HAPTIC);
            this.leftHapticHandle = this.getActionHandle(ACTION_LEFT_HAPTIC);
            this.cameraPoseHandle = this.getActionHandle(ACTION_EXTERNAL_CAMERA);
            for (VRInputActionSet actionSet : VRInputActionSet.values()) {
                int error = VRInput.VRInput_GetActionSetHandle(actionSet.name, longRef);
                if (error != 0) {
                    throw new RuntimeException("Error getting action set handle for '" + actionSet.name + "': " + MCOpenVR.getInputErrorName(error));
                }
                this.actionSetHandles.put(actionSet, longRef.get(0));
            }
            this.deviceHandle[0] = this.getInputSourceHandle("/user/hand/right");
            this.deviceHandle[1] = this.getInputSourceHandle("/user/hand/left");
            this.deviceHandle[2] = this.getInputSourceHandle("/user/camera");
            this.deviceHandle[3] = this.getInputSourceHandle("/user/waist");
            this.deviceHandle[4] = this.getInputSourceHandle("/user/foot/right");
            this.deviceHandle[5] = this.getInputSourceHandle("/user/foot/left");
            this.deviceHandle[6] = this.getInputSourceHandle("/user/elbow/right");
            this.deviceHandle[7] = this.getInputSourceHandle("/user/elbow/left");
            this.deviceHandle[8] = this.getInputSourceHandle("/user/knee/right");
            this.deviceHandle[9] = this.getInputSourceHandle("/user/knee/left");
        }
    }

    private void loadActionManifest() throws RenderConfigException {
        String actionsPath = new File("openvr/input/action_manifest.json").getAbsolutePath();
        this.checkPathValid(actionsPath, "Failed to install action manifest", false);
        int error = VRInput.VRInput_SetActionManifestPath(actionsPath);
        if (error != 0) {
            throw new RenderConfigException((Component)Component.translatable((String)"vivecraft.messages.vriniterror"), (Component)Component.literal((String)("Failed to load action manifest: " + MCOpenVR.getInputErrorName(error))));
        }
    }

    private void processInputAction(VRInputAction action) {
        if (action.isActive() && action.isEnabledRaw() && (!ClientDataHolderVR.getInstance().vrSettings.ingameBindingsInGui || action.actionSet != VRInputActionSet.INGAME || action.keyBinding.key != InputConstants.Type.MOUSE.getOrCreate(0) || this.mc.screen == null)) {
            if (action.isButtonChanged()) {
                if (action.isButtonPressed() && action.isEnabled()) {
                    if (!this.ignorePressesNextFrame || this.canActionBeRepressed(action)) {
                        this.pressAction(action);
                    }
                } else {
                    this.unpressAction(action);
                }
            } else if (action.isButtonPressed() && action.isEnabled() && !action.keyBinding.isDown() && this.canActionBeRepressed(action)) {
                this.pressAction(action);
            }
        } else if (this.checkIfNotMovement(action)) {
            this.unpressAction(action);
        }
    }

    private boolean canActionBeRepressed(VRInputAction action) {
        return action.actionSet == VRInputActionSet.INGAME && this.unpressedSetKeys.get((Object)action.actionSet).contains(action);
    }

    private void pressAction(VRInputAction action) {
        action.pressBinding();
        this.unpressedSetKeys.get((Object)action.actionSet).remove(action);
    }

    private void unpressAction(VRInputAction action) {
        if (!this.activeActionSets.contains((Object)action.actionSet) && action.isButtonChanged()) {
            this.unpressedSetKeys.get((Object)action.actionSet).add(action);
        }
        action.unpressBinding();
    }

    private boolean checkIfNotMovement(VRInputAction action) {
        return action.keyBinding != this.mc.options.keyLeft && action.keyBinding != this.mc.options.keyRight && action.keyBinding != this.mc.options.keyUp && action.keyBinding != this.mc.options.keyDown || !this.isMovement;
    }

    private void processScrollInput(KeyMapping keyMapping, Runnable upCallback, Runnable downCallback) {
        float value;
        VRInputAction action = this.getInputAction(keyMapping);
        if (action.isEnabled() && action.getLastOrigin() != 0L && (value = action.getAxis2D(false).y()) != 0.0f) {
            if (value > 0.0f) {
                upCallback.run();
            } else if (value < 0.0f) {
                downCallback.run();
            }
        }
    }

    private void processSwipeInput(KeyMapping keyMapping, Runnable leftCallback, Runnable rightCallback, Runnable upCallback, Runnable downCallback) {
        ControllerType controller;
        VRInputAction action = this.getInputAction(keyMapping);
        if (action.isEnabled() && action.getLastOrigin() != 0L && (controller = this.findActiveBindingControllerType(keyMapping)) != null) {
            if (!this.trackpadSwipeSamplers.containsKey(keyMapping.getName())) {
                this.trackpadSwipeSamplers.put(keyMapping.getName(), new TrackpadSwipeSampler());
            }
            TrackpadSwipeSampler trackpadswipesampler = this.trackpadSwipeSamplers.get(keyMapping.getName());
            trackpadswipesampler.update(controller, action.getAxis2D(false));
            if (trackpadswipesampler.isSwipedUp() && upCallback != null) {
                this.triggerHapticPulse(controller, 0.001f, 400.0f, 0.5f);
                upCallback.run();
            }
            if (trackpadswipesampler.isSwipedDown() && downCallback != null) {
                this.triggerHapticPulse(controller, 0.001f, 400.0f, 0.5f);
                downCallback.run();
            }
            if (trackpadswipesampler.isSwipedLeft() && leftCallback != null) {
                this.triggerHapticPulse(controller, 0.001f, 400.0f, 0.5f);
                leftCallback.run();
            }
            if (trackpadswipesampler.isSwipedRight() && rightCallback != null) {
                this.triggerHapticPulse(controller, 0.001f, 400.0f, 0.5f);
                rightCallback.run();
            }
        }
    }

    private void pollVREvents() {
        VREvent vrEvent = VREvent.calloc();
        while (VRSystem.VRSystem_PollNextEvent(vrEvent, VREvent.SIZEOF)) {
            this.vrEvents.add(vrEvent);
            vrEvent = VREvent.calloc();
        }
        vrEvent.free();
    }

    /*
     * Unable to fully structure code
     */
    private void processVREvents() {
lbl1:
        // 7 sources

        block9: while (!this.vrEvents.isEmpty()) {
            event = this.vrEvents.poll();
            try {
                switch (event.eventType()) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 108: 
                    case 853: {
                        this.getXforms = true;
                        ** break;
                    }
                    case 700: {
                        if (ClientDataHolderVR.getInstance().vrSettings.closeWithRuntime) {
                            org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: SteamVR closed, closing the game with it");
                            this.mc.stop();
                            ** break;
                        }
                        org.vivecraft.client_vr.settings.VRSettings.LOGGER.info("Vivecraft: SteamVR closed, disabling VR");
                        VRState.VR_ENABLED = false;
                        ClientDataHolderVR.getInstance().vrSettings.vrEnabled = false;
                        ClientDataHolderVR.getInstance().vrSettings.saveOptions();
                        continue block9;
                    }
                    ** default:
lbl19:
                    // 1 sources

                    continue block9;
                }
            }
            finally {
                if (event == null) continue;
                event.close();
            }
        }
    }

    private void readOriginInfo(long inputValueHandle) {
        int error = VRInput.VRInput_GetOriginTrackedDeviceInfo(inputValueHandle, this.originInfo, InputOriginInfo.SIZEOF);
        if (error != 0) {
            throw new RuntimeException("Error reading origin info: " + MCOpenVR.getInputErrorName(error));
        }
    }

    private boolean readOriginInfoNoError(long inputValueHandle) {
        int error = VRInput.VRInput_GetOriginTrackedDeviceInfo(inputValueHandle, this.originInfo, InputOriginInfo.SIZEOF);
        return error == 0;
    }

    private void readPoseData(long poseHandle) {
        int error = VRInput.VRInput_GetPoseActionDataForNextFrame(poseHandle, 1, this.poseData, InputPoseActionData.SIZEOF, 0L);
        if (error != 0) {
            throw new RuntimeException("Error reading pose data: " + MCOpenVR.getInputErrorName(error));
        }
    }

    private void updateControllerPose(int controller, long actionHandle) {
        this.readPoseData(actionHandle);
        if (this.poseData.activeOrigin() != 0L) {
            TrackedDevicePose pose;
            this.readOriginInfo(this.poseData.activeOrigin());
            int deviceIndex = this.originInfo.trackedDeviceIndex();
            if (this.deviceSource[controller].source != DeviceSource.Source.OPENVR || deviceIndex != this.deviceSource[controller].deviceIndex) {
                this.deviceSource[controller].set(DeviceSource.Source.OPENVR, deviceIndex);
                this.getXforms = true;
            }
            this.deviceSource[controller].deviceIndex = deviceIndex;
            if (deviceIndex != -1 && (pose = this.poseData.pose()).bPoseIsValid()) {
                OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(pose.mDeviceToAbsoluteTracking(), this.poseMatrices[deviceIndex]);
                HmdVector3 velocity = pose.vVelocity();
                this.deviceVelocity[deviceIndex].set(velocity.v(0), velocity.v(1), velocity.v(2));
                this.controllerPose[controller].set((Matrix4fc)this.poseMatrices[deviceIndex]);
                this.controllerTracking[controller] = true;
                return;
            }
        } else {
            this.deviceSource[controller].reset();
        }
        this.controllerTracking[controller] = false;
    }

    private void updateTrackerPose(int controller, boolean fetchDeviceIndex) {
        if (fetchDeviceIndex) {
            if (this.readOriginInfoNoError(this.deviceHandle[controller])) {
                int deviceIndex = this.originInfo.trackedDeviceIndex();
                this.deviceSource[controller].set(DeviceSource.Source.OPENVR, deviceIndex);
            } else {
                this.deviceSource[controller].reset();
            }
        }
        if (this.deviceSource[controller].source == DeviceSource.Source.OPENVR && this.deviceSource[controller].deviceIndex != -1 && VRSystem.VRSystem_IsTrackedDeviceConnected(this.deviceSource[controller].deviceIndex)) {
            this.controllerPose[controller].set((Matrix4fc)this.poseMatrices[this.deviceSource[controller].deviceIndex]);
            this.controllerTracking[controller] = true;
            return;
        }
        this.deviceSource[controller].reset();
        this.controllerTracking[controller] = false;
    }

    private void updatePose() {
        int error = VRCompositor.VRCompositor_WaitGetPoses(this.trackedDevicePoses, null);
        if (error > 0) {
            org.vivecraft.client_vr.settings.VRSettings.LOGGER.error("Vivecraft: Compositor Error: GetPoseError {}", (Object)OpenVRStereoRenderer.getCompositorError(error));
        }
        if (error == 101) {
            this.triggerHapticPulse(0, 500);
            this.triggerHapticPulse(1, 500);
        }
        if (this.getXforms) {
            this.getTransforms();
        } else if (this.debugInfo) {
            this.debugInfo = false;
            this.debugOut(0);
            this.debugOut(this.deviceSource[0].deviceIndex);
            this.debugOut(this.deviceSource[1].deviceIndex);
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            HmdMatrix34 temp = HmdMatrix34.calloc(stack);
            OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(VRSystem.VRSystem_GetEyeToHeadTransform(0, temp), this.hmdPoseLeftEye);
            OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(VRSystem.VRSystem_GetEyeToHeadTransform(1, temp), this.hmdPoseRightEye);
        }
        for (int device = 0; device < 64; ++device) {
            TrackedDevicePose pose = (TrackedDevicePose)this.trackedDevicePoses.get(device);
            if (!pose.bPoseIsValid()) continue;
            OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(pose.mDeviceToAbsoluteTracking(), this.poseMatrices[device]);
            HmdVector3 velocity = pose.vVelocity();
            this.deviceVelocity[device].set(velocity.v(0), velocity.v(1), velocity.v(2));
        }
        if (((TrackedDevicePose)this.trackedDevicePoses.get(0)).bPoseIsValid()) {
            this.hmdPose.set((Matrix4fc)this.poseMatrices[0]);
            this.headIsTracking = true;
        } else {
            this.headIsTracking = false;
            this.hmdPose.identity();
            this.hmdPose.m31(1.62f);
        }
        if (this.inputInitialized) {
            int updateError;
            this.mc.getProfiler().push("updateActionState");
            if (this.updateActiveActionSets() && (updateError = VRInput.VRInput_UpdateActionState(this.activeActionSetsBuffer, VRActiveActionSet.SIZEOF)) != 0) {
                throw new RuntimeException("Error updating action state: code " + MCOpenVR.getInputErrorName(updateError));
            }
            this.inputActions.values().forEach(this::readNewData);
            this.mc.getProfiler().pop();
            if (this.dh.vrSettings.reverseHands) {
                this.updateControllerPose(0, this.leftPoseHandle);
                this.updateControllerPose(1, this.rightPoseHandle);
            } else {
                this.updateControllerPose(0, this.rightPoseHandle);
                this.updateControllerPose(1, this.leftPoseHandle);
            }
            this.updateControllerPose(2, this.cameraPoseHandle);
            for (int i = 3; i < 10; ++i) {
                if (this.deviceSource[i].source == DeviceSource.Source.OSC && this.oscTrackers.trackers[this.deviceSource[i].deviceIndex].isTracking()) continue;
                this.updateTrackerPose(i, !this.usingUnlabeledTrackers);
            }
        }
        this.updateAim();
    }

    private long getActionSetHandle(VRInputActionSet actionSet) {
        return this.actionSetHandles.get((Object)actionSet);
    }

    private long getControllerHandle(ControllerType hand) {
        if (this.dh.vrSettings.reverseHands) {
            return this.deviceHandle[hand == ControllerType.RIGHT ? 1 : 0];
        }
        return this.deviceHandle[hand == ControllerType.RIGHT ? 0 : 1];
    }

    private long getInputSourceHandle(String path) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer longRef = stack.callocLong(1);
            int error = VRInput.VRInput_GetInputSourceHandle(path, longRef);
            if (error != 0) {
                throw new RuntimeException("Error getting input source handle for '" + path + "': " + MCOpenVR.getInputErrorName(error));
            }
            long l = longRef.get(0);
            return l;
        }
    }

    protected ControllerType getOriginControllerType(long inputValueHandle) {
        if (inputValueHandle != 0L) {
            this.readOriginInfo(inputValueHandle);
            if (this.originInfo.trackedDeviceIndex() != -1) {
                if (this.deviceSource[0].source == DeviceSource.Source.OPENVR && this.originInfo.trackedDeviceIndex() == this.deviceSource[0].deviceIndex) {
                    return ControllerType.RIGHT;
                }
                if (this.deviceSource[1].source == DeviceSource.Source.OPENVR && this.originInfo.trackedDeviceIndex() == this.deviceSource[1].deviceIndex) {
                    return ControllerType.LEFT;
                }
            }
        }
        return null;
    }

    private void readNewData(VRInputAction action) {
        switch (action.type) {
            case "boolean": {
                if (action.isHanded()) {
                    for (ControllerType type : ControllerType.values()) {
                        this.readDigitalData(action, type);
                    }
                    break;
                }
                this.readDigitalData(action, null);
                break;
            }
            case "vector1": 
            case "vector2": 
            case "vector3": {
                if (action.isHanded()) {
                    for (ControllerType type : ControllerType.values()) {
                        this.readAnalogData(action, type);
                    }
                    break;
                }
                this.readAnalogData(action, null);
            }
        }
    }

    private void readDigitalData(VRInputAction action, ControllerType hand) {
        int index = hand != null ? hand.ordinal() : 0;
        int error = VRInput.VRInput_GetDigitalActionData(action.handle, this.digital, InputDigitalActionData.SIZEOF, hand != null ? this.getControllerHandle(hand) : 0L);
        if (error != 0) {
            throw new RuntimeException("Error reading digital data for '" + action.name + "': " + MCOpenVR.getInputErrorName(error));
        }
        action.digitalData[index].activeOrigin = this.digital.activeOrigin();
        action.digitalData[index].isActive = this.digital.bActive();
        action.digitalData[index].state = this.digital.bState();
        action.digitalData[index].isChanged = this.digital.bChanged();
    }

    private void readAnalogData(VRInputAction action, ControllerType hand) {
        int index = hand != null ? hand.ordinal() : 0;
        int error = VRInput.VRInput_GetAnalogActionData(action.handle, this.analog, InputAnalogActionData.SIZEOF, hand != null ? this.getControllerHandle(hand) : 0L);
        if (error != 0) {
            throw new RuntimeException("Error reading analog data for '" + action.name + "': " + MCOpenVR.getInputErrorName(error));
        }
        action.analogData[index].x = this.analog.x();
        action.analogData[index].y = this.analog.y();
        action.analogData[index].z = this.analog.z();
        action.analogData[index].deltaX = this.analog.deltaX();
        action.analogData[index].deltaY = this.analog.deltaY();
        action.analogData[index].deltaZ = this.analog.deltaZ();
        action.analogData[index].activeOrigin = this.analog.activeOrigin();
        action.analogData[index].isActive = this.analog.bActive();
    }

    @Override
    public void calibrateFBT(float headsetYaw) {
        for (int i = 3; i < 10; ++i) {
            this.updateTrackerPose(i, true);
        }
        super.calibrateFBT(headsetYaw);
    }

    private List<Integer> getTrackerIds() {
        ArrayList<Integer> trackers = new ArrayList<Integer>();
        for (int device = 0; device < 64; ++device) {
            if (!VRSystem.VRSystem_IsTrackedDeviceConnected(device) || VRSystem.VRSystem_GetTrackedDeviceClass(device) != 3) continue;
            trackers.add(device);
        }
        return trackers;
    }

    @Override
    public List<Triple<DeviceSource, Integer, Matrix4fc>> getTrackers() {
        List<Triple<DeviceSource, Integer, Matrix4fc>> trackers = super.getTrackers();
        List<Integer> ovrTrackers = this.getTrackerIds();
        Vector3f offset = new Vector3f();
        if (!this.dh.vrSettings.seated && this.dh.vrSettings.allowStandingOriginOffset && this.dh.vr.isHMDTracking()) {
            offset.set((Vector3fc)this.dh.vrSettings.originOffset);
        }
        for (int tracker : ovrTrackers) {
            int type = -1;
            for (int i = 0; i < 10; ++i) {
                if (!this.deviceSource[i].is(DeviceSource.Source.OPENVR, tracker)) continue;
                type = i;
                break;
            }
            if (!trackers.stream().noneMatch(t -> ((DeviceSource)t.getLeft()).is(DeviceSource.Source.OPENVR, tracker))) continue;
            trackers.add((Triple<DeviceSource, Integer, Matrix4fc>)Triple.of((Object)new DeviceSource(DeviceSource.Source.OPENVR, tracker), (Object)type, (Object)MathUtils.addTranslation(new Matrix4f((Matrix4fc)this.poseMatrices[tracker]), offset)));
        }
        return trackers;
    }

    @Override
    public List<Long> getOrigins(VRInputAction action) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (OpenVR.VRInput != null) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                LongBuffer longRef = stack.callocLong(16);
                int error = VRInput.VRInput_GetActionOrigins(this.getActionSetHandle(action.actionSet), action.handle, longRef);
                if (error != 0) {
                    throw new RuntimeException("Error getting action origins for '" + action.name + "': " + MCOpenVR.getInputErrorName(error));
                }
                while (longRef.remaining() > 0) {
                    long handle = longRef.get();
                    if (handle == 0L) continue;
                    list.add(handle);
                }
            }
        }
        return list;
    }

    @Override
    public String getOriginName(long origin) {
        if (OpenVR.VRInput == null) {
            return "";
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer str = stack.calloc(32768);
            int error = VRInput.VRInput_GetOriginLocalizedName(origin, str, 5);
            if (error != 0) {
                throw new RuntimeException("Error getting origin name: " + MCOpenVR.getInputErrorName(error));
            }
            String string = this.memUTF8NullTerminated(str);
            return string;
        }
    }

    @Override
    public VRRenderer createVRRenderer() {
        return new OpenVRStereoRenderer(this);
    }

    @Override
    public boolean isActive() {
        int activityLevel = VRSystem.VRSystem_GetTrackedDeviceActivityLevel(0);
        return activityLevel == 1 || activityLevel == 2;
    }

    @Override
    public float getIPD() {
        return VRSystem.VRSystem_GetFloatTrackedDeviceProperty(0, 2003, this.errorBuffer);
    }

    @Override
    public String getRuntimeName() {
        return "SteamVR";
    }

    static {
        STEAM_LANGUAGES = Map.ofEntries(Map.entry("english", "en_US"), Map.entry("bulgarian", "bg_BG"), Map.entry("schinese", "zh_CN"), Map.entry("tchinese", "zh_TW"), Map.entry("czech", "cs_CZ"), Map.entry("danish", "da_DK"), Map.entry("dutch", "nl_NL"), Map.entry("finnish", "fi_FI"), Map.entry("french", "fr_FR"), Map.entry("german", "de_DE"), Map.entry("greek", "el_GR"), Map.entry("hungarian", "hu_HU"), Map.entry("indonesian", "id_ID"), Map.entry("italian", "it_IT"), Map.entry("japanese", "ja_JP"), Map.entry("koreana", "ko_KR"), Map.entry("norwegian", "no_NO"), Map.entry("polish", "pl_PL"), Map.entry("portuguese", "pt_PT"), Map.entry("brazilian", "pt_BR"), Map.entry("romanian", "ro_RO"), Map.entry("russian", "ru_RU"), Map.entry("spanish", "es_ES"), Map.entry("latam", "es_MX"), Map.entry("swedish", "sv_SE"), Map.entry("thai", "th_TH"), Map.entry("turkish", "tr_TR"), Map.entry("ukrainian", "uk_UA"), Map.entry("vietnamese", "vi_VN"));
        STEAM_LANGUAGE_WRONG_MAPPINGS = Map.ofEntries(Map.entry("cs_CZ", "cs_CS"), Map.entry("da_DK", "da_DA"), Map.entry("el_GR", "el_EL"), Map.entry("sv_SE", "sv_SV"));
    }
}

