/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.vivecraft.client_vr.utils.RGBAColor;

public class ColoredButton
extends Button {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    private final RGBAColor color = new RGBAColor();

    public ColoredButton(Component message, int x, int y, int width, int height, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
    }

    public RGBAColor getColor() {
        return this.color;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.colorFromFloat((float)this.alpha, (float)this.color.r, (float)this.color.g, (float)this.color.b));
        int i = ARGB.color((float)this.alpha, (int)(this.active ? -1 : -6250336));
        this.renderString(guiGraphics, minecraft.font, i);
    }
}

