/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRMovementStyle;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveBlockTags;

public class TeleportTracker
implements Tracker {
    private float teleportEnergy;
    private Vec3 movementTeleportDestination = Vec3.ZERO;
    private Direction movementTeleportDestinationSideHit;
    public double movementTeleportProgress;
    public double movementTeleportDistance;
    private int movementTeleportTimer = 0;
    private final Vec3[] movementTeleportArc = new Vec3[50];
    public int movementTeleportArcSteps = 0;
    public double lastTeleportArcDisplayOffset = 0.0;
    public VRMovementStyle vrMovementStyle;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public TeleportTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
        this.vrMovementStyle = new VRMovementStyle();
    }

    public float getTeleportEnergy() {
        return this.teleportEnergy;
    }

    public boolean isAiming() {
        return this.movementTeleportProgress > 0.0;
    }

    public Vec3 getDestination() {
        return this.movementTeleportDestination;
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (p == null) {
            return false;
        }
        if (this.mc.gameMode == null) {
            return false;
        }
        if (!p.isAlive()) {
            return false;
        }
        return !p.isSleeping();
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.movementTeleportDestination = Vec3.ZERO;
        this.movementTeleportArcSteps = 0;
        this.movementTeleportProgress = 0.0;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        boolean seatedTeleport;
        Random random = new Random();
        if (this.teleportEnergy < 100.0f) {
            this.teleportEnergy += 1.0f;
        }
        boolean doTeleport = false;
        Vec3 destination = null;
        boolean bindingTeleport = VivecraftVRMod.INSTANCE.keyTeleport.isDown() && this.dh.vrPlayer.isTeleportEnabled();
        boolean bl = seatedTeleport = this.dh.vrSettings.seated && !this.dh.vrPlayer.getFreeMove() && (player.input.getMoveVector().y != 0.0f || player.input.getMoveVector().x != 0.0f);
        if ((bindingTeleport || seatedTeleport) && !player.isPassenger()) {
            destination = this.movementTeleportDestination;
            if (this.vrMovementStyle.teleportOnRelease || this.movementTeleportTimer >= 0 && (destination.x != 0.0 || destination.y != 0.0 || destination.z != 0.0)) {
                if (this.movementTeleportTimer == 0 && this.vrMovementStyle.startTeleportingSound != null) {
                    player.playSound(this.vrMovementStyle.startTeleportingSound, this.vrMovementStyle.startTeleportingSoundVolume, 1.0f / (random.nextFloat() * 0.4f + 1.2f) + 0.5f);
                }
                ++this.movementTeleportTimer;
                if (this.movementTeleportTimer > 0) {
                    if (this.vrMovementStyle.teleportOnRelease) {
                        this.movementTeleportProgress = 1.0;
                    } else {
                        Vec3 playerPos = player.position();
                        double dist = destination.distanceTo(playerPos);
                        this.movementTeleportProgress = (double)this.movementTeleportTimer / (dist + 3.0);
                    }
                    if (destination.x != 0.0 || destination.y != 0.0 || destination.z != 0.0) {
                        if (this.vrMovementStyle.destinationSparkles) {
                            // empty if block
                        }
                        if (this.vrMovementStyle.airSparkles) {
                            Vec3 eyeCenterPos = this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition();
                            if (!this.vrMovementStyle.teleportOnRelease) {
                                eyeCenterPos = player.position();
                            }
                            Vec3 motionDir = destination.subtract(eyeCenterPos).normalize();
                            Vec3 forward = player.getLookAngle();
                            Vec3 right = forward.cross(MathUtils.UP_D);
                            Vec3 up = right.cross(forward);
                            for (int iParticle = 0; iParticle < 3; ++iParticle) {
                                double forwardDist = random.nextDouble() + 3.5;
                                double upDist = random.nextDouble() * 2.5;
                                double rightDist = random.nextDouble() * 4.0 - 2.0;
                                Vec3 sparkPos = new Vec3(eyeCenterPos.x + forward.x * forwardDist, eyeCenterPos.y + forward.y * forwardDist, eyeCenterPos.z + forward.z * forwardDist);
                                sparkPos = sparkPos.add(right.x * rightDist, right.y * rightDist, right.z * rightDist);
                                sparkPos.add(up.x * upDist, up.y * upDist, up.z * upDist);
                                double d = -0.6;
                            }
                        }
                    }
                } else if (!this.vrMovementStyle.teleportOnRelease) {
                    this.movementTeleportProgress = 0.0;
                }
                if (!this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                    doTeleport = true;
                }
            }
        } else {
            if (this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                destination = this.movementTeleportDestination;
                doTeleport = true;
            }
            this.movementTeleportTimer = 0;
            this.movementTeleportProgress = 0.0;
        }
        if (doTeleport && destination != null && (destination.x != 0.0 || destination.y != 0.0 || destination.z != 0.0)) {
            this.movementTeleportDistance = destination.distanceTo(player.position());
            if (!this.dh.vrPlayer.isTeleportSupported()) {
                String command = "tp " + destination.x + " " + destination.y + " " + destination.z;
                player.connection.sendCommand(command);
            } else {
                if (ClientNetworking.SERVER_SUPPORTS_DIRECT_TELEPORT) {
                    ((PlayerExtension)player).vivecraft$setTeleported(true);
                }
                player.snapTo(destination.x, destination.y, destination.z);
            }
            this.doTeleportCallback();
            if (this.movementTeleportDistance > 0.0 && this.vrMovementStyle.endTeleportingSound != null) {
                player.playSound(this.vrMovementStyle.endTeleportingSound, this.vrMovementStyle.endTeleportingSoundVolume, 1.0f);
            } else {
                ((PlayerExtension)player).vivecraft$stepSound(BlockPos.containing((Position)destination), destination);
            }
        }
    }

    public void updateTeleportDestinations(LocalPlayer player) {
        Profiler.get().push("updateTeleportDestinations");
        if (this.vrMovementStyle.arcAiming) {
            this.movementTeleportDestination = Vec3.ZERO;
            if (this.movementTeleportProgress > 0.0) {
                this.updateTeleportArc(player);
            }
        }
        Profiler.get().pop();
    }

    private void updateTeleportArc(LocalPlayer player) {
        int controller = this.dh.vrSettings.seated ? 0 : 1;
        Vec3 start = RenderHelper.getControllerRenderPos(controller);
        VRData.VRDevicePose controllerWorld = this.dh.vrPlayer.vrdata_world_render.getController(controller);
        int maxSteps = 50;
        this.movementTeleportArc[0] = new Vec3(start.x, start.y, start.z);
        this.movementTeleportArcSteps = 1;
        float gravityAcceleration = 0.098f;
        Vector3f gravity = controllerWorld.getMatrix().rotateZ(controllerWorld.getRollRad()).transformDirection(MathUtils.DOWN, new Vector3f()).mul(0.098f);
        float speed = 0.5f;
        Vector3f velocity = controllerWorld.getDirection().mul(0.5f);
        Vec3 pos = new Vec3(start.x, start.y, start.z);
        for (int i = this.movementTeleportArcSteps; i < maxSteps && (float)(i * 4) <= this.teleportEnergy; ++i) {
            Vec3 newPos = new Vec3(pos.x + (double)velocity.x, pos.y + (double)velocity.y, pos.z + (double)velocity.z);
            BlockHitResult blockhitresult = this.mc.level.clip(new ClipContext(pos, newPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            if (blockhitresult.getType() != HitResult.Type.MISS) {
                boolean ok;
                this.movementTeleportArc[i] = blockhitresult.getLocation();
                this.movementTeleportArcSteps = i + 1;
                this.checkAndSetTeleportDestination(player, start, blockhitresult);
                Vec3 diff = player.position().subtract(this.movementTeleportDestination);
                double yDiff = diff.y;
                this.movementTeleportDistance = diff.length();
                double xzDiff = Math.sqrt(diff.x * diff.x + diff.z * diff.z);
                boolean bl = ok = !player.isShiftKeyDown() || !(yDiff > 0.2);
                if (!player.getAbilities().mayfly && ClientNetworking.isLimitedSurvivalTeleport()) {
                    if (ClientNetworking.getTeleportDownLimit() > 0 && yDiff > (double)ClientNetworking.getTeleportDownLimit() + 0.2) {
                        ok = false;
                    } else if (ClientNetworking.getTeleportUpLimit() > 0 && -yDiff > (double)((float)ClientNetworking.getTeleportUpLimit() * ((PlayerExtension)player).vivecraft$getMuhJumpFactor()) + 0.2) {
                        ok = false;
                    } else if (ClientNetworking.getTeleportHorizLimit() > 0 && xzDiff > (double)((float)ClientNetworking.getTeleportHorizLimit() * ((PlayerExtension)player).vivecraft$getMuhSpeedFactor()) + 0.2) {
                        ok = false;
                    }
                }
                if (ok) break;
                this.movementTeleportDestination = Vec3.ZERO;
                this.movementTeleportDistance = 0.0;
                break;
            }
            pos = new Vec3(newPos.x, newPos.y, newPos.z);
            this.movementTeleportArc[i] = new Vec3(newPos.x, newPos.y, newPos.z);
            this.movementTeleportArcSteps = i + 1;
            velocity = velocity.add((Vector3fc)gravity);
        }
    }

    private void doTeleportCallback() {
        this.dh.swingTracker.disableSwing = 3;
        if (ClientNetworking.isLimitedSurvivalTeleport()) {
            this.mc.player.causeFoodExhaustion((float)(this.movementTeleportDistance / 16.0 * 1.2));
            if (this.mc.gameMode.hasMissTime() && this.vrMovementStyle.arcAiming) {
                this.teleportEnergy -= (float)this.movementTeleportDistance * 4.0f;
            }
        }
        this.mc.player.fallDistance = 0.0;
        this.movementTeleportTimer = -1;
    }

    private boolean checkAndSetTeleportDestination(LocalPlayer player, Vec3 start, BlockHitResult collision) {
        BlockPos blockpos = collision.getBlockPos();
        BlockState blockState = player.level().getBlockState(blockpos);
        if (!this.mc.level.getFluidState(blockpos).isEmpty()) {
            Vec3 hitVec = new Vec3(collision.getLocation().x, (double)blockpos.getY(), collision.getLocation().z);
            Vec3 offset = hitVec.subtract(player.getX(), player.getBoundingBox().minY, player.getZ());
            AABB aabb = player.getBoundingBox().move(offset.x, offset.y, offset.z);
            boolean emptySpotReq = this.mc.level.noCollision((Entity)player, aabb);
            if (!emptySpotReq) {
                Vec3 center = Vec3.atBottomCenterOf((Vec3i)blockpos);
                offset = center.subtract(player.getX(), player.getBoundingBox().minY, player.getZ());
                aabb = player.getBoundingBox().move(offset.x, offset.y, offset.z);
                emptySpotReq = this.mc.level.noCollision((Entity)player, aabb);
            }
            float ex = 0.0f;
            if (this.dh.vrSettings.seated) {
                ex = 0.5f;
            }
            if (emptySpotReq) {
                this.movementTeleportDestination = new Vec3(aabb.getCenter().x, aabb.minY + (double)ex, aabb.getCenter().z);
                this.movementTeleportDestinationSideHit = collision.getDirection();
                return true;
            }
        } else if (collision.getDirection() != Direction.UP) {
            if (blockState.getBlock() instanceof LadderBlock || blockState.getBlock() instanceof VineBlock || blockState.is(ViveBlockTags.VIVECRAFT_CLIMBABLE)) {
                Vec3 dest = new Vec3((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
                Block block = this.mc.level.getBlockState(blockpos.below()).getBlock();
                if (block == blockState.getBlock()) {
                    dest = dest.add(0.0, -1.0, 0.0);
                }
                this.movementTeleportDestination = dest.scale(1.0);
                this.movementTeleportDestinationSideHit = collision.getDirection();
                return true;
            }
            if (!player.getAbilities().mayfly && ClientNetworking.isLimitedSurvivalTeleport()) {
                return false;
            }
        }
        BlockPos hitBlock = collision.getBlockPos().below();
        for (int i = 0; i < 2; ++i) {
            blockState = player.level().getBlockState(hitBlock);
            if (!blockState.getCollisionShape((BlockGetter)this.mc.level, hitBlock).isEmpty()) {
                boolean emptySpotReq;
                double height = blockState.getCollisionShape((BlockGetter)this.mc.level, hitBlock).max(Direction.Axis.Y);
                Vec3 hitVec = new Vec3(collision.getLocation().x, (double)hitBlock.getY() + height, collision.getLocation().z);
                Vec3 offset = hitVec.subtract(player.getX(), player.getBoundingBox().minY, player.getZ());
                AABB aabb = player.getBoundingBox().move(offset.x, offset.y, offset.z);
                double ex = 0.0;
                if (blockState.getBlock() == Blocks.SOUL_SAND || blockState.getBlock() == Blocks.HONEY_BLOCK) {
                    ex = 0.05;
                }
                boolean bl = emptySpotReq = this.mc.level.noCollision((Entity)player, aabb) && !this.mc.level.noCollision((Entity)player, aabb.inflate(0.0, 0.125 + ex, 0.0));
                if (!emptySpotReq) {
                    Vec3 center = Vec3.upFromBottomCenterOf((Vec3i)hitBlock, (double)height);
                    offset = center.subtract(player.getX(), player.getBoundingBox().minY, player.getZ());
                    aabb = player.getBoundingBox().move(offset.x, offset.y, offset.z);
                    boolean bl2 = emptySpotReq = this.mc.level.noCollision((Entity)player, aabb) && !this.mc.level.noCollision((Entity)player, aabb.inflate(0.0, 0.125 + ex, 0.0));
                }
                if (emptySpotReq) {
                    Vec3 dest = new Vec3(aabb.getCenter().x, (double)hitBlock.getY() + height, aabb.getCenter().z);
                    this.movementTeleportDestination = dest.scale(1.0);
                    return true;
                }
            }
            hitBlock = hitBlock.above();
        }
        return false;
    }

    public Vec3 getInterpolatedArcPosition(float progress) {
        if (this.movementTeleportArcSteps == 1 || progress <= 0.0f) {
            return new Vec3(this.movementTeleportArc[0].x, this.movementTeleportArc[0].y, this.movementTeleportArc[0].z);
        }
        if (progress >= 1.0f) {
            return new Vec3(this.movementTeleportArc[this.movementTeleportArcSteps - 1].x, this.movementTeleportArc[this.movementTeleportArcSteps - 1].y, this.movementTeleportArc[this.movementTeleportArcSteps - 1].z);
        }
        float stepFloat = progress * (float)(this.movementTeleportArcSteps - 1);
        int step = (int)Math.floor(stepFloat);
        double deltaX = this.movementTeleportArc[step + 1].x - this.movementTeleportArc[step].x;
        double deltaY = this.movementTeleportArc[step + 1].y - this.movementTeleportArc[step].y;
        double deltaZ = this.movementTeleportArc[step + 1].z - this.movementTeleportArc[step].z;
        float stepProgress = stepFloat - (float)step;
        return new Vec3(this.movementTeleportArc[step].x + deltaX * (double)stepProgress, this.movementTeleportArc[step].y + deltaY * (double)stepProgress, this.movementTeleportArc[step].z + deltaZ * (double)stepProgress);
    }
}

